/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits.format;

import java.io.StringReader;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Map;
import java.util.ResourceBundle;
import org.ngs.ngunits.Prefix;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.UCUM;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.converter.AbstractUnitConverter;
import org.ngs.ngunits.converter.MultiplyConverter;
import org.ngs.ngunits.converter.RationalConverter;
import org.ngs.ngunits.format.ParseException;
import org.ngs.ngunits.format.SymbolMap;
import org.ngs.ngunits.format.TokenMgrError;
import org.ngs.ngunits.format.UCUMParser;
import org.ngs.ngunits.quantity.Mass;
import org.ngs.ngunits.unit.AnnotatedUnit;
import org.ngs.ngunits.unit.DefaultUnitDelegate;
import org.ngs.ngunits.unit.ProductUnit;
import org.ngs.ngunits.unit.TransformedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UCUMFormat
extends Format {
    private static final SymbolMap PRINT_SYMBOLS = new SymbolMap(ResourceBundle.getBundle("org.ngs.ngunits.format.UCUM_Print"));
    private static final SymbolMap CASE_SENSITIVE_SYMBOLS = new SymbolMap(ResourceBundle.getBundle("org.ngs.ngunits.format.UCUM_CS"));
    private static final SymbolMap CASE_INSENSITIVE_SYMBOLS = new SymbolMap(ResourceBundle.getBundle("org.ngs.ngunits.format.UCUM_CI"));
    private static final UCUMFormat PRINT_INSTANCE = new Print(PRINT_SYMBOLS);
    private static final UCUMFormat CS_INSTANCE = new Parsing(CASE_SENSITIVE_SYMBOLS, true);
    private static final UCUMFormat CI_INSTANCE = new Parsing(CASE_INSENSITIVE_SYMBOLS, false);
    final SymbolMap _symbolMap;

    public static UCUMFormat getPrintInstance() {
        return PRINT_INSTANCE;
    }

    public static UCUMFormat getCaseSensitiveInstance() {
        return CS_INSTANCE;
    }

    public static UCUMFormat getCaseInsensitiveInstance() {
        return CI_INSTANCE;
    }

    UCUMFormat(SymbolMap symbolMap) {
        this._symbolMap = symbolMap;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.formatInternal((Unit)object, stringBuffer);
        return stringBuffer;
    }

    private void formatInternal(Unit<?> unit, StringBuffer stringBuffer) {
        String string = this._symbolMap.getSymbol(unit);
        if (string != null) {
            stringBuffer.append(string);
        } else if (unit instanceof ProductUnit) {
            Map<Unit, Integer> map = unit.getProductUnits();
            int n = 0;
            boolean bl = true;
            for (Map.Entry<Unit, Integer> entry : map.entrySet()) {
                if (entry.getValue() < 0) {
                    ++n;
                    continue;
                }
                this.formatExponent(entry.getKey(), entry.getValue(), !bl, stringBuffer);
                bl = false;
            }
            if (n > 0) {
                for (Map.Entry<Unit, Integer> entry : map.entrySet()) {
                    if (entry.getValue() >= 0) continue;
                    this.formatExponent(entry.getKey(), entry.getValue(), !bl, stringBuffer);
                    bl = false;
                }
            }
        } else if (unit instanceof TransformedUnit || unit.equals(SI.KILOGRAM)) {
            boolean bl;
            UnitConverter unitConverter;
            StringBuffer stringBuffer2 = new StringBuffer();
            if (unit.equals(SI.KILOGRAM)) {
                stringBuffer2 = this.format(UCUM.GRAM, stringBuffer2, null);
                unitConverter = Prefix.KILO.converter;
                bl = true;
            } else {
                TransformedUnit transformedUnit = (TransformedUnit)unit;
                Unit<Mass> unit2 = transformedUnit.getParent();
                unitConverter = transformedUnit.toParent();
                if (unit2.equals(SI.KILOGRAM)) {
                    unit2 = UCUM.GRAM;
                    unitConverter = unitConverter.concatenate(Prefix.KILO.converter);
                }
                stringBuffer2 = this.format(unit2, stringBuffer2, null);
                bl = !unit2.equals(DefaultUnitDelegate.INSTANCE.one());
            }
            this.formatConverter(unitConverter, bl, stringBuffer2);
            stringBuffer.append(stringBuffer2);
        } else {
            throw new IllegalArgumentException("Cannot format the given Object as UCUM units (unsupported unit type " + unit.getClass().getName() + ")");
        }
        if (unit instanceof AnnotatedUnit) {
            stringBuffer.append('{');
            stringBuffer.append(((AnnotatedUnit)unit).getAnnotation());
            stringBuffer.append('}');
        }
    }

    protected void formatExponent(Unit<?> unit, int n, boolean bl, StringBuffer stringBuffer) {
        if (n < 0) {
            stringBuffer.append('/');
        } else if (bl) {
            stringBuffer.append('.');
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        this.formatInternal(unit, stringBuffer2);
        if (stringBuffer2.indexOf(".") >= 0 || stringBuffer2.indexOf("/") >= 0) {
            stringBuffer2.insert(0, '(');
            stringBuffer2.append(')');
        }
        stringBuffer.append(stringBuffer2);
        if (Math.abs(n) != 1) {
            stringBuffer.append(Integer.toString(Math.abs(n)));
        }
    }

    protected void formatConverter(UnitConverter unitConverter, boolean bl, StringBuffer stringBuffer) {
        boolean bl2 = stringBuffer.indexOf(".") >= 0 || stringBuffer.indexOf("/") >= 0;
        Prefix prefix = this._symbolMap.getPrefix(unitConverter);
        if (prefix != null && !bl2) {
            stringBuffer.insert(0, this._symbolMap.getSymbol(prefix));
        } else if (unitConverter != AbstractUnitConverter.IDENTITY) {
            if (unitConverter instanceof MultiplyConverter) {
                MultiplyConverter multiplyConverter;
                double d;
                long l;
                if (bl2) {
                    stringBuffer.insert(0, '(');
                    stringBuffer.append(')');
                }
                if ((double)(l = (long)(d = (multiplyConverter = (MultiplyConverter)unitConverter).getFactor())) != d || l < -9007199254740992L || l > 0x20000000000000L) {
                    throw new IllegalArgumentException("Only integer factors are supported in UCUM");
                }
                if (bl) {
                    stringBuffer.append('.');
                }
                stringBuffer.append(l);
            } else if (unitConverter instanceof RationalConverter) {
                RationalConverter rationalConverter;
                if (bl2) {
                    stringBuffer.insert(0, '(');
                    stringBuffer.append(')');
                }
                if ((rationalConverter = (RationalConverter)unitConverter).getDividend() != 1L) {
                    if (bl) {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append(rationalConverter.getDividend());
                }
                if (rationalConverter.getDivisor() != 1L) {
                    stringBuffer.append('/');
                    stringBuffer.append(rationalConverter.getDivisor());
                }
            } else {
                throw new IllegalArgumentException("Unable to format units in UCUM (unsupported UnitConverter " + unitConverter + ")");
            }
        }
    }

    protected Unit parseInternal(String string, ParsePosition parsePosition) {
        if (string == null || string.length() == 0) {
            parsePosition.setErrorIndex(0);
            return null;
        }
        UCUMParser uCUMParser = new UCUMParser(this._symbolMap, new StringReader(string));
        try {
            Unit unit = uCUMParser.parseUnit();
            parsePosition.setIndex(string.length());
            return unit;
        }
        catch (ParseException parseException) {
            if (parseException.currentToken != null) {
                parsePosition.setErrorIndex(parseException.currentToken.endColumn);
            } else {
                parsePosition.setErrorIndex(0);
            }
            return null;
        }
        catch (TokenMgrError tokenMgrError) {
            parsePosition.setErrorIndex(0);
            return null;
        }
    }

    private static void test(String string) {
        boolean bl = false;
        String string2 = "";
        try {
            Unit unit = (Unit)CS_INSTANCE.parseObject(string);
            string2 = CS_INSTANCE.format(unit);
            bl = string2.equals(string);
        }
        catch (java.text.ParseException parseException) {
            System.err.println("error parsing " + string);
            parseException.printStackTrace();
        }
        System.out.println(string + " " + bl + (bl ? "" : " (" + string2 + ")"));
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"rad2", "s-1", "kg.m/s2", "N/m2", "N.m", "J/s", "C/s", "J/C", "C/V", "V/A", "Ohm-1", "V.s", "Wb/m2", "Wb/A", "cd.sr", "lm/m2", "s-1", "J/kg", "J/kg", "deg", "[pi].rad/360", "deg/60", "'/60", "dm3", "m2", "a_j/12", "a_g/12", "kg", "[e].V", "Mm", "m/s", "J.s", "J/K", "F/m", "m3.kg-1/s2", "m/s2", "[c].a_j", "g.[g]", "[lb_av].[g]", "cm-1{salt}", "cm/s2", "g.cm/s2", "dyn.cm", "dyn.s/cm2", "cm2/s", "/[pi].A/m", "Oe.cm", "cd/cm2", "cd/cm2/[pi]", "lx", "Bq", "C/kg", "erg/g", "RAD", "cm", "[nmi_i]/h", "[in_i]2", "[ft_i]2", "[yd_i]2", "[in_i]3", "[ft_i]3", "[yd_i]3", "[in_i]3", "[ft_i]3", "[pi]/4.[mil_i]2", "m/3937", "[ft_us]/12", "[ch_us]/100", "[rch_us]/100", "[rd_us]2", "[rd_us]2", "[mi_us]2", "[mi_us]2", "cm", "[ch_br]/100", "[nmi_br]/h", "[yd_br]2", "[in_i]3", "[gal_us]/4", "[qt_us]/2", "[pt_us]/4", "[gil_us]/4", "[foz_us]/8", "[fdr_us]/60", "[ft_i]3", "[in_i]3", "[bu_us]/8", "[bu_us]/4", "[pk_us]/8", "[dqt_us]/2", "[foz_us]/2", "[tbs_us]/3", "[gal_br]/4", "[qt_br]/2", "[pt_br]/4", "[gil_br]/5", "[foz_br]/8", "[fdr_br]/60", "mg", "[lb_av]/16", "[oz_av]/16", "[in_i]/12", "[lne]/6", "[pied]/12", "[pouce]/12", "[ligne]/6", "[didot]", "[Btu_th]", "[ft_i].[lbf_av]/s", "kPa", "kPa", "/m", "/[in_i]", "mm/[pi]", "ml/12", "mL/min/kg", "g/dl", "mol/s", "umol/min", "m3", "nm", "fm2", "kgf/cm2", "S", "[lbf_av]/[in_i]2", "[pi].rad", "[pi].sr", "/24", "/s", "1/s", ""};
        for (int i = 0; i < stringArray2.length; ++i) {
            UCUMFormat.test("cm-1{salt}");
        }
    }

    private static class Parsing
    extends UCUMFormat {
        private final boolean _caseSensitive;

        public Parsing(SymbolMap symbolMap, boolean bl) {
            super(symbolMap);
            this._caseSensitive = bl;
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            if (!this._caseSensitive) {
                string = string.toUpperCase();
            }
            return this.parseInternal(string, parsePosition);
        }
    }

    private static class Print
    extends UCUMFormat {
        public Print(SymbolMap symbolMap) {
            super(symbolMap);
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            throw new UnsupportedOperationException("The print format is for pretty-printing of units only. Parsing is not supported.");
        }
    }
}

