/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataInput;
import java.io.IOException;
import org.openimaj.io.ReadableBinary;

public abstract class ReadableArrayBinary<V>
implements ReadableBinary {
    public V[] value;

    public ReadableArrayBinary(V[] list) {
        this.value = list;
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        int sz = in.readInt();
        if (this.value == null) {
            this.value = this.createEmpty(sz);
        }
        for (int i = 0; i < sz; ++i) {
            this.value[i] = this.readValue(in);
        }
    }

    protected abstract V readValue(DataInput var1) throws IOException;

    protected abstract V[] createEmpty(int var1) throws IOException;

    @Override
    public byte[] binaryHeader() {
        return this.value.getClass().getName().getBytes();
    }
}

