/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import org.openimaj.io.ReadableBinary;

public abstract class ReadableMapBinary<K, V>
implements ReadableBinary {
    public Map<K, V> value;

    public ReadableMapBinary(Map<K, V> map) {
        this.value = map;
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            K key = this.readKey(in);
            V val = this.readValue(in);
            this.value.put(key, val);
        }
    }

    protected abstract K readKey(DataInput var1) throws IOException;

    protected abstract V readValue(DataInput var1) throws IOException;

    @Override
    public byte[] binaryHeader() {
        return this.value.getClass().getName().getBytes();
    }
}

