/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.parallel.partition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import org.openimaj.util.parallel.partition.Partitioner;

public class FixedSizeBlockingChunkPartitioner<T>
implements Partitioner<T> {
    private Queue<T> queue;
    private int chunkSize = 20;

    public FixedSizeBlockingChunkPartitioner(Queue<T> objects) {
        this.queue = objects;
    }

    public FixedSizeBlockingChunkPartitioner(Queue<T> objects, int chunkSize) {
        this.queue = objects;
        this.chunkSize = chunkSize;
    }

    @Override
    public Iterator<Iterator<T>> getPartitions() {
        return new Iterator<Iterator<T>>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<T> next() {
                ArrayList list = new ArrayList(FixedSizeBlockingChunkPartitioner.this.chunkSize);
                int i = 0;
                while (i < FixedSizeBlockingChunkPartitioner.this.chunkSize) {
                    Object toAdd = null;
                    Queue queue = FixedSizeBlockingChunkPartitioner.this.queue;
                    synchronized (queue) {
                        toAdd = FixedSizeBlockingChunkPartitioner.this.queue.poll();
                    }
                    if (toAdd == null) continue;
                    list.add(toAdd);
                    ++i;
                }
                return list.iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }
}

