/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.stream.window;

import java.util.ArrayList;
import org.openimaj.util.data.Context;
import org.openimaj.util.function.Function;
import org.openimaj.util.stream.AbstractStream;
import org.openimaj.util.stream.Stream;

public class ContextRealTimeWindowFunction<IN>
implements Function<Stream<IN>, Stream<Context>> {
    private long waitTime;
    private long currentWindowStartTime;

    public ContextRealTimeWindowFunction(long waitTime) {
        this.waitTime = waitTime;
        this.currentWindowStartTime = -1L;
    }

    @Override
    public Stream<Context> apply(final Stream<IN> inner) {
        return new AbstractStream<Context>(){

            @Override
            public boolean hasNext() {
                return inner.hasNext();
            }

            @Override
            public Context next() {
                ContextRealTimeWindowFunction.this.currentWindowStartTime = System.currentTimeMillis();
                ArrayList currentWindow = new ArrayList();
                while (inner.hasNext() && System.currentTimeMillis() - ContextRealTimeWindowFunction.this.currentWindowStartTime < ContextRealTimeWindowFunction.this.waitTime) {
                    Object next = inner.next();
                    currentWindow.add(next);
                }
                Context context = new Context();
                context.put("windowstart", ContextRealTimeWindowFunction.this.currentWindowStartTime);
                context.put("item", currentWindow);
                return context;
            }
        };
    }
}

