/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.voronoi;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.utils.TinInstantiationUtility;
import org.tinfour.utils.Tincalc;
import org.tinfour.utils.VertexColorizerKempe6;
import org.tinfour.voronoi.BoundedVoronoiDiagram;
import org.tinfour.voronoi.BoundedVoronoiRenderingType;
import org.tinfour.voronoi.BoundedVoronoiStylerDefault;
import org.tinfour.voronoi.IBoundedVoronoiStyler;
import org.tinfour.voronoi.IBoundedVoronoiVertexSymbol;
import org.tinfour.voronoi.ThiessenPolygon;

public class BoundedVoronoiDrawingUtility {
    private final BoundedVoronoiDiagram diagram;
    private final AffineTransform af;
    private final Rectangle2D bounds;
    private final Rectangle2D clipBounds;
    private static final Color[] defaultColors = new Color[]{Color.YELLOW, Color.MAGENTA, Color.ORANGE, Color.LIGHT_GRAY, Color.PINK, Color.GREEN.brighter(), Color.RED, Color.BLUE};

    public BoundedVoronoiDrawingUtility(BoundedVoronoiDiagram diagram, int width, int height, int pad, Rectangle2D optionalBounds) {
        if (diagram == null) {
            throw new IllegalArgumentException("Null input diagram not allowed");
        }
        if (pad < 0) {
            throw new IllegalArgumentException("Negative pad value not allowed");
        }
        if (width - 2 * pad < 1 || height - 2 * pad < 1) {
            throw new IllegalArgumentException("Width and height (minus padding) too small");
        }
        this.diagram = diagram;
        if (optionalBounds == null) {
            Rectangle2D sb = diagram.getSampleBounds();
            double w = sb.getWidth();
            double h = sb.getHeight();
            double x = sb.getX();
            double y = sb.getY();
            this.bounds = new Rectangle2D.Double(x - w * 0.1, y - h * 0.1, w * 1.2, h * 1.2);
        } else {
            this.bounds = new Rectangle2D.Double(optionalBounds.getX(), optionalBounds.getY(), optionalBounds.getWidth(), optionalBounds.getHeight());
        }
        double x0 = this.bounds.getMinX();
        double y0 = this.bounds.getMinY();
        double x1 = this.bounds.getMaxX();
        double y1 = this.bounds.getMaxY();
        this.af = this.initTransform(width, height, pad, x0, x1, y0, y1);
        this.clipBounds = this.computeClipBounds();
    }

    public BoundedVoronoiDrawingUtility(BoundedVoronoiDiagram diagram, Rectangle2D clipBounds, AffineTransform af) {
        this.diagram = diagram;
        this.af = af;
        this.bounds = diagram.getBounds();
        this.clipBounds = clipBounds;
    }

    AffineTransform getTransform() {
        return this.af;
    }

    AffineTransform getInverseTransform() {
        try {
            return this.af.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            return new AffineTransform();
        }
    }

    private AffineTransform initTransform(int width, int height, int pad, double x0, double x1, double y0, double y1) {
        double rImage = (double)(width - pad) / (double)(height - pad);
        double rData = (x1 - x0) / (y1 - y0);
        double rAspect = rImage / rData;
        double uPerPixel = rAspect >= 1.0 ? (y1 - y0) / (double)(height - pad) : (x1 - x0) / (double)(width - pad);
        double scale = 1.0 / uPerPixel;
        double xCenter = (x0 + x1) / 2.0;
        double yCenter = (y0 + y1) / 2.0;
        double xOffset = (double)((width - pad) / 2) - scale * xCenter + (double)(pad / 2);
        double yOffset = (double)((height - pad) / 2) + scale * yCenter + (double)(pad / 2);
        AffineTransform transform = new AffineTransform(scale, 0.0, 0.0, -scale, xOffset, yOffset);
        try {
            transform.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            throw new IllegalArgumentException("Input elements result in a degenerate transform: " + ex.getMessage(), ex);
        }
        return transform;
    }

    private Rectangle2D computeClipBounds() {
        double x0 = this.bounds.getMinX();
        double y0 = this.bounds.getMinY();
        double x1 = this.bounds.getMaxX();
        double y1 = this.bounds.getMaxY();
        Point2D.Double llCorner = new Point2D.Double(x0, y0);
        Point2D.Double urCorner = new Point2D.Double(x1, y1);
        this.af.transform(llCorner, llCorner);
        this.af.transform(urCorner, urCorner);
        return new Rectangle2D.Double(((Point2D)llCorner).getX(), ((Point2D)urCorner).getY(), ((Point2D)urCorner).getX() - ((Point2D)llCorner).getX(), ((Point2D)llCorner).getY() - ((Point2D)urCorner).getY());
    }

    public void drawWireframe(Graphics g, Color foreground, double strokeWidth, Font font) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(foreground);
        g2d.setStroke(new BasicStroke((float)strokeWidth));
        Point2D.Double p0 = new Point2D.Double();
        Point2D.Double p1 = new Point2D.Double();
        Line2D.Double l2d = new Line2D.Double();
        Ellipse2D.Double e2d = new Ellipse2D.Double();
        List<IQuadEdge> edgeList = this.diagram.getEdges();
        for (IQuadEdge e : edgeList) {
            Vertex A = e.getA();
            Vertex B = e.getB();
            ((Point2D)p0).setLocation(A.getX(), A.getY());
            ((Point2D)p1).setLocation(B.getX(), B.getY());
            this.af.transform(p0, p0);
            this.af.transform(p1, p1);
            l2d.setLine(p0, p1);
            g2d.draw(l2d);
        }
        g2d.setStroke(new BasicStroke(1.0f));
        FontRenderContext frc = null;
        if (font != null) {
            g2d.setFont(font);
            frc = new FontRenderContext(null, true, true);
        }
        g2d.setClip(null);
        List<Vertex> vertexList = this.diagram.getVertices();
        for (Vertex v : vertexList) {
            double x = v.getX();
            double y = v.getY();
            ((Point2D)p0).setLocation(x, y);
            this.af.transform(p0, p1);
            ((RectangularShape)e2d).setFrame(((Point2D)p1).getX() - 2.0, ((Point2D)p1).getY() - 2.0, 6.0, 6.0);
            g2d.fill(e2d);
            g2d.draw(e2d);
            if (font == null) continue;
            String text = v.getLabel();
            TextLayout layout = new TextLayout(text, font, frc);
            double yOffset = layout.getAscent() + 2.0f;
            g2d.drawString(text, (int)(((Point2D)p1).getX() + 3.0), (int)(((Point2D)p1).getY() + 3.0 + yOffset));
        }
    }

    public void drawVertices(Graphics g, Color foreground, Font font, List<Vertex> vertexList) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Point2D.Double p0 = new Point2D.Double();
        Point2D.Double p1 = new Point2D.Double();
        Ellipse2D.Double e2d = new Ellipse2D.Double();
        g2d.setClip(null);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(foreground);
        FontRenderContext frc = null;
        if (font != null) {
            g2d.setFont(font);
            frc = new FontRenderContext(null, true, true);
        }
        for (Vertex v : vertexList) {
            double x = v.getX();
            double y = v.getY();
            ((Point2D)p0).setLocation(x, y);
            this.af.transform(p0, p1);
            ((RectangularShape)e2d).setFrame(((Point2D)p1).getX() - 2.0, ((Point2D)p1).getY() - 2.0, 6.0, 6.0);
            g2d.fill(e2d);
            g2d.draw(e2d);
            if (font == null) continue;
            String text = v.getLabel();
            TextLayout layout = new TextLayout(text, font, frc);
            double yOffset = layout.getAscent() + 2.0f;
            g2d.drawString(text, (int)(((Point2D)p1).getX() + 3.0), (int)(((Point2D)p1).getY() + 3.0 + yOffset));
        }
    }

    public void drawPolygons(Graphics g, Paint[] paintSpec, boolean assignAutomaticColors) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Paint[] paint = paintSpec;
        if (paintSpec == null) {
            paint = defaultColors;
        }
        if (assignAutomaticColors) {
            if (paint.length < 6) {
                throw new IllegalArgumentException("Input paint specification must include at least 6 values");
            }
            this.assignAutomaticColors();
        }
        g2d.setClip(this.clipBounds);
        g2d.setStroke(new BasicStroke(1.0f));
        Point2D.Double p0 = new Point2D.Double();
        List<ThiessenPolygon> polygons = this.diagram.getPolygons();
        for (ThiessenPolygon poly : polygons) {
            List<IQuadEdge> qList = poly.getEdges();
            Path2D.Double path = new Path2D.Double();
            IQuadEdge q0 = qList.get(0);
            ((Point2D)p0).setLocation(q0.getA().getX(), q0.getA().getY());
            this.af.transform(p0, p0);
            ((Path2D)path).moveTo(((Point2D)p0).getX(), ((Point2D)p0).getY());
            for (IQuadEdge q : qList) {
                ((Point2D)p0).setLocation(q.getB().getX(), q.getB().getY());
                this.af.transform(p0, p0);
                ((Path2D)path).lineTo(((Point2D)p0).getX(), ((Point2D)p0).getY());
            }
            path.closePath();
            Vertex v = poly.getVertex();
            int k = v.getAuxiliaryIndex();
            g2d.setPaint(paint[k]);
            g2d.fill(path);
            g2d.draw(path);
        }
        g2d.setClip(null);
    }

    public void drawEdges(Graphics g, Color foreground, double strokeWidth, List<IQuadEdge> edgeList) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Shape saveClip = g2d.getClip();
        g2d.setClip(null);
        g2d.setColor(foreground);
        g2d.setStroke(new BasicStroke((float)strokeWidth));
        Point2D.Double p0 = new Point2D.Double();
        Point2D.Double p1 = new Point2D.Double();
        Line2D.Double l2d = new Line2D.Double();
        for (IQuadEdge e : edgeList) {
            Vertex A = e.getA();
            Vertex B = e.getB();
            if (A == null || B == null) continue;
            ((Point2D)p0).setLocation(A.getX(), A.getY());
            ((Point2D)p1).setLocation(B.getX(), B.getY());
            this.af.transform(p0, p0);
            this.af.transform(p1, p1);
            l2d.setLine(p0, p1);
            g2d.draw(l2d);
        }
        g2d.setClip(saveClip);
    }

    public void assignAutomaticColors() {
        List<Vertex> vertexList = this.diagram.getVertices();
        int nVertices = vertexList.size();
        Rectangle2D.Double sampleBounds = new Rectangle2D.Double(vertexList.get(0).getX(), vertexList.get(0).getY(), 0.0, 0.0);
        for (Vertex v : vertexList) {
            sampleBounds.add(v.getX(), v.getY());
        }
        double area = ((RectangularShape)sampleBounds).getWidth() * ((RectangularShape)sampleBounds).getHeight();
        double nominalPointSpacing = Tincalc.sampleSpacing(area, nVertices);
        TinInstantiationUtility maker = new TinInstantiationUtility(0.25, vertexList.size());
        IIncrementalTin tin = maker.constructInstance(nominalPointSpacing);
        tin.add(vertexList, null);
        if (!tin.isBootstrapped()) {
            return;
        }
        VertexColorizerKempe6 kempe6 = new VertexColorizerKempe6();
        kempe6.assignColorsToVertices(tin);
        tin.dispose();
    }

    public void draw(Graphics g, IBoundedVoronoiStyler specifiedStyler) {
        IBoundedVoronoiStyler styler = specifiedStyler;
        if (styler == null) {
            styler = new BoundedVoronoiStylerDefault();
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setClip(this.clipBounds);
        g2d.setStroke(new BasicStroke(1.0f));
        if (styler.isFeatureTypeEnabled(BoundedVoronoiRenderingType.Area)) {
            this.drawAreaFill(g2d, styler);
        }
        if (styler.isFeatureTypeEnabled(BoundedVoronoiRenderingType.Line)) {
            this.drawLines(g2d, styler);
        }
        if (styler.isFeatureTypeEnabled(BoundedVoronoiRenderingType.Vertex)) {
            this.drawVertices(g2d, styler);
        }
    }

    private void drawAreaFill(Graphics2D g2d, IBoundedVoronoiStyler styler) {
        Point2D.Double p0 = new Point2D.Double();
        List<ThiessenPolygon> polygons = this.diagram.getPolygons();
        for (ThiessenPolygon poly : polygons) {
            if (!styler.isRenderingEnabled(poly, BoundedVoronoiRenderingType.Area)) continue;
            List<IQuadEdge> qList = poly.getEdges();
            Path2D.Double path = new Path2D.Double();
            IQuadEdge q0 = qList.get(0);
            ((Point2D)p0).setLocation(q0.getA().getX(), q0.getA().getY());
            this.af.transform(p0, p0);
            ((Path2D)path).moveTo(((Point2D)p0).getX(), ((Point2D)p0).getY());
            for (IQuadEdge q : qList) {
                ((Point2D)p0).setLocation(q.getB().getX(), q.getB().getY());
                this.af.transform(p0, p0);
                ((Path2D)path).lineTo(((Point2D)p0).getX(), ((Point2D)p0).getY());
            }
            path.closePath();
            styler.applyStylingForAreaFill(g2d, poly);
            g2d.fill(path);
            g2d.draw(path);
        }
    }

    private void drawLines(Graphics2D g2d, IBoundedVoronoiStyler styler) {
        Point2D.Double p0 = new Point2D.Double();
        Point2D.Double p1 = new Point2D.Double();
        Line2D.Double l2d = new Line2D.Double();
        boolean[] drawn = new boolean[this.diagram.getMaximumEdgeAllocationIndex()];
        for (ThiessenPolygon poly : this.diagram.getPolygons()) {
            if (!styler.isRenderingEnabled(poly, BoundedVoronoiRenderingType.Line)) continue;
            styler.applyStylingForLineDrawing(g2d, poly);
            for (IQuadEdge e : poly.getEdges()) {
                if (drawn[e.getIndex()]) continue;
                drawn[e.getIndex()] = true;
                drawn[e.getIndex() ^ 1] = true;
                Vertex A = e.getA();
                Vertex B = e.getB();
                ((Point2D)p0).setLocation(A.getX(), A.getY());
                ((Point2D)p1).setLocation(B.getX(), B.getY());
                this.af.transform(p0, p0);
                this.af.transform(p1, p1);
                l2d.setLine(p0, p1);
                g2d.draw(l2d);
            }
        }
    }

    private void drawVertices(Graphics2D g2d, IBoundedVoronoiStyler styler) {
        Point2D.Double p0 = new Point2D.Double();
        Point2D.Double p1 = new Point2D.Double();
        for (ThiessenPolygon poly : this.diagram.getPolygons()) {
            if (!styler.isRenderingEnabled(poly, BoundedVoronoiRenderingType.Vertex)) continue;
            Vertex v = poly.getVertex();
            ((Point2D)p0).setLocation(v.getX(), v.getY());
            this.af.transform(p0, p1);
            if (this.clipBounds != null && !this.clipBounds.contains(p1)) continue;
            IBoundedVoronoiVertexSymbol s = styler.getVertexSymbol(poly);
            s.draw(g2d, ((Point2D)p1).getX(), ((Point2D)p1).getY());
        }
    }
}

