/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.standard.DecoratorFigure;

public class BorderDecorator
extends DecoratorFigure {
    private static final long serialVersionUID = 1205601808259084917L;
    private int borderDecoratorSerializedDataVersion = 1;
    private Point myBorderOffset;
    private Color myBorderColor;
    private Color myShadowColor;

    public BorderDecorator() {
    }

    public BorderDecorator(Figure figure) {
        super(figure);
    }

    protected void initialize() {
        this.setBorderOffset(new Point(3, 3));
    }

    public void setBorderOffset(Point point) {
        this.myBorderOffset = point;
    }

    public Point getBorderOffset() {
        if (this.myBorderOffset == null) {
            return new Point(0, 0);
        }
        return this.myBorderOffset;
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        super.draw(graphics);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        graphics.setColor(Color.gray);
        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public Rectangle displayBox() {
        Rectangle rectangle = this.getDecoratedFigure().displayBox();
        rectangle.grow(this.getBorderOffset().x, this.getBorderOffset().y);
        return rectangle;
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        Rectangle rectangle = figureChangeEvent.getInvalidatedRectangle();
        rectangle.grow(this.getBorderOffset().x, this.getBorderOffset().y);
        super.figureInvalidated(new FigureChangeEvent(this, rectangle, figureChangeEvent));
    }

    public Insets connectionInsets() {
        Insets insets = super.connectionInsets();
        insets.top -= this.getBorderOffset().y;
        insets.bottom -= this.getBorderOffset().y;
        insets.left -= this.getBorderOffset().x;
        insets.right -= this.getBorderOffset().x;
        return insets;
    }
}

