/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jhotdraw.contrib.AutoscrollHelper;
import org.jhotdraw.contrib.dnd.DNDHelper;
import org.jhotdraw.contrib.dnd.DNDInterface;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Cursor;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingChangeEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureSelection;
import org.jhotdraw.framework.FigureSelectionListener;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.framework.Painter;
import org.jhotdraw.framework.PointConstrainer;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.DeleteCommand;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.InsertIntoDrawingVisitor;
import org.jhotdraw.standard.ReverseFigureEnumerator;
import org.jhotdraw.standard.SimpleUpdateStrategy;
import org.jhotdraw.standard.StandardFigureSelection;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Command;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.UndoableCommand;

public class StandardDrawingView
extends JPanel
implements DrawingView,
DNDInterface,
Autoscroll {
    private transient DrawingEditor fEditor;
    private transient List fSelectionListeners;
    private Drawing fDrawing;
    private transient Rectangle fDamage;
    private transient List fSelection;
    private transient List fSelectionHandles;
    private Point fLastClick;
    private List fBackgrounds;
    private List fForegrounds;
    private Painter fUpdateStrategy;
    private PointConstrainer fConstrainer;
    public static final int MINIMUM_WIDTH = 400;
    public static final int MINIMUM_HEIGHT = 300;
    public static final int SCROLL_INCR = 100;
    public static final int SCROLL_OFFSET = 10;
    private static int counter;
    private int myCounter = counter++;
    private DNDHelper dndh;
    private MouseListener mouseListener;
    private MouseMotionListener motionListener;
    private KeyListener keyListener;
    private boolean myIsReadOnly;
    private static final long serialVersionUID = -3878153366174603336L;
    private int drawingViewSerializedDataVersion = 1;
    private ASH ash = new ASH(10);

    public StandardDrawingView(DrawingEditor drawingEditor) {
        this(drawingEditor, 400, 300);
    }

    public StandardDrawingView(DrawingEditor drawingEditor, int n, int n2) {
        this.setAutoscrolls(true);
        this.fEditor = drawingEditor;
        this.setPreferredSize(new Dimension(n, n2));
        this.fSelectionListeners = CollectionsFactory.current().createList();
        this.addFigureSelectionListener(this.editor());
        this.setLastClick(new Point(0, 0));
        this.fConstrainer = null;
        this.fSelection = CollectionsFactory.current().createList();
        this.setDisplayUpdate(this.createDisplayUpdate());
        this.setBackground(Color.lightGray);
        this.addMouseListener(this.createMouseListener());
        this.addMouseMotionListener(this.createMouseMotionListener());
        this.addKeyListener(this.createKeyListener());
    }

    protected MouseListener createMouseListener() {
        this.mouseListener = new DrawingViewMouseListener();
        return this.mouseListener;
    }

    protected MouseMotionListener createMouseMotionListener() {
        this.motionListener = new DrawingViewMouseMotionListener();
        return this.motionListener;
    }

    protected KeyListener createKeyListener() {
        this.keyListener = new DrawingViewKeyListener();
        return this.keyListener;
    }

    protected Painter createDisplayUpdate() {
        return new SimpleUpdateStrategy();
    }

    public void setEditor(DrawingEditor drawingEditor) {
        this.fEditor = drawingEditor;
    }

    public Tool tool() {
        return this.editor().tool();
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public void setDrawing(Drawing drawing) {
        if (this.drawing() != null) {
            this.clearSelection();
            this.drawing().removeDrawingChangeListener(this);
        }
        this.fDrawing = drawing;
        if (this.drawing() != null) {
            this.drawing().addDrawingChangeListener(this);
        }
        this.checkMinimumSize();
        this.repaint();
    }

    public DrawingEditor editor() {
        return this.fEditor;
    }

    public Figure add(Figure figure) {
        return this.drawing().add(figure);
    }

    public Figure remove(Figure figure) {
        return this.drawing().remove(figure);
    }

    public void addAll(Collection collection) {
        FigureEnumerator figureEnumerator = new FigureEnumerator(collection);
        while (figureEnumerator.hasNextFigure()) {
            this.add(figureEnumerator.nextFigure());
        }
    }

    public boolean figureExists(Figure figure, FigureEnumeration figureEnumeration) {
        while (figureEnumeration.hasNextFigure()) {
            Figure figure2 = figureEnumeration.nextFigure();
            if (!figure2.includes(figure)) continue;
            return true;
        }
        return false;
    }

    public FigureEnumeration insertFigures(FigureEnumeration figureEnumeration, int n, int n2, boolean bl) {
        Object object;
        if (figureEnumeration == null) {
            return FigureEnumerator.getEmptyEnumeration();
        }
        List list = CollectionsFactory.current().createList(10);
        InsertIntoDrawingVisitor insertIntoDrawingVisitor = new InsertIntoDrawingVisitor(this.drawing());
        while (figureEnumeration.hasNextFigure()) {
            object = figureEnumeration.nextFigure();
            if (object instanceof ConnectionFigure) {
                list.add(object);
                continue;
            }
            if (object == null) continue;
            object.moveBy(n, n2);
            object.visit(insertIntoDrawingVisitor);
        }
        object = new FigureEnumerator(list);
        while (object.hasNextFigure()) {
            ConnectionFigure connectionFigure = (ConnectionFigure)object.nextFigure();
            Figure figure = connectionFigure.startFigure();
            Figure figure2 = connectionFigure.endFigure();
            if (!this.figureExists(figure, this.drawing().figures()) || !this.figureExists(figure2, this.drawing().figures()) || bl && !connectionFigure.canConnect(figure, figure2)) continue;
            if (bl) {
                Point point = figure.center();
                Point point2 = figure2.center();
                Connector connector = connectionFigure.startFigure().connectorAt(point2.x, point2.y);
                Connector connector2 = connectionFigure.endFigure().connectorAt(point.x, point.y);
                if (connector2 != null && connector != null) {
                    connectionFigure.connectStart(connector);
                    connectionFigure.connectEnd(connector2);
                    connectionFigure.updateConnection();
                }
            }
            connectionFigure.visit(insertIntoDrawingVisitor);
        }
        this.addToSelectionAll(insertIntoDrawingVisitor.getInsertedFigures());
        return insertIntoDrawingVisitor.getInsertedFigures();
    }

    public FigureEnumeration getConnectionFigures(Figure figure) {
        if (figure == null || !figure.canConnect()) {
            return null;
        }
        List list = CollectionsFactory.current().createList(5);
        FigureEnumeration figureEnumeration = this.drawing().figures();
        while (figureEnumeration.hasNextFigure()) {
            ConnectionFigure connectionFigure;
            Figure figure2 = figureEnumeration.nextFigure();
            if (!(figure2 instanceof ConnectionFigure) || this.isFigureSelected(figure2) || !(connectionFigure = (ConnectionFigure)figure2).startFigure().includes(figure) && !connectionFigure.endFigure().includes(figure)) continue;
            list.add(figure2);
        }
        return new FigureEnumerator(list);
    }

    public void setDisplayUpdate(Painter painter) {
        this.fUpdateStrategy = painter;
    }

    public Painter getDisplayUpdate() {
        return this.fUpdateStrategy;
    }

    public FigureEnumeration selection() {
        return this.selectionZOrdered();
    }

    public FigureEnumeration selectionZOrdered() {
        List list = CollectionsFactory.current().createList(this.selectionCount());
        list.addAll(this.fSelection);
        return new ReverseFigureEnumerator(list);
    }

    public int selectionCount() {
        return this.fSelection.size();
    }

    public boolean isFigureSelected(Figure figure) {
        return this.fSelection.contains(figure);
    }

    public void addToSelection(Figure figure) {
        if (this.addToSelectionImpl(figure)) {
            this.fireSelectionChanged();
        }
    }

    protected boolean addToSelectionImpl(Figure figure) {
        boolean bl = false;
        if (!this.isFigureSelected(figure) && this.drawing().includes(figure)) {
            this.fSelection.add(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            bl = true;
        }
        return bl;
    }

    public void addToSelectionAll(Collection collection) {
        this.addToSelectionAll(new FigureEnumerator(collection));
    }

    public void addToSelectionAll(FigureEnumeration figureEnumeration) {
        boolean bl = false;
        while (figureEnumeration.hasNextFigure()) {
            bl |= this.addToSelectionImpl(figureEnumeration.nextFigure());
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    public void removeFromSelection(Figure figure) {
        if (this.isFigureSelected(figure)) {
            this.fSelection.remove(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            this.fireSelectionChanged();
        }
    }

    public void toggleSelection(Figure figure) {
        if (this.isFigureSelected(figure)) {
            this.removeFromSelection(figure);
        } else {
            this.addToSelection(figure);
        }
        this.fireSelectionChanged();
    }

    public void clearSelection() {
        if (this.selectionCount() == 0) {
            return;
        }
        FigureEnumeration figureEnumeration = this.selection();
        while (figureEnumeration.hasNextFigure()) {
            figureEnumeration.nextFigure().invalidate();
        }
        this.fSelection = CollectionsFactory.current().createList();
        this.fSelectionHandles = null;
        this.fireSelectionChanged();
    }

    protected HandleEnumeration selectionHandles() {
        if (this.fSelectionHandles == null) {
            this.fSelectionHandles = CollectionsFactory.current().createList();
            FigureEnumeration figureEnumeration = this.selection();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                HandleEnumeration handleEnumeration = figure.handles();
                while (handleEnumeration.hasNextHandle()) {
                    this.fSelectionHandles.add(handleEnumeration.nextHandle());
                }
            }
        }
        return new HandleEnumerator(this.fSelectionHandles);
    }

    public FigureSelection getFigureSelection() {
        return new StandardFigureSelection(this.selectionZOrdered(), this.selectionCount());
    }

    public Handle findHandle(int n, int n2) {
        HandleEnumeration handleEnumeration = this.selectionHandles();
        while (handleEnumeration.hasNextHandle()) {
            Handle handle = handleEnumeration.nextHandle();
            if (!handle.containsPoint(n, n2)) continue;
            return handle;
        }
        return null;
    }

    protected void fireSelectionChanged() {
        if (this.fSelectionListeners != null) {
            for (int i = 0; i < this.fSelectionListeners.size(); ++i) {
                FigureSelectionListener figureSelectionListener = (FigureSelectionListener)this.fSelectionListeners.get(i);
                figureSelectionListener.figureSelectionChanged(this);
            }
        }
    }

    protected Rectangle getDamage() {
        return this.fDamage;
    }

    protected void setDamage(Rectangle rectangle) {
        this.fDamage = rectangle;
    }

    public Point lastClick() {
        return this.fLastClick;
    }

    protected void setLastClick(Point point) {
        this.fLastClick = point;
    }

    public void setConstrainer(PointConstrainer pointConstrainer) {
        this.fConstrainer = pointConstrainer;
    }

    public PointConstrainer getConstrainer() {
        return this.fConstrainer;
    }

    protected Point constrainPoint(Point point) {
        Dimension dimension = this.getSize();
        point.x = Geom.range(1, dimension.width, point.x);
        point.y = Geom.range(1, dimension.height, point.y);
        if (this.fConstrainer != null) {
            return this.fConstrainer.constrainPoint(point);
        }
        return point;
    }

    private void moveSelection(int n, int n2) {
        FigureEnumeration figureEnumeration = this.selection();
        while (figureEnumeration.hasNextFigure()) {
            figureEnumeration.nextFigure().moveBy(n, n2);
        }
        this.checkDamage();
    }

    public synchronized void checkDamage() {
        Iterator iterator = this.drawing().drawingChangeListeners();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof DrawingView)) continue;
            ((DrawingView)e).repairDamage();
        }
    }

    public void repairDamage() {
        if (this.getDamage() != null) {
            this.repaint(this.getDamage().x, this.getDamage().y, this.getDamage().width, this.getDamage().height);
            this.setDamage(null);
        }
    }

    public void drawingInvalidated(DrawingChangeEvent drawingChangeEvent) {
        Rectangle rectangle = drawingChangeEvent.getInvalidatedRectangle();
        if (this.getDamage() == null) {
            this.setDamage(rectangle);
        } else {
            Rectangle rectangle2 = this.getDamage();
            rectangle2.add(rectangle);
            this.setDamage(rectangle2);
        }
    }

    public void drawingRequestUpdate(DrawingChangeEvent drawingChangeEvent) {
        this.repairDamage();
    }

    public void drawingTitleChanged(DrawingChangeEvent drawingChangeEvent) {
    }

    protected void paintComponent(Graphics graphics) {
        if (this.getDisplayUpdate() != null) {
            this.getDisplayUpdate().draw(graphics, this);
        }
    }

    public void drawAll(Graphics graphics) {
        boolean bl = graphics instanceof PrintGraphics;
        this.drawBackground(graphics);
        if (this.fBackgrounds != null && !bl) {
            this.drawPainters(graphics, this.fBackgrounds);
        }
        this.drawDrawing(graphics);
        if (this.fForegrounds != null && !bl) {
            this.drawPainters(graphics, this.fForegrounds);
        }
        if (!bl) {
            this.drawHandles(graphics);
        }
    }

    public void draw(Graphics graphics, FigureEnumeration figureEnumeration) {
        boolean bl = graphics instanceof PrintGraphics;
        if (this.fBackgrounds != null && !bl) {
            this.drawPainters(graphics, this.fBackgrounds);
        }
        this.drawing().draw(graphics, figureEnumeration);
        if (this.fForegrounds != null && !bl) {
            this.drawPainters(graphics, this.fForegrounds);
        }
        if (!bl) {
            this.drawHandles(graphics);
        }
    }

    public void drawHandles(Graphics graphics) {
        HandleEnumeration handleEnumeration = this.selectionHandles();
        while (handleEnumeration.hasNextHandle()) {
            handleEnumeration.nextHandle().draw(graphics);
        }
    }

    public void drawDrawing(Graphics graphics) {
        this.drawing().draw(graphics);
    }

    public void drawBackground(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
    }

    protected void drawPainters(Graphics graphics, List list) {
        for (int i = 0; i < list.size(); ++i) {
            ((Painter)list.get(i)).draw(graphics, this);
        }
    }

    public void addBackground(Painter painter) {
        if (this.fBackgrounds == null) {
            this.fBackgrounds = CollectionsFactory.current().createList(3);
        }
        this.fBackgrounds.add(painter);
        this.repaint();
    }

    public void removeBackground(Painter painter) {
        if (this.fBackgrounds != null) {
            this.fBackgrounds.remove(painter);
        }
        this.repaint();
    }

    protected List getBackgrounds() {
        return this.fBackgrounds;
    }

    public void removeForeground(Painter painter) {
        if (this.fForegrounds != null) {
            this.fForegrounds.remove(painter);
        }
        this.repaint();
    }

    public void addForeground(Painter painter) {
        if (this.fForegrounds == null) {
            this.fForegrounds = CollectionsFactory.current().createList(3);
        }
        this.fForegrounds.add(painter);
        this.repaint();
    }

    protected List getForegrounds() {
        return this.fForegrounds;
    }

    public void freezeView() {
        this.drawing().lock();
    }

    public void unfreezeView() {
        this.drawing().unlock();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.fSelection = CollectionsFactory.current().createList();
        if (this.drawing() != null) {
            this.drawing().addDrawingChangeListener(this);
        }
        this.fSelectionListeners = CollectionsFactory.current().createList();
    }

    protected void checkMinimumSize() {
        Dimension dimension = this.getDrawingSize();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension2.height < dimension.height || dimension2.width < dimension.width) {
            dimension2.height = dimension.height + 10;
            dimension2.width = dimension.width + 10;
            this.setPreferredSize(dimension2);
        }
    }

    protected Dimension getDrawingSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.drawing() != null) {
            FigureEnumeration figureEnumeration = this.drawing().figures();
            while (figureEnumeration.hasNextFigure()) {
                Rectangle rectangle = figureEnumeration.nextFigure().displayBox();
                dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width);
                dimension.height = Math.max(dimension.height, rectangle.y + rectangle.height);
            }
        }
        return dimension;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isInteractive() {
        return true;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void addFigureSelectionListener(FigureSelectionListener figureSelectionListener) {
        this.fSelectionListeners.add(figureSelectionListener);
    }

    public void removeFigureSelectionListener(FigureSelectionListener figureSelectionListener) {
        this.fSelectionListeners.remove(figureSelectionListener);
    }

    public int getDefaultDNDActions() {
        return 3;
    }

    public void autoscroll(Point point) {
        this.ash.autoscroll(point);
    }

    public Insets getAutoscrollInsets() {
        return this.ash.getAutoscrollInsets();
    }

    public String toString() {
        return "DrawingView Nr: " + this.myCounter;
    }

    protected void handleMouseEventException(Throwable throwable) {
        JOptionPane.showMessageDialog(this, throwable.getClass().getName() + " - " + throwable.getMessage(), "Error", 0);
        throwable.printStackTrace();
    }

    protected DNDHelper createDNDHelper() {
        return new DNDHelper(true, true){

            protected DrawingView view() {
                return StandardDrawingView.this;
            }

            protected DrawingEditor editor() {
                return StandardDrawingView.this.editor();
            }
        };
    }

    protected DNDHelper getDNDHelper() {
        if (this.dndh == null) {
            this.dndh = this.createDNDHelper();
        }
        return this.dndh;
    }

    public DragSourceListener getDragSourceListener() {
        return this.getDNDHelper().getDragSourceListener();
    }

    public void DNDInitialize(DragGestureListener dragGestureListener) {
        this.getDNDHelper().initialize(dragGestureListener);
    }

    public void DNDDeinitialize() {
        this.getDNDHelper().deinitialize();
    }

    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }

    public void setReadOnly(boolean bl) {
        if (bl != this.isReadOnly()) {
            if (bl) {
                this.removeMouseListener(this.mouseListener);
                this.removeMouseMotionListener(this.motionListener);
                this.removeKeyListener(this.keyListener);
            } else {
                this.addMouseListener(this.mouseListener);
                this.addMouseMotionListener(this.motionListener);
                this.addKeyListener(this.keyListener);
            }
            this.myIsReadOnly = bl;
        }
    }

    public void setCursor(Cursor cursor) {
        if (cursor instanceof java.awt.Cursor) {
            super.setCursor((java.awt.Cursor)((Object)cursor));
        }
    }

    public Dimension getMinimumSize() {
        Rectangle rectangle = new Rectangle();
        FigureEnumeration figureEnumeration = this.drawing().figures();
        while (figureEnumeration.hasNextFigure()) {
            rectangle.add(figureEnumeration.nextFigure().displayBox());
        }
        return new Dimension(rectangle.width, rectangle.height);
    }

    public class DrawingViewKeyListener
    implements KeyListener {
        private Command deleteCmd = this.createDeleteCommand();

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            if (n2 == 0 && (n == 8 || n == 127)) {
                if (this.deleteCmd.isExecutable()) {
                    this.deleteCmd.execute();
                }
            } else if (n2 == 0 && (n == 40 || n == 38 || n == 39 || n == 37)) {
                this.handleCursorKey(n);
            } else {
                StandardDrawingView.this.tool().keyDown(keyEvent, n);
            }
            StandardDrawingView.this.checkDamage();
        }

        protected void handleCursorKey(int n) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            int n5 = 1;
            if (StandardDrawingView.this.fConstrainer != null) {
                n4 = StandardDrawingView.this.fConstrainer.getStepX();
                n5 = StandardDrawingView.this.fConstrainer.getStepY();
            }
            switch (n) {
                case 40: {
                    n3 = n5;
                    break;
                }
                case 38: {
                    n3 = -n5;
                    break;
                }
                case 39: {
                    n2 = n4;
                    break;
                }
                case 37: {
                    n2 = -n4;
                }
            }
            StandardDrawingView.this.moveSelection(n2, n3);
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        protected Command createDeleteCommand() {
            return new UndoableCommand(new DeleteCommand("Delete", StandardDrawingView.this.editor()));
        }
    }

    public class DrawingViewMouseMotionListener
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            try {
                Point point = StandardDrawingView.this.constrainPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                StandardDrawingView.this.tool().mouseDrag(mouseEvent, point.x, point.y);
                StandardDrawingView.this.checkDamage();
            }
            catch (Throwable throwable) {
                StandardDrawingView.this.handleMouseEventException(throwable);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            try {
                StandardDrawingView.this.tool().mouseMove(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
            }
            catch (Throwable throwable) {
                StandardDrawingView.this.handleMouseEventException(throwable);
            }
        }
    }

    public class DrawingViewMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            try {
                StandardDrawingView.this.requestFocus();
                Point point = StandardDrawingView.this.constrainPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                StandardDrawingView.this.setLastClick(new Point(mouseEvent.getX(), mouseEvent.getY()));
                StandardDrawingView.this.tool().mouseDown(mouseEvent, point.x, point.y);
                StandardDrawingView.this.checkDamage();
            }
            catch (Throwable throwable) {
                StandardDrawingView.this.handleMouseEventException(throwable);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                Point point = StandardDrawingView.this.constrainPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                StandardDrawingView.this.tool().mouseUp(mouseEvent, point.x, point.y);
                StandardDrawingView.this.checkDamage();
            }
            catch (Throwable throwable) {
                StandardDrawingView.this.handleMouseEventException(throwable);
            }
        }
    }

    class ASH
    extends AutoscrollHelper {
        public ASH(int n) {
            super(n);
        }

        public Dimension getSize() {
            return StandardDrawingView.this.getSize();
        }

        public Rectangle getVisibleRect() {
            return StandardDrawingView.this.getVisibleRect();
        }

        public void scrollRectToVisible(Rectangle rectangle) {
            StandardDrawingView.this.scrollRectToVisible(rectangle);
        }
    }
}

