/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.AbstractValueAnimator;
import org.openimaj.content.animation.animator.ReversableValueAnimator;

public class LinearByteValueAnimator
extends AbstractValueAnimator<Byte>
implements ReversableValueAnimator<Byte> {
    byte start;
    byte finish;
    byte incr;
    byte current;

    public LinearByteValueAnimator(byte start, byte finish, int duration) {
        super(start, 0, 0);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (byte)((finish - start) / (byte)duration);
    }

    public LinearByteValueAnimator(int startWait, int stopWait, byte start, byte finish, int duration) {
        super(start, startWait, stopWait);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (byte)((finish - start) / (byte)duration);
    }

    @Override
    public Byte makeNextValue() {
        this.current = (byte)(this.current + this.incr);
        if (this.start < this.finish && this.current > this.finish) {
            this.current = this.finish;
        } else if (this.start > this.finish && this.current < this.finish) {
            this.current = this.finish;
        }
        return this.current;
    }

    @Override
    protected boolean complete() {
        if (this.incr == 0) {
            return true;
        }
        byte next = (byte)(this.current + this.incr);
        if (this.start < this.finish && (double)next - 1.0E-7 > (double)this.finish) {
            return true;
        }
        return this.start > this.finish && (double)next + 1.0E-7 < (double)this.finish;
    }

    @Override
    protected void resetToInitial() {
        this.current = this.start;
    }

    @Override
    public ReversableValueAnimator<Byte> reverseAnimator() {
        byte curr = this.current;
        byte sta = this.start;
        this.reset();
        this.current = curr;
        this.incr = (byte)(this.incr * -1);
        this.start = this.finish;
        this.finish = sta;
        return this;
    }
}

