/*
Copyright (c) 2019 - 2023 Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef RPPT_H
#define RPPT_H

/*!
 * \file
 * \brief RPP Tensor Operations
 * \defgroup group_rppt RPP Tensor Operations
 * \brief The header includes all files containing RPP Tensor Operations
 */

#include "rpp.h"
#ifdef __cplusplus
extern "C" {
#endif

#include "rppt_tensor_color_augmentations.h"
#include "rppt_tensor_data_exchange_operations.h"
#include "rppt_tensor_effects_augmentations.h"
#include "rppt_tensor_filter_augmentations.h"
#include "rppt_tensor_geometric_augmentations.h"
#include "rppt_tensor_morphological_operations.h"
#include "rppt_tensor_arithmetic_operations.h"
#include "rppt_tensor_statistical_operations.h"
#include "rppt_tensor_audio_augmentations.h"

#ifdef __cplusplus
}
#endif
#endif // RPPT_H
