/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.lang.reflect;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.onemind.commons.java.datastructure.LookupCache;

public class ClassLookupCache
extends LookupCache {
    private static final HashSet _packages = new LinkedHashSet();
    private static final Logger _logger = Logger.getLogger((class$org$onemind$commons$java$lang$reflect$ClassLookupCache == null ? (class$org$onemind$commons$java$lang$reflect$ClassLookupCache = ClassLookupCache.class$("org.onemind.commons.java.lang.reflect.ClassLookupCache")) : class$org$onemind$commons$java$lang$reflect$ClassLookupCache).getName());
    static /* synthetic */ Class class$org$onemind$commons$java$lang$reflect$ClassLookupCache;

    public void addPackage(String packageName) {
        if (packageName.endsWith(".*")) {
            packageName = packageName.substring(0, packageName.length() - 2);
        }
        _packages.add(packageName);
        this.clearNegCache();
    }

    public Class getClass(String className) {
        if (className.indexOf(46) == -1) {
            Iterator it = _packages.iterator();
            Class c = null;
            while (it.hasNext()) {
                String fullName = (String)it.next() + "." + className;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Looking up class " + fullName);
                }
                if ((c = (Class)this.lookup(fullName)) == null) continue;
                return c;
            }
            return null;
        }
        return (Class)this.lookup(className);
    }

    public Object produce(Object key) {
        Class<?> c;
        block3: {
            String className = (String)key;
            c = null;
            try {
                c = Class.forName(className);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Lookup class " + key + " successful");
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINEST)) break block3;
                _logger.finest("Lookup class " + key + " failed");
            }
        }
        return c;
    }

    public Set getPackages() {
        return Collections.unmodifiableSet(_packages);
    }

    protected void clearNegCache() {
        super.clearNegCache();
    }

    protected boolean isInCache(Object o) {
        return super.isInCache(o);
    }

    protected boolean isInNegCache(Object o) {
        return super.isInNegCache(o);
    }

    protected void setDoNegativeCache(boolean b) {
        super.setDoNegativeCache(b);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

