/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.registry.Documentation;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.DocumentationImpl;
import org.java.plugin.registry.xml.ModelPrerequisite;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

class PluginPrerequisiteImpl
implements PluginPrerequisite {
    private static Log log = LogFactory.getLog(class$org$java$plugin$registry$xml$PluginPrerequisiteImpl == null ? (class$org$java$plugin$registry$xml$PluginPrerequisiteImpl = PluginPrerequisiteImpl.class$("org.java.plugin.registry.xml.PluginPrerequisiteImpl")) : class$org$java$plugin$registry$xml$PluginPrerequisiteImpl);
    private final PluginDescriptorImpl descriptor;
    private final PluginFragmentImpl fragment;
    private final ModelPrerequisite model;
    private DocumentationImpl doc;
    static /* synthetic */ Class class$org$java$plugin$registry$xml$PluginPrerequisiteImpl;

    static boolean matches(Version version, Version version2, String string) {
        if (version == null) {
            return true;
        }
        if ("equal".equals(string)) {
            return version2.equals(version);
        }
        if ("equivalent".equals(string)) {
            return version2.isEquivalentTo(version);
        }
        if ("compatible".equals(string)) {
            return version2.isCompatibleWith(version);
        }
        if ("greater-or-equal".equals(string)) {
            return version2.isGreaterOrEqualTo(version);
        }
        return version2.isCompatibleWith(version);
    }

    PluginPrerequisiteImpl(PluginDescriptorImpl pluginDescriptorImpl, PluginFragmentImpl pluginFragmentImpl, ModelPrerequisite modelPrerequisite) throws ManifestProcessingException {
        this.descriptor = pluginDescriptorImpl;
        this.fragment = pluginFragmentImpl;
        this.model = modelPrerequisite;
        if (this.model.getPluginId() == null || this.model.getPluginId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "prerequisitePliginIdIsBlank", pluginDescriptorImpl.getId());
        }
        if (pluginDescriptorImpl.getId().equals(this.model.getPluginId())) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "invalidPrerequisitePluginId", pluginDescriptorImpl.getId());
        }
        if (this.model.getId() == null || this.model.getId().trim().length() == 0) {
            this.model.setId("prerequisite:" + this.model.getPluginId());
        }
        if (this.model.getDocumentation() != null) {
            this.doc = new DocumentationImpl(this, this.model.getDocumentation());
        }
        log.debug("object instantiated: " + this);
    }

    public String getPluginId() {
        return this.model.getPluginId();
    }

    public Version getPluginVersion() {
        return this.model.getPluginVersion();
    }

    public PluginDescriptor getDeclaringPluginDescriptor() {
        return this.descriptor;
    }

    public PluginFragment getDeclaringPluginFragment() {
        return this.fragment;
    }

    public boolean isOptional() {
        return this.model.isOptional();
    }

    public boolean matches() {
        PluginDescriptor pluginDescriptor = null;
        try {
            pluginDescriptor = this.descriptor.getRegistry().getPluginDescriptor(this.model.getPluginId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return PluginPrerequisiteImpl.matches(this.model.getPluginVersion(), pluginDescriptor.getVersion(), this.model.getMatch());
    }

    public String getMatch() {
        return this.model.getMatch();
    }

    public boolean isExported() {
        return this.model.isExported();
    }

    public String getId() {
        return this.model.getId();
    }

    public String getDocsPath() {
        return this.fragment != null ? this.fragment.getDocsPath() : this.descriptor.getDocsPath();
    }

    public Documentation getDocumentation() {
        return this.doc;
    }

    public String getUniqueId() {
        return this.descriptor.getRegistry().makeUniqueId(this.descriptor.getId(), this.getId());
    }

    public String toString() {
        return "{Prerequisite: uid=" + this.getUniqueId() + "}";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

