// RUN: rm -rf %t
// RUN: split-file %s %t

// Check that with a sufficiently new SDK not searching for module maps in subdirectories.

// New SDK.
// RUN: %clang -target x86_64-apple-macos10.13 -isysroot %t/MacOSX15.0.sdk -fmodules %t/test.c -### 2>&1 \
// RUN:   | FileCheck --check-prefix=NO-SUBDIRECTORIES %t/test.c
// Old SDK.
// RUN: %clang -target x86_64-apple-macos10.13 -isysroot %t/MacOSX14.0.sdk -fmodules %t/test.c -### 2>&1 \
// RUN:   | FileCheck --check-prefix=SEARCH-SUBDIRECTORIES %t/test.c
// Non-Darwin platform.
// RUN: %clang -target i386-unknown-linux -isysroot %t/MacOSX15.0.sdk -fmodules %t/test.c -### 2>&1 \
// RUN:   | FileCheck --check-prefix=SEARCH-SUBDIRECTORIES %t/test.c
// New SDK overriding the default.
// RUN: %clang -target x86_64-apple-macos10.13 -isysroot %t/MacOSX15.0.sdk -fmodules %t/test.c -fmodulemap-allow-subdirectory-search -### 2>&1 \
// RUN:   | FileCheck --check-prefix=SEARCH-SUBDIRECTORIES %t/test.c

//--- test.c
// NO-SUBDIRECTORIES: "-fno-modulemap-allow-subdirectory-search"
// SEARCH-SUBDIRECTORIES-NOT: "-fno-modulemap-allow-subdirectory-search"

//--- MacOSX15.0.sdk/SDKSettings.json
{
  "CanonicalName": "macosx15.0",
  "Version": "15.0",
  "IsBaseSDK": "YES",
  "DisplayName": "macOS 15.0",
  "MinimalDisplayName": "15.0",
  "SupportedTargets": {
    "macosx": {
      "PlatformFamilyName": "macOS",
      "PlatformFamilyDisplayName": "macOS",
      "Archs": ["x86_64", "x86_64h", "arm64", "arm64e"], "LLVMTargetTripleVendor": "apple", "LLVMTargetTripleSys": "macos", "LLVMTargetTripleEnvironment": "",
      "BuildVersionPlatformID": "1",
      "ClangRuntimeLibraryPlatformName": "osx",
      "SystemPrefix": "",
      "DefaultDeploymentTarget": "15.0",
      "RecommendedDeploymentTarget": "11.0",
      "MinimumDeploymentTarget": "10.13", "MaximumDeploymentTarget": "15.0.99",
      "ValidDeploymentTargets": ["10.13", "10.14", "10.15", "11.0", "11.1", "11.2", "11.3", "11.4", "11.5", "12.0", "12.2", "12.3", "12.4", "13.0", "13.1", "13.2", "13.3", "13.4", "13.5", "14.0", "14.1", "14.2", "14.3", "14.4", "14.5", "14.6", "15.0"]
    },
    "iosmac": {
      "Archs": ["x86_64", "x86_64h", "arm64", "arm64e"], "LLVMTargetTripleVendor": "apple", "LLVMTargetTripleSys": "ios", "LLVMTargetTripleEnvironment": "macabi",
      "BuildVersionPlatformID": "6",
      "ClangRuntimeLibraryPlatformName": "osx",
      "SystemPrefix": "/System/iOSSupport",
      "DefaultDeploymentTarget": "18.0",
      "RecommendedDeploymentTarget": "14.2",
      "MinimumDeploymentTarget": "13.1", "MaximumDeploymentTarget": "18.0.99",
      "ValidDeploymentTargets": ["13.1", "13.2", "13.3", "13.3.1", "13.4", "13.5", "14.0", "14.1", "14.2", "14.3", "14.4", "14.5", "14.6", "14.7", "15.0", "15.2", "15.3", "15.4", "15.5", "15.6", "16.0", "16.1", "16.2", "16.3", "16.4", "16.5", "16.6", "17.0", "17.1", "17.2", "17.3", "17.4", "17.5", "17.6", "18.0"]
    }
  },
  "VersionMap": {
    "macOS_iOSMac": {"10.15": "13.1", "10.15.1": "13.2", "10.15.2": "13.3", "10.15.3": "13.3.1", "10.15.4": "13.4", "10.15.5": "13.5",                                 "11.0": "14.2", "11.0.1": "14.2", "11.1": "14.3", "11.2": "14.4", "11.3": "14.5", "11.4": "14.6", "11.5": "14.7", "12.0": "15.0", "12.0.1": "15.0", "12.1": "15.2", "12.2": "15.3", "12.3": "15.4", "12.4": "15.5", "12.5": "15.6", "13.0": "16.1",                 "13.1": "16.2", "13.2": "16.3", "13.3": "16.4", "13.4": "16.5", "13.5": "16.6", "14.0": "17.0", "14.1": "17.1", "14.2": "17.2", "14.3": "17.3", "14.4": "17.4", "14.5": "17.5", "14.6": "17.6", "15.0": "18.0"},
    "iOSMac_macOS": {"13.1": "10.15", "13.2": "10.15.1", "13.3": "10.15.2", "13.3.1": "10.15.3", "13.4": "10.15.4", "13.5": "10.15.5", "14.0": "11.0", "14.1": "11.0", "14.2": "11.0",                   "14.3": "11.1", "14.4": "11.2", "14.5": "11.3", "14.6": "11.4", "14.7": "11.5", "15.0": "12.0",                   "15.2": "12.1", "15.3": "12.2", "15.4": "12.3", "15.5": "12.4", "15.6": "12.5", "16.0": "13.0", "16.1": "13.0", "16.2": "13.1", "16.3": "13.2", "16.4": "13.3", "16.5": "13.4", "16.6": "13.5", "17.0": "14.0", "17.1": "14.1", "17.2": "14.2", "17.3": "14.3", "17.4": "14.4", "17.5": "14.5", "17.6": "14.6", "18.0": "15.0"}
  },
  "DefaultDeploymentTarget": "15.0",
  "MaximumDeploymentTarget": "15.0.99"
}

//--- MacOSX14.0.sdk/SDKSettings.json
{
  "CanonicalName": "macosx14.0",
  "Version": "14.0",
  "IsBaseSDK": "YES",
  "DisplayName": "macOS 14.0",
  "MinimalDisplayName": "14.0",
  "SupportedTargets": {
    "macosx": {
      "PlatformFamilyName": "macOS",
      "PlatformFamilyDisplayName": "macOS",
      "Archs": ["x86_64", "x86_64h", "arm64", "arm64e"], "LLVMTargetTripleVendor": "apple", "LLVMTargetTripleSys": "macos", "LLVMTargetTripleEnvironment": "",
      "BuildVersionPlatformID": "1",
      "ClangRuntimeLibraryPlatformName": "osx",
      "SystemPrefix": "",
      "DefaultDeploymentTarget": "14.0",
      "RecommendedDeploymentTarget": "10.14.6",
      "MinimumDeploymentTarget": "10.13", "MaximumDeploymentTarget": "14.0.99",
      "ValidDeploymentTargets": ["10.13", "10.14", "10.15", "11.0", "11.1", "11.2", "11.3", "11.4", "11.5", "12.0", "12.2", "12.3", "12.4", "13.0", "13.1", "13.2", "13.3", "13.4", "13.5", "14.0"]
    },
    "iosmac": {
      "Archs": ["x86_64", "x86_64h", "arm64", "arm64e"], "LLVMTargetTripleVendor": "apple", "LLVMTargetTripleSys": "ios", "LLVMTargetTripleEnvironment": "macabi",
      "BuildVersionPlatformID": "6",
      "ClangRuntimeLibraryPlatformName": "osx",
      "SystemPrefix": "/System/iOSSupport",
      "DefaultDeploymentTarget": "17.0",
      "RecommendedDeploymentTarget": "13.1",
      "MinimumDeploymentTarget": "13.1", "MaximumDeploymentTarget": "17.0.99",
      "ValidDeploymentTargets": ["13.1", "13.2", "13.3", "13.3.1", "13.4", "13.5", "14.0", "14.1", "14.2", "14.3", "14.4", "14.5", "14.6", "14.7", "15.0", "15.2", "15.3", "15.4", "15.5", "15.6", "16.0", "16.1", "16.2", "16.3", "16.4", "16.5", "16.6", "17.0"]
    }
  },
  "VersionMap": {
    "macOS_iOSMac": {"10.15": "13.1", "10.15.1": "13.2", "10.15.2": "13.3", "10.15.3": "13.3.1", "10.15.4": "13.4", "10.15.5": "13.5",                                 "11.0": "14.2", "11.0.1": "14.2", "11.1": "14.3", "11.2": "14.4", "11.3": "14.5", "11.4": "14.6", "11.5": "14.7", "12.0": "15.0", "12.0.1": "15.0", "12.1": "15.2", "12.2": "15.3", "12.3": "15.4", "12.4": "15.5", "12.5": "15.6", "13.0": "16.1",                 "13.1": "16.2", "13.2": "16.3", "13.3": "16.4", "13.4": "16.5", "13.5": "16.6", "14.0": "17.0"},
    "iOSMac_macOS": {"13.1": "10.15", "13.2": "10.15.1", "13.3": "10.15.2", "13.3.1": "10.15.3", "13.4": "10.15.4", "13.5": "10.15.5", "14.0": "11.0", "14.1": "11.0", "14.2": "11.0",                   "14.3": "11.1", "14.4": "11.2", "14.5": "11.3", "14.6": "11.4", "14.7": "11.5", "15.0": "12.0",                   "15.2": "12.1", "15.3": "12.2", "15.4": "12.3", "15.5": "12.4", "15.6": "12.5", "16.0": "13.0", "16.1": "13.0", "16.2": "13.1", "16.3": "13.2", "16.4": "13.3", "16.5": "13.4", "16.6": "13.5", "17.0": "14.0"}
  },
  "DefaultDeploymentTarget": "14.0",
  "MaximumDeploymentTarget": "14.0.99"
}
