/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class WindowsFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String osType;
    private String vsPath;
    private String jdkPath;
    private int requireJDK;
    private String errorMessage = "\n\n\nError messages:\n";
    private int countError = 0;
    private int installSuccess;
    private String currentDir = "";
    private String installerShell = "";
    private String installerLog = "";
    private String vsLinkUrl;
    private String sdkLinkUrl;
    private String jdkLinkUrl;
    private JPanel infoContentPane = null;
    private JPanel vsPathContentPane = null;
    private JPanel jdkPathContentPane = null;
    private JPanel compileContentPane = null;
    private JPanel finishContentPane = null;
    private JButton infoPrevButton = null;
    private JButton infoNextButton = null;
    private JButton vsPathPrevButton = null;
    private JButton vsPathNextButton = null;
    private JButton jdkPathPrevButton = null;
    private JButton jdkPathNextButton = null;
    private JButton compilePrevButton = null;
    private JButton compileNextButton = null;
    private JButton finishPrevButton = null;
    private JButton finishNextButton = null;
    private JLabel infoLabel = null;
    private JLabel infoLinkLabel = null;
    private JLabel infoSDKLinkLabel = null;
    private JLabel vsPathLabel = null;
    private JLabel jdkPathLabel = null;
    private JLabel compileLabel = null;
    private JLabel finishSuccessLabel = null;
    private JLabel finishFailLabel = null;
    private JTextField vsPathTextField = null;
    private JButton vsPathChooseButton = null;
    private JButton jdkPathChooseButton = null;
    private JTextField jdkPathTextField = null;
    private JTextArea compileTextArea = null;
    private JScrollPane compileScrollPane = null;
    private JCheckBox vsPathUseJavaCheckBox = null;

    public WindowsFrame() {
        this.initialize();
    }

    public WindowsFrame(String osType) {
        this.osType = osType;
        this.initialize();
    }

    private void initialize() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        this.setSize(screenWidth / 4 * 3, screenHeight / 4 * 3);
        this.setLocation(screenWidth / 8, screenHeight / 8);
        this.setContentPane(this.getInfoContentPane());
        this.setTitle("XSB Installation");
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        try {
            this.currentDir = MainRun.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            this.currentDir = this.currentDir.substring(0, this.currentDir.lastIndexOf(47) + 1);
            this.currentDir = URLDecoder.decode(this.currentDir, "utf-8");
            this.currentDir = new File(this.currentDir).getPath();
            this.installerShell = this.currentDir + "\\installer\\windowsinstall.bat \"" + this.currentDir + "\" ";
            this.installerLog = this.currentDir + "\\Installer.log";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getFrameHeight() {
        return this.getHeight();
    }

    private int getFrameWidth() {
        return this.getWidth();
    }

    private JPanel getInfoContentPane() {
        if (this.infoContentPane == null) {
            this.infoContentPane = new JPanel();
            this.infoContentPane.setLayout(null);
            this.infoContentPane.add(this.getInfoLabel());
            this.infoContentPane.add(this.getInfoLinkLabel());
            if (this.osType.contains("64")) {
                this.infoContentPane.add(this.getInfoSDKLinkLabel());
            }
            this.infoContentPane.add(this.getInfoNextButton());
            this.infoContentPane.add(this.getInfoPrevButton());
        }
        return this.infoContentPane;
    }

    private JButton getInfoPrevButton() {
        if (this.infoPrevButton == null) {
            this.infoPrevButton = new JButton();
            this.infoPrevButton.setText("Previous");
            this.infoPrevButton.setEnabled(false);
            this.infoPrevButton.setBounds(200, this.getFrameHeight() - 100, 100, 30);
        }
        return this.infoPrevButton;
    }

    private JButton getInfoNextButton() {
        if (this.infoNextButton == null) {
            this.infoNextButton = new JButton();
            this.infoNextButton.setText("Next");
            this.infoNextButton.setBounds(this.getFrameWidth() - 350, this.getFrameHeight() - 100, 100, 30);
            this.infoNextButton.addActionListener(new InfoNextListener());
        }
        return this.infoNextButton;
    }

    private JLabel getInfoLabel() {
        if (this.infoLabel == null) {
            this.infoLabel = new JLabel();
            String message = "<html><body><h1>XSB Installation</h1><br/><br/><h3>Operating system: " + this.osType + ".</h3><br/><h3>Please make sure that Visual Studio with the C++ compiler is installed on your system.<br/><h3>If not, you can download it for free from:</h3></body></html>";
            this.infoLabel.setText(message);
            this.infoLabel.setBounds(30, 20, 600, 300);
        }
        return this.infoLabel;
    }

    private JLabel getInfoLinkLabel() {
        if (this.infoLinkLabel == null) {
            this.infoLinkLabel = new JLabel();
            Properties props = new Properties();
            try {
                InputStream in = Object.class.getResourceAsStream("/link.properties");
                props.load(in);
                this.vsLinkUrl = props.getProperty("visualstudio");
                System.out.println(this.vsLinkUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String message = "<html><body><h3><a href=\"\">" + this.vsLinkUrl + "</a></body></h3></html>";
            this.infoLinkLabel.setText(message);
            this.infoLinkLabel.setBounds(40, 300, 300, 30);
            this.infoLinkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        Runtime.getRuntime().exec("cmd.exe /c start " + WindowsFrame.this.vsLinkUrl);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    WindowsFrame.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    WindowsFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            });
        }
        return this.infoLinkLabel;
    }

    private JLabel getInfoSDKLinkLabel() {
        if (this.infoSDKLinkLabel == null) {
            this.infoSDKLinkLabel = new JLabel();
            Properties props = new Properties();
            try {
                InputStream in = Object.class.getResourceAsStream("/link.properties");
                props.load(in);
                this.sdkLinkUrl = props.getProperty("net");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String message = "<html><body><h3>Since you are using a 64-bit Windows system, you may also need</h3><br/><h3>&nbsp;&nbsp;<a href=\"\">.Net Framework</a>.</h3></html>";
            this.infoSDKLinkLabel.setText(message);
            this.infoSDKLinkLabel.setBounds(30, 350, 450, 120);
            this.infoSDKLinkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        Runtime.getRuntime().exec("cmd.exe /c start " + WindowsFrame.this.sdkLinkUrl);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    WindowsFrame.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    WindowsFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            });
        }
        return this.infoSDKLinkLabel;
    }

    private JPanel getVsPathContentPane() {
        if (this.vsPathContentPane == null) {
            this.vsPathContentPane = new JPanel();
            this.vsPathContentPane.setLayout(null);
            this.vsPathContentPane.add(this.getVsPathLabel());
            this.vsPathContentPane.add(this.getVsPathNextButton());
            this.vsPathContentPane.add(this.getVsPathPrevButton());
            this.vsPathContentPane.add(this.getVsPathChooseButton());
            this.vsPathContentPane.add(this.getVsPathTextField());
            this.vsPathContentPane.add(this.getVsPathUseJavaCheckBox());
        }
        return this.vsPathContentPane;
    }

    private JButton getVsPathPrevButton() {
        if (this.vsPathPrevButton == null) {
            this.vsPathPrevButton = new JButton();
            this.vsPathPrevButton.setText("Previous");
            this.vsPathPrevButton.setBounds(200, this.getFrameHeight() - 100, 100, 30);
            this.vsPathPrevButton.addActionListener(new VsPathPrevListener());
        }
        return this.vsPathPrevButton;
    }

    private JButton getVsPathNextButton() {
        if (this.vsPathNextButton == null) {
            this.vsPathNextButton = new JButton();
            this.vsPathNextButton.setText("Next");
            this.vsPathNextButton.setBounds(this.getFrameWidth() - 350, this.getFrameHeight() - 100, 100, 30);
            this.vsPathNextButton.addActionListener(new VsPathNextListener());
        }
        return this.vsPathNextButton;
    }

    private JLabel getVsPathLabel() {
        if (this.vsPathLabel == null) {
            this.vsPathLabel = new JLabel();
            String message = "<html><body><h1>XSB Installation</h1><br/><br/><h3>Please enter the full path name of a Visual Studio's settings file in your installation of the studio.<br/>A settings file has one of these names:<br/><br/>&nbsp;&nbsp;&nbsp;  vcvarsx86_amd64.bat, vcvars62.bat, or similar (to compile XSB as a 64 bit app - <i>recommended</i>)<br/>&nbsp;&nbsp;&nbsp;  vcvars32.bat (to compile as a 32 bit app)</h3><br/>Use Windows search for the appropriate file, if the exact full path is not known.<br/></body></html>";
            this.vsPathLabel.setText(message);
            this.vsPathLabel.setBounds(30, 20, 800, 250);
        }
        return this.vsPathLabel;
    }

    private JButton getVsPathChooseButton() {
        if (this.vsPathChooseButton == null) {
            this.vsPathChooseButton = new JButton();
            this.vsPathChooseButton.setText("Browse");
            this.vsPathChooseButton.setBounds(340, 280, 100, 30);
            this.vsPathChooseButton.addActionListener(new VsPathChooseListener());
        }
        return this.vsPathChooseButton;
    }

    private JTextField getVsPathTextField() {
        if (this.vsPathTextField == null) {
            this.vsPathTextField = new JTextField();
            this.vsPathTextField.setBounds(30, 280, 300, 30);
        }
        return this.vsPathTextField;
    }

    private JCheckBox getVsPathUseJavaCheckBox() {
        if (this.vsPathUseJavaCheckBox == null) {
            this.vsPathUseJavaCheckBox = new JCheckBox();
            this.vsPathUseJavaCheckBox.setText("Check if you require faster XSB-Java interface");
            this.vsPathUseJavaCheckBox.setBounds(30, 320, 300, 30);
        }
        return this.vsPathUseJavaCheckBox;
    }

    private JPanel getJdkPathContentPane() {
        if (this.jdkPathContentPane == null) {
            this.jdkPathContentPane = new JPanel();
            this.jdkPathContentPane.setLayout(null);
            this.jdkPathContentPane.add(this.getJdkPathLabel());
            this.jdkPathContentPane.add(this.getJdkPathNextButton());
            this.jdkPathContentPane.add(this.getJdkPathPrevButton());
            this.jdkPathContentPane.add(this.getJdkPathChooseButton());
            this.jdkPathContentPane.add(this.getJdkPathTextField());
        }
        return this.jdkPathContentPane;
    }

    private JButton getJdkPathPrevButton() {
        if (this.jdkPathPrevButton == null) {
            this.jdkPathPrevButton = new JButton();
            this.jdkPathPrevButton.setText("Previous");
            this.jdkPathPrevButton.setEnabled(false);
            this.jdkPathPrevButton.setBounds(200, this.getFrameHeight() - 100, 100, 30);
        }
        return this.jdkPathPrevButton;
    }

    private JButton getJdkPathNextButton() {
        if (this.jdkPathNextButton == null) {
            this.jdkPathNextButton = new JButton();
            this.jdkPathNextButton.setText("Next");
            this.jdkPathNextButton.setBounds(this.getFrameWidth() - 350, this.getFrameHeight() - 100, 100, 30);
            this.jdkPathNextButton.addActionListener(new JdkPathNextListener());
        }
        return this.jdkPathNextButton;
    }

    private JLabel getJdkPathLabel() {
        if (this.jdkPathLabel == null) {
            this.jdkPathLabel = new JLabel();
            Properties props = new Properties();
            try {
                InputStream in = Object.class.getResourceAsStream("/link.properties");
                props.load(in);
                this.jdkLinkUrl = props.getProperty("jdk");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String message = "<html><body><h1>XSB Installation</h1><br/><br/><h3>The environment variable JAVA_HOME has not been set.</h3><br/><h3>Make sure that Java JDK (not just JRE!) is installed. If it is not, download it from</h3><br/><h3>&nbsp;&nbsp;<a href=\"\">" + this.jdkLinkUrl + "</a></h3><br/><br/><h3>Once the JDK is installed, please enter the folder where it resides on your system:</h3><br/><br/></body></html>";
            this.jdkPathLabel.setText(message);
            this.jdkPathLabel.setBounds(30, 20, 600, 300);
            this.jdkPathLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        Runtime.getRuntime().exec("cmd.exe /c start " + WindowsFrame.this.jdkLinkUrl);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    WindowsFrame.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    WindowsFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            });
        }
        return this.jdkPathLabel;
    }

    private JButton getJdkPathChooseButton() {
        if (this.jdkPathChooseButton == null) {
            this.jdkPathChooseButton = new JButton();
            this.jdkPathChooseButton.setText("Browse");
            this.jdkPathChooseButton.setBounds(340, 340, 100, 30);
            this.jdkPathChooseButton.addActionListener(new JdkPathChooseListener());
        }
        return this.jdkPathChooseButton;
    }

    private JTextField getJdkPathTextField() {
        if (this.jdkPathTextField == null) {
            this.jdkPathTextField = new JTextField();
            this.jdkPathTextField.setBounds(30, 340, 300, 30);
        }
        return this.jdkPathTextField;
    }

    private JPanel getCompileContentPane() {
        if (this.compileContentPane == null) {
            this.compileContentPane = new JPanel();
            this.compileContentPane.setLayout(null);
            this.compileContentPane.add(this.getCompileLabel());
            this.compileContentPane.add(this.getCompileNextButton());
            this.compileContentPane.add(this.getCompilePrevButton());
            this.compileContentPane.add(this.getCompileScrollPane());
            this.installation();
        }
        return this.compileContentPane;
    }

    private JButton getCompilePrevButton() {
        if (this.compilePrevButton == null) {
            this.compilePrevButton = new JButton();
            this.compilePrevButton.setText("Previous");
            this.compilePrevButton.setEnabled(false);
            this.compilePrevButton.setBounds(200, this.getFrameHeight() - 80, 100, 30);
        }
        return this.compilePrevButton;
    }

    private JButton getCompileNextButton() {
        if (this.compileNextButton == null) {
            this.compileNextButton = new JButton();
            this.compileNextButton.setText("Next");
            this.compileNextButton.setBounds(this.getFrameWidth() - 350, this.getFrameHeight() - 80, 100, 30);
            this.compileNextButton.setEnabled(false);
            this.compileNextButton.addActionListener(new CompileNextListener());
        }
        return this.compileNextButton;
    }

    private JLabel getCompileLabel() {
        if (this.compileLabel == null) {
            this.compileLabel = new JLabel();
            String message = "<html><body><h1>XSB is being compiled ...</h1><br/></body></html>";
            this.compileLabel.setText(message);
            this.compileLabel.setBounds(30, 0, 600, 50);
        }
        return this.compileLabel;
    }

    private JScrollPane getCompileScrollPane() {
        if (this.compileScrollPane == null) {
            this.compileScrollPane = new JScrollPane();
            this.compileScrollPane.setBounds(10, 60, this.getFrameWidth() - 20, this.getFrameHeight() - 160);
            this.compileScrollPane.setViewportView(this.getCompileTextArea());
            this.getCompileTextArea().setLineWrap(true);
        }
        return this.compileScrollPane;
    }

    private JTextArea getCompileTextArea() {
        if (this.compileTextArea == null) {
            this.compileTextArea = new JTextArea();
        }
        return this.compileTextArea;
    }

    private JPanel getFinishContentPane() {
        if (this.finishContentPane == null) {
            this.finishContentPane = new JPanel();
            this.finishContentPane.setLayout(null);
            if (this.installSuccess == 1) {
                this.finishContentPane.add(this.getFinishSuccessLabel());
            } else {
                this.finishContentPane.add(this.getFinishFailLabel());
            }
            this.finishContentPane.add(this.getFinishNextButton());
            this.finishContentPane.add(this.getFinishPrevButton());
        }
        return this.finishContentPane;
    }

    private JButton getFinishPrevButton() {
        if (this.finishPrevButton == null) {
            this.finishPrevButton = new JButton();
            this.finishPrevButton.setText("Previous");
            this.finishPrevButton.setEnabled(false);
            this.finishPrevButton.setBounds(200, this.getFrameHeight() - 100, 100, 30);
        }
        return this.finishPrevButton;
    }

    private JButton getFinishNextButton() {
        if (this.finishNextButton == null) {
            this.finishNextButton = new JButton();
            this.finishNextButton.setText("Finish");
            this.finishNextButton.setBounds(this.getFrameWidth() - 350, this.getFrameHeight() - 100, 100, 30);
            this.finishNextButton.addActionListener(new FinishNextListener());
        }
        return this.finishNextButton;
    }

    private JLabel getFinishSuccessLabel() {
        if (this.finishSuccessLabel == null) {
            this.finishSuccessLabel = new JLabel();
            String xsbShell = this.osType.contains("32") ? "xsb.bat" : "xsb64.bat";
            String message = "<html><body><h1>XSB Installation</h1><br/><br/><h2>The installation was successful. The log is in " + this.installerLog + "</h2><br/><h3>You can run XSB using:</h3><h3>&nbsp;&nbsp;" + this.currentDir + "\\bin\\" + xsbShell + "</h3></br><br/><h3>Click <i>Finish</i> to exit.</h3></body></html>";
            this.finishSuccessLabel.setText(message);
            this.finishSuccessLabel.setBounds(30, 20, 600, 400);
        }
        return this.finishSuccessLabel;
    }

    private JLabel getFinishFailLabel() {
        if (this.finishFailLabel == null) {
            this.finishFailLabel = new JLabel();
            String message = "<html><body><h1>XSB Installation</h1><br/><br/><h2>The installation was not successful.</h2><br/><h2>Please check " + this.installerLog + " for errors.</h2><br/><br/><h2>Click <i>Finish</i> to exit.</h2></body></html>";
            this.finishFailLabel.setText(message);
            this.finishFailLabel.setBounds(30, 20, 600, 400);
        }
        return this.finishFailLabel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void installation() {
        if (this.requireJDK == 1) {
            if (this.jdkPath.charAt(this.jdkPath.length() - 1) == '\\') {
                this.jdkPath = this.jdkPath.substring(0, this.jdkPath.length() - 1);
            }
            String customSetting1 = "XSB_INTERPROLOG=yes";
            String customSetting2 = "MY_INCLUDE_DIRS=/I\"" + this.jdkPath + "\\include\" /I\"" + this.jdkPath + "\\include\\win32\"";
            String windowsType = null;
            windowsType = this.osType.contains("32") ? "windows" : "windows64";
            try {
                Process proc = Runtime.getRuntime().exec("cmd /c echo " + customSetting1 + " > build\\" + windowsType + "\\custom_settings.mak");
                proc.waitFor();
                Process process = Runtime.getRuntime().exec("cmd /c echo " + customSetting2 + " >> build\\" + windowsType + "\\custom_settings.mak");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            String setvcvar;
            String makexsb;
            System.out.println(this.vsPath);
            String vsDisk = this.vsPath.substring(0, 2);
            String xsbDisk = this.currentDir.substring(0, 2);
            String xsbarch = "";
            if (this.osType.contains("32") || this.vsPath.contains("vcvars32.bat")) {
                makexsb = "makexsb.bat";
                xsbarch = "x86-pc-windows";
                if (!this.vsPath.contains("vcvars32.bat")) {
                    JOptionPane.showMessageDialog(this, "Visual Studio's settings file for 32 bit Windows must be vcvars32.bat");
                    return;
                }
                setvcvar = this.vsPath;
            } else {
                String cpuType = System.getProperty("sun.cpu.isalist");
                xsbarch = "x64-pc-windows";
                if (cpuType.contains("amd64")) {
                    makexsb = "makexsb64.bat";
                    setvcvar = this.vsPath;
                } else {
                    makexsb = "makexsb64.bat";
                    setvcvar = this.vsPath;
                }
            }
            Process process = Runtime.getRuntime().exec("cmd /c " + this.installerShell + "\"" + setvcvar + "\" " + vsDisk + " " + xsbDisk + " \"" + this.currentDir + "\" " + makexsb + " " + xsbarch);
            final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            final BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            Thread t1 = new Thread(){

                @Override
                public void run() {
                    String line = null;
                    try {
                        while ((line = bufferedReader.readLine()) != null) {
                            if (line.contains("=== done ===")) {
                                JOptionPane.showMessageDialog(WindowsFrame.this, "Compilation is complete. Scroll down to see if there were any errors.");
                                WindowsFrame.this.compileNextButton.setEnabled(true);
                                if (WindowsFrame.this.countError == 0) {
                                    WindowsFrame.this.errorMessage = WindowsFrame.this.errorMessage + "No\n";
                                }
                                WindowsFrame.this.getCompileTextArea().setText(WindowsFrame.this.getCompileTextArea().getText() + WindowsFrame.this.errorMessage);
                                String testSucc = WindowsFrame.this.osType.contains("32") ? WindowsFrame.this.currentDir + "\\bin\\xsb.bat -v" : WindowsFrame.this.currentDir + "\\bin\\xsb64.bat -v";
                                Process resultProcess = Runtime.getRuntime().exec(testSucc);
                                try {
                                    resultProcess.waitFor();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                if (resultProcess.exitValue() == 1) {
                                    WindowsFrame.this.installSuccess = 0;
                                } else {
                                    WindowsFrame.this.installSuccess = 1;
                                }
                                File file = new File(WindowsFrame.this.installerLog);
                                if (!file.exists()) {
                                    file.createNewFile();
                                }
                                String totalMessage = WindowsFrame.this.getCompileTextArea().getText();
                                FileOutputStream fw = new FileOutputStream(file);
                                fw.write(totalMessage.getBytes());
                                fw.flush();
                                fw.close();
                                break;
                            }
                            WindowsFrame.this.getCompileTextArea().setText(WindowsFrame.this.getCompileTextArea().getText() + "\n   >" + line);
                            JScrollBar sbar = WindowsFrame.this.getCompileScrollPane().getVerticalScrollBar();
                            sbar.setValue(sbar.getMaximum());
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            Thread t2 = new Thread(){

                @Override
                public void run() {
                    String line = null;
                    try {
                        while ((line = errorReader.readLine()) != null) {
                            System.out.println(line);
                            if (line.contains("Could Not Find") || line.contains("Microsoft (R) Program Maintenance Utility Version") || line.contains("Copyright (C) Microsoft Corporation")) continue;
                            WindowsFrame.this.countError++;
                            WindowsFrame.this.errorMessage = WindowsFrame.this.errorMessage + "\n" + line;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            t1.start();
            t2.start();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class FinishNextListener
    implements ActionListener {
        FinishNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            System.exit(0);
        }
    }

    class CompileNextListener
    implements ActionListener {
        CompileNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            WindowsFrame.this.setContentPane(WindowsFrame.this.getFinishContentPane());
            WindowsFrame.this.validate();
        }
    }

    class JdkPathChooseListener
    implements ActionListener {
        JdkPathChooseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JFileChooser fc = new JFileChooser("C:\\Program Files");
            fc.setFileSelectionMode(1);
            File f = null;
            int flag = fc.showOpenDialog(null);
            if (flag == 0) {
                f = fc.getSelectedFile();
                WindowsFrame.this.jdkPath = f.getPath();
            }
            WindowsFrame.this.getJdkPathTextField().setText(WindowsFrame.this.jdkPath);
        }
    }

    class JdkPathNextListener
    implements ActionListener {
        JdkPathNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            WindowsFrame.this.jdkPath = WindowsFrame.this.getJdkPathTextField().getText();
            if (Tools.fileExist(WindowsFrame.this.jdkPath + "\\bin\\javac.exe") == 0 || Tools.fileExist(WindowsFrame.this.jdkPath + "\\include\\jni.h") == 0 || Tools.fileExist(WindowsFrame.this.jdkPath + "\\include\\win32\\jni_md.h") == 0) {
                JOptionPane.showMessageDialog(WindowsFrame.this, "JDK not found at the given location.");
                return;
            }
            WindowsFrame.this.setContentPane(WindowsFrame.this.getCompileContentPane());
            WindowsFrame.this.validate();
        }
    }

    class VsPathChooseListener
    implements ActionListener {
        VsPathChooseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JFileChooser fc = new JFileChooser("C:");
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Batch files", "bat");
            fc.setFileFilter(filter);
            File f = null;
            int flag = fc.showOpenDialog(null);
            if (flag == 0) {
                f = fc.getSelectedFile();
                WindowsFrame.this.vsPath = f.getPath();
            }
            WindowsFrame.this.getVsPathTextField().setText(WindowsFrame.this.vsPath);
        }
    }

    class VsPathNextListener
    implements ActionListener {
        VsPathNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            WindowsFrame.this.vsPath = WindowsFrame.this.getVsPathTextField().getText();
            WindowsFrame.this.requireJDK = 0;
            if (WindowsFrame.this.getVsPathUseJavaCheckBox().isSelected()) {
                WindowsFrame.this.requireJDK = 1;
                boolean needJavaHome = true;
                Map<String, String> env = System.getenv();
                for (Map.Entry<String, String> entry : env.entrySet()) {
                    if (!entry.getKey().toString().equals("JAVA_HOME")) continue;
                    WindowsFrame.this.jdkPath = entry.getValue().toString();
                    if (Tools.fileExist(WindowsFrame.this.jdkPath + "\\bin\\javac.exe") != 0 && Tools.fileExist(WindowsFrame.this.jdkPath + "\\include\\jni.h") != 0 && Tools.fileExist(WindowsFrame.this.jdkPath + "\\include\\win32\\jni_md.h") != 0) break;
                    needJavaHome = false;
                    break;
                }
                if (needJavaHome) {
                    WindowsFrame.this.setContentPane(WindowsFrame.this.getJdkPathContentPane());
                    WindowsFrame.this.validate();
                    return;
                }
            }
            WindowsFrame.this.setContentPane(WindowsFrame.this.getCompileContentPane());
            WindowsFrame.this.validate();
        }
    }

    class VsPathPrevListener
    implements ActionListener {
        VsPathPrevListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            WindowsFrame.this.setContentPane(WindowsFrame.this.getInfoContentPane());
            WindowsFrame.this.validate();
        }
    }

    class InfoNextListener
    implements ActionListener {
        InfoNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            WindowsFrame.this.setContentPane(WindowsFrame.this.getVsPathContentPane());
            WindowsFrame.this.validate();
        }
    }
}

