/*
Do not forget to set PATH. Something like this:
  Linux, sh/bash:
    export PATH=$PATH:$HOME/progs/minizinc/MiniZincIDE-2.2.3-bundle-linux/bin
  Windows:
    set PATH=%PATH%;"C:\progs\minizinc\MiniZincIDE-2.2.3-bundle-linux\bin"
*/

:- import
        solve_flex/8,
        solve/8
   from minizinc.

%% For optimization problems, the number of solutions must always be 1
%% or else it will return also non-optimal solutions.

%% Australia
?- nl, writeln('Example: Australia'),
   (solve('examples/australia.mzn',[],[],_,4,au(wa,nt,sa,q,nsw,v,t),Result,_Exceptions),
       writeln(Result),
       fail
   ;
       true
   ).

%% Australia2
?- nl, writeln('Example: Australia2'),
   (solve('examples/australia2.mzn',[],['Color' = '{ red, yellow, blue }'],_,3,
          au2(+'W. Australia'=wa, +'N. Territory'=nt, +'S. Australia'=sa, +'Queensland'=q, +'New S. Wales'=nsw, +'Victoria'=v, +'Tasmania'=t),
          au2(S1=C1,S2=C2,S3=C3,S4=C4,S5=C5,S6=C6,S7=C7),
          _Exceptions),
       writeln(au_colors(S1=C1,S2=C2,S3=C3,S4=C4,S5=C5,S6=C6,S7=C7)),
       fail
   ;
       true
   ).

%% bake.mzn
%% This example also illustrates the use of solve_flex, which is delayed because
%% the in-parameters butter and cocoa are not ground.
?- nl, writeln('Example: Baking cookies'),
   (solve_flex('examples/bake.mzn',['examples/bake.dzn'],[butter=Butter,cocoa=Cocoa],_,1,bake(str(price)=price,str(bananaCakes)=b,str(cocoaCakes)=c),Result,_Exceptions),
       Butter = 1500,
       Cocoa=800,
       writeln(Result),
       fail
   ;
       true
   ).

%% Stable Marriage: as an example, using non-default 'chuffed' solver
%% bundled with Minizinc.
%% The chuffed solver is not nearly as powerful as gecode (default);
%% it cannot do optimization, for example.
%% This example also illustrates the use of solve_flex, which is delayed because
%% the in-parameter rank=MenRanking is not ground.
?- nl, writeln('Example: Stable marriage'),
   (solve_flex('examples/marriage.mzn',['examples/marriage.dzn'],[rankMen=MenRanking],chuffed,4,marriage(wife=husband),Result,_Exceptions),
       MenRanking = '[|5,1,2,4,3,|4,1,3,2,5,|5,3,2,4,1,|1,5,4,3,2,|4,3,2,1,5|]',
       writeln(Result),
       fail
   ;
       true
   ).

%% prod-planning.mzn
?- nl, writeln('Example: Product planning'),
   (solve('examples/prod-planning.mzn',['examples/prod-planning.dzn','examples/prod-planning2.dzn'],[profit=[400,550]],_,1,plan(+profit=maxprofit,'Products'=produce,'Resources'=used),Result,_Exceptions),
       writeln(Result),
       fail
   ;
       true
   ).

%% N queens
?- nl, writeln('Example: N Queens'),
   (solve('examples/queens.mzn',[],[n=13],_,3,board(q),Result,_Exceptions),
       writeln(Result),
       fail
   ;
       true
   ).

%% SEND+MORE+MONEY: as an example, using non-default 'chuffed' solver
%% bundled with Minizinc.
%% The chuffed solver is not nearly as powerful as gecode (default);
%% it cannot do optimization, for example.
?- nl, writeln('Example: Sendmoney'),
   (solve('examples/sendmoney.mzn',[],[],chuffed,3,money(+send = ['S','E','N','D'],+more = ['M','O','R','E'], +money = ['M','O','N','E','Y']),Result,_Exceptions),
       writeln(Result),
       fail
   ;
       true
   ).

%% Knapsack
?- nl, writeln('Example: Knapsack'),
   (solve('examples/knapsack.mzn',['examples/knapsack.dzn'],[capacity=200,weights=[90,72,43,40,33], 'ITEM'=anon_enum(5)],_,1,sack(+ 'total weight' = total_weight,+'total profit' = total_profit, +knapsack = knapsack),Result,_Exceptions),
       writeln(Result),
       fail
   ;
       true
   ).

%% Social golfers
?- nl, writeln('Example: Golfers'),
   (solve('examples/golfer.mzn',[],[weeks=4,groups=4,size=3],_,3,golfer(str(groups) = 'GROUP',str(weeks) = 'WEEK', str(schedule) = 'Sched'),Result,_Exceptions),
       writeln(Result),
       fail
   ;
       true
   ).

%% Job shop
?- nl, writeln('Example: Job shop'),
   (solve('examples/jobshop.mzn',['examples/jobshop.dzn'],['JOB'=anon_enum(5),'TASK'=anon_enum(5)],_,1,jobs(+total_duration=end,+jobs = 'JOB',+tasks = 'TASK', +schedule = s),Result,_Exceptions),
       writeln(Result),
       fail
   ;
       true
   ).
