/* File:      xpathconfig.P -- loader for the XPATH foreign module
** Author(s): Rohan Shirwaikar
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 2004-2018
** 
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**      http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
**
*/


:- compiler_options([xpp_on]).
#include "extensions_xsb.h"


:- import xsb_running_under/1, force_rename_file/2 from packaging.
:- import slash/1, str_cat/3 from machine.
:- import search_module/6 from consult.
:- import compile_so/3, runtime_loader_flag/3 from foreign.
:- import path_sysop/3, path_sysop/2, fmt_write_string/3 from file_io.
:- import xpath_info/2 from xpath_init.
:- import xsb_configuration/2 from xsb_configuration.
:- import concat_atom/2 from string.


'_$_make_xpathH'(CC, CC_opts) :-
	slash(Slash),
	xsb_configuration(configuration, XSBconfiguration),
	xpath_info(ldflags, LoaderFlagsBase),
        concat_atom([LoaderFlagsBase, ' -lcurl'], LoaderFlags),
	((xsb_running_under(unix) ; xsb_running_under(darwin)) ->
	    LD_flags = LoaderFlags
	; %% Cygwin. Under Windows loader options are ignored
	    str_cat(' -lwsock32 ', LoaderFlags, LD_flags)
	),

	package_configuration(dir(xpath), XPathDir),
	fmt_write_string(LD_directives_file,
			 '%s%scc%sxpathparser.H', f(XPathDir, Slash, Slash)),
	telling(OldTell),
	tell(LD_directives_file),
	writeln('%% This file is generated on-the-fly by xpathconfig.P'),
	writeln('%% Do not edit--any changes will be written over.'),
	write('%% config:    '), writeln(XSBconfiguration),
	write('%% CC:        '), writeln(CC),
	write('%% CC Opts: '), writeln(CC_opts), 
	writeln(':- export parse_xpath__/4, allocate_xpath_error_term__/1.'),
	write(':- ldoption('''),
	write(LD_flags),
	writeln(''').'),
	told,
	tell(OldTell).


:-
    [xpath_init],
    xpath_info(support,'no'),
    abort('++Error[XPATH]> The xpath package is not configured. Please configure it first.').


:-
    package_configuration(dir(xpath), XPathDir),  
    slash(Slash),
    Basename = xpathparser,
    xsb_configuration(config_libdir, ConfigLibDir),
    xsb_configuration(compiler, CC),
    xsb_configuration(config_dir, ConfigDir),
    xpath_info(ccflags, CCflags),
    xsb_configuration(config_bindir, ConfigBinDir),

    %% These construct the files where the included Windows copy of
    %% libxml2, iconv, etc., is sitting
    (xsb_running_under(windows64) -> PkgDlls = bin64
    ; PkgDlls = bin
    ),
    fmt_write_string(WindXML2Dlls,
		     '%s%scc%s%s%s*.dll',f(XPathDir,Slash,Slash,PkgDlls,Slash)),
    fmt_write_string(WindXML2Libs,
		     '%s%scc%s%s%s*.lib',f(XPathDir,Slash,Slash,PkgDlls,Slash)),

    fmt_write_string(Module, '%s%scc%s%s', f(XPathDir,Slash,Slash,Basename)),
    fmt_write_string(LibObjFile,
		     '%s%s%s%s',
		     args(ConfigLibDir,Slash,Basename,XSB_OBJ_EXTENSION_ATOM)),
    fmt_write_string(Curl, '%s%s..%scurl%scc', 
				 f(XPathDir, Slash, Slash, Slash)),
    fmt_write_string(CurlHFile, '%s%s..%scurl%scc%sload_page.c', 
				 f(XPathDir, Slash, Slash, Slash, Slash)),
    fmt_write_string(CC_opts, ' %s -I %s -I %s %s', f(CCflags, ConfigDir, Curl, CurlHFile)),
    str_cat(Module, XSB_OBJ_EXTENSION_ATOM, Objfile),
    ((xsb_running_under(windows) ; xsb_running_under(cygwin))
    ->
	fmt_write_string(ConfigSharedMod,
			 '%s%s%s.dll', f(ConfigBinDir, Slash, Basename))
    ; xsb_running_under(darwin)
    ->
	fmt_write_string(ConfigSharedMod,
			 '%s%s%s.dylib', f(ConfigLibDir, Slash, Basename))
    ;
	fmt_write_string(ConfigSharedMod,
			 '%s%s%s.so',  f(ConfigLibDir, Slash, Basename))
    ),
    (   %% avoid recompilation
	search_module(Basename,Dir,_Mod,_Ext,BaseDir,ModuleO),
	str_cat(Module, '.c', ModuleSourceFile),
	path_sysop(newerthan,ModuleO,ModuleSourceFile),
	path_sysop(newerthan,ConfigSharedMod,ModuleSourceFile)
    %% module compiled and is current, so just load
    -> [Basename]
    
    %% If Module isn't compiled or is old --- recompile
    ;
	'_$_make_xpathH'(CC, CC_opts),
	(xsb_running_under(windows) ->
	    %% Copy libxml2, iconv, zlib libraries from xpath/cc/bin
	    shell(['copy /B /Y ', '"', WindXML2Dlls, '"', ' ', '"', ConfigBinDir, '"']),
	    shell(['copy /B /Y ', '"', WindXML2Libs, '"', ' ', '"', ConfigBinDir, '"']),
	    [Basename],
	    (path_sysop(exists,Objfile) -> force_rename_file(Objfile, LibObjFile)
	    ; true
	    )

	; xsb_running_under(cygwin) ->
	    %% Copy libxml2, iconv, zlib libraries from xpath/cc/bin
	    shell(['copy /B /Y ', '"', WindXML2Dlls, '"', ' ', '"', ConfigBinDir, '"']),
	    shell(['copy /B /Y ', '"', WindXML2Libs, '"', ' ', '"', ConfigBinDir, '"']),

	    str_cat(Module, '.dll', SharedLib),
	    consult(Module, [cc(CC), cc_opts(CC_opts)]),
	    force_rename_file(SharedLib, ConfigSharedMod),
	    force_rename_file(Objfile, LibObjFile),
	    str_cat(Module, '.o', ObjfileO),
	    fmt_write_string(LibObjFileO,
			     '%s%s%s.o', f(ConfigBinDir, Slash, Basename)),
	    force_rename_file(ObjfileO, LibObjFileO),
	    str_cat(Module, '.a', ObjfileA),
	    fmt_write_string(LibObjFileA,
			     '%s%s%s.a', f(ConfigBinDir, Slash, Basename)),
	    force_rename_file(ObjfileA, LibObjFileA),
	    str_cat(Module, '.def', ObjfileDef),
	    fmt_write_string(LibObjFileDef,
			     '%s%s%s.def', f(ConfigBinDir, Slash, Basename)),
	    force_rename_file(ObjfileDef, LibObjFileDef)

	; xsb_running_under(darwin) ->  %% MacOS
	    consult(Module, [cc(CC), cc_opts(CC_opts)]),
	    force_rename_file(Objfile, LibObjFile),
	    str_cat(Module, '.dylib', SharedLib),
	    force_rename_file(SharedLib,ConfigSharedMod)
	; %% Other Unices
	    consult(Module, [cc(CC), cc_opts(CC_opts)]),
	    force_rename_file(Objfile, LibObjFile),
	    str_cat(Module, '.so', SharedLib),
	    force_rename_file(SharedLib,ConfigSharedMod)
	)
    ).
