/* File:      gensym.P
** Author(s): Kostis F, Sagonas, Jiyang Xu 
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 1986, 1993-1999
** Copyright (C) ECRC, Germany, 1990
** 
** XSB is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XSB is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XSB; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: gensym.P,v 1.7 2004/05/17 19:16:17 dwarren Exp $
** 
*/

/*======================================================================*/
/* prepare for compiler and type inference				*/
/*======================================================================*/

:- compiler_options([sysmod,optimize]).

/* TLS -- I dont understand this comment, so am adding prepare/1 */
prepare :- conset(gennum_val, 300).	/* for gennum and gensym */
		/* big number to avoid conflict in internal variable */
		/* generated by gennum with read-in variable numbered */
		/* from 0 above */

:- mode prepare(+).
prepare(N) :- 
	integer(N),N >= 0,
	conset(gennum_val, N).	

/*----conlength---------------------------------------------------------*/

:- mode conlength(+,?).
conlength(Con, Length) :-
	conname(Con, Name), str_len(Name, Len), Length = Len.

/*----gennum------------------------------------------------------------*/
:- conset(gennum_val,0).
:- mode gennum(?).
gennum(N) :- conget(gennum_val, O), N is O + 1, conset(gennum_val, N).

:- mode gennum(+,?).
gennum(Obj,N) :-
	nonvar(Obj), conget(Obj, O), N is O + 1, conset(Obj, N).

/*----gensym------------------------------------------------------------*/

:- mode gensym(+,?).
gensym(Root, Sym) :-
	(atom(Root),var(Sym)
	->  gennum(N),
	    number_codes(N,NLst), atom_codes(NAtm, NLst),
	    str_cat(Root, NAtm, Sym)
	;   abort('Wrong type argument in gensym/2')
	).


%% Implemented as builtins to speedup backtrackable updates

:- mode conset(+,+).
conset(Con, Val) :- conset(Con,Val).

:- mode conget(+,?).
conget(Con, Val) :- conget(Con,Val).
/*
conset(Con, Val) :- 
	term_psc(Con, Psc), psc_set_prop(Psc, Val).

conget(Con, Val) :- 
	term_psc(Con, Psc), psc_prop(Psc, Val0), Val = Val0.
*/

:- mode coninc(+).
coninc(Con) :-
	term_psc(Con, Psc), psc_prop(Psc, N),
	NewN is N+1, psc_set_prop(Psc, NewN).

:- mode coninc(+,?).
coninc(Con,NewN) :-
	term_psc(Con, Psc), psc_prop(Psc, N),
	NewN is N+1, psc_set_prop(Psc, NewN).

/*======================================================================*/
/* counter routines. A counter is a unary term.				*/
/*======================================================================*/

:- mode newcounter(?).
newcounter(C) :- term_psc(C, Psc), psc_set_type(Psc, 8),
	arg(1, C, V), 
	( integer(V), V0 = V
	; V0 = 0
	),
	psc_set_prop(Psc, V0).

:- mode inccounter(?).
inccounter(C) :- term_psc(C, Psc), psc_prop(Psc, V), 
		 V1 is V + 1, psc_set_prop(Psc, V1).

:- mode getcounter(?).
getcounter(C) :- term_psc(C, Psc), psc_prop(Psc, V), arg(1, C, V).

/*======================================================================*/
/* call a goal every Count times entered.				*/
/*   Can be useful for periodic logging.				*/
/*======================================================================*/

:- mode call_every(?,+,+).
call_every(Goal,Count,UniqueIDAtom) :-
    coninc(UniqueIDAtom,I),
    (I >= Count
     -> call(Goal),
	conset(UniqueIDAtom,0)
     ;	true
    ).

