/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.artifacts.ivyservice.DefaultUnresolvedDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.locking.LockOutOfDateException;

public class DependencyLockingGraphVisitor
implements DependencyGraphVisitor {
    private final DependencyLockingProvider dependencyLockingProvider;
    private final String configurationName;
    private Set<ModuleComponentIdentifier> allResolvedModules;
    private Set<ModuleComponentIdentifier> changingResolvedModules;
    private Set<ModuleComponentIdentifier> extraModules;
    private Map<ModuleComponentIdentifier, String> forcedModules;
    private Map<ModuleIdentifier, ModuleComponentIdentifier> modulesToBeLocked;
    private DependencyLockingState dependencyLockingState;
    private boolean lockOutOfDate = false;

    public DependencyLockingGraphVisitor(String configurationName, DependencyLockingProvider dependencyLockingProvider) {
        this.configurationName = configurationName;
        this.dependencyLockingProvider = dependencyLockingProvider;
    }

    @Override
    public void start(RootGraphNode root) {
        this.dependencyLockingState = this.dependencyLockingProvider.loadLockState(this.configurationName);
        if (this.dependencyLockingState.mustValidateLockState()) {
            Set<ModuleComponentIdentifier> lockedModules = this.dependencyLockingState.getLockedDependencies();
            this.modulesToBeLocked = Maps.newHashMapWithExpectedSize((int)lockedModules.size());
            for (ModuleComponentIdentifier lockedModule : lockedModules) {
                this.modulesToBeLocked.put(lockedModule.getModuleIdentifier(), lockedModule);
            }
            this.allResolvedModules = Sets.newHashSetWithExpectedSize((int)this.modulesToBeLocked.size());
            this.extraModules = Sets.newHashSet();
            this.forcedModules = Maps.newHashMap();
        } else {
            this.modulesToBeLocked = Collections.emptyMap();
            this.allResolvedModules = Sets.newHashSet();
        }
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        boolean changing = false;
        ComponentIdentifier identifier = node.getOwner().getComponentId();
        ComponentGraphResolveMetadata metadata = node.getOwner().getMetadataOrNull();
        if (metadata != null && metadata.isChanging()) {
            changing = true;
        }
        if (!node.isRoot() && identifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier id = (ModuleComponentIdentifier)identifier;
            if (identifier instanceof MavenUniqueSnapshotComponentIdentifier) {
                id = ((MavenUniqueSnapshotComponentIdentifier)id).getSnapshotComponent();
            }
            if (!id.getVersion().isEmpty() && this.allResolvedModules.add(id)) {
                if (changing) {
                    this.addChangingModule(id);
                }
                if (this.dependencyLockingState.mustValidateLockState()) {
                    ModuleComponentIdentifier lockedId = this.modulesToBeLocked.remove(id.getModuleIdentifier());
                    if (lockedId == null) {
                        if (!this.dependencyLockingState.getIgnoredEntryFilter().isSatisfiedBy(id)) {
                            this.extraModules.add(id);
                        }
                    } else if (!lockedId.getVersion().equals(id.getVersion()) && !this.isNodeRejected(node)) {
                        this.forcedModules.put(lockedId, id.getVersion());
                    }
                }
            }
        }
    }

    private boolean isNodeRejected(DependencyGraphNode node) {
        return node.getComponent().isRejected();
    }

    private void addChangingModule(ModuleComponentIdentifier id) {
        if (this.changingResolvedModules == null) {
            this.changingResolvedModules = new HashSet<ModuleComponentIdentifier>();
        }
        this.changingResolvedModules.add(id);
    }

    @Override
    public void visitSelector(DependencyGraphSelector selector) {
    }

    @Override
    public void visitEdges(DependencyGraphNode node) {
    }

    @Override
    public void finish(DependencyGraphNode root) {
    }

    public void writeLocks() {
        if (!this.lockOutOfDate) {
            Set<ModuleComponentIdentifier> changingModules = this.changingResolvedModules == null ? Collections.emptySet() : this.changingResolvedModules;
            this.dependencyLockingProvider.persistResolvedDependencies(this.configurationName, this.allResolvedModules, changingModules);
        }
    }

    public Set<UnresolvedDependency> collectLockingFailures() {
        if (!(!this.dependencyLockingState.mustValidateLockState() || this.modulesToBeLocked.isEmpty() && this.extraModules.isEmpty() && this.forcedModules.isEmpty())) {
            this.lockOutOfDate = true;
            return DependencyLockingGraphVisitor.createLockingFailures(this.modulesToBeLocked, this.extraModules, this.forcedModules);
        }
        return Collections.emptySet();
    }

    private static Set<UnresolvedDependency> createLockingFailures(Map<ModuleIdentifier, ModuleComponentIdentifier> modulesToBeLocked, Set<ModuleComponentIdentifier> extraModules, Map<ModuleComponentIdentifier, String> forcedModules) {
        HashSet completedFailures = Sets.newHashSetWithExpectedSize((int)(modulesToBeLocked.values().size() + extraModules.size()));
        for (ModuleComponentIdentifier moduleComponentIdentifier : modulesToBeLocked.values()) {
            completedFailures.add(new DefaultUnresolvedDependency(DefaultModuleVersionSelector.newSelector(moduleComponentIdentifier.getModuleIdentifier(), moduleComponentIdentifier.getVersion()), new LockOutOfDateException("Did not resolve '" + moduleComponentIdentifier.getDisplayName() + "' which is part of the dependency lock state")));
        }
        for (ModuleComponentIdentifier moduleComponentIdentifier : extraModules) {
            completedFailures.add(new DefaultUnresolvedDependency(DefaultModuleVersionSelector.newSelector(moduleComponentIdentifier.getModuleIdentifier(), moduleComponentIdentifier.getVersion()), new LockOutOfDateException("Resolved '" + moduleComponentIdentifier.getDisplayName() + "' which is not part of the dependency lock state")));
        }
        for (Map.Entry entry : forcedModules.entrySet()) {
            ModuleComponentIdentifier forcedModule = (ModuleComponentIdentifier)entry.getKey();
            completedFailures.add(new DefaultUnresolvedDependency(DefaultModuleVersionSelector.newSelector(forcedModule.getModuleIdentifier(), forcedModule.getVersion()), new LockOutOfDateException("Did not resolve '" + forcedModule.getDisplayName() + "' which has been forced / substituted to a different version: '" + (String)entry.getValue() + "'")));
        }
        return completedFailures;
    }
}

