/* SPDX-FileCopyrightText: 2024 Greenbone AG
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

import React from 'react';

import _ from 'gmp/locale';

import {isDefined} from 'gmp/utils/identity';

import PropTypes from 'web/utils/proptypes';

import Divider from 'web/components/layout/divider';
import Layout from 'web/components/layout/layout';

import DetailsLink from 'web/components/link/detailslink';

import InfoTable from 'web/components/table/infotable';
import TableBody from 'web/components/table/body';
import TableData from 'web/components/table/data';
import TableRow from 'web/components/table/row';

import {Col} from 'web/entity/page';

const ScanConfigDetails = ({entity}) => {
  const {comment, deprecated, tasks = []} = entity;
  return (
    <Layout flex="column" grow>
      <InfoTable>
        <colgroup>
          <Col width="10%" />
          <Col width="90%" />
        </colgroup>
        <TableBody>
          {deprecated && (
            <TableRow>
              <TableData>{_('Deprecated')}</TableData>
              <TableData>{_('yes')}</TableData>
            </TableRow>
          )}
          {isDefined(comment) && (
            <TableRow>
              <TableData>{_('Comment')}</TableData>
              <TableData>{comment}</TableData>
            </TableRow>
          )}
          {tasks.length > 0 && (
            <TableRow>
              <TableData>{_('Tasks using this Scan Config')}</TableData>
              <TableData>
                <Divider wrap>
                  {tasks.map((task, index) => {
                    return (
                      <React.Fragment key={task.id}>
                        <DetailsLink id={task.id} type="task">
                          {task.name}
                        </DetailsLink>
                        {index !== tasks.length - 1 && ','}
                      </React.Fragment>
                    );
                  })}
                </Divider>
              </TableData>
            </TableRow>
          )}
        </TableBody>
      </InfoTable>
    </Layout>
  );
};

ScanConfigDetails.propTypes = {
  entity: PropTypes.model.isRequired,
};

export default ScanConfigDetails;

// vim: set ts=2 sw=2 tw=80:
