/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;

@JRubyClass(name={"Enumerator::ArithmeticSequence"}, parent="Enumerator")
public class RubyArithmeticSequence
extends RubyObject {
    public static final String GENERATOR = "@__generator__";
    public static final String LOOKAHEAD = "@__lookahead__";
    public static final String FEEDVALUE = "@__feedvalue__";
    public static final String OBJECT = "@__object__";
    public static final String METHOD = "@__method__";
    public static final String ARGS = "@__args__";
    private IRubyObject begin;
    private IRubyObject end;
    private IRubyObject step;
    private IRubyObject excludeEnd;
    private IRubyObject generatedBy;
    private String method;
    private IRubyObject[] args;

    public static RubyClass createArithmeticSequenceClass(Ruby runtime2, RubyClass enumeratorModule) {
        RubyClass sequencec = runtime2.defineClassUnder("ArithmeticSequence", enumeratorModule, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, enumeratorModule);
        sequencec.includeModule(runtime2.getEnumerable());
        sequencec.defineAnnotatedMethods(RubyArithmeticSequence.class);
        RubyClass seqMetaClass = sequencec.getMetaClass();
        seqMetaClass.undefineMethod("new");
        return sequencec;
    }

    public RubyArithmeticSequence(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public RubyArithmeticSequence(Ruby runtime2, RubyClass klass, IRubyObject generatedBy, String method2, IRubyObject[] args2, IRubyObject begin2, IRubyObject end2, IRubyObject step2, IRubyObject excludeEnd) {
        super(runtime2, klass);
        this.begin = begin2;
        this.end = end2;
        this.step = step2;
        this.excludeEnd = excludeEnd;
        this.generatedBy = generatedBy;
        this.method = method2;
        this.args = args2;
        this.setInstanceVariable(OBJECT, generatedBy);
        this.setInstanceVariable(METHOD, RubyString.newString(runtime2, method2));
        this.setInstanceVariable(ARGS, args2 != null ? RubyArray.newArrayMayCopy(runtime2, args2) : RubyArray.newEmptyArray(runtime2));
        this.setInstanceVariable(GENERATOR, runtime2.getNil());
        this.setInstanceVariable(LOOKAHEAD, RubyArray.newArray(runtime2, 4));
        this.setInstanceVariable(FEEDVALUE, new RubyEnumerator.FeedValue(runtime2));
    }

    public static RubyArithmeticSequence newArithmeticSequence(ThreadContext context, IRubyObject generatedBy, String method2, IRubyObject[] args2, IRubyObject begin2, IRubyObject end2, IRubyObject step2, IRubyObject excludeEnd) {
        return new RubyArithmeticSequence(context.runtime, context.runtime.getArithmeticSequence(), generatedBy, method2, args2, begin2, end2, step2, excludeEnd);
    }

    private static JavaSites.NumericSites sites(ThreadContext context) {
        return context.sites.Numeric;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        IRubyObject c = this.begin;
        IRubyObject e = this.end;
        IRubyObject s2 = this.step;
        if (!block.isGiven()) {
            return this;
        }
        if (!(this.step instanceof RubyComplex) && RubyNumeric.floatStep(context, c, e, s2, this.excludeEnd.isTrue(), true, block)) {
            return this;
        }
        if (this.end.isNil()) {
            while (true) {
                block.yield(context, c);
                c = ((RubyNumeric)c).op_plus(context, s2);
            }
        }
        if (Helpers.rbEqual(context, this.step, RubyNumeric.int2fix(context.runtime, 0L)).isTrue()) {
            while (true) {
                block.yield(context, c);
            }
        }
        IRubyObject len_1 = ((RubyNumeric)((RubyNumeric)e).op_minus(context, c)).idiv(context, s2);
        IRubyObject last2 = ((RubyNumeric)c).op_plus(context, Numeric.f_mul(context, s2, len_1));
        if (this.excludeEnd.isTrue() && Helpers.rbEqual(context, last2, e).isTrue()) {
            last2 = ((RubyNumeric)last2).op_minus(context, s2);
        }
        CallSite op_ge2 = RubyArithmeticSequence.sites((ThreadContext)context).op_ge;
        if (Numeric.f_negative_p(context, s2)) {
            while (RubyNumeric.numFuncall(context, c, op_ge2, last2).isTrue()) {
                block.yield(context, c);
                c = ((RubyNumeric)c).op_plus(context, s2);
            }
        } else {
            while (RubyNumeric.numFuncall(context, last2, op_ge2, c).isTrue()) {
                block.yield(context, c);
                c = ((RubyNumeric)c).op_plus(context, s2);
            }
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject first(ThreadContext context) {
        return this.first(context, null);
    }

    @JRubyMethod
    public IRubyObject first(ThreadContext context, IRubyObject num) {
        Ruby runtime2 = context.runtime;
        IRubyObject b2 = this.begin;
        IRubyObject e = this.end;
        IRubyObject s2 = this.step;
        if (num == null) {
            if (b2.isNil()) {
                return context.nil;
            }
            if (!e.isNil()) {
                RubyNumeric zero = RubyNumeric.int2fix(runtime2, 0L);
                CallSite op_cmp2 = RubyArithmeticSequence.sites((ThreadContext)context).op_cmp;
                CachingCallSite op_gt2 = RubyArithmeticSequence.sites((ThreadContext)context).op_gt;
                CachingCallSite op_lt2 = RubyArithmeticSequence.sites((ThreadContext)context).op_lt;
                int r = RubyComparable.cmpint(context, ((RubyNumeric)this.step).coerceCmp(context, op_cmp2, (IRubyObject)zero), s2, zero);
                if (r > 0 && RubyNumeric.numFuncall(context, b2, op_gt2, e).isTrue()) {
                    return context.nil;
                }
                if (r < 0 && RubyNumeric.numFuncall(context, b2, op_lt2, e).isTrue()) {
                    return context.nil;
                }
            }
            return b2;
        }
        long n = RubyNumeric.num2long(num);
        if (n < 0L) {
            throw runtime2.newArgumentError("attempt to take negative size");
        }
        if (n == 0L) {
            return runtime2.newEmptyArray();
        }
        boolean x = this.excludeEnd.isTrue();
        if (b2 instanceof RubyFixnum && e.isNil() && s2 instanceof RubyFixnum) {
            long i2 = RubyNumeric.fix2long(b2);
            long unit = RubyNumeric.fix2long(s2);
            RubyArray ary = RubyArray.newArray(runtime2, n);
            while (n > 0L && RubyNumeric.fixable(runtime2, i2)) {
                ary.append(RubyFixnum.newFixnum(runtime2, i2));
                i2 += unit;
                --n;
            }
            if (n > 0L) {
                b2 = RubyFixnum.newFixnum(runtime2, i2);
                while (n > 0L) {
                    ary.append(b2);
                    b2 = ((RubyInteger)b2).op_plus(context, s2);
                    --n;
                }
            }
            return ary;
        }
        if (b2 instanceof RubyFixnum && e instanceof RubyFixnum && s2 instanceof RubyFixnum) {
            RubyArray ary;
            long i3 = RubyNumeric.fix2long(b2);
            long end2 = RubyNumeric.fix2long(e);
            long unit = RubyNumeric.fix2long(s2);
            if (unit >= 0L) {
                long len;
                if (!x) {
                    ++end2;
                }
                if ((len = end2 - i3) < 0L) {
                    len = 0L;
                }
                ary = RubyArray.newArray(runtime2, n < len ? n : len);
                while (n > 0L && i3 < end2) {
                    ary.append(RubyFixnum.newFixnum(runtime2, i3));
                    if (i3 + unit >= i3) {
                        i3 += unit;
                        --n;
                        continue;
                    }
                    break;
                }
            } else {
                long len;
                if (!x) {
                    --end2;
                }
                if ((len = i3 - end2) < 0L) {
                    len = 0L;
                }
                ary = RubyArray.newArray(runtime2, n < len ? n : len);
                while (n > 0L && i3 > end2) {
                    ary.append(RubyFixnum.newFixnum(runtime2, i3));
                    if (i3 + unit <= i3) {
                        i3 += unit;
                        --n;
                        continue;
                    }
                    break;
                }
            }
            return ary;
        }
        if (b2 instanceof RubyFloat || e instanceof RubyFloat || s2 instanceof RubyFloat) {
            RubyArray ary;
            double unit = RubyNumeric.num2dbl(s2);
            double beg = RubyNumeric.num2dbl(b2);
            double end3 = e.isNil() ? (unit < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY) : RubyNumeric.num2dbl(e);
            double len = RubyNumeric.floatStepSize(beg, end3, unit, x);
            if ((double)n > len) {
                n = (long)len;
            }
            if (Double.isInfinite(unit)) {
                if (len > 0.0) {
                    ary = RubyArray.newArray(runtime2, 1);
                    ary.append(RubyNumeric.dbl2num(runtime2, beg));
                } else {
                    ary = runtime2.newEmptyArray();
                }
            } else if (unit == 0.0) {
                IRubyObject val = RubyNumeric.dbl2num(runtime2, beg);
                ary = RubyArray.newArray(runtime2, n);
                long i4 = 0L;
                while ((double)i4 < len) {
                    ary.append(val);
                    ++i4;
                }
            } else {
                ary = RubyArray.newArray(runtime2, n);
                for (long i5 = 0L; i5 < n; ++i5) {
                    double d = (double)i5 * unit + beg;
                    if (unit >= 0.0 ? end3 < d : d < end3) {
                        d = end3;
                    }
                    ary.append(RubyNumeric.dbl2num(runtime2, d));
                }
            }
            return ary;
        }
        return Helpers.invokeSuper(context, (IRubyObject)this, (RubyModule)runtime2.getEnumerator(), "first", num, Block.NULL_BLOCK);
    }

    @Override
    @JRubyMethod(name={"==", "eql?"})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyArithmeticSequence)) {
            return context.fals;
        }
        RubyArithmeticSequence aseqOther = (RubyArithmeticSequence)other;
        if (!Helpers.rbEqual(context, this.begin, aseqOther.begin).isTrue()) {
            return context.fals;
        }
        if (!Helpers.rbEqual(context, this.end, aseqOther.end).isTrue()) {
            return context.fals;
        }
        if (!Helpers.rbEqual(context, this.step, aseqOther.step).isTrue()) {
            return context.fals;
        }
        if (!Helpers.rbEqual(context, this.excludeEnd, aseqOther.excludeEnd).isTrue()) {
            return context.fals;
        }
        return context.tru;
    }

    @Override
    public RubyFixnum hash() {
        return this.hash(this.metaClass.runtime.getCurrentContext());
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyFixnum v = Helpers.safeHash(context, this.excludeEnd);
        long hash2 = Helpers.hashStart(runtime2, v.convertToInteger().getLongValue());
        v = Helpers.safeHash(context, this.begin);
        hash2 = Helpers.murmurCombine(hash2, v.convertToInteger().getLongValue());
        v = Helpers.safeHash(context, this.end);
        hash2 = Helpers.murmurCombine(hash2, v.convertToInteger().getLongValue());
        v = Helpers.safeHash(context, this.step);
        hash2 = Helpers.murmurCombine(hash2, v.convertToInteger().getLongValue());
        hash2 = Helpers.hashEnd(hash2);
        return runtime2.newFixnum(hash2);
    }

    @Override
    public final IRubyObject inspect() {
        return this.inspect(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public RubyString inspect(ThreadContext context) {
        int argc;
        ByteList str = new ByteList();
        boolean isRange = this.generatedBy instanceof RubyRange;
        str.append(40);
        if (isRange) {
            str.append(40);
        }
        str.append(RubyObject.inspect(context, this.generatedBy).getByteList());
        if (isRange) {
            str.append(41);
        }
        str.append(46).append(this.method.getBytes());
        if (this.args != null && (argc = this.args.length) > 0) {
            IRubyObject[] keys2;
            IRubyObject kwds = context.nil;
            str.append(40);
            if (this.args[argc - 1] instanceof RubyHash) {
                boolean allKey = true;
                for (IRubyObject key2 : keys2 = ((RubyHash)this.args[argc - 1]).keys().toJavaArray()) {
                    if (key2 instanceof RubySymbol) continue;
                    allKey = false;
                    break;
                }
                if (allKey) {
                    kwds = this.args[--argc];
                }
            }
            int counter = 0;
            while (argc > 0) {
                str.append(RubyObject.inspect(context, this.args[counter]).getByteList());
                str.append(44).append(32);
                --argc;
                ++counter;
            }
            if (!kwds.isNil()) {
                for (IRubyObject key2 : keys2 = ((RubyHash)kwds).keys().toJavaArray()) {
                    IRubyObject value2 = ((RubyHash)kwds).fastARef(key2);
                    str.append(((RubySymbol)key2).getBytes());
                    str.append(58).append(32);
                    str.append(RubyObject.inspect(context, value2).getByteList());
                    str.append(44).append(32);
                }
            }
            str = new ByteList(str, 0, str.length() - 2);
            str.append(41);
        }
        str.append(41);
        return RubyString.newStringLight(context.runtime, str);
    }

    @JRubyMethod
    public IRubyObject begin(ThreadContext context) {
        return this.begin;
    }

    @JRubyMethod
    public IRubyObject end(ThreadContext context) {
        return this.end;
    }

    @JRubyMethod
    public IRubyObject step(ThreadContext context) {
        return this.step;
    }

    @JRubyMethod(name={"exclude_end?"})
    public IRubyObject exclude_end(ThreadContext context) {
        return this.excludeEnd;
    }

    @JRubyMethod
    public IRubyObject last(ThreadContext context) {
        return this.last(context, null);
    }

    @JRubyMethod
    public IRubyObject last(ThreadContext context, IRubyObject num) {
        long n;
        CachingCallSite op_gt2;
        Ruby runtime2 = context.runtime;
        IRubyObject b2 = this.begin;
        IRubyObject e = this.end;
        IRubyObject s2 = this.step;
        if (e.isNil()) {
            throw runtime2.newRangeError("cannot get the last element of endless arithmetic sequence");
        }
        IRubyObject len_1 = ((RubyNumeric)((RubyNumeric)e).op_minus(context, b2)).idiv(context, s2);
        if (Numeric.f_negative_p(context, len_1)) {
            if (num == null) {
                return context.nil;
            }
            return runtime2.newEmptyArray();
        }
        IRubyObject last2 = ((RubyNumeric)b2).op_plus(context, Numeric.f_mul(context, s2, len_1));
        boolean last_is_adjusted = this.excludeEnd.isTrue();
        if (last_is_adjusted && Helpers.rbEqual(context, last2, e).isTrue()) {
            last2 = ((RubyNumeric)last2).op_minus(context, s2);
        }
        if (num == null) {
            return last2;
        }
        IRubyObject len = last_is_adjusted ? len_1 : ((RubyNumeric)len_1).op_plus(context, RubyNumeric.int2fix(runtime2, 1L));
        IRubyObject nv = num;
        if (!(nv instanceof RubyInteger)) {
            nv = num.convertToInteger();
        }
        if (RubyNumeric.numFuncall(context, nv, op_gt2 = RubyArithmeticSequence.sites((ThreadContext)context).op_gt, len).isTrue()) {
            nv = len;
        }
        if ((n = RubyNumeric.num2long(nv)) < 0L) {
            throw runtime2.newArgumentError("negative array size");
        }
        RubyArray ary = RubyArray.newArray(runtime2, n);
        b2 = ((RubyNumeric)last2).op_minus(context, Numeric.f_mul(context, s2, nv));
        while (n > 0L) {
            b2 = ((RubyNumeric)b2).op_plus(context, s2);
            ary.append(b2);
            --n;
        }
        return ary;
    }

    @JRubyMethod
    public IRubyObject size(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (this.begin instanceof RubyFloat || this.end instanceof RubyFloat || this.step instanceof RubyFloat) {
            double ee = this.end.isNil() ? (Numeric.f_negative_p(context, this.step) ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY) : RubyNumeric.num2dbl(this.end);
            double n = RubyNumeric.floatStepSize(RubyNumeric.num2dbl(this.begin), ee, RubyNumeric.num2dbl(this.step), this.excludeEnd.isTrue());
            if (Double.isInfinite(n)) {
                return RubyNumeric.dbl2num(runtime2, n);
            }
            if (RubyNumeric.posFixable(n)) {
                return RubyNumeric.int2fix(runtime2, (long)n);
            }
            return RubyBignum.newBignorm(runtime2, n);
        }
        if (this.end.isNil()) {
            return RubyNumeric.dbl2num(runtime2, Double.POSITIVE_INFINITY);
        }
        if (!(this.step instanceof RubyNumeric)) {
            this.step = this.step.convertToInteger();
        }
        if (Helpers.rbEqual(context, this.step, RubyNumeric.int2fix(runtime2, 0L)).isTrue()) {
            return RubyNumeric.dbl2num(runtime2, Double.POSITIVE_INFINITY);
        }
        IRubyObject len_1 = ((RubyNumeric)((RubyNumeric)this.end).op_minus(context, this.begin)).idiv(context, this.step);
        if (Numeric.f_negative_p(context, len_1)) {
            return RubyNumeric.int2fix(runtime2, 0L);
        }
        IRubyObject last2 = ((RubyNumeric)this.begin).op_plus(context, Numeric.f_mul(context, this.step, len_1));
        IRubyObject len = this.excludeEnd.isTrue() && Helpers.rbEqual(context, last2, this.end).isTrue() ? len_1 : ((RubyNumeric)len_1).op_plus(context, RubyNumeric.int2fix(runtime2, 1L));
        return len;
    }

    private static IRubyObject size(ThreadContext context, RubyArithmeticSequence self2, IRubyObject[] args2) {
        return self2.size(context);
    }

    private static JavaSites.FiberSites fiberSites(ThreadContext context) {
        return context.sites.Fiber;
    }

    @JRubyMethod(name={"each_cons"})
    public IRubyObject each_cons(ThreadContext context, IRubyObject arg2, Block block) {
        int size2 = (int)RubyNumeric.num2long(arg2);
        if (size2 <= 0) {
            throw context.runtime.newArgumentError("invalid size");
        }
        return block.isGiven() ? RubyEnumerable.each_consCommon(context, this, size2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_cons", arg2);
    }

    @JRubyMethod(name={"each_slice"})
    public IRubyObject each_slice(ThreadContext context, IRubyObject arg2, Block block) {
        int size2 = (int)RubyNumeric.num2long(arg2);
        if (size2 <= 0) {
            throw context.runtime.newArgumentError("invalid size");
        }
        return block.isGiven() ? RubyEnumerable.each_sliceCommon(context, this, size2, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_slice", new IRubyObject[]{arg2}, RubyArithmeticSequence::size);
    }

    @JRubyMethod(required=1)
    public IRubyObject each_with_object(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon(context, this, block, arg2) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_with_object", new IRubyObject[]{arg2}, RubyArithmeticSequence::size);
    }

    @JRubyMethod(name={"with_index"})
    public IRubyObject with_index(ThreadContext context, Block block) {
        return this.with_index(context, context.nil, block);
    }

    @JRubyMethod(name={"with_index"})
    public IRubyObject with_index(ThreadContext context, IRubyObject arg2, Block block) {
        int index2;
        Ruby runtime2 = context.runtime;
        int n = index2 = arg2.isNil() ? 0 : RubyNumeric.num2int(arg2);
        if (!block.isGiven()) {
            return arg2.isNil() ? RubyEnumerator.enumeratorizeWithSize(context, this, "with_index", RubyArithmeticSequence::size) : RubyEnumerator.enumeratorizeWithSize(context, this, "with_index", new IRubyObject[]{runtime2.newFixnum(index2)}, RubyArithmeticSequence::size);
        }
        return RubyEnumerable.callEach(context, RubyArithmeticSequence.fiberSites((ThreadContext)context).each, this, (BlockCallback)new RubyEnumerable.EachWithIndex(block, index2));
    }
}

