<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# queue

```go
import "github.com/zyedidia/generic/queue"
```

Package queue provides an implementation of a First In First Out \(FIFO\) queue. The FIFO queue is implemented using the doubly\-linked list from the 'list' package.

<details><summary>Example</summary>
<p>

```go
{
	q := New[int]()
	q.Enqueue(1)
	q.Enqueue(2)

	q.Each(func(i int) {
		fmt.Println(i)
	})

}
```

#### Output

```
1
2
```

</p>
</details>

## Index

- [type Queue](<#type-queue>)
  - [func New[T any]() *Queue[T]](<#func-new>)
  - [func Of[S ~[]E, E any](slice S) *Queue[E]](<#func-of>)
  - [func (q *Queue[T]) Clear()](<#func-queuet-clear>)
  - [func (q *Queue[T]) Copy() *Queue[T]](<#func-queuet-copy>)
  - [func (q *Queue[T]) Dequeue() T](<#func-queuet-dequeue>)
  - [func (q *Queue[T]) DequeueAll() []T](<#func-queuet-dequeueall>)
  - [func (q *Queue[T]) Each(fn func(t T))](<#func-queuet-each>)
  - [func (q *Queue[T]) Empty() bool](<#func-queuet-empty>)
  - [func (q *Queue[T]) Enqueue(value T)](<#func-queuet-enqueue>)
  - [func (q *Queue[T]) Len() int](<#func-queuet-len>)
  - [func (q *Queue[T]) Peek() T](<#func-queuet-peek>)
  - [func (q *Queue[T]) PeekAll() []T](<#func-queuet-peekall>)
  - [func (q *Queue[T]) TryDequeue() (T, bool)](<#func-queuet-trydequeue>)
  - [func (q *Queue[T]) TryPeek() (T, bool)](<#func-queuet-trypeek>)


## type [Queue](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L11-L14>)

Queue is a simple First In First Out \(FIFO\) queue.

```go
type Queue[T any] struct {
    // contains filtered or unexported fields
}
```

### func [New](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L17>)

```go
func New[T any]() *Queue[T]
```

New returns an empty First In First Out \(FIFO\) queue.

### func [Of](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L25>)

```go
func Of[S ~[]E, E any](slice S) *Queue[E]
```

Of returns a First In First Out \(FIFO\) queue that has been populated with values from an existing slice.

### func \(\*Queue\[T\]\) [Clear](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L116>)

```go
func (q *Queue[T]) Clear()
```

Clear empties the queue, resetting it to zero elements.

### func \(\*Queue\[T\]\) [Copy](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L122>)

```go
func (q *Queue[T]) Copy() *Queue[T]
```

Copy returns a shallow copy of this queue.

### func \(\*Queue\[T\]\) [Dequeue](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L47>)

```go
func (q *Queue[T]) Dequeue() T
```

Dequeue removes and returns the item at the front of the queue.

A panic occurs if the queue is Empty.

<details><summary>Example</summary>
<p>

```go
{
	q := New[int]()
	q.Enqueue(1)

	fmt.Println(q.Dequeue())

}
```

#### Output

```
1
```

</p>
</details>

### func \(\*Queue\[T\]\) [DequeueAll](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L70>)

```go
func (q *Queue[T]) DequeueAll() []T
```

DequeueAll removes and returns all the items in the queue.

### func \(\*Queue\[T\]\) [Each](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L128>)

```go
func (q *Queue[T]) Each(fn func(t T))
```

Each calls 'fn' on every item in the queue, starting with the least recently pushed element.

### func \(\*Queue\[T\]\) [Empty](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L111>)

```go
func (q *Queue[T]) Empty() bool
```

Empty returns true if the queue is empty.

<details><summary>Example (Empty)</summary>
<p>

```go
{
	q := New[int]()

	fmt.Println(q.Empty())

}
```

#### Output

```
true
```

</p>
</details>

<details><summary>Example (Nonempty)</summary>
<p>

```go
{
	q := New[int]()
	q.Enqueue(1)

	fmt.Println(q.Empty())

}
```

#### Output

```
false
```

</p>
</details>

### func \(\*Queue\[T\]\) [Enqueue](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L39>)

```go
func (q *Queue[T]) Enqueue(value T)
```

Enqueue inserts 'value' to the end of the queue.

<details><summary>Example</summary>
<p>

```go
{
	q := New[int]()
	q.Enqueue(1)
}
```

</p>
</details>

### func \(\*Queue\[T\]\) [Len](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L34>)

```go
func (q *Queue[T]) Len() int
```

Len returns the number of items currently in the queue.

### func \(\*Queue\[T\]\) [Peek](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L81>)

```go
func (q *Queue[T]) Peek() T
```

Peek returns the item at the front of the queue without removing it.

A panic occurs if the queue is Empty.

<details><summary>Example</summary>
<p>

```go
{
	q := New[int]()
	q.Enqueue(1)

	fmt.Println(q.Peek())

}
```

#### Output

```
1
```

</p>
</details>

### func \(\*Queue\[T\]\) [PeekAll](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L100>)

```go
func (q *Queue[T]) PeekAll() []T
```

PeekAll returns all the items in the queue without removing them.

### func \(\*Queue\[T\]\) [TryDequeue](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L58>)

```go
func (q *Queue[T]) TryDequeue() (T, bool)
```

TryDequeue tries to remove and return the item at the front of the queue.

If the queue is empty, then false is returned as the second return value.

### func \(\*Queue\[T\]\) [TryPeek](<https://github.com/zyedidia/generic/blob/master/queue/queue.go#L91>)

```go
func (q *Queue[T]) TryPeek() (T, bool)
```

TryPeek tries to return the item at the front of the queue without removing it.

If the queue is empty, then false is returned as the second return value.



Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
