/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo, Marko Mattila

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __GAME_STATISTIC_H__
#define __GAME_STATISTIC_H__

#include <vector>
#include <string>
#include <stdio.h>
using namespace std;


class player_statistic{
  /**
   *\author Marko Mattila
   *\date 290504
   *
   *	Class for contain player statistics.
   *	Currently statistic contains only information of:
   *	# of hits
   *	# of misses
   *	an id of the player
   *
   *	New statistics should be added to this class.
   */
 public:
  player_statistic(int owner_id);
  player_statistic(const player_statistic &ps);
  
  virtual ~player_statistic();
  bool operator< (const player_statistic *ps);
  
  int get_id();
  double get_hit_percent() const;
  double get_ricochet_percent() const;
  int get_hits();
  int get_all_shots();
  int get_ricochets();
  int get_cannon_hits();
  int get_destroyed_cannons();

  // public member variables
  int nr_hits;
  int nr_all_shots;
  int nr_cannon_hits;
  int nr_destroyed_cannons;

  // initializes all to 0
  void reinit();

protected: 
  // player id
  unsigned int id;

 
};


class game_statistic{
  /**
   *@Author Marko Mattila
   *@date 290504
   *
   *	game_statistic class is a container class for player_statistic
   *	objects.
   *
   *
   */
 public:
  game_statistic();
  virtual ~game_statistic();

  /**
   *Add a new player_statistic object to the container.
   */
  bool add_player(player_statistic *ps);
  /**
   * Update the number of hits for the player with the id.
   *\param id - id of the player
   *\param hits - number of hits to update
   */
  bool update_player_nr_hits(int id, int hits=1); 
  /**
   * Update the number of hits to cannons sfor the player with the id.
   *\param id - id of the player
   *\param hits - number of hits to update
   */
  bool update_player_nr_cannon_hits(int id, int hits=1); 
  bool update_player_nr_destroyed_cannons(int id); 
  /**
   * Update over all hit count for the player with id.
   *\param id - id of the player
   *\param hits - number of shots to update
   */
  bool update_player_nr_all_shots(int id, int shots=1); 
  /**
   * Get player_statistic object with the id
   *\param id - the id of the player.
   */
  player_statistic *get_player_by_id(int id);
  /**
   * Return a player_statistic object with the best hit percent.
   */
  player_statistic *get_best_player();
  /**
   * Return a player_statistic object with the worst hit percent.
   */
  player_statistic *get_worst_player();
  /**
   * Remove a player_statistic object from the container.
   *\param id - id of the player.
   */
  void remove_player(int id);
  
  /**
   * Return a sorted list of player_statistics: best player
   * is the first etc..
   */
  vector<player_statistic*> * get_statistics();

  /* re-initialized all to 0 */
  void reinit();

 private:
  // Vector for pointers to the player_statistic objects
  vector <player_statistic*> *p_stats;
   
};

#endif
