/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.ai.logic;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.yura.domination.engine.ai.logic.AIDomination;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIMission
extends AIDomination {
    public AIMission(int type) {
        super(type);
    }

    @Override
    protected String fortify(AIDomination.GameState gs, List<Country> attackable, boolean minimal, List<Country> borders) {
        String result;
        if (this.player.getMission().getNoofarmies() > 1 && this.player.getTerritoriesOwned().size() - 3 >= this.player.getMission().getNoofcountries() && (result = super.fortify(gs, attackable, true, this.player.getTerritoriesOwned())) != null) {
            return result;
        }
        return super.fortify(gs, attackable, minimal, borders);
    }

    @Override
    protected boolean shouldEndAttack(AIDomination.GameState gameState) {
        boolean result = super.shouldEndAttack(gameState);
        if (result && this.isCloseToTerritoryTarget()) {
            return false;
        }
        return result;
    }

    @Override
    protected int scoreCountry(Country country) {
        int result = super.scoreCountry(country);
        if (this.player.getMission().getPlayer() != null && !this.isTargetMoot()) {
            Vector n = country.getNeighbours();
            for (int i = 0; i < n.size(); ++i) {
                Country nc = (Country)n.get(i);
                if (nc.getOwner() != this.player.getMission().getPlayer()) continue;
                --result;
            }
        }
        return result;
    }

    private boolean isCloseToTerritoryTarget() {
        return this.player.getMission().getNoofcountries() > 0 && (this.player.getMission().getPlayer() == null || this.isTargetMoot()) && this.player.getTerritoriesOwned().size() - 3 >= this.player.getMission().getNoofcountries();
    }

    @Override
    protected boolean pressAttack(AIDomination.GameState gameState) {
        boolean result = super.pressAttack(gameState);
        if (!result && this.isCloseToTerritoryTarget()) {
            return true;
        }
        return result;
    }

    @Override
    protected int getMinPlacement() {
        return Math.max(1, this.player.getMission().getNoofarmies());
    }

    @Override
    public AIDomination.GameState getGameState(Player p, boolean excludeCards) {
        AIDomination.GameState g = super.getGameState(p, excludeCards);
        if (this.player.getMission().getPlayer() != null && !this.isTargetMoot() && this.player.getMission().getPlayer() != g.orderedPlayers.get((int)0).p) {
            g.targetPlayers.add(0, this.player.getMission().getPlayer());
        }
        if (g.commonThreat == null) {
            for (AIDomination.PlayerState ps : g.orderedPlayers) {
                if (ps.owned.size() <= 1) continue;
                g.breakOnlyTargets = true;
                g.targetPlayers.add(0, ps.p);
                break;
            }
        }
        return g;
    }

    private boolean isTargetMoot() {
        return this.player.getMission().getPlayer() != null && (this.player.getMission().getPlayer() == this.player || this.player.getMission().getPlayer().getTerritoriesOwned().isEmpty());
    }

    @Override
    protected double getContinentValue(Continent co) {
        double result = super.getContinentValue(co);
        if (this.isTargetContinent(co)) {
            result *= 4.0;
        }
        return result;
    }

    private boolean isTargetContinent(Continent co) {
        return this.player.getMission().getContinent1() == co || this.player.getMission().getContinent2() == co || this.player.getMission().getContinent3() == co;
    }

    @Override
    protected boolean shouldProactivelyFortify(Continent co, boolean attack, List<Country> attackable, AIDomination.GameState gameState, Map<Country, AIDomination.AttackTarget> targets, boolean pressAttack, List<AIDomination.EliminationTarget> continents) {
        boolean result = super.shouldProactivelyFortify(co, attack, attackable, gameState, targets, pressAttack, continents);
        if (result && this.isTargetContinent(co) && gameState.me.owned.size() > 0) {
            return false;
        }
        return result;
    }
}

