/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.MapServerListener;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.domination.mapstore.gen.XMLMapAccess;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.io.FileUtil;
import net.yura.mobile.io.HTTPClient;
import net.yura.mobile.io.ServiceLink;
import net.yura.mobile.io.UTF8InputStreamReader;
import net.yura.mobile.util.SystemUtil;
import net.yura.mobile.util.Url;
import net.yura.social.GooglePlusOne;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapServerClient
extends HTTPClient {
    public static final Logger logger = Logger.getLogger(MapServerClient.class.getName());
    public static final int XML_REQUEST_ID = 1;
    public static final int MAP_REQUEST_ID = 2;
    public static final int IMG_REQUEST_ID = 3;
    public static final int PULS_REQUEST_ID = 4;
    private static final String RATE_URL = "http://maps.yura.net/maps?mapfile=";
    static final Hashtable headers = new Hashtable();
    MapServerListener chooser;
    List downloads = new Vector();

    public MapServerClient(MapServerListener aThis) {
        super(4);
        this.chooser = aThis;
    }

    public void kill() {
        this.chooser = null;
        if (this.downloads.isEmpty()) {
            super.kill();
        }
    }

    protected void onError(HTTPClient.Request r, int responseCode, Hashtable headers, Exception ex) {
        ServerRequest request = (ServerRequest)r;
        MapServerListener ch = this.chooser;
        if (request.type == 2 && ((MapDownload)request.id).ignoreErrorInDownload(request.url, responseCode)) {
            logger.info("skipped " + (Object)((Object)request));
            return;
        }
        Level level = Level.WARNING;
        if (ex instanceof UnknownHostException || ex instanceof SocketTimeoutException || ex instanceof ConnectException || ex instanceof EOFException && responseCode == 0 || ex instanceof SocketException && ("Connection timed out".equals(ex.getMessage()) || "Connection reset by peer".equals(ex.getMessage()) || "recvfrom failed: ETIMEDOUT (Connection timed out)".equals(ex.getMessage()) || "recvfrom failed: ECONNRESET (Connection reset by peer)".equals(ex.getMessage()))) {
            level = Level.INFO;
        }
        logger.log(level, "error: " + responseCode + " " + ex + " " + (Object)((Object)request) + "\n" + headers, ex != null ? ex : new Exception());
        if (ch != null) {
            String error = "error:" + (responseCode != 0 ? " " + responseCode : "") + (ex != null ? " " + ex : "");
            if (request.type == 1 || request.type == 4) {
                ch.onXMLError(error);
            } else if (request.type == 2) {
                ch.onDownloadError(error);
            }
        }
    }

    protected void onResult(HTTPClient.Request r, int responseCode, Hashtable headers, InputStream is, long length) throws Exception {
        ServerRequest request = (ServerRequest)r;
        MapServerListener ch = this.chooser;
        if (request.type == 1) {
            XMLMapAccess access = new XMLMapAccess();
            ServiceLink.Task task = (ServiceLink.Task)access.load((Reader)new UTF8InputStreamReader((InputStream)new BufferedInputStream(is)));
            if (Midlet.getPlatform() == 10) {
                is.read();
            }
            if (ch != null) {
                String method = task.getMethod();
                Object param = task.getObject();
                if ("categories".equals(method)) {
                    if (param instanceof List) {
                        ch.gotResultCategories(request.url, (List)param);
                    }
                } else if ("maps".equals(method) && param instanceof java.util.Map) {
                    java.util.Map info = (java.util.Map)param;
                    List list = (List)info.get("maps");
                    if (request.params != null && "TOP_RATINGS".equals(request.params.get("sort")) && list.size() > 0) {
                        ArrayList<String> urls = new ArrayList<String>(list.size());
                        for (Map map : list) {
                            String fileUID = MapChooser.getFileUID(map.getMapUrl());
                            urls.add(RATE_URL + Url.encode((String)fileUID));
                        }
                        ServerRequest request1 = new ServerRequest();
                        request1.id = new Object[]{request.url, list};
                        request1.url = "https://clients6.google.com/rpc?key=AIzaSyCKSbrvQasunBoV16zDH9R33D88CeLr9gQ";
                        request1.type = 4;
                        request1.post = true;
                        request1.postData = GooglePlusOne.getRequest(urls);
                        request1.headers = new Hashtable();
                        request1.headers.put("Content-Type:", "application/json");
                        this.makeRequest(request1);
                    } else {
                        ch.gotResultMaps(request.url, list);
                    }
                }
            }
        } else if (request.type == 2) {
            ((MapDownload)request.id).gotRes(request.url, is);
        } else if (request.type == 3) {
            MapChooser.gotImgFromServer(request.id, request.url, SystemUtil.getData((InputStream)is, (int)((int)length)), ch);
        } else if (request.type == 4) {
            Object[] tmp = (Object[])request.id;
            String ratedlistUrl = (String)tmp[0];
            List ratedList = (List)tmp[1];
            java.util.Map<String, Integer> urlRatings = GooglePlusOne.getCount(is);
            final HashMap<String, Integer> ratings = new HashMap<String, Integer>();
            for (Map.Entry<String, Integer> entry : urlRatings.entrySet()) {
                String fileUID = Url.decode((String)entry.getKey().substring(RATE_URL.length()));
                ratings.put(fileUID, entry.getValue());
            }
            Collections.sort(ratedList, new Comparator<Map>(){

                @Override
                public int compare(Map map0, Map map1) {
                    int rating1;
                    int rating0 = MapServerClient.getRating(map0, ratings);
                    if (rating0 != (rating1 = MapServerClient.getRating(map1, ratings))) {
                        return rating1 - rating0;
                    }
                    return Integer.parseInt(map0.getId()) - Integer.parseInt(map1.getId());
                }
            });
            if (ch != null) {
                ch.gotResultMaps(ratedlistUrl, ratedList);
            }
        } else {
            logger.warning("[MapServerClient] unknown type " + request.type);
        }
    }

    private static int getRating(Map map, java.util.Map<String, Integer> ratings) {
        Integer rating = ratings.get(MapChooser.getFileUID(map.getMapUrl()));
        return rating == null ? 0 : rating;
    }

    private void makeRequest(String url, Hashtable params, int type, Object key) {
        ServerRequest request = new ServerRequest();
        request.type = type;
        request.url = url;
        request.params = params;
        request.id = key;
        request.headers = headers;
        logger.info("Make Request: " + (Object)((Object)request));
        this.makeRequest(request);
    }

    public void makeRequestXML(String string, String key, String value) {
        Hashtable<String, String> params = null;
        if (key != null && value != null) {
            params = new Hashtable<String, String>();
            params.put(key, value);
        }
        this.makeRequest(string, params, 1, null);
    }

    void getImage(String url, Object key) {
        this.makeRequest(url, null, 3, key);
    }

    public void downloadMap(String fullMapUrl) {
        MapDownload download = new MapDownload(fullMapUrl);
        this.downloads.add(download);
    }

    public boolean isDownloading(String mapUID) {
        for (int c = 0; c < this.downloads.size(); ++c) {
            MapDownload download = (MapDownload)this.downloads.get(c);
            if (!download.mapUID.equals(mapUID)) continue;
            return true;
        }
        return false;
    }

    private static void saveFile(InputStream is, OutputStream out) throws IOException {
        int COPY_BLOCK_SIZE = 1024;
        byte[] data = new byte[COPY_BLOCK_SIZE];
        int i = 0;
        while ((i = is.read(data, 0, COPY_BLOCK_SIZE)) != -1) {
            out.write(data, 0, i);
        }
    }

    public static String getURL(String context, String path) {
        try {
            return new URI(context).resolve(new URI(null, null, path, null)).toASCIIString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getPath(String context, String url) {
        try {
            return new URI(context).relativize(new URI(url)).getPath();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        headers.put("Cache-Control", "no-cache");
        headers.put("Pragma", "no-cache");
    }

    class MapDownload {
        String mapUID;
        String mapContext;
        final List urls = new Vector();
        final List fileNames = new Vector();
        boolean error = false;

        MapDownload(String url) {
            this.mapUID = MapChooser.getFileUID(url);
            this.mapContext = url.substring(0, url.length() - this.mapUID.length());
            this.downloadFile(this.mapUID);
        }

        public String toString() {
            return this.mapUID;
        }

        final void downloadFile(String fileName) {
            this.fileNames.add(fileName);
            String url = MapServerClient.getURL(this.mapContext, fileName);
            this.urls.add(url);
            MapServerClient.this.makeRequest(url, null, 2, this);
        }

        boolean hasUrl(String url) {
            return this.urls.contains(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gotResponse(String url) {
            boolean empty;
            List list = this.urls;
            synchronized (list) {
                this.urls.remove(url);
                empty = this.urls.isEmpty();
            }
            if (empty) {
                MapServerClient.this.downloads.remove(this);
                try {
                    if (!this.error) {
                        for (int c = this.fileNames.size() - 1; c >= 0; --c) {
                            String fileName = (String)this.fileNames.get(c);
                            RiskUtil.streamOpener.renameMapFile(fileName + ".part", fileName);
                        }
                        MapChooser.clearFromCache(this.mapUID);
                        MapUpdateService.getInstance().downloadFinished(this.mapUID);
                        MapServerListener ch = MapServerClient.this.chooser;
                        if (ch != null) {
                            ch.downloadFinished(this.mapUID);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "rename error! map=" + this.mapUID + " context=" + this.mapContext + " url=" + url + " files=" + this.fileNames, ex);
                }
                if (MapServerClient.this.chooser == null) {
                    MapServerClient.this.kill();
                }
            }
        }

        private void gotRes(String url, InputStream is) throws Exception {
            String fileName = MapServerClient.getPath(this.mapContext, url);
            String saveToDiskName = fileName + ".part";
            OutputStream out = null;
            try {
                out = RiskUtil.streamOpener.saveMapFile(saveToDiskName);
                MapServerClient.saveFile(is, out);
                if (fileName.endsWith(".map")) {
                    java.util.Map info = RiskUtil.loadInfo(saveToDiskName, false);
                    String pic = (String)info.get("pic");
                    String crd = (String)info.get("crd");
                    String map = (String)info.get("map");
                    String prv = (String)info.get("prv");
                    if (pic == null || crd == null || map == null || "".equals(pic) || "".equals(crd) || "".equals(map)) {
                        throw new RuntimeException("info not found for map: " + this.mapUID + " in file: " + saveToDiskName + " info=" + info);
                    }
                    this.downloadFile(pic);
                    this.downloadFile(crd);
                    this.downloadFile(map);
                    if (prv != null) {
                        this.downloadFile("preview/" + prv);
                    }
                }
            }
            catch (Exception ex) {
                this.error = true;
                throw ex;
            }
            finally {
                FileUtil.close((Object)is);
                FileUtil.close((Object)out);
            }
            this.gotResponse(url);
        }

        private boolean ignoreErrorInDownload(String url, int responseCode) {
            boolean ignoreError;
            String fileName = MapServerClient.getPath(this.mapContext, url);
            boolean bl = ignoreError = responseCode == 404 && MapChooser.fileExists(fileName);
            if (ignoreError) {
                this.fileNames.remove(fileName);
            } else {
                this.error = true;
            }
            this.gotResponse(url);
            return ignoreError;
        }
    }

    class ServerRequest
    extends HTTPClient.Request {
        public int type;

        ServerRequest() {
        }
    }
}

