/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;

public class TiledLayer
extends Layer {
    int columns;
    int rows;
    int[][] cells;
    Vector animatedTiles = new Vector();

    public TiledLayer(int columns, int rows, Image image, int tileWidth, int tileHeight) {
        this.columns = columns;
        this.rows = rows;
        this.image = image;
        this.frameWidth = tileWidth;
        this.frameHeight = tileHeight;
        this.cells = new int[rows][columns];
        this.w = columns * tileWidth;
        this.h = rows * tileHeight;
    }

    public int createAnimatedTile(int staticTileIndex) {
        this.animatedTiles.addElement(new Integer(staticTileIndex));
        return -this.animatedTiles.size();
    }

    public void setAnimatedTile(int animatedtileIndex, int staticTileIndex) {
        this.animatedTiles.setElementAt(new Integer(staticTileIndex), -animatedtileIndex - 1);
    }

    public int getAnimatedTile(int animatedTileIndex) {
        return (Integer)this.animatedTiles.elementAt(-animatedTileIndex - 1);
    }

    public void setCell(int col, int row, int tileIndex) {
        this.cells[row][col] = tileIndex;
    }

    public int getCell(int col, int row) {
        return this.cells[row][col];
    }

    public void fillCells(int col, int row, int numCols, int numRows, int tileIndex) {
        for (int r = row; r < row + numRows; ++r) {
            for (int c = col; c < col + numCols; ++c) {
                this.cells[r][c] = tileIndex;
            }
        }
    }

    public final int getCellWidth() {
        return this.frameWidth;
    }

    public final int getCellHeight() {
        return this.frameHeight;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final int getRows() {
        return this.rows;
    }

    public void setStaticTileSet(Image image, int tileWidth, int tileHeight) {
        if (image.getWidth() / tileWidth * (image.getHeight() / tileHeight) < this.getFrameCount()) {
            this.fillCells(0, 0, this.columns, this.rows, 0);
            this.animatedTiles = new Vector();
        }
        this.image = image;
        this.frameHeight = tileHeight;
        this.frameWidth = tileWidth;
    }

    public final void paint(Graphics g) {
        int maxX = g.getClipX() + g.getClipWidth();
        int col0 = (g.getClipX() - this.x) / this.frameWidth;
        if (col0 < 0) {
            col0 = 0;
        }
        int maxY = g.getClipY() + g.getClipHeight();
        int row0 = (g.getClipY() - this.y) / this.frameHeight;
        if (row0 < 0) {
            row0 = 0;
        }
        int cy = this.y + row0 * this.frameHeight;
        for (int row = row0; row < this.rows && cy < maxY; cy += this.frameHeight, ++row) {
            int cx = this.x + col0 * this.frameWidth;
            for (int col = col0; col < this.columns && cx < maxX; cx += this.frameWidth, ++col) {
                int idx = this.cells[row][col];
                if (idx == 0) continue;
                if (idx < 0) {
                    idx = this.getAnimatedTile(idx);
                }
                this.drawImage(g, cx, cy, idx - 1, 0);
                g.setColor(0xFFFFFF);
            }
        }
    }
}

