/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.index;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.writer.AbstractExtendDitaWriter;
import org.dita.dost.writer.AbstractWriter;
import org.dita.dost.writer.IDitaTranstypeIndexWriter;

public final class IndexTermCollection {
    private static IndexTermCollection collection = null;
    private final List<IndexTerm> termList = new ArrayList<IndexTerm>(16);
    private String indexType = null;
    private String indexClass = null;
    private String outputFileRoot = null;
    private DITAOTLogger javaLogger;
    private PipelineHashIO pipelineHashIO = null;

    public void setLogger(DITAOTLogger logger) {
        this.javaLogger = logger;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String type) {
        this.indexType = type;
    }

    public String getIndexClass() {
        return this.indexClass;
    }

    public void setIndexClass(String indexClass) {
        this.indexClass = indexClass;
    }

    public void addTerm(IndexTerm term) {
        int i;
        int termNum = this.termList.size();
        for (i = 0; i < termNum; ++i) {
            IndexTerm indexTerm = this.termList.get(i);
            if (indexTerm.equals(term)) {
                return;
            }
            if (!indexTerm.getTermFullName().equals(term.getTermFullName()) || !indexTerm.getTermKey().equals(term.getTermKey())) continue;
            indexTerm.addTargets(term.getTargetList());
            indexTerm.addSubTerms(term.getSubTerms());
            break;
        }
        if (i == termNum) {
            this.termList.add(term);
        }
    }

    public List<IndexTerm> getTermList() {
        return this.termList;
    }

    public void sort() {
        if (IndexTerm.getTermLocale() == null || IndexTerm.getTermLocale().getLanguage().trim().length() == 0) {
            IndexTerm.setTermLocale(new Locale("en", "us"));
        }
        for (IndexTerm term : this.termList) {
            term.sortSubTerms();
        }
        Collections.sort(this.termList);
    }

    public void outputTerms() throws DITAOTException {
        StringBuilder buff = new StringBuilder(this.outputFileRoot);
        AbstractWriter abstractWriter = null;
        if (this.indexClass != null && this.indexClass.length() > 0) {
            try {
                Class<?> anIndexClass = Class.forName(this.indexClass);
                abstractWriter = (AbstractWriter)anIndexClass.newInstance();
                IDitaTranstypeIndexWriter indexWriter = (IDitaTranstypeIndexWriter)anIndexClass.newInstance();
                try {
                    ((AbstractExtendDitaWriter)abstractWriter).setPipelineHashIO(this.getPipelineHashIO());
                }
                catch (ClassCastException e) {
                    this.javaLogger.info(e.getMessage());
                    this.javaLogger.info(e.toString());
                    e.printStackTrace();
                }
                buff = new StringBuilder(indexWriter.getIndexFileName(this.outputFileRoot));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("Index writer class not defined");
        }
        abstractWriter.setLogger(this.javaLogger);
        ((IDitaTranstypeIndexWriter)((Object)abstractWriter)).setTermList(this.getTermList());
        abstractWriter.write(new File(buff.toString()));
    }

    public void setOutputFileRoot(String fileRoot) {
        this.outputFileRoot = fileRoot;
    }

    private PipelineHashIO getPipelineHashIO() {
        return this.pipelineHashIO;
    }

    public void setPipelineHashIO(PipelineHashIO hashIO) {
        this.pipelineHashIO = hashIO;
    }
}

