/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.streams.Steps;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.ChunkMapReader;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.TopicRefWriter;

public final class ChunkModule
extends AbstractPipelineModuleImpl {
    private static final DitaClass ECLIPSEMAP_PLUGIN = DitaClass.getInstance("- map/map eclipsemap/plugin ");
    public static final String ROOT_CHUNK_OVERRIDE = "root-chunk-override";
    private final Map<URI, String> relativePath2fix = new HashMap<URI, String>();

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        String transtype = input.getAttribute("transtype");
        ChunkMapReader mapReader = new ChunkMapReader();
        mapReader.setLogger(this.logger);
        mapReader.setJob(this.job);
        mapReader.setXmlUtils(this.xmlUtils);
        mapReader.supportToNavigation("eclipsehelp".equals(transtype));
        if (input.getAttribute(ROOT_CHUNK_OVERRIDE) != null) {
            mapReader.setRootChunkOverride(input.getAttribute(ROOT_CHUNK_OVERRIDE));
        }
        try {
            Job.FileInfo in = this.job.getFileInfo(fi -> fi.isInput).iterator().next();
            File mapFile = new File(this.job.tempDirURI.resolve(in.uri));
            if (transtype.equals("eclipsehelp") && this.isEclipseMap(mapFile.toURI())) {
                for (Job.FileInfo f : this.job.getFileInfo()) {
                    if (!"ditamap".equals(f.format)) continue;
                    mapReader.read(new File(this.job.tempDirURI.resolve(f.uri)).getAbsoluteFile());
                }
            } else {
                mapReader.read(mapFile);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        Map<URI, URI> changeTable = mapReader.getChangeTable();
        if (this.hasChanges(changeTable)) {
            Map<URI, URI> conflicTable = mapReader.getConflicTable();
            this.updateList(changeTable, conflicTable, mapReader);
            this.updateRefOfDita(changeTable, conflicTable);
        }
        return null;
    }

    private boolean hasChanges(Map<URI, URI> changeTable) {
        if (changeTable.isEmpty()) {
            return false;
        }
        for (Map.Entry<URI, URI> e : changeTable.entrySet()) {
            if (e.getKey().equals(e.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean isEclipseMap(URI mapFile) throws DITAOTException {
        XdmNode doc;
        try {
            doc = this.job.getStore().getImmutableNode(mapFile);
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to parse input map: " + e.getMessage(), e);
        }
        return doc.select(XMLUtils.rootElement().then(Steps.attribute((String)"class"))).anyMatch(xdmItems -> ECLIPSEMAP_PLUGIN.matches(xdmItems.getStringValue()));
    }

    private void updateRefOfDita(Map<URI, URI> changeTable, Map<URI, URI> conflictTable) {
        TopicRefWriter topicRefWriter = new TopicRefWriter();
        topicRefWriter.setLogger(this.logger);
        topicRefWriter.setJob(this.job);
        topicRefWriter.setChangeTable(changeTable);
        topicRefWriter.setup(conflictTable);
        try {
            for (Job.FileInfo f : this.job.getFileInfo()) {
                if (!"dita".equals(f.format) && !"ditamap".equals(f.format)) continue;
                topicRefWriter.setFixpath(this.relativePath2fix.get(f.uri));
                File tmp = new File(this.job.tempDirURI.resolve(f.uri));
                topicRefWriter.write(tmp);
            }
        }
        catch (DITAOTException ex) {
            this.logger.error(ex.getMessage(), ex);
        }
    }

    private void updateList(Map<URI, URI> changeTable, Map<URI, URI> conflictTable, ChunkMapReader mapReader) {
        Job.FileInfo f;
        Job.FileInfo ff;
        URI oldFile;
        Object abs;
        URI xmlDitalist = this.job.tempDirURI.resolve("dummy.xml");
        HashSet<URI> hrefTopics = new HashSet<URI>();
        Set<URI> chunkTopicSet = mapReader.getChunkTopicSet();
        for (Job.FileInfo f2 : this.job.getFileInfo()) {
            abs = this.job.tempDirURI.resolve(f2.uri);
            if (!f2.isTarget || chunkTopicSet.contains(abs)) continue;
            hrefTopics.add(f2.uri);
        }
        for (Job.FileInfo f2 : this.job.getFileInfo()) {
            abs = this.job.tempDirURI.resolve(f2.uri);
            if (!chunkTopicSet.contains(abs)) continue;
            URI s = f2.uri;
            if (s.getFragment() == null) {
                hrefTopics.removeIf(ent -> this.job.tempDirURI.resolve((URI)ent).equals(this.job.tempDirURI.resolve(s)));
                continue;
            }
            hrefTopics.remove(s);
        }
        LinkedHashSet<URI> topicList = new LinkedHashSet<URI>(128);
        HashSet<URI> oldTopicList = new HashSet<URI>();
        for (Job.FileInfo f3 : this.job.getFileInfo()) {
            if (!"dita".equals(f3.format)) continue;
            oldTopicList.add(f3.uri);
        }
        for (URI t : hrefTopics) {
            topicList.add(t);
            oldTopicList.remove(t);
        }
        LinkedHashSet<URI> chunkedTopicSet = new LinkedHashSet<URI>(128);
        LinkedHashSet<URI> chunkedDitamapSet = new LinkedHashSet<URI>(128);
        HashSet<URI> ditamapList = new HashSet<URI>();
        for (Job.FileInfo fileInfo : this.job.getFileInfo()) {
            if (!"ditamap".equals(fileInfo.format)) continue;
            ditamapList.add(fileInfo.uri);
        }
        for (Map.Entry entry : changeTable.entrySet()) {
            oldFile = (URI)entry.getKey();
            URI newFile = (URI)entry.getValue();
            if (!newFile.equals(oldFile)) continue;
            URI newChunkedFile = URLUtils.getRelativePath(xmlDitalist, newFile);
            String extName = FileUtils.getExtension(newChunkedFile.getPath());
            if (extName != null && !extName.equalsIgnoreCase("ditamap")) {
                chunkedTopicSet.add(newChunkedFile);
                if (topicList.contains(newChunkedFile)) continue;
                topicList.add(newChunkedFile);
                oldTopicList.remove(newChunkedFile);
                continue;
            }
            if (!ditamapList.contains(newChunkedFile)) {
                ditamapList.add(newChunkedFile);
                oldTopicList.remove(newChunkedFile);
            }
            chunkedDitamapSet.add(newChunkedFile);
        }
        for (URI uRI : oldTopicList) {
            URI f5 = this.job.tempDirURI.resolve(uRI);
            if (!this.job.getStore().exists(f5)) continue;
            this.logger.debug("Delete " + String.valueOf(f5));
            try {
                this.job.getStore().delete(f5);
            }
            catch (IOException e) {
                this.logger.error("Failed to delete " + String.valueOf(f5));
            }
        }
        for (Map.Entry entry : changeTable.entrySet()) {
            URI targetPath;
            oldFile = (URI)entry.getKey();
            URI from = (URI)entry.getValue();
            if (!from.equals(oldFile) || (targetPath = conflictTable.get(oldFile)) == null) continue;
            URI target = targetPath;
            if (!this.job.getStore().exists(target)) {
                URI relativePath = URLUtils.getRelativePath(xmlDitalist, from);
                URI relativeTargetPath = URLUtils.getRelativePath(xmlDitalist, target);
                if (relativeTargetPath.getPath().contains("/")) {
                    this.relativePath2fix.put(relativeTargetPath, relativeTargetPath.getPath().substring(0, relativeTargetPath.getPath().lastIndexOf("/") + 1));
                }
                try {
                    if (this.job.getStore().exists(target)) {
                        this.logger.debug("Delete " + String.valueOf(target));
                        this.job.getStore().delete(target);
                    }
                    this.logger.debug("Move " + String.valueOf(from) + " to " + String.valueOf(target));
                    this.job.getStore().move(from, target);
                    Job.FileInfo fi = this.job.getFileInfo(from);
                    if (fi != null) {
                        this.job.remove(fi);
                    }
                }
                catch (IOException e) {
                    this.logger.error("Failed to replace chunk topic: " + e.getMessage(), e);
                }
                topicList.remove(relativePath);
                chunkedTopicSet.remove(relativePath);
                relativePath = URLUtils.getRelativePath(xmlDitalist, target);
                topicList.add(relativePath);
                chunkedTopicSet.add(relativePath);
                continue;
            }
            conflictTable.remove(oldFile);
        }
        HashSet<URI> all = new HashSet<URI>();
        all.addAll(topicList);
        all.addAll(ditamapList);
        all.addAll(chunkedDitamapSet);
        all.addAll(chunkedTopicSet);
        for (URI file : oldTopicList) {
            Job.FileInfo fi;
            if (all.contains(file) || (fi = this.job.getFileInfo(file)) == null) continue;
            this.job.remove(fi);
        }
        for (URI file : topicList) {
            ff = this.job.getOrCreateFileInfo(URLUtils.stripFragment(file));
            ff.format = "dita";
        }
        for (URI file : ditamapList) {
            ff = this.job.getOrCreateFileInfo(file);
            ff.format = "ditamap";
        }
        for (URI file : chunkedDitamapSet) {
            f = this.job.getOrCreateFileInfo(file);
            f.format = "ditamap";
            f.isResourceOnly = false;
        }
        for (URI file : chunkedTopicSet) {
            f = this.job.getOrCreateFileInfo(URLUtils.stripFragment(file));
            f.format = "dita";
            f.isResourceOnly = false;
        }
        try {
            this.job.write();
        }
        catch (IOException iOException) {
            this.logger.error(iOException.getMessage(), iOException);
        }
    }

    public static class CounterChunkFilenameGenerator
    implements ChunkFilenameGenerator {
        private final AtomicInteger counter = new AtomicInteger();

        @Override
        public String generateFilename(String prefix, String extension) {
            return prefix + this.counter.getAndIncrement() + extension;
        }

        @Override
        public String generateID() {
            return "unique_" + this.counter.getAndIncrement();
        }
    }

    public static class RandomChunkFilenameGenerator
    implements ChunkFilenameGenerator {
        private final Random random = new Random();

        @Override
        public String generateFilename(String prefix, String extension) {
            return prefix + this.random.nextInt(Integer.MAX_VALUE) + extension;
        }

        @Override
        public String generateID() {
            return "unique_" + this.random.nextInt(Integer.MAX_VALUE);
        }
    }

    public static interface ChunkFilenameGenerator {
        public String generateFilename(String var1, String var2);

        public String generateID();
    }

    public static class ChunkFilenameGeneratorFactory {
        public static ChunkFilenameGenerator newInstance() {
            String mode = Configuration.configuration.get("chunk.id-generation-scheme");
            if (mode != null && mode.equals("counter")) {
                return new CounterChunkFilenameGenerator();
            }
            return new RandomChunkFilenameGenerator();
        }
    }
}

