/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.streams.Steps;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.filter.SubjectScheme;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;

public class SubjectSchemeReader {
    public static final String ANY_ELEMENT = "*";
    private static final net.sf.saxon.s9api.QName ATTRIBUTE_QNAME_KEYREF = net.sf.saxon.s9api.QName.fromClarkName((String)"keyref");
    private static final net.sf.saxon.s9api.QName ATTRIBUTE_QNAME_KEYS = net.sf.saxon.s9api.QName.fromClarkName((String)"keys");
    private static final net.sf.saxon.s9api.QName ATTRIBUTE_QNAME_NAME = net.sf.saxon.s9api.QName.fromClarkName((String)"name");
    private DITAOTLogger logger;
    private Job job;
    private final Map<QName, Map<String, Set<SubjectScheme.SubjectDefinition>>> bindingMap;
    private final Map<QName, Map<String, Set<String>>> validValuesMap = new HashMap<QName, Map<String, Set<String>>>();
    private final Map<QName, Map<String, String>> defaultValueMap = new HashMap<QName, Map<String, String>>();

    public SubjectSchemeReader() {
        this.bindingMap = new HashMap<QName, Map<String, Set<SubjectScheme.SubjectDefinition>>>();
    }

    public void reset() {
        this.validValuesMap.clear();
        this.defaultValueMap.clear();
        this.bindingMap.clear();
    }

    public Map<QName, Map<String, Set<String>>> getValidValuesMap() {
        return this.validValuesMap;
    }

    public Map<QName, Map<String, String>> getDefaultValueMap() {
        return this.defaultValueMap;
    }

    public SubjectScheme getSubjectSchemeMap() {
        return new SubjectScheme(this.bindingMap);
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public Map<URI, Set<URI>> readMapFromXML(File inputFile) throws IOException {
        HashMap graph = new HashMap();
        if (!inputFile.exists()) {
            return Collections.emptyMap();
        }
        Properties prop = new Properties();
        try (BufferedInputStream in = new BufferedInputStream(this.job.getStore().getInputStream(inputFile.toURI()));){
            prop.loadFromXML(in);
        }
        catch (IOException e) {
            throw new IOException("Failed to read subject scheme graph: " + e.getMessage(), e);
        }
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            HashSet<URI> r = new HashSet<URI>();
            for (String v : StringUtils.restoreSet(value, ",")) {
                r.add(URLUtils.toURI(v));
            }
            graph.put(URLUtils.toURI(key), r);
        }
        return Collections.unmodifiableMap(graph);
    }

    public void writeMapToXML(Map<URI, Set<URI>> m, File outputFile) throws IOException {
        if (m == null) {
            return;
        }
        Properties prop = new Properties();
        for (Map.Entry<URI, Set<URI>> entry : m.entrySet()) {
            URI key = entry.getKey();
            String value = StringUtils.join(entry.getValue(), ",");
            prop.setProperty(key.getPath(), value);
        }
        try (OutputStream os = this.job.getStore().getOutputStream(outputFile.toURI());){
            prop.storeToXML(os, null);
        }
        catch (IOException e) {
            throw new IOException("Failed to write subject scheme graph: " + e.getMessage(), e);
        }
    }

    public void loadSubjectScheme(File scheme) {
        assert (scheme.isAbsolute());
        if (!this.job.getStore().exists(scheme.toURI())) {
            throw new IllegalStateException();
        }
        this.logger.debug("Load subject scheme " + String.valueOf(scheme));
        try {
            XdmNode doc = this.job.getStore().getImmutableNode(scheme.toURI());
            XdmNode schemeRoot = doc.getOutermostElement();
            if (schemeRoot == null) {
                return;
            }
            this.loadSubjectScheme(schemeRoot);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public void loadSubjectScheme(XdmNode schemeRoot) {
        Map<String, SubjectScheme.SubjectDefinition> subjectDefinitionsByKey = this.getSubjectDefinition(schemeRoot);
        for (XdmNode child : schemeRoot.children(Constants.SUBJECTSCHEME_ENUMERATIONDEF::matches)) {
            this.processEnumerationDef(subjectDefinitionsByKey, child);
        }
    }

    public Map<String, SubjectScheme.SubjectDefinition> getSubjectDefinition(XdmNode schemeRoot) {
        List<SubjectScheme.SubjectDefinition> subjectDefinitions = this.readSubjectDefinitions(schemeRoot);
        HashMap<String, SubjectScheme.SubjectDefinition> buf = new HashMap<String, SubjectScheme.SubjectDefinition>();
        this.getSubjectDefinition(subjectDefinitions, buf);
        return Collections.unmodifiableMap(buf);
    }

    private void getSubjectDefinition(List<SubjectScheme.SubjectDefinition> subjectDefinitions, Map<String, SubjectScheme.SubjectDefinition> buf) {
        for (SubjectScheme.SubjectDefinition subjectDefinition : subjectDefinitions) {
            for (String key : subjectDefinition.keys()) {
                buf.putIfAbsent(key, subjectDefinition);
            }
            this.getSubjectDefinition(subjectDefinition.children(), buf);
        }
    }

    private List<SubjectScheme.SubjectDefinition> readSubjectDefinitions(XdmNode elem) {
        ArrayList<SubjectScheme.SubjectDefinition> res = new ArrayList<SubjectScheme.SubjectDefinition>();
        this.readSubjectDefinitions(elem, res);
        return Collections.unmodifiableList(res);
    }

    private void readSubjectDefinitions(XdmNode elem, List<SubjectScheme.SubjectDefinition> buf) {
        for (XdmNode child : elem.children()) {
            if (Constants.SUBJECTSCHEME_SUBJECTDEF.matches(child)) {
                String keyref = child.getAttributeValue(ATTRIBUTE_QNAME_KEYREF);
                if (keyref == null || keyref.isEmpty()) {
                    keyref = null;
                }
                ArrayList<SubjectScheme.SubjectDefinition> childBuf = new ArrayList<SubjectScheme.SubjectDefinition>();
                this.readSubjectDefinitions(child, childBuf);
                SubjectScheme.SubjectDefinition res = new SubjectScheme.SubjectDefinition(Set.copyOf(SubjectSchemeReader.getKeyValues(child)), keyref, childBuf);
                buf.add(res);
                continue;
            }
            this.readSubjectDefinitions(child, buf);
        }
    }

    public void processEnumerationDef(Map<String, SubjectScheme.SubjectDefinition> subjectDefinitions, XdmNode enumerationDef) {
        String elementName = enumerationDef.select(Steps.child(Constants.SUBJECTSCHEME_ELEMENTDEF::matches).then(Steps.attribute((String)"name").where(Predicate.not(SubjectSchemeReader.isEmptyAttribute())))).findFirst().map(XdmItem::getStringValue).orElse(ANY_ELEMENT);
        Optional attributeDefElement = enumerationDef.select(Steps.child(Constants.SUBJECTSCHEME_ATTRIBUTEDEF::matches).first()).findFirst();
        QName attributeName = attributeDefElement.map(child -> child.getAttributeValue(ATTRIBUTE_QNAME_NAME)).filter(name -> name != null && !name.isEmpty()).map(QName::valueOf).orElse(null);
        if (attributeDefElement.isPresent()) {
            this.bindingMap.computeIfAbsent(attributeName, k -> new HashMap());
        }
        enumerationDef.select(Steps.child(Constants.SUBJECTSCHEME_DEFAULTSUBJECT::matches)).map(child -> child.getAttributeValue(ATTRIBUTE_QNAME_KEYREF)).filter(keyref -> keyref != null && !keyref.isEmpty()).findFirst().ifPresent(keyValue -> {
            Map S = this.defaultValueMap.getOrDefault(attributeName, new HashMap());
            S.put(elementName, keyValue);
            this.defaultValueMap.put(attributeName, S);
        });
        for (XdmNode child2 : enumerationDef.children(Constants.SUBJECTSCHEME_SUBJECTDEF::matches)) {
            List keyValues = Optional.ofNullable(child2.getAttributeValue(ATTRIBUTE_QNAME_KEYREF)).filter(Predicate.not(String::isBlank)).or(() -> Optional.ofNullable(child2.getAttributeValue(ATTRIBUTE_QNAME_KEYS))).map(String::trim).filter(Predicate.not(String::isEmpty)).map(value -> Arrays.asList(value.split("\\s+"))).orElse(List.of());
            if (subjectDefinitions.isEmpty() || keyValues.isEmpty()) continue;
            for (String keyValue2 : keyValues) {
                SubjectScheme.SubjectDefinition subTree = subjectDefinitions.get(keyValue2);
                if (subTree == null) continue;
                Map S = this.bindingMap.getOrDefault(attributeName, new HashMap());
                Set A = S.getOrDefault(elementName, new HashSet());
                if (!A.contains(subTree) && attributeName != null) {
                    this.putValuePairsIntoMap(subTree, elementName, attributeName, keyValue2);
                }
                A.add(subTree);
                S.put(elementName, A);
                this.bindingMap.put(attributeName, S);
            }
        }
    }

    private static Predicate<XdmNode> isEmptyAttribute() {
        return attr -> attr.getStringValue().isEmpty();
    }

    private static List<String> getKeyValues(XdmNode child) {
        String value = child.getAttributeValue(ATTRIBUTE_QNAME_KEYS);
        if (value == null) {
            return List.of();
        }
        if ((value = value.trim()).isEmpty()) {
            return List.of();
        }
        return Arrays.asList(value.split("\\s+"));
    }

    private void putValuePairsIntoMap(SubjectScheme.SubjectDefinition subtree, String elementName, QName attName, String category) {
        Map valueMap = this.validValuesMap.getOrDefault(attName, new HashMap());
        Set valueSet = valueMap.getOrDefault(elementName, new HashSet());
        subtree.flatten().stream().flatMap(child -> child.keys().stream()).filter(key -> !key.equals(category)).forEach(valueSet::add);
        valueMap.put(elementName, valueSet);
        this.validValuesMap.put(attName, valueMap);
    }
}

