/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.nio.charset.StandardCharsets;

final class FilePathToURI {
    private static final boolean[] gNeedEscaping;
    private static final char[] gAfterEscaping1;
    private static final char[] gAfterEscaping2;
    private static final char[] gHexChs;

    private FilePathToURI() {
    }

    public static String filepath2URI(String path) {
        if (path == null) {
            return null;
        }
        path = FilePathToURI.escapeSpecialAsciiAndNonAscii(path);
        return path;
    }

    private static String escapeSpecialAsciiAndNonAscii(String path) {
        int i;
        int ch;
        int len = path.length();
        StringBuilder buffer = new StringBuilder(len * 3);
        if (len >= 2 && path.charAt(1) == ':' && (ch = Character.toUpperCase(path.charAt(0))) >= 65 && ch <= 90) {
            buffer.append('/');
        }
        for (i = 0; i < len && (ch = path.charAt(i)) < 128; ++i) {
            if (gNeedEscaping[ch]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[ch]);
                buffer.append(gAfterEscaping2[ch]);
                continue;
            }
            buffer.append((char)ch);
        }
        if (i < len) {
            for (byte b : path.substring(i).getBytes(StandardCharsets.UTF_8)) {
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(gHexChs[ch >> 4]);
                    buffer.append(gHexChs[ch & 0xF]);
                    continue;
                }
                if (gNeedEscaping[b]) {
                    buffer.append('%');
                    buffer.append(gAfterEscaping1[b]);
                    buffer.append(gAfterEscaping2[b]);
                    continue;
                }
                buffer.append((char)b);
            }
        }
        return buffer.toString();
    }

    static {
        char[] escChs;
        gNeedEscaping = new boolean[128];
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i <= 31; ++i) {
            FilePathToURI.gNeedEscaping[i] = true;
            FilePathToURI.gAfterEscaping1[i] = gHexChs[i >> 4];
            FilePathToURI.gAfterEscaping2[i] = gHexChs[i & 0xF];
        }
        FilePathToURI.gNeedEscaping[127] = true;
        FilePathToURI.gAfterEscaping1[127] = 55;
        FilePathToURI.gAfterEscaping2[127] = 70;
        char[] cArray = escChs = new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '?', '|', '\\', '^', '~', '[', ']', '`', '\'', '&'};
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char escCh;
            char ch = escCh = cArray[i];
            FilePathToURI.gNeedEscaping[ch] = true;
            FilePathToURI.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            FilePathToURI.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
        }
    }
}

