/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;

public class Pool<T> {
    private final Queue<T> objects;
    private final Supplier<T> create;

    public Pool(Supplier<T> create) {
        this.create = create;
        this.objects = new ConcurrentLinkedQueue<T>();
    }

    public T borrowObject() {
        T t = this.objects.poll();
        if (t == null) {
            t = this.create.get();
        }
        return t;
    }

    public void returnObject(T object) {
        this.objects.offer(object);
    }
}

