/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import com.thaiopensource.resolver.Resolver;
import java.io.IOException;
import org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.ditang.relaxng.defaults.RelaxNGDefaultsComponent;

public class RelaxDefaultsParserConfiguration
extends XIncludeAwareParserConfiguration {
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String XERCES_SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected RelaxNGDefaultsComponent fRelaxDefaults = null;
    protected final Resolver resolver;
    private boolean relaxNGValidation = false;

    public RelaxDefaultsParserConfiguration() {
        this(null, null, null);
    }

    public RelaxDefaultsParserConfiguration(SymbolTable symbolTable) {
        this(symbolTable, null, null);
    }

    public RelaxDefaultsParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool, Resolver resolver) {
        this(symbolTable, grammarPool, null, resolver);
    }

    public RelaxDefaultsParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool, XMLComponentManager parentSettings, Resolver resolver) {
        super(symbolTable, grammarPool, parentSettings);
        this.resolver = resolver;
    }

    public boolean parse(boolean complete) throws XNIException, IOException {
        if (this.fInputSource != null) {
            try {
                this.setFeature(DYNAMIC_VALIDATION, this.getFeature(VALIDATION) || this.getFeature(XERCES_SCHEMA_VALIDATION));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return super.parse(complete);
    }

    protected void configurePipeline() {
        super.configurePipeline();
        this.insertRelaxDefaultsComponent();
    }

    protected void configureXML11Pipeline() {
        super.configureXML11Pipeline();
        this.insertRelaxDefaultsComponent();
    }

    protected void insertRelaxDefaultsComponent() {
        if (this.fRelaxDefaults == null) {
            this.fRelaxDefaults = new RelaxNGDefaultsComponent(this.resolver, this.fGrammarPool);
            this.addCommonComponent(this.fRelaxDefaults);
            this.fRelaxDefaults.setValidate(this.relaxNGValidation);
            this.fRelaxDefaults.setProperty("http://apache.org/xml/properties/internal/error-handler", this.getProperty("http://apache.org/xml/properties/internal/error-handler"));
            this.fRelaxDefaults.reset((XMLComponentManager)this);
        }
        XMLDocumentSource prev = this.fLastComponent;
        this.fLastComponent = this.fRelaxDefaults;
        XMLDocumentHandler next = prev.getDocumentHandler();
        prev.setDocumentHandler((XMLDocumentHandler)this.fRelaxDefaults);
        this.fRelaxDefaults.setDocumentSource(prev);
        if (next != null) {
            this.fRelaxDefaults.setDocumentHandler(next);
            next.setDocumentSource((XMLDocumentSource)this.fRelaxDefaults);
        }
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        if (XERCES_SCHEMA_VALIDATION.equals(featureId)) {
            this.relaxNGValidation = state;
        }
        super.setFeature(featureId, state);
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if ("http://apache.org/xml/properties/internal/grammar-pool".equals(propertyId)) {
            this.fGrammarPool = (XMLGrammarPool)value;
        }
        super.setProperty(propertyId, value);
    }
}

