/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import java.util.concurrent.atomic.AtomicInteger;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Closure;

public class LearningEvaluator
implements SequenceEvaluator {
    private static final int EVAL_LIMIT = 20;
    private static final int LEARNING_LIMIT = 40;
    private final Expression expression;
    private SequenceEvaluator evaluator;
    private final AtomicInteger completed;
    private final AtomicInteger count;

    public LearningEvaluator(Expression expr, SequenceEvaluator lazy) {
        this.expression = expr;
        this.evaluator = lazy;
        this.completed = new AtomicInteger(0);
        this.count = new AtomicInteger(0);
    }

    @Override
    public Sequence evaluate(XPathContext context) throws XPathException {
        int numberStarted = this.count.incrementAndGet();
        if (numberStarted > 40) {
            return this.evaluator.evaluate(context);
        }
        Sequence result = this.evaluator.evaluate(context);
        if (result instanceof Closure) {
            ((Closure)result).setLearningEvaluator(this, numberStarted);
        }
        return result;
    }

    public void reportCompletion(int serialNumber) {
        int numberCompleted = this.completed.incrementAndGet();
        int numberStarted = this.count.get();
        if (numberCompleted >= 20 && numberCompleted == numberStarted) {
            this.evaluator = this.expression.makeElaborator().eagerly();
        }
    }
}

