/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.elab.Pingable;
import net.sf.saxon.ma.Parcel;
import net.sf.saxon.ma.arrays.AbstractArrayItem;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ImmutableArrayItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SequenceIteratorOverJavaIterator;
import net.sf.saxon.z.IntSet;

public class SimpleArrayItem
extends AbstractArrayItem {
    public static final SimpleArrayItem EMPTY_ARRAY = new SimpleArrayItem(new ArrayList<GroundedValue>());
    private final List<GroundedValue> _members;
    private boolean knownToBeGrounded = false;
    private Pingable conversionPingable;

    public SimpleArrayItem(List<GroundedValue> members) {
        this._members = members;
    }

    public static SimpleArrayItem makeSimpleArrayItem(SequenceIterator input) throws XPathException {
        Item item;
        ArrayList<GroundedValue> members = new ArrayList<GroundedValue>();
        while ((item = input.next()) != null) {
            members.add(item);
        }
        SimpleArrayItem result = new SimpleArrayItem(members);
        result.knownToBeGrounded = true;
        return result;
    }

    @Override
    public OperandRole[] getOperandRoles() {
        return new OperandRole[]{OperandRole.SINGLE_ATOMIC};
    }

    public void requestNotification(Pingable informee) {
        this.conversionPingable = informee;
    }

    public void notifyConversion() {
        if (this.conversionPingable != null) {
            this.conversionPingable.ping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeGrounded() throws XPathException {
        if (!this.knownToBeGrounded) {
            SimpleArrayItem simpleArrayItem = this;
            synchronized (simpleArrayItem) {
                for (int i = 0; i < this._members.size(); ++i) {
                    this._members.set(i, ((Sequence)this._members.get(i)).materialize());
                }
                this.knownToBeGrounded = true;
            }
        }
    }

    @Override
    public AnnotationList getAnnotations() {
        return AnnotationList.EMPTY;
    }

    @Override
    public GroundedValue get(int index) {
        return this._members.get(index);
    }

    @Override
    public ArrayItem put(int index, GroundedValue newValue) {
        this.notifyConversion();
        ImmutableArrayItem a2 = new ImmutableArrayItem(this);
        return a2.put(index, newValue);
    }

    @Override
    public int arrayLength() {
        return this._members.size();
    }

    @Override
    public boolean isEmpty() {
        return this._members.isEmpty();
    }

    @Override
    public Iterable<GroundedValue> members() {
        return this._members;
    }

    @Override
    public SequenceIterator parcels() {
        return new SequenceIteratorOverJavaIterator<GroundedValue>(this._members.iterator(), member -> new Parcel((GroundedValue)member));
    }

    @Override
    public ArrayItem removeSeveral(IntSet positions) {
        this.notifyConversion();
        ImmutableArrayItem a2 = new ImmutableArrayItem(this);
        return a2.removeSeveral(positions);
    }

    @Override
    public ArrayItem remove(int pos) {
        this.notifyConversion();
        ImmutableArrayItem a2 = new ImmutableArrayItem(this);
        return a2.remove(pos);
    }

    @Override
    public ArrayItem subArray(int start, int end) {
        return new SimpleArrayItem(this._members.subList(start, end));
    }

    @Override
    public ArrayItem insert(int position, GroundedValue member) {
        this.notifyConversion();
        ImmutableArrayItem a2 = new ImmutableArrayItem(this);
        return a2.insert(position, member);
    }

    @Override
    public ArrayItem append(GroundedValue newMember) {
        this.notifyConversion();
        ImmutableArrayItem a2 = new ImmutableArrayItem(this);
        return a2.append(newMember);
    }

    @Override
    public ArrayItem concat(ArrayItem other) {
        this.notifyConversion();
        ImmutableArrayItem a2 = new ImmutableArrayItem(this);
        return a2.concat(other);
    }

    public List<GroundedValue> getMembers() {
        return this._members;
    }

    @Override
    public String toShortString() {
        int size = this.getMembers().size();
        if (size == 0) {
            return "[]";
        }
        if (size > 5) {
            return "[(:size " + size + ":)]";
        }
        StringBuilder buff = new StringBuilder(256);
        buff.append("[");
        for (GroundedValue entry : this.members()) {
            buff.append(Err.depictSequence(entry).toString().trim());
            buff.append(", ");
        }
        if (size == 1) {
            buff.append("]");
        } else {
            buff.setCharAt(buff.length() - 2, ']');
        }
        return buff.toString().trim();
    }
}

