// generated by diplomat-tool
import { SegmenterWordType } from "./SegmenterWordType.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `WordBreakIterator`](https://docs.rs/icu/latest/icu/segmenter/iterators/struct.WordBreakIterator.html) for more information.
 */
const WordBreakIteratorUtf8_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_WordBreakIteratorUtf8_destroy_mv1(ptr);
});

export class WordBreakIteratorUtf8 {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];
    #aEdge = [];

    #internalConstructor(symbol, ptr, selfEdge, aEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("WordBreakIteratorUtf8 is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#aEdge = aEdge;
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            WordBreakIteratorUtf8_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Finds the next breakpoint. Returns -1 if at the end of the string or if the index is
     * out of range of a 32-bit signed integer.
     *
     * See the [Rust documentation for `next`](https://docs.rs/icu/latest/icu/segmenter/iterators/struct.WordBreakIterator.html#method.next) for more information.
     */
    next() {

        const result = wasm.icu4x_WordBreakIteratorUtf8_next_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Return the status value of break boundary.
     *
     * See the [Rust documentation for `word_type`](https://docs.rs/icu/latest/icu/segmenter/iterators/struct.WordBreakIterator.html#method.word_type) for more information.
     */
    get wordType() {

        const result = wasm.icu4x_WordBreakIteratorUtf8_word_type_mv1(this.ffiValue);

        try {
            return new SegmenterWordType(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * Return true when break boundary is word-like such as letter/number/CJK
     *
     * See the [Rust documentation for `is_word_like`](https://docs.rs/icu/latest/icu/segmenter/iterators/struct.WordBreakIterator.html#method.is_word_like) for more information.
     */
    get isWordLike() {

        const result = wasm.icu4x_WordBreakIteratorUtf8_is_word_like_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    constructor(symbol, ptr, selfEdge, aEdge) {
        return this.#internalConstructor(...arguments)
    }
}