// http://turtle.sourceforge.net
//
// Copyright Mathieu Champlon 2014
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#include <turtle/mock.hpp>
#include <boost/test/unit_test.hpp>

namespace {
//[ limitations_literal_zero_problem
class base
{
public:
    virtual void method(int* i) = 0;
};

MOCK_BASE_CLASS(mock_base, base)
{
    MOCK_METHOD(method, 1)
};
//]
} // namespace

BOOST_AUTO_TEST_CASE(literal_zero)
{
    mock_base m;
    //[ limitations_literal_zero_solution_1
    MOCK_EXPECT(m.method).with(mock::equal<int*>(0)); // this compiles
                                                      //]
                                                      //[ limitations_literal_zero_solution_2
    MOCK_EXPECT(m.method).with(mock::negate);
    //]
    //[ limitations_literal_zero_solution_3
    MOCK_EXPECT(m.method).with(nullptr);
    //]
}
