/*
 * Copyright 2016-2017 Józef Kucia for CodeWeavers
 * Copyright 2020-2021 Philip Rebohle for Valve Corporation
 * Copyright 2020-2021 Joshua Ashton for Valve Corporation
 * Copyright 2020-2021 Hans-Kristian Arntzen for Valve Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#define VKD3D_DBG_CHANNEL VKD3D_DBG_CHANNEL_API
#include "d3d12_crosstest.h"

void test_buffers_oob_behavior_vectorized_byte_address(void)
{
    /* Vectorized structured buffers are handled by other tests, but
     * vectorized byte address buffers are particularly
     * weird due to component based robustness.
     * Intended to trip vectorized load-store optimizations in dxil-spirv. */
    D3D12_ROOT_SIGNATURE_DESC root_signature_desc;
    D3D12_FEATURE_DATA_SHADER_MODEL shader_model;
    D3D12_DESCRIPTOR_RANGE descriptor_ranges[1];
    D3D12_FEATURE_DATA_D3D12_OPTIONS4 options4;
    ID3D12GraphicsCommandList *command_list;
    D3D12_ROOT_PARAMETER root_parameters[1];
    D3D12_CPU_DESCRIPTOR_HANDLE cpu_handle;
    D3D12_GPU_DESCRIPTOR_HANDLE gpu_handle;
    ID3D12PipelineState *write_pso_32bit;
    ID3D12PipelineState *write_pso_16bit;
    ID3D12PipelineState *read_pso_32bit;
    ID3D12PipelineState *read_pso_16bit;
    unsigned int descriptor_size, i, j;
    ID3D12Resource *read_output_buffer;
    ID3D12DescriptorHeap *gpu_heap;
    ID3D12DescriptorHeap *cpu_heap;
    ID3D12Resource *output_buffer;
    struct resource_readback rb;
    struct test_context context;
    ID3D12CommandQueue *queue;
    HRESULT hr;

    static const BYTE cs_code_write_32bit_dxil[] =
    {
#if 0
    RWByteAddressBuffer WriteUint1 : register(u2);
    RWByteAddressBuffer WriteUint2 : register(u3);
    RWByteAddressBuffer WriteUint3 : register(u4);
    RWByteAddressBuffer WriteUint4 : register(u5);

    [numthreads(64, 1, 1)]
    void main(uint thr : SV_DispatchThreadID)
    {
        WriteUint1.Store<uint>(4 * thr, thr);
        WriteUint2.Store<uint2>(8 * thr, 2 * thr + uint2(0, 1));
        WriteUint3.Store<uint3>(12 * thr, 3 * thr + uint3(0, 1, 2));
        WriteUint4.Store<uint4>(16 * thr, 4 * thr + uint4(0, 1, 2, 3));
    }
#endif
        0x44, 0x58, 0x42, 0x43, 0x43, 0x0a, 0xd2, 0xf1, 0x15, 0xa8, 0xa9, 0xb3, 0x2e, 0xfb, 0x1b, 0x25, 0xf9, 0xe5, 0xe7, 0x8a, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0x38, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x18, 0x01, 0x00, 0x00, 0x34, 0x01, 0x00, 0x00, 0x53, 0x46, 0x49, 0x30, 0x08, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x4f, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x50, 0x53, 0x56, 0x30, 0xa8, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
        0x05, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x41, 0x53, 0x48, 0x14, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xc6, 0x67, 0xdd, 0x93, 0xf1, 0x52, 0x56, 0xbf, 0xa6, 0x3e, 0xf7, 0xfa, 0xa4, 0x05, 0x9f, 0x04, 0x44, 0x58, 0x49, 0x4c, 0x84, 0x05, 0x00, 0x00, 0x62, 0x00, 0x05, 0x00,
        0x61, 0x01, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0x02, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x6c, 0x05, 0x00, 0x00, 0x42, 0x43, 0xc0, 0xde, 0x21, 0x0c, 0x00, 0x00, 0x58, 0x01, 0x00, 0x00,
        0x0b, 0x82, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x07, 0x81, 0x23, 0x91, 0x41, 0xc8, 0x04, 0x49, 0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c, 0x25, 0x05, 0x08, 0x19,
        0x1e, 0x04, 0x8b, 0x62, 0x80, 0x14, 0x45, 0x02, 0x42, 0x92, 0x0b, 0x42, 0xa4, 0x10, 0x32, 0x14, 0x38, 0x08, 0x18, 0x4b, 0x0a, 0x32, 0x52, 0x88, 0x48, 0x90, 0x14, 0x20, 0x43, 0x46, 0x88, 0xa5,
        0x00, 0x19, 0x32, 0x42, 0xe4, 0x48, 0x0e, 0x90, 0x91, 0x22, 0xc4, 0x50, 0x41, 0x51, 0x81, 0x8c, 0xe1, 0x83, 0xe5, 0x8a, 0x04, 0x29, 0x46, 0x06, 0x51, 0x18, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
        0x1b, 0x8c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x40, 0x02, 0xa8, 0x0d, 0x84, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x20, 0x6d, 0x30, 0x86, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x09, 0xa8, 0x00,
        0x49, 0x18, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x13, 0x82, 0x60, 0x42, 0x20, 0x4c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x89, 0x20, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x32, 0x22, 0x48, 0x09,
        0x20, 0x64, 0x85, 0x04, 0x93, 0x22, 0xa4, 0x84, 0x04, 0x93, 0x22, 0xe3, 0x84, 0xa1, 0x90, 0x14, 0x12, 0x4c, 0x8a, 0x8c, 0x0b, 0x84, 0xa4, 0x4c, 0x10, 0x48, 0x23, 0x00, 0x25, 0x00, 0x14, 0xe6,
        0x08, 0xc0, 0xa0, 0x0c, 0x63, 0x0c, 0x22, 0x73, 0x04, 0x08, 0x99, 0x7b, 0x86, 0xcb, 0x9f, 0xb0, 0x87, 0x90, 0xfc, 0x10, 0x68, 0x86, 0x85, 0x40, 0xc1, 0x29, 0x0b, 0x18, 0x68, 0x8c, 0x31, 0xc6,
        0x30, 0x83, 0xd2, 0x1c, 0x41, 0x50, 0x0c, 0x34, 0xcc, 0x18, 0x8b, 0xd8, 0x40, 0xc0, 0x69, 0xd2, 0x14, 0x51, 0xc2, 0xe4, 0xaf, 0xf0, 0x86, 0x4d, 0x84, 0x36, 0x0c, 0x11, 0x21, 0x49, 0x1b, 0x55,
        0x14, 0x44, 0x84, 0x82, 0x41, 0x6f, 0x8e, 0x00, 0x14, 0x00, 0x00, 0x00, 0x13, 0x14, 0x72, 0xc0, 0x87, 0x74, 0x60, 0x87, 0x36, 0x68, 0x87, 0x79, 0x68, 0x03, 0x72, 0xc0, 0x87, 0x0d, 0xaf, 0x50,
        0x0e, 0x6d, 0xd0, 0x0e, 0x7a, 0x50, 0x0e, 0x6d, 0x00, 0x0f, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x78,
        0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe9, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x76, 0x40, 0x07,
        0x7a, 0x60, 0x07, 0x74, 0xd0, 0x06, 0xe6, 0x10, 0x07, 0x76, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x60, 0x0e, 0x73, 0x20, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe6, 0x60, 0x07, 0x74, 0xa0,
        0x07, 0x76, 0x40, 0x07, 0x6d, 0xe0, 0x0e, 0x78, 0xa0, 0x07, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x43, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x86, 0x3c, 0x04, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x79, 0x12, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xf2, 0x30,
        0x40, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x05, 0x02, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x32, 0x1e, 0x98, 0x14, 0x19, 0x11, 0x4c, 0x90, 0x8c, 0x09, 0x26, 0x47,
        0xc6, 0x04, 0x43, 0x1a, 0x25, 0x50, 0x04, 0xc5, 0x30, 0x02, 0x50, 0x16, 0x65, 0x50, 0x08, 0xa5, 0x50, 0x80, 0x01, 0xb4, 0x46, 0x00, 0x28, 0x16, 0x08, 0xc1, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x79, 0x18, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x1a, 0x03, 0x4c, 0x90, 0x46, 0x02, 0x13, 0x44, 0x35, 0x18, 0x63, 0x0b, 0x73, 0x3b, 0x03, 0xb1, 0x2b, 0x93, 0x9b, 0x4b, 0x7b, 0x73, 0x03, 0x99,
        0x71, 0xb9, 0x01, 0x41, 0xa1, 0x0b, 0x3b, 0x9b, 0x7b, 0x91, 0x2a, 0x62, 0x2a, 0x0a, 0x9a, 0x2a, 0xfa, 0x9a, 0xb9, 0x81, 0x79, 0x31, 0x4b, 0x73, 0x0b, 0x63, 0x4b, 0xd9, 0x10, 0x04, 0x13, 0x84,
        0x81, 0x98, 0x20, 0x0c, 0xc5, 0x06, 0x61, 0x20, 0x26, 0x08, 0x83, 0xb1, 0x41, 0x18, 0x0c, 0x0a, 0x63, 0x73, 0x1b, 0x06, 0xc4, 0x20, 0x26, 0x08, 0xc3, 0x31, 0x41, 0x80, 0x1e, 0x02, 0x13, 0x84,
        0x01, 0x99, 0x20, 0x2c, 0xcd, 0x86, 0x45, 0x59, 0x18, 0x85, 0x18, 0x1a, 0xc7, 0x71, 0x80, 0x09, 0xc2, 0x90, 0x6c, 0x58, 0x86, 0x85, 0x51, 0xa0, 0xa1, 0x71, 0x1c, 0x07, 0x98, 0x20, 0x0c, 0xca,
        0x86, 0x85, 0x58, 0x18, 0x45, 0x1a, 0x1a, 0xc7, 0x71, 0x80, 0x09, 0xc2, 0xb0, 0x6c, 0x58, 0xa0, 0x85, 0x51, 0xa8, 0xa1, 0x71, 0x1c, 0x07, 0xd8, 0x40, 0x3c, 0xd1, 0x54, 0x6d, 0x20, 0x00, 0x0b,
        0x00, 0x26, 0x08, 0x02, 0x40, 0xa2, 0x2d, 0x2c, 0xcd, 0x6d, 0x82, 0x10, 0x39, 0x13, 0x84, 0x81, 0xd9, 0x30, 0x6c, 0xc3, 0xb0, 0x81, 0x50, 0x34, 0x89, 0xdb, 0x50, 0x60, 0x19, 0x70, 0x75, 0x55,
        0xd8, 0xd8, 0xec, 0xda, 0x5c, 0xd2, 0xc8, 0xca, 0xdc, 0xe8, 0xa6, 0x04, 0x41, 0x15, 0x32, 0x3c, 0x17, 0xbb, 0x32, 0xb9, 0xb9, 0xb4, 0x37, 0xb7, 0x29, 0x01, 0xd1, 0x84, 0x0c, 0xcf, 0xc5, 0x2e,
        0x8c, 0xcd, 0xae, 0x4c, 0x6e, 0x4a, 0x60, 0xd4, 0x21, 0xc3, 0x73, 0x99, 0x43, 0x0b, 0x23, 0x2b, 0x93, 0x6b, 0x7a, 0x23, 0x2b, 0x63, 0x9b, 0x12, 0x20, 0x65, 0xc8, 0xf0, 0x5c, 0xe4, 0xca, 0xe6,
        0xde, 0xea, 0xe4, 0xc6, 0xca, 0xe6, 0xa6, 0x04, 0x56, 0x1d, 0x32, 0x3c, 0x97, 0x32, 0x37, 0x3a, 0xb9, 0x3c, 0xa8, 0xb7, 0x34, 0x37, 0xba, 0xb9, 0x29, 0x41, 0x07, 0x00, 0x79, 0x18, 0x00, 0x00,
        0x4c, 0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c, 0xc4, 0xe1, 0x1c, 0x66, 0x14, 0x01, 0x3d, 0x88, 0x43, 0x38, 0x84, 0xc3, 0x8c, 0x42, 0x80, 0x07, 0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6,
        0x00, 0x0f, 0xed, 0x10, 0x0e, 0xf4, 0x80, 0x0e, 0x33, 0x0c, 0x42, 0x1e, 0xc2, 0xc1, 0x1d, 0xce, 0xa1, 0x1c, 0x66, 0x30, 0x05, 0x3d, 0x88, 0x43, 0x38, 0x84, 0x83, 0x1b, 0xcc, 0x03, 0x3d, 0xc8,
        0x43, 0x3d, 0x8c, 0x03, 0x3d, 0xcc, 0x78, 0x8c, 0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79, 0x48, 0x87, 0x70, 0x70, 0x07, 0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20, 0x87, 0x19, 0xcc, 0x11,
        0x0e, 0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e, 0x30, 0x0f, 0xe3, 0xf0, 0x0e, 0xf0, 0x50, 0x0e, 0x33, 0x10, 0xc4, 0x1d, 0xde, 0x21, 0x1c, 0xd8, 0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89,
        0x3b, 0xbc, 0x83, 0x3b, 0xd0, 0x43, 0x39, 0xb4, 0x03, 0x3c, 0xbc, 0x83, 0x3c, 0x84, 0x03, 0x3b, 0xcc, 0xf0, 0x14, 0x76, 0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x68, 0x87, 0x72, 0x68, 0x07, 0x37,
        0x80, 0x87, 0x70, 0x90, 0x87, 0x70, 0x60, 0x07, 0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76, 0x78, 0x87, 0x77, 0x80, 0x87, 0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98, 0x87, 0x79, 0x98, 0x81,
        0x2c, 0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5, 0xc0, 0x0e, 0xec, 0x30, 0x03, 0x62, 0xc8, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xcc, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c,
        0xc4, 0x81, 0x1d, 0xca, 0x61, 0x06, 0xd6, 0x90, 0x43, 0x39, 0xc8, 0x43, 0x39, 0x98, 0x43, 0x39, 0xc8, 0x43, 0x39, 0xb8, 0xc3, 0x38, 0x94, 0x43, 0x38, 0x88, 0x03, 0x3b, 0x94, 0xc3, 0x2f, 0xbc,
        0x83, 0x3c, 0xfc, 0x82, 0x3b, 0xd4, 0x03, 0x3b, 0xb0, 0xc3, 0x0c, 0xc4, 0x21, 0x07, 0x7c, 0x70, 0x03, 0x7a, 0x28, 0x87, 0x76, 0x80, 0x87, 0x19, 0xd1, 0x43, 0x0e, 0xf8, 0xe0, 0x06, 0xe4, 0x20,
        0x0e, 0xe7, 0xe0, 0x06, 0xf6, 0x10, 0x0e, 0xf2, 0xc0, 0x0e, 0xe1, 0x90, 0x0f, 0xef, 0x50, 0x0f, 0xf4, 0x00, 0x00, 0x00, 0x71, 0x20, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x36, 0x20, 0x0d, 0x97,
        0xef, 0x3c, 0xbe, 0x10, 0x11, 0xc0, 0x44, 0x84, 0x40, 0x33, 0x2c, 0x84, 0x09, 0x60, 0xc3, 0xe5, 0x3b, 0x8f, 0x1f, 0x01, 0xd6, 0x46, 0x15, 0x05, 0x11, 0xb1, 0x93, 0x13, 0x11, 0x3e, 0x72, 0xdb,
        0x16, 0x20, 0x0d, 0x97, 0xef, 0x3c, 0xfe, 0x74, 0x44, 0x04, 0x30, 0x88, 0x83, 0x8f, 0xdc, 0xb6, 0x01, 0x10, 0x0c, 0x80, 0x34, 0x00, 0x00, 0x00, 0x61, 0x20, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00,
        0x13, 0x04, 0x41, 0x2c, 0x10, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x34, 0x66, 0x00, 0x4a, 0xae, 0x30, 0x05, 0x4a, 0x37, 0xa0, 0x30, 0xc8, 0x94, 0x40, 0x19, 0x94, 0x43, 0x79, 0x00, 0x00,
        0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0xc0, 0x58, 0x08, 0x01, 0x39, 0xcc, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x30, 0x57, 0x52, 0x54, 0x50, 0x33, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x0c, 0xa6,
        0x18, 0x97, 0xe4, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x93, 0x2d, 0x47, 0x75, 0x3d, 0x23, 0x06, 0x06, 0x00, 0x82, 0x60, 0x40, 0x70, 0x8a, 0x55, 0x41, 0x76, 0x23, 0x06, 0x0e, 0x00, 0x82,
        0x60, 0x90, 0x74, 0xcd, 0x10, 0x3c, 0xc2, 0xf3, 0x3c, 0x4a, 0x55, 0xc2, 0x76, 0x15, 0x70, 0x5b, 0x04, 0x76, 0x23, 0x06, 0x0e, 0x00, 0x82, 0x60, 0x90, 0x80, 0x01, 0x74, 0x04, 0xd2, 0x20, 0x48,
        0x12, 0x83, 0x55, 0x91, 0x49, 0x05, 0x1f, 0x94, 0xf0, 0x41, 0x21, 0x91, 0x8c, 0x18, 0x38, 0x00, 0x08, 0x82, 0x41, 0x42, 0x06, 0x14, 0x13, 0x58, 0xc4, 0x20, 0x58, 0x0f, 0x57, 0x88, 0x18, 0x6c,
        0x25, 0x62, 0xb0, 0xa5, 0x7c, 0x5b, 0xcc, 0x77, 0x23, 0x06, 0x0e, 0x00, 0x82, 0x60, 0x90, 0xa0, 0x01, 0x16, 0x05, 0x1a, 0x43, 0x0c, 0x82, 0x04, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    };

    static const BYTE cs_code_write_16bit_dxil[] =
    {
#if 0
    RWByteAddressBuffer WriteShort1 : register(u6);
    RWByteAddressBuffer WriteShort2 : register(u7);
    RWByteAddressBuffer WriteShort3 : register(u8);
    RWByteAddressBuffer WriteShort4 : register(u9);

    [numthreads(64, 1, 1)]
    void main(uint thr : SV_DispatchThreadID)
    {
        WriteShort1.Store<uint16_t>(2 * thr, uint16_t(thr));
        WriteShort2.Store<uint16_t2>(4 * thr, uint16_t(2 * thr) + uint16_t2(0, 1));
        WriteShort3.Store<uint16_t3>(6 * thr, uint16_t(3 * thr) + uint16_t3(0, 1, 2));
        WriteShort4.Store<uint16_t4>(8 * thr, uint16_t(4 * thr) + uint16_t4(0, 1, 2, 3));
    }
#endif
        0x44, 0x58, 0x42, 0x43, 0xbc, 0xd0, 0x15, 0xdd, 0x79, 0x7c, 0x27, 0xda, 0x33, 0x83, 0x7c, 0x3f, 0x0d, 0xe3, 0x79, 0xd8, 0x01, 0x00, 0x00, 0x00, 0xe0, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0x38, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x18, 0x01, 0x00, 0x00, 0x34, 0x01, 0x00, 0x00, 0x53, 0x46, 0x49, 0x30, 0x08, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x4f, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x50, 0x53, 0x56, 0x30, 0xa8, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
        0x09, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x41, 0x53, 0x48, 0x14, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x11, 0x4f, 0xdb, 0x99, 0x0d, 0xe0, 0x00, 0x33, 0x9f, 0xa8, 0xf9, 0xe2, 0xb1, 0xe2, 0x5f, 0xc4, 0x44, 0x58, 0x49, 0x4c, 0xa4, 0x05, 0x00, 0x00, 0x62, 0x00, 0x05, 0x00,
        0x69, 0x01, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0x02, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x8c, 0x05, 0x00, 0x00, 0x42, 0x43, 0xc0, 0xde, 0x21, 0x0c, 0x00, 0x00, 0x60, 0x01, 0x00, 0x00,
        0x0b, 0x82, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x07, 0x81, 0x23, 0x91, 0x41, 0xc8, 0x04, 0x49, 0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c, 0x25, 0x05, 0x08, 0x19,
        0x1e, 0x04, 0x8b, 0x62, 0x80, 0x14, 0x45, 0x02, 0x42, 0x92, 0x0b, 0x42, 0xa4, 0x10, 0x32, 0x14, 0x38, 0x08, 0x18, 0x4b, 0x0a, 0x32, 0x52, 0x88, 0x48, 0x90, 0x14, 0x20, 0x43, 0x46, 0x88, 0xa5,
        0x00, 0x19, 0x32, 0x42, 0xe4, 0x48, 0x0e, 0x90, 0x91, 0x22, 0xc4, 0x50, 0x41, 0x51, 0x81, 0x8c, 0xe1, 0x83, 0xe5, 0x8a, 0x04, 0x29, 0x46, 0x06, 0x51, 0x18, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
        0x1b, 0x8c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x40, 0x02, 0xa8, 0x0d, 0x84, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x20, 0x6d, 0x30, 0x86, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x09, 0xa8, 0x00,
        0x49, 0x18, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x13, 0x82, 0x60, 0x42, 0x20, 0x4c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x89, 0x20, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x32, 0x22, 0x48, 0x09,
        0x20, 0x64, 0x85, 0x04, 0x93, 0x22, 0xa4, 0x84, 0x04, 0x93, 0x22, 0xe3, 0x84, 0xa1, 0x90, 0x14, 0x12, 0x4c, 0x8a, 0x8c, 0x0b, 0x84, 0xa4, 0x4c, 0x10, 0x4c, 0x23, 0x00, 0x25, 0x00, 0x14, 0xe6,
        0x08, 0xc0, 0xa0, 0x0c, 0x63, 0x0c, 0x22, 0x73, 0x04, 0x08, 0x99, 0x7b, 0x86, 0xcb, 0x9f, 0xb0, 0x87, 0x90, 0xfc, 0x10, 0x68, 0x86, 0x85, 0x40, 0xc1, 0x99, 0x23, 0x80, 0xca, 0x02, 0x06, 0x1a,
        0x23, 0xa5, 0x94, 0xcc, 0x20, 0x35, 0x47, 0x10, 0x14, 0x03, 0x0d, 0x33, 0x06, 0xa3, 0x36, 0x10, 0x70, 0x9a, 0x34, 0x45, 0x94, 0x30, 0xf9, 0x2b, 0xbc, 0x61, 0x13, 0xa1, 0x0d, 0x43, 0x44, 0x48,
        0xd2, 0x46, 0x15, 0x05, 0x11, 0xa1, 0x60, 0x10, 0x9c, 0x23, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x13, 0x14, 0x72, 0xc0, 0x87, 0x74, 0x60, 0x87, 0x36, 0x68, 0x87, 0x79, 0x68, 0x03, 0x72, 0xc0,
        0x87, 0x0d, 0xae, 0x50, 0x0e, 0x6d, 0xd0, 0x0e, 0x7a, 0x50, 0x0e, 0x6d, 0x00, 0x0f, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0xa0, 0x07, 0x73, 0x20, 0x07,
        0x6d, 0x90, 0x0e, 0x78, 0xa0, 0x07, 0x78, 0xd0, 0x06, 0xe9, 0x10, 0x07, 0x76, 0xa0, 0x07, 0x71, 0x60, 0x07, 0x6d, 0x90, 0x0e, 0x73, 0x20, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe9, 0x60,
        0x07, 0x74, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x6d, 0x60, 0x0e, 0x71, 0x60, 0x07, 0x7a, 0x10, 0x07, 0x76, 0xd0, 0x06, 0xe6, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x60, 0x0e, 0x76,
        0x40, 0x07, 0x7a, 0x60, 0x07, 0x74, 0xd0, 0x06, 0xee, 0x80, 0x07, 0x7a, 0x10, 0x07, 0x76, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x7a, 0x60, 0x07, 0x74, 0x30, 0xe4, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xc8, 0x43, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x90, 0x47, 0x01, 0x02, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
        0x21, 0x4f, 0x03, 0x04, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0x20, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x32, 0x1e, 0x98, 0x14, 0x19, 0x11, 0x4c, 0x90, 0x8c, 0x09, 0x26, 0x47,
        0xc6, 0x04, 0x43, 0x1a, 0x25, 0x50, 0x04, 0xc5, 0x30, 0x02, 0x50, 0x16, 0xe5, 0x50, 0x10, 0x65, 0x50, 0x12, 0x85, 0x50, 0x80, 0x01, 0xc4, 0x46, 0x00, 0x48, 0x16, 0x38, 0x20, 0x20, 0x02, 0xc5,
        0x19, 0x00, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x47, 0x00, 0x00, 0x00, 0x1a, 0x03, 0x4c, 0x90, 0x46, 0x02, 0x13, 0x44, 0x35, 0x18, 0x63, 0x0b, 0x73, 0x3b, 0x03, 0xb1, 0x2b, 0x93, 0x9b, 0x4b,
        0x7b, 0x73, 0x03, 0x99, 0x71, 0xb9, 0x01, 0x41, 0xa1, 0x0b, 0x3b, 0x9b, 0x7b, 0x91, 0x2a, 0x62, 0x2a, 0x0a, 0x9a, 0x2a, 0xfa, 0x9a, 0xb9, 0x81, 0x79, 0x31, 0x4b, 0x73, 0x0b, 0x63, 0x4b, 0xd9,
        0x10, 0x04, 0x13, 0x84, 0x81, 0x98, 0x20, 0x0c, 0xc5, 0x06, 0x61, 0x20, 0x26, 0x08, 0x83, 0xb1, 0x41, 0x18, 0x0c, 0x0a, 0x63, 0x73, 0x1b, 0x06, 0xc4, 0x20, 0x26, 0x08, 0xc3, 0x31, 0x41, 0x88,
        0x22, 0x02, 0x13, 0x84, 0x01, 0x99, 0x20, 0x30, 0xcf, 0x86, 0x45, 0x59, 0x18, 0xc5, 0x18, 0x1a, 0xc7, 0x71, 0x80, 0x09, 0xc2, 0x90, 0x6c, 0x58, 0x86, 0x85, 0x51, 0xa0, 0xa1, 0x71, 0x1c, 0x07,
        0x98, 0x20, 0x0c, 0xca, 0x86, 0x85, 0x58, 0x18, 0x45, 0x1a, 0x1a, 0xc7, 0x71, 0x80, 0x09, 0xc2, 0xb0, 0x4c, 0x10, 0x06, 0x66, 0xc3, 0x42, 0x2d, 0x8c, 0x52, 0x0d, 0x8d, 0xe3, 0x38, 0xc0, 0x06,
        0xe2, 0x89, 0x26, 0x6b, 0x03, 0x01, 0x5c, 0x00, 0x30, 0x41, 0x10, 0x00, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x13, 0x04, 0x09, 0x9a, 0x20, 0x0c, 0xcd, 0x04, 0x61, 0x70, 0x36, 0x0c, 0xdd, 0x30, 0x6c,
        0x20, 0x94, 0x8d, 0xf3, 0x36, 0x14, 0x99, 0x06, 0x60, 0x5f, 0x15, 0x36, 0x36, 0xbb, 0x36, 0x97, 0x34, 0xb2, 0x32, 0x37, 0xba, 0x29, 0x41, 0x50, 0x85, 0x0c, 0xcf, 0xc5, 0xae, 0x4c, 0x6e, 0x2e,
        0xed, 0xcd, 0x6d, 0x4a, 0x40, 0x34, 0x21, 0xc3, 0x73, 0xb1, 0x0b, 0x63, 0xb3, 0x2b, 0x93, 0x9b, 0x12, 0x18, 0x75, 0xc8, 0xf0, 0x5c, 0xe6, 0xd0, 0xc2, 0xc8, 0xca, 0xe4, 0x9a, 0xde, 0xc8, 0xca,
        0xd8, 0xa6, 0x04, 0x48, 0x19, 0x32, 0x3c, 0x17, 0xb9, 0xb2, 0xb9, 0xb7, 0x3a, 0xb9, 0xb1, 0xb2, 0xb9, 0x29, 0xc1, 0x55, 0x87, 0x0c, 0xcf, 0xa5, 0xcc, 0x8d, 0x4e, 0x2e, 0x0f, 0xea, 0x2d, 0xcd,
        0x8d, 0x6e, 0x6e, 0x4a, 0xf0, 0x01, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c, 0xc4, 0xe1, 0x1c, 0x66, 0x14, 0x01, 0x3d, 0x88, 0x43, 0x38, 0x84, 0xc3,
        0x8c, 0x42, 0x80, 0x07, 0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6, 0x00, 0x0f, 0xed, 0x10, 0x0e, 0xf4, 0x80, 0x0e, 0x33, 0x0c, 0x42, 0x1e, 0xc2, 0xc1, 0x1d, 0xce, 0xa1, 0x1c, 0x66, 0x30,
        0x05, 0x3d, 0x88, 0x43, 0x38, 0x84, 0x83, 0x1b, 0xcc, 0x03, 0x3d, 0xc8, 0x43, 0x3d, 0x8c, 0x03, 0x3d, 0xcc, 0x78, 0x8c, 0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79, 0x48, 0x87, 0x70, 0x70, 0x07,
        0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20, 0x87, 0x19, 0xcc, 0x11, 0x0e, 0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e, 0x30, 0x0f, 0xe3, 0xf0, 0x0e, 0xf0, 0x50, 0x0e, 0x33, 0x10, 0xc4, 0x1d,
        0xde, 0x21, 0x1c, 0xd8, 0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89, 0x3b, 0xbc, 0x83, 0x3b, 0xd0, 0x43, 0x39, 0xb4, 0x03, 0x3c, 0xbc, 0x83, 0x3c, 0x84, 0x03, 0x3b, 0xcc, 0xf0, 0x14, 0x76,
        0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x68, 0x87, 0x72, 0x68, 0x07, 0x37, 0x80, 0x87, 0x70, 0x90, 0x87, 0x70, 0x60, 0x07, 0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76, 0x78, 0x87, 0x77, 0x80, 0x87,
        0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98, 0x87, 0x79, 0x98, 0x81, 0x2c, 0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5, 0xc0, 0x0e, 0xec, 0x30, 0x03, 0x62, 0xc8, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c,
        0xcc, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c, 0xc4, 0x81, 0x1d, 0xca, 0x61, 0x06, 0xd6, 0x90, 0x43, 0x39, 0xc8, 0x43, 0x39, 0x98, 0x43, 0x39, 0xc8, 0x43, 0x39, 0xb8,
        0xc3, 0x38, 0x94, 0x43, 0x38, 0x88, 0x03, 0x3b, 0x94, 0xc3, 0x2f, 0xbc, 0x83, 0x3c, 0xfc, 0x82, 0x3b, 0xd4, 0x03, 0x3b, 0xb0, 0xc3, 0x0c, 0xc4, 0x21, 0x07, 0x7c, 0x70, 0x03, 0x7a, 0x28, 0x87,
        0x76, 0x80, 0x87, 0x19, 0xd1, 0x43, 0x0e, 0xf8, 0xe0, 0x06, 0xe4, 0x20, 0x0e, 0xe7, 0xe0, 0x06, 0xf6, 0x10, 0x0e, 0xf2, 0xc0, 0x0e, 0xe1, 0x90, 0x0f, 0xef, 0x50, 0x0f, 0xf4, 0x00, 0x00, 0x00,
        0x71, 0x20, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x36, 0x20, 0x0d, 0x97, 0xef, 0x3c, 0xbe, 0x10, 0x11, 0xc0, 0x44, 0x84, 0x40, 0x33, 0x2c, 0x84, 0x09, 0x60, 0xc3, 0xe5, 0x3b, 0x8f, 0x1f, 0x01,
        0xd6, 0x46, 0x15, 0x05, 0x11, 0xb1, 0x93, 0x13, 0x11, 0x3e, 0x52, 0xeb, 0x16, 0x20, 0x0d, 0x97, 0xef, 0x3c, 0xfe, 0x74, 0x44, 0x04, 0x30, 0x88, 0x83, 0x8f, 0xdc, 0xb6, 0x01, 0x10, 0x0c, 0x80,
        0x34, 0x00, 0x00, 0x00, 0x61, 0x20, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x13, 0x04, 0x41, 0x2c, 0x10, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x34, 0x4a, 0xae, 0x30, 0x05, 0x66, 0x00, 0x4a,
        0x37, 0x80, 0x4c, 0x09, 0x94, 0x41, 0x39, 0x94, 0x07, 0xa5, 0x19, 0x80, 0x12, 0x28, 0x82, 0x32, 0x00, 0x00, 0x00, 0x00, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0xd0, 0x6c, 0x0c, 0x32, 0x49, 0xcf,
        0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x34, 0x5c, 0x93, 0x68, 0x15, 0x34, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x4d, 0xe7, 0x28, 0xdc, 0x15, 0x8d, 0x18, 0x24, 0x00, 0x08, 0x82, 0x41, 0xe3, 0x3d,
        0x8b, 0xb6, 0x49, 0x23, 0x06, 0x06, 0x00, 0x82, 0x60, 0x40, 0x84, 0x41, 0xb3, 0x5d, 0x90, 0xa0, 0x04, 0x30, 0xb8, 0x11, 0x03, 0x07, 0x00, 0x41, 0x30, 0x50, 0xc6, 0x40, 0x22, 0x82, 0x48, 0x58,
        0x96, 0xe5, 0x01, 0x83, 0x0b, 0x12, 0x54, 0xb0, 0x6c, 0x15, 0x62, 0x70, 0x23, 0x06, 0x0e, 0x00, 0x82, 0x60, 0xa0, 0x98, 0x41, 0x85, 0x04, 0xd4, 0x20, 0x38, 0x4e, 0x34, 0x06, 0x65, 0x74, 0x72,
        0x41, 0x82, 0x0a, 0x1e, 0x28, 0xe1, 0x81, 0x52, 0xcc, 0x40, 0x46, 0x0c, 0x1c, 0x00, 0x04, 0xc1, 0x40, 0x59, 0x03, 0xcd, 0x09, 0x32, 0x62, 0x10, 0xa6, 0x0a, 0x0d, 0xce, 0x48, 0x50, 0xc1, 0xb4,
        0x25, 0x4c, 0x5b, 0xc3, 0xb4, 0xf5, 0x98, 0xc1, 0x8d, 0x18, 0x38, 0x00, 0x08, 0x82, 0x81, 0x02, 0x07, 0x1f, 0x15, 0x78, 0x05, 0x31, 0x08, 0x59, 0x1b, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    };

    static const BYTE cs_code_read_32bit_dxil[] =
    {
#if 0
    RWByteAddressBuffer Writeback : register(u1);

    RWByteAddressBuffer WriteUint1 : register(u2);
    RWByteAddressBuffer WriteUint2 : register(u3);
    RWByteAddressBuffer WriteUint3 : register(u4);
    RWByteAddressBuffer WriteUint4 : register(u5);

    [numthreads(64, 1, 1)]
    void main(uint thr : SV_DispatchThreadID)
    {
        if (4 * thr < 48)
            Writeback.Store<uint>(0 + 4 * thr, WriteUint1.Load<uint>(4 * thr));

        if (8 * thr < 48)
            Writeback.Store<uint2>(1 * 64 + 8 * thr, WriteUint2.Load<uint2>(8 * thr));

        if (12 * thr < 48)
            Writeback.Store<uint3>(2 * 64 + 12 * thr, WriteUint3.Load<uint3>(12 * thr));

        if (16 * thr < 48)
            Writeback.Store<uint4>(3 * 64 + 16 * thr, WriteUint4.Load<uint4>(16 * thr));
    }
#endif
        0x44, 0x58, 0x42, 0x43, 0x62, 0x2a, 0x23, 0x51, 0xa0, 0x59, 0x3e, 0xe5, 0x3a, 0xe5, 0xa5, 0x07, 0x0a, 0xd8, 0x70, 0x5b, 0x01, 0x00, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0x38, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x30, 0x01, 0x00, 0x00, 0x4c, 0x01, 0x00, 0x00, 0x53, 0x46, 0x49, 0x30, 0x08, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x4f, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x50, 0x53, 0x56, 0x30, 0xc0, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
        0x04, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x41, 0x53, 0x48, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x3d, 0x9e, 0xa8,
        0x3d, 0x43, 0x9f, 0x42, 0x07, 0xbb, 0x05, 0xf3, 0x56, 0x69, 0x52, 0x14, 0x44, 0x58, 0x49, 0x4c, 0x7c, 0x06, 0x00, 0x00, 0x62, 0x00, 0x05, 0x00, 0x9f, 0x01, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c,
        0x02, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x64, 0x06, 0x00, 0x00, 0x42, 0x43, 0xc0, 0xde, 0x21, 0x0c, 0x00, 0x00, 0x96, 0x01, 0x00, 0x00, 0x0b, 0x82, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x13, 0x00, 0x00, 0x00, 0x07, 0x81, 0x23, 0x91, 0x41, 0xc8, 0x04, 0x49, 0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c, 0x25, 0x05, 0x08, 0x19, 0x1e, 0x04, 0x8b, 0x62, 0x80, 0x14, 0x45, 0x02,
        0x42, 0x92, 0x0b, 0x42, 0xa4, 0x10, 0x32, 0x14, 0x38, 0x08, 0x18, 0x4b, 0x0a, 0x32, 0x52, 0x88, 0x48, 0x90, 0x14, 0x20, 0x43, 0x46, 0x88, 0xa5, 0x00, 0x19, 0x32, 0x42, 0xe4, 0x48, 0x0e, 0x90,
        0x91, 0x22, 0xc4, 0x50, 0x41, 0x51, 0x81, 0x8c, 0xe1, 0x83, 0xe5, 0x8a, 0x04, 0x29, 0x46, 0x06, 0x51, 0x18, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1b, 0x8c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07,
        0x40, 0x02, 0xa8, 0x0d, 0x84, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x20, 0x6d, 0x30, 0x86, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x09, 0xa8, 0x00, 0x49, 0x18, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
        0x13, 0x82, 0x60, 0x42, 0x20, 0x4c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x89, 0x20, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x32, 0x22, 0x48, 0x09, 0x20, 0x64, 0x85, 0x04, 0x93, 0x22, 0xa4, 0x84,
        0x04, 0x93, 0x22, 0xe3, 0x84, 0xa1, 0x90, 0x14, 0x12, 0x4c, 0x8a, 0x8c, 0x0b, 0x84, 0xa4, 0x4c, 0x10, 0x58, 0x23, 0x00, 0x25, 0x00, 0x14, 0xe6, 0x08, 0xc0, 0xa0, 0x0c, 0x63, 0x0c, 0x22, 0x73,
        0x04, 0x08, 0x99, 0x7b, 0x86, 0xcb, 0x9f, 0xb0, 0x87, 0x90, 0xfc, 0x10, 0x68, 0x86, 0x85, 0x40, 0xc1, 0x29, 0x0b, 0x18, 0x68, 0x8c, 0x31, 0xc6, 0x30, 0x83, 0xd2, 0x4d, 0xc3, 0xe5, 0x4f, 0xd8,
        0x43, 0x48, 0xfe, 0x4a, 0x48, 0x2b, 0x31, 0xf9, 0xc8, 0x6d, 0xa3, 0x62, 0x8c, 0x31, 0x46, 0x39, 0xd6, 0x40, 0x63, 0x98, 0x41, 0x6c, 0x8e, 0x20, 0x28, 0x06, 0x1a, 0x66, 0x0c, 0x47, 0x6f, 0x20,
        0xe0, 0x34, 0x69, 0x8a, 0x28, 0x61, 0xf2, 0x57, 0x78, 0xc3, 0x26, 0x42, 0x1b, 0x86, 0x88, 0x90, 0xa4, 0x8d, 0x2a, 0x0a, 0x22, 0x42, 0xc1, 0x20, 0x39, 0x47, 0x00, 0x0a, 0x53, 0x00, 0x00, 0x00,
        0x13, 0x14, 0x72, 0xc0, 0x87, 0x74, 0x60, 0x87, 0x36, 0x68, 0x87, 0x79, 0x68, 0x03, 0x72, 0xc0, 0x87, 0x0d, 0xaf, 0x50, 0x0e, 0x6d, 0xd0, 0x0e, 0x7a, 0x50, 0x0e, 0x6d, 0x00, 0x0f, 0x7a, 0x30,
        0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x78, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0x60, 0x07, 0x7a,
        0x30, 0x07, 0x72, 0xd0, 0x06, 0xe9, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x76, 0x40, 0x07, 0x7a, 0x60, 0x07, 0x74, 0xd0, 0x06, 0xe6, 0x10, 0x07, 0x76, 0xa0, 0x07,
        0x73, 0x20, 0x07, 0x6d, 0x60, 0x0e, 0x73, 0x20, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe6, 0x60, 0x07, 0x74, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x6d, 0xe0, 0x0e, 0x78, 0xa0, 0x07, 0x71, 0x60,
        0x07, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x43, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x3c, 0x04, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x0c, 0x79, 0x12, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xf2, 0x30, 0x40, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xe4,
        0x79, 0x80, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x0b, 0x04, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x32, 0x1e, 0x98, 0x14, 0x19, 0x11, 0x4c, 0x90, 0x8c, 0x09, 0x26, 0x47,
        0xc6, 0x04, 0x43, 0x1a, 0x25, 0x50, 0x04, 0xc5, 0x30, 0x02, 0x50, 0x16, 0x65, 0x50, 0x08, 0xa5, 0x50, 0x80, 0x01, 0xe4, 0x46, 0x00, 0x88, 0x16, 0x08, 0xcd, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x79, 0x18, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x1a, 0x03, 0x4c, 0x90, 0x46, 0x02, 0x13, 0x44, 0x35, 0x18, 0x63, 0x0b, 0x73, 0x3b, 0x03, 0xb1, 0x2b, 0x93, 0x9b, 0x4b, 0x7b, 0x73, 0x03, 0x99,
        0x71, 0xb9, 0x01, 0x41, 0xa1, 0x0b, 0x3b, 0x9b, 0x7b, 0x91, 0x2a, 0x62, 0x2a, 0x0a, 0x9a, 0x2a, 0xfa, 0x9a, 0xb9, 0x81, 0x79, 0x31, 0x4b, 0x73, 0x0b, 0x63, 0x4b, 0xd9, 0x10, 0x04, 0x13, 0x84,
        0xa1, 0x98, 0x20, 0x0c, 0xc6, 0x06, 0x61, 0x20, 0x26, 0x08, 0xc3, 0xb1, 0x41, 0x18, 0x0c, 0x0a, 0x63, 0x73, 0x1b, 0x06, 0xc4, 0x20, 0x26, 0x08, 0x03, 0x32, 0x41, 0x98, 0x20, 0x02, 0x13, 0x84,
        0x21, 0x99, 0x20, 0x38, 0xce, 0x86, 0x45, 0x59, 0x18, 0x65, 0x18, 0x1a, 0xc7, 0x71, 0x80, 0x0d, 0xcb, 0xb0, 0x30, 0x0a, 0x31, 0x34, 0x8e, 0xe3, 0x00, 0x13, 0x84, 0x41, 0xd9, 0xb0, 0x10, 0x0b,
        0xa3, 0x44, 0x43, 0xe3, 0x38, 0x0e, 0x30, 0x41, 0x18, 0x96, 0x0d, 0x4b, 0xb4, 0x30, 0xca, 0x34, 0x34, 0x8e, 0xe3, 0x00, 0x13, 0x84, 0x81, 0xd9, 0xb0, 0x4c, 0x0b, 0xa3, 0x54, 0x43, 0xe3, 0x38,
        0x0e, 0xb0, 0xa1, 0x78, 0x20, 0x89, 0xb2, 0x36, 0x10, 0xc0, 0x05, 0x00, 0x13, 0x04, 0x01, 0x20, 0xd1, 0x16, 0x96, 0xe6, 0x36, 0x41, 0xa0, 0x9e, 0x09, 0xc2, 0xd0, 0x6c, 0x18, 0xb8, 0x61, 0xd8,
        0x40, 0x28, 0xdb, 0xd4, 0x6d, 0x28, 0x32, 0x0d, 0xc0, 0xbc, 0x2a, 0x6c, 0x6c, 0x76, 0x6d, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x53, 0x82, 0xa0, 0x0a, 0x19, 0x9e, 0x8b, 0x5d, 0x99, 0xdc, 0x5c,
        0xda, 0x9b, 0xdb, 0x94, 0x80, 0x68, 0x42, 0x86, 0xe7, 0x62, 0x17, 0xc6, 0x66, 0x57, 0x26, 0x37, 0x25, 0x30, 0xea, 0x90, 0xe1, 0xb9, 0xcc, 0xa1, 0x85, 0x91, 0x95, 0xc9, 0x35, 0xbd, 0x91, 0x95,
        0xb1, 0x4d, 0x09, 0x90, 0x32, 0x64, 0x78, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x53, 0x82, 0xab, 0x0e, 0x19, 0x9e, 0x4b, 0x99, 0x1b, 0x9d, 0x5c, 0x1e, 0xd4, 0x5b, 0x9a,
        0x1b, 0xdd, 0xdc, 0x94, 0xc0, 0x03, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c, 0xc4, 0xe1, 0x1c, 0x66, 0x14, 0x01, 0x3d, 0x88, 0x43, 0x38, 0x84, 0xc3,
        0x8c, 0x42, 0x80, 0x07, 0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6, 0x00, 0x0f, 0xed, 0x10, 0x0e, 0xf4, 0x80, 0x0e, 0x33, 0x0c, 0x42, 0x1e, 0xc2, 0xc1, 0x1d, 0xce, 0xa1, 0x1c, 0x66, 0x30,
        0x05, 0x3d, 0x88, 0x43, 0x38, 0x84, 0x83, 0x1b, 0xcc, 0x03, 0x3d, 0xc8, 0x43, 0x3d, 0x8c, 0x03, 0x3d, 0xcc, 0x78, 0x8c, 0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79, 0x48, 0x87, 0x70, 0x70, 0x07,
        0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20, 0x87, 0x19, 0xcc, 0x11, 0x0e, 0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e, 0x30, 0x0f, 0xe3, 0xf0, 0x0e, 0xf0, 0x50, 0x0e, 0x33, 0x10, 0xc4, 0x1d,
        0xde, 0x21, 0x1c, 0xd8, 0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89, 0x3b, 0xbc, 0x83, 0x3b, 0xd0, 0x43, 0x39, 0xb4, 0x03, 0x3c, 0xbc, 0x83, 0x3c, 0x84, 0x03, 0x3b, 0xcc, 0xf0, 0x14, 0x76,
        0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x68, 0x87, 0x72, 0x68, 0x07, 0x37, 0x80, 0x87, 0x70, 0x90, 0x87, 0x70, 0x60, 0x07, 0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76, 0x78, 0x87, 0x77, 0x80, 0x87,
        0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98, 0x87, 0x79, 0x98, 0x81, 0x2c, 0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5, 0xc0, 0x0e, 0xec, 0x30, 0x03, 0x62, 0xc8, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c,
        0xcc, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c, 0xc4, 0x81, 0x1d, 0xca, 0x61, 0x06, 0xd6, 0x90, 0x43, 0x39, 0xc8, 0x43, 0x39, 0x98, 0x43, 0x39, 0xc8, 0x43, 0x39, 0xb8,
        0xc3, 0x38, 0x94, 0x43, 0x38, 0x88, 0x03, 0x3b, 0x94, 0xc3, 0x2f, 0xbc, 0x83, 0x3c, 0xfc, 0x82, 0x3b, 0xd4, 0x03, 0x3b, 0xb0, 0xc3, 0x0c, 0xc4, 0x21, 0x07, 0x7c, 0x70, 0x03, 0x7a, 0x28, 0x87,
        0x76, 0x80, 0x87, 0x19, 0xd1, 0x43, 0x0e, 0xf8, 0xe0, 0x06, 0xe4, 0x20, 0x0e, 0xe7, 0xe0, 0x06, 0xf6, 0x10, 0x0e, 0xf2, 0xc0, 0x0e, 0xe1, 0x90, 0x0f, 0xef, 0x50, 0x0f, 0xf4, 0x30, 0x83, 0x81,
        0xc8, 0x01, 0x1f, 0xdc, 0x40, 0x1c, 0xe4, 0xa1, 0x1c, 0xc2, 0x61, 0x1d, 0xdc, 0x40, 0x1c, 0xe4, 0x01, 0x00, 0x00, 0x00, 0x71, 0x20, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x46, 0x20, 0x0d, 0x97,
        0xef, 0x3c, 0xbe, 0x10, 0x11, 0xc0, 0x44, 0x84, 0x40, 0x33, 0x2c, 0x84, 0x0d, 0x5c, 0xc3, 0xe5, 0x3b, 0x8f, 0x1f, 0x01, 0xd6, 0x46, 0x15, 0x05, 0x11, 0x95, 0x0e, 0x30, 0xf8, 0xc8, 0x6d, 0x9b,
        0x00, 0x36, 0x5c, 0xbe, 0xf3, 0xf8, 0x11, 0x60, 0x6d, 0x54, 0x51, 0x10, 0x11, 0x3b, 0x39, 0x11, 0xe1, 0x23, 0xb7, 0x6d, 0x01, 0xd2, 0x70, 0xf9, 0xce, 0xe3, 0x4f, 0x47, 0x44, 0x00, 0x83, 0x38,
        0xf8, 0xc8, 0x6d, 0x1b, 0x00, 0xc1, 0x00, 0x48, 0x03, 0x00, 0x00, 0x00, 0x61, 0x20, 0x00, 0x00, 0x56, 0x00, 0x00, 0x00, 0x13, 0x04, 0x49, 0x2c, 0x10, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x34, 0x66, 0x00, 0x4a, 0xae, 0xc0, 0xca, 0x52, 0xa0, 0x30, 0x05, 0x4a, 0x37, 0xa0, 0x30, 0x0a, 0x50, 0xa0, 0x00, 0x07, 0xc8, 0x94, 0x40, 0x19, 0x94, 0x43, 0x79, 0x00, 0x23, 0x06, 0x09, 0x00,
        0x82, 0x60, 0xf0, 0x68, 0x0c, 0x31, 0x49, 0xd0, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x3c, 0x5b, 0x53, 0x54, 0x54, 0x34, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x0f, 0xe7, 0x18, 0x9a, 0x25, 0x8d,
        0x18, 0x24, 0x00, 0x08, 0x82, 0xc1, 0xd3, 0x3d, 0x07, 0xb7, 0x4d, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0xf0, 0x78, 0x10, 0xa2, 0x75, 0xd4, 0x88, 0x81, 0x01, 0x80, 0x20, 0x18, 0x10, 0x62, 0xd0,
        0x6c, 0x15, 0x78, 0x37, 0xdc, 0x10, 0x48, 0x64, 0x30, 0xcb, 0x10, 0x08, 0xc1, 0x88, 0x81, 0x02, 0x80, 0x20, 0x18, 0x30, 0x63, 0x20, 0x15, 0x42, 0xc5, 0x6c, 0xa3, 0x09, 0x01, 0x30, 0x62, 0xe0,
        0x00, 0x20, 0x08, 0x06, 0x89, 0x19, 0x4c, 0x06, 0x71, 0x05, 0xd7, 0x75, 0x39, 0xdd, 0x2c, 0x81, 0x50, 0x85, 0x77, 0xc3, 0x0d, 0x81, 0x45, 0x06, 0xb3, 0x0c, 0x03, 0x11, 0x8c, 0x18, 0x28, 0x00,
        0x08, 0x82, 0x01, 0x73, 0x06, 0x96, 0x22, 0x64, 0xcf, 0x37, 0x9a, 0x10, 0x00, 0xa3, 0x09, 0x42, 0x50, 0x05, 0x18, 0xc0, 0x88, 0x81, 0x03, 0x80, 0x20, 0x18, 0x24, 0x6c, 0x90, 0x31, 0x41, 0x37,
        0x08, 0x5d, 0x37, 0x8d, 0xc1, 0x2c, 0x01, 0x51, 0xcb, 0x25, 0xc3, 0x0d, 0x01, 0x47, 0x06, 0xb3, 0x0c, 0x85, 0x11, 0x8c, 0x18, 0x28, 0x00, 0x08, 0x82, 0x01, 0xd3, 0x06, 0x5c, 0x24, 0x7c, 0x54,
        0x19, 0x8c, 0x26, 0x04, 0xc0, 0x68, 0x82, 0x10, 0x8c, 0x26, 0x0c, 0x42, 0x19, 0x1c, 0x8c, 0x18, 0x38, 0x00, 0x08, 0x82, 0x41, 0x32, 0x07, 0x60, 0x30, 0x05, 0x64, 0x40, 0x0c, 0x02, 0x19, 0x64,
        0x6a, 0x30, 0x4b, 0x60, 0x94, 0xa4, 0x06, 0x37, 0xdc, 0x10, 0x8c, 0x01, 0x19, 0xcc, 0x32, 0x1c, 0x48, 0x30, 0x62, 0xa0, 0x00, 0x20, 0x08, 0x06, 0x0c, 0x1d, 0x8c, 0x41, 0x26, 0x98, 0x81, 0xc6,
        0x06, 0xa3, 0x09, 0x01, 0x30, 0x9a, 0x20, 0x04, 0xa3, 0x09, 0x83, 0x30, 0x9a, 0x40, 0x0c, 0x75, 0x8c, 0x01, 0x8c, 0x18, 0x38, 0x00, 0x08, 0x82, 0x41, 0xb2, 0x07, 0x68, 0xb0, 0x05, 0x6c, 0x50,
        0x10, 0x83, 0x00, 0x06, 0x72, 0x30, 0x4b, 0x80, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    };

    static const BYTE cs_code_read_16bit_dxil[] =
    {
#if 0
    RWByteAddressBuffer Writeback : register(u1);

    RWByteAddressBuffer WriteShort1 : register(u6);
    RWByteAddressBuffer WriteShort2 : register(u7);
    RWByteAddressBuffer WriteShort3 : register(u8);
    RWByteAddressBuffer WriteShort4 : register(u9);

    [numthreads(64, 1, 1)]
    void main(uint thr : SV_DispatchThreadID)
    {
        if (2 * thr < 48)
            Writeback.Store<uint16_t>(4 * 64 + 2 * thr, WriteShort1.Load<uint16_t>(2 * thr));

        if (4 * thr < 48)
            Writeback.Store<uint16_t2>(5 * 64 + 4 * thr, WriteShort2.Load<uint16_t2>(4 * thr));

        if (6 * thr < 48)
            Writeback.Store<uint16_t3>(6 * 64 + 6 * thr, WriteShort3.Load<uint16_t3>(6 * thr));

        if (8 * thr < 48)
            Writeback.Store<uint16_t4>(7 * 64 + 8 * thr, WriteShort4.Load<uint16_t4>(8 * thr));
    }
#endif
        0x44, 0x58, 0x42, 0x43, 0xbf, 0x17, 0x94, 0xb9, 0x47, 0xff, 0x95, 0x04, 0x21, 0xfa, 0x62, 0x3b, 0x15, 0x06, 0xbc, 0xb4, 0x01, 0x00, 0x00, 0x00, 0xec, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0x38, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x30, 0x01, 0x00, 0x00, 0x4c, 0x01, 0x00, 0x00, 0x53, 0x46, 0x49, 0x30, 0x08, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x4f, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x50, 0x53, 0x56, 0x30, 0xc0, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
        0x08, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x41, 0x53, 0x48, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x37, 0x64, 0x27,
        0x3d, 0x42, 0x0c, 0x2b, 0x23, 0x22, 0xeb, 0xd9, 0x4c, 0x9e, 0x37, 0x92, 0x44, 0x58, 0x49, 0x4c, 0x98, 0x06, 0x00, 0x00, 0x62, 0x00, 0x05, 0x00, 0xa6, 0x01, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c,
        0x02, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x80, 0x06, 0x00, 0x00, 0x42, 0x43, 0xc0, 0xde, 0x21, 0x0c, 0x00, 0x00, 0x9d, 0x01, 0x00, 0x00, 0x0b, 0x82, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x13, 0x00, 0x00, 0x00, 0x07, 0x81, 0x23, 0x91, 0x41, 0xc8, 0x04, 0x49, 0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c, 0x25, 0x05, 0x08, 0x19, 0x1e, 0x04, 0x8b, 0x62, 0x80, 0x14, 0x45, 0x02,
        0x42, 0x92, 0x0b, 0x42, 0xa4, 0x10, 0x32, 0x14, 0x38, 0x08, 0x18, 0x4b, 0x0a, 0x32, 0x52, 0x88, 0x48, 0x90, 0x14, 0x20, 0x43, 0x46, 0x88, 0xa5, 0x00, 0x19, 0x32, 0x42, 0xe4, 0x48, 0x0e, 0x90,
        0x91, 0x22, 0xc4, 0x50, 0x41, 0x51, 0x81, 0x8c, 0xe1, 0x83, 0xe5, 0x8a, 0x04, 0x29, 0x46, 0x06, 0x51, 0x18, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1b, 0x8c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07,
        0x40, 0x02, 0xa8, 0x0d, 0x84, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x20, 0x6d, 0x30, 0x86, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x09, 0xa8, 0x00, 0x49, 0x18, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
        0x13, 0x82, 0x60, 0x42, 0x20, 0x4c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x89, 0x20, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x32, 0x22, 0x48, 0x09, 0x20, 0x64, 0x85, 0x04, 0x93, 0x22, 0xa4, 0x84,
        0x04, 0x93, 0x22, 0xe3, 0x84, 0xa1, 0x90, 0x14, 0x12, 0x4c, 0x8a, 0x8c, 0x0b, 0x84, 0xa4, 0x4c, 0x10, 0x5c, 0x23, 0x00, 0x25, 0x00, 0x14, 0xe6, 0x08, 0xc0, 0xa0, 0x0c, 0x63, 0x0c, 0x22, 0x73,
        0x04, 0x08, 0x99, 0x7b, 0x86, 0xcb, 0x9f, 0xb0, 0x87, 0x90, 0xfc, 0x10, 0x68, 0x86, 0x85, 0x40, 0xc1, 0x99, 0x23, 0x80, 0xca, 0x02, 0x06, 0x1a, 0x23, 0xa5, 0x94, 0xcc, 0x20, 0x75, 0xd3, 0x70,
        0xf9, 0x13, 0xf6, 0x10, 0x92, 0xbf, 0x12, 0xd2, 0x4a, 0x4c, 0x3e, 0x52, 0xeb, 0xa8, 0x48, 0x29, 0xa5, 0x51, 0x0e, 0x36, 0xd0, 0x18, 0x66, 0x50, 0x9b, 0x23, 0x08, 0x8a, 0x81, 0x86, 0x19, 0xe3,
        0x11, 0x1c, 0x08, 0x38, 0x4d, 0x9a, 0x22, 0x4a, 0x98, 0xfc, 0x15, 0xde, 0xb0, 0x89, 0xd0, 0x86, 0x21, 0x22, 0x24, 0x69, 0xa3, 0x8a, 0x82, 0x88, 0x50, 0x30, 0x68, 0xce, 0x11, 0x80, 0xc2, 0x14,
        0x00, 0x00, 0x00, 0x00, 0x13, 0x14, 0x72, 0xc0, 0x87, 0x74, 0x60, 0x87, 0x36, 0x68, 0x87, 0x79, 0x68, 0x03, 0x72, 0xc0, 0x87, 0x0d, 0xae, 0x50, 0x0e, 0x6d, 0xd0, 0x0e, 0x7a, 0x50, 0x0e, 0x6d,
        0x00, 0x0f, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x78, 0xa0, 0x07, 0x78, 0xd0, 0x06, 0xe9, 0x10, 0x07,
        0x76, 0xa0, 0x07, 0x71, 0x60, 0x07, 0x6d, 0x90, 0x0e, 0x73, 0x20, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe9, 0x60, 0x07, 0x74, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x6d, 0x60, 0x0e, 0x71, 0x60,
        0x07, 0x7a, 0x10, 0x07, 0x76, 0xd0, 0x06, 0xe6, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x60, 0x0e, 0x76, 0x40, 0x07, 0x7a, 0x60, 0x07, 0x74, 0xd0, 0x06, 0xee, 0x80, 0x07, 0x7a,
        0x10, 0x07, 0x76, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x7a, 0x60, 0x07, 0x74, 0x30, 0xe4, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xc8, 0x43, 0x00, 0x01, 0x10, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x90, 0x47, 0x01, 0x02, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x21, 0x4f, 0x03, 0x04, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x43, 0x1e, 0x08, 0x08, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x32, 0x1e, 0x98, 0x14, 0x19, 0x11, 0x4c, 0x90, 0x8c, 0x09, 0x26, 0x47,
        0xc6, 0x04, 0x43, 0x1a, 0x25, 0x50, 0x04, 0xc5, 0x30, 0x02, 0x50, 0x16, 0xe5, 0x50, 0x06, 0x05, 0x51, 0x08, 0x25, 0x51, 0x80, 0x01, 0xf4, 0x46, 0x00, 0xa8, 0x16, 0x38, 0x20, 0x20, 0x02, 0xd1,
        0x19, 0x00, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x4a, 0x00, 0x00, 0x00, 0x1a, 0x03, 0x4c, 0x90, 0x46, 0x02, 0x13, 0x44, 0x35, 0x18, 0x63, 0x0b, 0x73, 0x3b, 0x03, 0xb1, 0x2b, 0x93, 0x9b, 0x4b,
        0x7b, 0x73, 0x03, 0x99, 0x71, 0xb9, 0x01, 0x41, 0xa1, 0x0b, 0x3b, 0x9b, 0x7b, 0x91, 0x2a, 0x62, 0x2a, 0x0a, 0x9a, 0x2a, 0xfa, 0x9a, 0xb9, 0x81, 0x79, 0x31, 0x4b, 0x73, 0x0b, 0x63, 0x4b, 0xd9,
        0x10, 0x04, 0x13, 0x84, 0xa1, 0x98, 0x20, 0x0c, 0xc6, 0x06, 0x61, 0x20, 0x26, 0x08, 0xc3, 0xb1, 0x41, 0x18, 0x0c, 0x0a, 0x63, 0x73, 0x1b, 0x06, 0xc4, 0x20, 0x26, 0x08, 0x03, 0x32, 0x41, 0xa0,
        0x24, 0x02, 0x13, 0x84, 0x21, 0x99, 0x20, 0x3c, 0xd0, 0x86, 0x45, 0x59, 0x18, 0x65, 0x18, 0x1a, 0xc7, 0x71, 0x80, 0x0d, 0xcb, 0xb0, 0x30, 0x8a, 0x31, 0x34, 0x8e, 0xe3, 0x00, 0x13, 0x84, 0x41,
        0xd9, 0xb0, 0x10, 0x0b, 0xa3, 0x44, 0x43, 0xe3, 0x38, 0x0e, 0x30, 0x41, 0x18, 0x96, 0x09, 0xc2, 0xc0, 0x6c, 0x58, 0xa6, 0x85, 0x51, 0xa8, 0xa1, 0x71, 0x1c, 0x07, 0x98, 0x20, 0x0c, 0xcd, 0x04,
        0x61, 0x70, 0x36, 0x2c, 0xd6, 0xc2, 0x28, 0xd7, 0xd0, 0x38, 0x8e, 0x03, 0x6c, 0x28, 0x1e, 0x48, 0xaa, 0xb0, 0x0d, 0x04, 0x90, 0x01, 0xc0, 0x04, 0x41, 0x00, 0x48, 0xb4, 0x85, 0xa5, 0xb9, 0x4d,
        0x10, 0xaa, 0x68, 0x82, 0x30, 0x3c, 0x1b, 0x06, 0x6f, 0x18, 0x36, 0x10, 0x4a, 0x67, 0x7d, 0x1b, 0x8a, 0x8d, 0x03, 0x34, 0x30, 0xa8, 0xc2, 0xc6, 0x66, 0xd7, 0xe6, 0x92, 0x46, 0x56, 0xe6, 0x46,
        0x37, 0x25, 0x08, 0xaa, 0x90, 0xe1, 0xb9, 0xd8, 0x95, 0xc9, 0xcd, 0xa5, 0xbd, 0xb9, 0x4d, 0x09, 0x88, 0x26, 0x64, 0x78, 0x2e, 0x76, 0x61, 0x6c, 0x76, 0x65, 0x72, 0x53, 0x02, 0xa3, 0x0e, 0x19,
        0x9e, 0xcb, 0x1c, 0x5a, 0x18, 0x59, 0x99, 0x5c, 0xd3, 0x1b, 0x59, 0x19, 0xdb, 0x94, 0x00, 0x29, 0x43, 0x86, 0xe7, 0x22, 0x57, 0x36, 0xf7, 0x56, 0x27, 0x37, 0x56, 0x36, 0x37, 0x25, 0xc8, 0xea,
        0x90, 0xe1, 0xb9, 0x94, 0xb9, 0xd1, 0xc9, 0xe5, 0x41, 0xbd, 0xa5, 0xb9, 0xd1, 0xcd, 0x4d, 0x09, 0xc0, 0x00, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c,
        0xc4, 0xe1, 0x1c, 0x66, 0x14, 0x01, 0x3d, 0x88, 0x43, 0x38, 0x84, 0xc3, 0x8c, 0x42, 0x80, 0x07, 0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6, 0x00, 0x0f, 0xed, 0x10, 0x0e, 0xf4, 0x80, 0x0e,
        0x33, 0x0c, 0x42, 0x1e, 0xc2, 0xc1, 0x1d, 0xce, 0xa1, 0x1c, 0x66, 0x30, 0x05, 0x3d, 0x88, 0x43, 0x38, 0x84, 0x83, 0x1b, 0xcc, 0x03, 0x3d, 0xc8, 0x43, 0x3d, 0x8c, 0x03, 0x3d, 0xcc, 0x78, 0x8c,
        0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79, 0x48, 0x87, 0x70, 0x70, 0x07, 0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20, 0x87, 0x19, 0xcc, 0x11, 0x0e, 0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e,
        0x30, 0x0f, 0xe3, 0xf0, 0x0e, 0xf0, 0x50, 0x0e, 0x33, 0x10, 0xc4, 0x1d, 0xde, 0x21, 0x1c, 0xd8, 0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89, 0x3b, 0xbc, 0x83, 0x3b, 0xd0, 0x43, 0x39, 0xb4,
        0x03, 0x3c, 0xbc, 0x83, 0x3c, 0x84, 0x03, 0x3b, 0xcc, 0xf0, 0x14, 0x76, 0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x68, 0x87, 0x72, 0x68, 0x07, 0x37, 0x80, 0x87, 0x70, 0x90, 0x87, 0x70, 0x60, 0x07,
        0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76, 0x78, 0x87, 0x77, 0x80, 0x87, 0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98, 0x87, 0x79, 0x98, 0x81, 0x2c, 0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5,
        0xc0, 0x0e, 0xec, 0x30, 0x03, 0x62, 0xc8, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xcc, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c, 0xc4, 0x81, 0x1d, 0xca, 0x61, 0x06, 0xd6, 0x90,
        0x43, 0x39, 0xc8, 0x43, 0x39, 0x98, 0x43, 0x39, 0xc8, 0x43, 0x39, 0xb8, 0xc3, 0x38, 0x94, 0x43, 0x38, 0x88, 0x03, 0x3b, 0x94, 0xc3, 0x2f, 0xbc, 0x83, 0x3c, 0xfc, 0x82, 0x3b, 0xd4, 0x03, 0x3b,
        0xb0, 0xc3, 0x0c, 0xc4, 0x21, 0x07, 0x7c, 0x70, 0x03, 0x7a, 0x28, 0x87, 0x76, 0x80, 0x87, 0x19, 0xd1, 0x43, 0x0e, 0xf8, 0xe0, 0x06, 0xe4, 0x20, 0x0e, 0xe7, 0xe0, 0x06, 0xf6, 0x10, 0x0e, 0xf2,
        0xc0, 0x0e, 0xe1, 0x90, 0x0f, 0xef, 0x50, 0x0f, 0xf4, 0x30, 0x83, 0x81, 0xc8, 0x01, 0x1f, 0xdc, 0x40, 0x1c, 0xe4, 0xa1, 0x1c, 0xc2, 0x61, 0x1d, 0xdc, 0x40, 0x1c, 0xe4, 0x01, 0x00, 0x00, 0x00,
        0x71, 0x20, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x46, 0x20, 0x0d, 0x97, 0xef, 0x3c, 0xbe, 0x10, 0x11, 0xc0, 0x44, 0x84, 0x40, 0x33, 0x2c, 0x84, 0x0d, 0x5c, 0xc3, 0xe5, 0x3b, 0x8f, 0x1f, 0x01,
        0xd6, 0x46, 0x15, 0x05, 0x11, 0x95, 0x0e, 0x30, 0xf8, 0x48, 0xad, 0x9b, 0x00, 0x36, 0x5c, 0xbe, 0xf3, 0xf8, 0x11, 0x60, 0x6d, 0x54, 0x51, 0x10, 0x11, 0x3b, 0x39, 0x11, 0xe1, 0x23, 0xb5, 0x6e,
        0x01, 0xd2, 0x70, 0xf9, 0xce, 0xe3, 0x4f, 0x47, 0x44, 0x00, 0x83, 0x38, 0xf8, 0xc8, 0x6d, 0x1b, 0x00, 0xc1, 0x00, 0x48, 0x03, 0x00, 0x00, 0x00, 0x61, 0x20, 0x00, 0x00, 0x5a, 0x00, 0x00, 0x00,
        0x13, 0x04, 0x49, 0x2c, 0x10, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x34, 0x66, 0x00, 0x4a, 0xae, 0xc0, 0xca, 0x52, 0xa0, 0x30, 0x05, 0x4a, 0x37, 0xa0, 0x00, 0x09, 0x0a, 0xb0, 0xa0, 0x00,
        0x0d, 0x0a, 0xf0, 0x80, 0x4c, 0x09, 0x94, 0x41, 0x39, 0x94, 0x07, 0xa5, 0x19, 0x00, 0x00, 0x00, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x00, 0x79, 0x4e, 0x51, 0x51, 0xd2, 0x88, 0x41, 0x02, 0x80,
        0x20, 0x18, 0x40, 0xdf, 0x63, 0x60, 0xd7, 0x34, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x10, 0x18, 0x40, 0x87, 0xa7, 0x51, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x00, 0x85, 0x41, 0x84, 0x80, 0x81,
        0x57, 0x8d, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x24, 0x06, 0x52, 0xe2, 0x85, 0x81, 0x35, 0x62, 0x60, 0x00, 0x20, 0x08, 0x06, 0x84, 0x19, 0x3c, 0x5f, 0x05, 0x63, 0x70, 0xc3, 0x0d, 0x01, 0x45,
        0x06, 0xb3, 0x0c, 0x81, 0x10, 0x8c, 0x18, 0x28, 0x00, 0x08, 0x82, 0x41, 0x73, 0x06, 0x54, 0x21, 0x5c, 0x0d, 0x19, 0x8c, 0x26, 0x04, 0x40, 0x11, 0x13, 0x8c, 0x18, 0x38, 0x00, 0x08, 0x82, 0x81,
        0xb2, 0x06, 0xd6, 0x11, 0x68, 0x02, 0xc3, 0x30, 0xd0, 0x19, 0xcc, 0x12, 0x08, 0x65, 0x9c, 0xc1, 0x0d, 0x37, 0x04, 0x19, 0x19, 0xcc, 0x32, 0x0c, 0x44, 0x30, 0x62, 0xa0, 0x00, 0x20, 0x08, 0x06,
        0x0d, 0x1b, 0x64, 0x8b, 0xc0, 0x45, 0x69, 0x30, 0x9a, 0x10, 0x00, 0xa3, 0x09, 0x42, 0x50, 0x05, 0x06, 0x23, 0x06, 0x0e, 0x00, 0x82, 0x60, 0xa0, 0xc4, 0x01, 0xd7, 0x04, 0x60, 0x30, 0x08, 0x92,
        0x54, 0xb5, 0xc1, 0x2c, 0x01, 0x51, 0x0c, 0x1b, 0xc8, 0x70, 0x43, 0xf0, 0x91, 0xc1, 0x2c, 0x43, 0x61, 0x04, 0x23, 0x06, 0x0a, 0x00, 0x82, 0x60, 0xd0, 0xc8, 0xc1, 0x27, 0x09, 0x62, 0x60, 0xbd,
        0xc1, 0x68, 0x42, 0x00, 0x8c, 0x26, 0x08, 0xc1, 0x68, 0xc2, 0x20, 0x94, 0xe1, 0xc1, 0x88, 0x81, 0x03, 0x80, 0x20, 0x18, 0x28, 0x78, 0x30, 0x06, 0x54, 0x70, 0x06, 0xc4, 0x20, 0x64, 0x1b, 0x1d,
        0xcc, 0x12, 0x18, 0x35, 0xbd, 0xc1, 0x0d, 0x37, 0x04, 0x66, 0x40, 0x06, 0xb3, 0x0c, 0x07, 0x12, 0x8c, 0x18, 0x28, 0x00, 0x08, 0x82, 0x41, 0x93, 0x07, 0x66, 0xa0, 0x09, 0x69, 0xc0, 0xd9, 0xc1,
        0x68, 0x42, 0x00, 0x8c, 0x26, 0x08, 0xc1, 0x68, 0xc2, 0x20, 0x8c, 0x26, 0x10, 0x43, 0x1d, 0x65, 0x00, 0x23, 0x06, 0x0e, 0x00, 0x82, 0x60, 0xa0, 0x80, 0xc2, 0x1a, 0x70, 0xc1, 0x1b, 0x14, 0xc4,
        0x20, 0x88, 0x01, 0x1f, 0xcc, 0x12, 0x20, 0x08, 0x00, 0x00, 0x00, 0x00,
    };

    if (!init_compute_test_context(&context))
        return;

    shader_model.HighestShaderModel = D3D_SHADER_MODEL_6_2;
    hr = ID3D12Device_CheckFeatureSupport(context.device, D3D12_FEATURE_SHADER_MODEL, &shader_model, sizeof(shader_model));
    if (FAILED(hr) || shader_model.HighestShaderModel < D3D_SHADER_MODEL_6_2)
    {
        skip("Shader model 6.2 not supported.\n");
        destroy_test_context(&context);
        return;
    }

    memset(&options4, 0, sizeof(options4));
    hr = ID3D12Device_CheckFeatureSupport(context.device, D3D12_FEATURE_D3D12_OPTIONS4, &options4, sizeof(options4));
    if (FAILED(hr))
        options4.Native16BitShaderOpsSupported = FALSE;

    if (!options4.Native16BitShaderOpsSupported)
        skip("Skipping 16-bit robustness tests.\n");

    command_list = context.list;
    queue = context.queue;

    root_signature_desc.NumParameters = 1;
    root_signature_desc.Flags = 0;
    root_signature_desc.NumStaticSamplers = 0;
    root_signature_desc.pStaticSamplers = NULL;
    root_signature_desc.pParameters = root_parameters;

    root_parameters[0].ParameterType = D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE;
    root_parameters[0].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
    root_parameters[0].DescriptorTable.NumDescriptorRanges = 1;
    root_parameters[0].DescriptorTable.pDescriptorRanges = descriptor_ranges;

    descriptor_ranges[0].RegisterSpace = 0;
    descriptor_ranges[0].BaseShaderRegister = 0;
    descriptor_ranges[0].OffsetInDescriptorsFromTableStart = 0;
    descriptor_ranges[0].NumDescriptors = UINT_MAX;
    descriptor_ranges[0].RangeType = D3D12_DESCRIPTOR_RANGE_TYPE_UAV;

    hr = create_root_signature(context.device, &root_signature_desc, &context.root_signature);
    ok(SUCCEEDED(hr), "Failed to create root signature, hr %#x.\n", hr);
    output_buffer = create_default_buffer(context.device, 8 * 16 * sizeof(uint32_t),
            D3D12_RESOURCE_FLAG_ALLOW_UNORDERED_ACCESS,
            D3D12_RESOURCE_STATE_UNORDERED_ACCESS);

    read_output_buffer = create_default_buffer(context.device, 8 * 16 * sizeof(uint32_t),
            D3D12_RESOURCE_FLAG_ALLOW_UNORDERED_ACCESS,
            D3D12_RESOURCE_STATE_UNORDERED_ACCESS);

    write_pso_32bit = create_compute_pipeline_state(context.device,
            context.root_signature,
            shader_bytecode(cs_code_write_32bit_dxil, sizeof(cs_code_write_32bit_dxil)));

    if (options4.Native16BitShaderOpsSupported)
    {
        write_pso_16bit = create_compute_pipeline_state(context.device,
                 context.root_signature,
                 shader_bytecode(cs_code_write_16bit_dxil, sizeof(cs_code_write_16bit_dxil)));
    }
    else
        write_pso_16bit = NULL;

    read_pso_32bit = create_compute_pipeline_state(context.device,
            context.root_signature,
            shader_bytecode(cs_code_read_32bit_dxil, sizeof(cs_code_read_32bit_dxil)));

    if (options4.Native16BitShaderOpsSupported)
    {
        read_pso_16bit = create_compute_pipeline_state(context.device,
                context.root_signature,
                shader_bytecode(cs_code_read_16bit_dxil, sizeof(cs_code_read_16bit_dxil)));
    }
    else
        read_pso_16bit = NULL;

    gpu_heap = create_gpu_descriptor_heap(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV, 8 + 2);
    cpu_heap = create_cpu_descriptor_heap(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV, 8 + 2);
    cpu_handle = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(cpu_heap);
    gpu_handle = ID3D12DescriptorHeap_GetGPUDescriptorHandleForHeapStart(gpu_heap);
    descriptor_size = ID3D12Device_GetDescriptorHandleIncrementSize(context.device,
              D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV);

    {
        D3D12_UNORDERED_ACCESS_VIEW_DESC view;
        D3D12_CPU_DESCRIPTOR_HANDLE h = cpu_handle;
        view.Format = DXGI_FORMAT_R32_TYPELESS;
        view.ViewDimension = D3D12_UAV_DIMENSION_BUFFER;
        view.Buffer.FirstElement = 0;
        view.Buffer.NumElements = 16 * 8;
        view.Buffer.StructureByteStride = 0;
        view.Buffer.CounterOffsetInBytes = 0;
        view.Buffer.Flags = D3D12_BUFFER_UAV_FLAG_RAW;
        ID3D12Device_CreateUnorderedAccessView(context.device, output_buffer, NULL, &view, h);
        h.ptr += descriptor_size;
        ID3D12Device_CreateUnorderedAccessView(context.device, read_output_buffer, NULL, &view, h);
    }

    for (i = 0; i < 8; i++)
    {
        D3D12_UNORDERED_ACCESS_VIEW_DESC view;
        D3D12_CPU_DESCRIPTOR_HANDLE h = cpu_handle;
        view.Format = DXGI_FORMAT_R32_TYPELESS;
        view.ViewDimension = D3D12_UAV_DIMENSION_BUFFER;
        view.Buffer.FirstElement = 16 * i;
        view.Buffer.NumElements = 8;
        view.Buffer.StructureByteStride = 0;
        view.Buffer.CounterOffsetInBytes = 0;
        view.Buffer.Flags = D3D12_BUFFER_UAV_FLAG_RAW;
        h.ptr += (2 + i) * descriptor_size;
        ID3D12Device_CreateUnorderedAccessView(context.device, output_buffer, NULL, &view, h);
    }

    ID3D12Device_CopyDescriptorsSimple(context.device, 8 + 2,
            ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(gpu_heap),
            ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(cpu_heap),
            D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV);

    ID3D12GraphicsCommandList_SetDescriptorHeaps(command_list, 1, &gpu_heap);
    {
        const UINT clear_value[4] = { 0xaaaaaaaau, 0xaaaaaaaau, 0xaaaaaaaau, 0xaaaaaaaau };
        ID3D12GraphicsCommandList_ClearUnorderedAccessViewUint(command_list,
                gpu_handle, cpu_handle, output_buffer,
                clear_value, 0, NULL);
        uav_barrier(command_list, output_buffer);
    }

    ID3D12GraphicsCommandList_SetComputeRootSignature(command_list, context.root_signature);
    ID3D12GraphicsCommandList_SetComputeRootDescriptorTable(command_list, 0, gpu_handle);

    ID3D12GraphicsCommandList_SetPipelineState(command_list, write_pso_32bit);
    ID3D12GraphicsCommandList_Dispatch(command_list, 1, 1, 1);
    if (write_pso_16bit)
    {
        ID3D12GraphicsCommandList_SetPipelineState(command_list, write_pso_16bit);
        ID3D12GraphicsCommandList_Dispatch(command_list, 1, 1, 1);
    }

    uav_barrier(command_list, output_buffer);
    ID3D12GraphicsCommandList_SetPipelineState(command_list, read_pso_32bit);
    ID3D12GraphicsCommandList_Dispatch(command_list, 1, 1, 1);
    if (read_pso_16bit)
    {
        ID3D12GraphicsCommandList_SetPipelineState(command_list, read_pso_16bit);
        ID3D12GraphicsCommandList_Dispatch(command_list, 1, 1, 1);
    }

    transition_resource_state(command_list, output_buffer,
            D3D12_RESOURCE_STATE_UNORDERED_ACCESS,
            D3D12_RESOURCE_STATE_COPY_SOURCE);
    get_buffer_readback_with_command_list(output_buffer, DXGI_FORMAT_UNKNOWN, &rb, queue, command_list);

    for (i = 0; i < 4; i++)
    {
        uint32_t value, expected;
        for (j = 0; j < 16; j++)
        {
            value = get_readback_uint(&rb, 16 * i + j, 0, 0);
            expected = j < 8 ? j : 0xaaaaaaaau;
            ok(value == expected, "32-bit value %u, %u: #%x != #%x.\n", i, j, value, expected);
        }
    }

    for (i = 4; i < 8; i++)
    {
        uint16_t value, expected;
        for (j = 0; j < 32; j++)
        {
            value = get_readback_uint16(&rb, 32 * i + j, 0);
            expected = options4.Native16BitShaderOpsSupported && j < 16 ? j : 0xaaaau;
            ok(value == expected, "16-bit value %u, %u: #%x != #%x.\n", i, j, value, expected);
        }
    }

    release_resource_readback(&rb);

    reset_command_list(command_list, context.allocator);
    transition_resource_state(command_list, read_output_buffer,
            D3D12_RESOURCE_STATE_UNORDERED_ACCESS,
            D3D12_RESOURCE_STATE_COPY_SOURCE);
    get_buffer_readback_with_command_list(read_output_buffer, DXGI_FORMAT_UNKNOWN, &rb, queue, command_list);

    for (i = 0; i < 4; i++)
    {
        uint32_t value, expected;
        for (j = 0; j < 16; j++)
        {
            value = get_readback_uint(&rb, 16 * i + j, 0, 0);
            expected = j < 8 ? j : 0;
            ok(value == expected, "32-bit value %u, %u: #%x != #%x.\n", i, j, value, expected);
        }
    }

    for (i = 4; i < 8; i++)
    {
        uint16_t value, expected;
        for (j = 0; j < 32; j++)
        {
            value = get_readback_uint16(&rb, 32 * i + j, 0);
            expected = options4.Native16BitShaderOpsSupported && j < 16 ? j : 0;
            ok(value == expected, "16-bit value %u, %u: #%x != #%x.\n", i, j, value, expected);
        }
    }

    release_resource_readback(&rb);
    ID3D12DescriptorHeap_Release(gpu_heap);
    ID3D12DescriptorHeap_Release(cpu_heap);
    ID3D12Resource_Release(output_buffer);
    ID3D12Resource_Release(read_output_buffer);
    ID3D12PipelineState_Release(write_pso_32bit);
    if (write_pso_16bit)
        ID3D12PipelineState_Release(write_pso_16bit);
    ID3D12PipelineState_Release(read_pso_32bit);
    if (read_pso_16bit)
        ID3D12PipelineState_Release(read_pso_16bit);
    destroy_test_context(&context);
}

static void test_buffers_oob_behavior(bool use_dxil)
{
    ID3D12DescriptorHeap *heap, *aux_cpu_heap, *aux_gpu_heap;
    const unsigned int chunk_size = 4 * 8 * 12 * 16;
    D3D12_ROOT_SIGNATURE_DESC root_signature_desc;
    D3D12_DESCRIPTOR_RANGE descriptor_ranges[1];
    D3D12_ROOT_PARAMETER root_parameters[1];

    ID3D12Resource *output_buffer;
    struct resource_readback rb;

    const unsigned int chunk_size_words = chunk_size / 4;
    unsigned int i, j, word_index, descriptor_size;
    ID3D12GraphicsCommandList *command_list;
    D3D12_CPU_DESCRIPTOR_HANDLE cpu_handle;
    D3D12_GPU_DESCRIPTOR_HANDLE gpu_handle;
    struct test_context context;
    ID3D12CommandQueue *queue;
    HRESULT hr;

#if 0
    RWStructuredBuffer<uint> RWUint1[4] : register(u0);
    RWStructuredBuffer<uint2> RWUint2[4] : register(u4);
    RWStructuredBuffer<uint3> RWUint3[4] : register(u8);
    RWStructuredBuffer<uint4> RWUint4[4] : register(u12);

    RWByteAddressBuffer BAB[16] : register(u16);

    [numthreads(1, 1, 1)]
    void main(uint idx : SV_DispatchThreadID)
    {
        if (idx == 0)
        {
            for (int j = 0; j < 4; j++)
                for (int i = 0; i < 4; i++)
                    RWUint1[j][i] = i;

            for (int j = 0; j < 4; j++)
                for (int i = 0; i < 4; i++)
                    RWUint2[j][i] = 2 * i + uint2(0, 1);

            for (int j = 0; j < 4; j++)
                for (int i = 0; i < 4; i++)
                    RWUint3[j][i] = 3 * i + uint3(0, 1, 2);

            for (int j = 0; j < 4; j++)
                for (int i = 0; i < 4; i++)
                    RWUint4[j][i] = 4 * i + uint4(0, 1, 2, 3);

            for (int j = 0; j < 4; j++)
                for (int i = 0; i < 4; i++)
                    BAB[4 * 0 + j].Store(4 * i + 4 * j, 4 * j + i);

            for (int j = 0; j < 4; j++)
                for (int i = 0; i < 4; i++)
                    BAB[4 * 1 + j].Store2(4 * i + 4 * j, 2 * (4 * j + i) + uint2(0, 1));

            for (int j = 0; j < 4; j++)
                for (int i = 0; i < 4; i++)
                    BAB[4 * 2 + j].Store3(4 * i + 4 * j, 3 * (4 * j + i) + uint3(0, 1, 2));

            for (int j = 0; j < 4; j++)
                for (int i = 0; i < 4; i++)
                    BAB[4 * 3 + j].Store4(4 * i + 4 * j, 4 * (4 * j + i) + uint4(0, 1, 2, 3));
        }
    }
#endif
    static const DWORD cs_code_dxbc[] =
    {
        0x43425844, 0x98dce5fe, 0x48936653, 0x4604b648, 0xb8cfb81c, 0x00000001, 0x00000bf8, 0x00000003,
        0x0000002c, 0x0000003c, 0x0000004c, 0x4e475349, 0x00000008, 0x00000000, 0x00000008, 0x4e47534f,
        0x00000008, 0x00000000, 0x00000008, 0x58454853, 0x00000ba4, 0x00050051, 0x000002e9, 0x0100086a,
        0x0700009e, 0x0031ee46, 0x00000000, 0x00000000, 0x00000003, 0x00000004, 0x00000000, 0x0700009e,
        0x0031ee46, 0x00000001, 0x00000004, 0x00000007, 0x00000008, 0x00000000, 0x0700009e, 0x0031ee46,
        0x00000002, 0x00000008, 0x0000000b, 0x0000000c, 0x00000000, 0x0700009e, 0x0031ee46, 0x00000003,
        0x0000000c, 0x0000000f, 0x00000010, 0x00000000, 0x0600009d, 0x0031ee46, 0x00000004, 0x00000010,
        0x0000001f, 0x00000000, 0x0200005f, 0x00020012, 0x02000068, 0x00000003, 0x0400009b, 0x00000001,
        0x00000001, 0x00000001, 0x0200001f, 0x0002000a, 0x05000036, 0x00100012, 0x00000000, 0x00004001,
        0x00000000, 0x01000030, 0x07000021, 0x00100022, 0x00000000, 0x0010000a, 0x00000000, 0x00004001,
        0x00000004, 0x03040003, 0x0010001a, 0x00000000, 0x05000036, 0x00100022, 0x00000000, 0x00004001,
        0x00000000, 0x01000030, 0x07000021, 0x00100042, 0x00000000, 0x0010001a, 0x00000000, 0x00004001,
        0x00000004, 0x03040003, 0x0010002a, 0x00000000, 0x0b0000a8, 0x0421e012, 0x00000000, 0x0010000a,
        0x00000000, 0x0010001a, 0x00000000, 0x00004001, 0x00000000, 0x0010001a, 0x00000000, 0x0700001e,
        0x00100022, 0x00000000, 0x0010001a, 0x00000000, 0x00004001, 0x00000001, 0x01000016, 0x0700001e,
        0x00100012, 0x00000000, 0x0010000a, 0x00000000, 0x00004001, 0x00000001, 0x01000016, 0x05000036,
        0x00100012, 0x00000000, 0x00004001, 0x00000000, 0x01000030, 0x07000021, 0x00100022, 0x00000000,
        0x0010000a, 0x00000000, 0x00004001, 0x00000004, 0x03040003, 0x0010001a, 0x00000000, 0x05000036,
        0x00100022, 0x00000000, 0x00004001, 0x00000000, 0x01000030, 0x07000021, 0x00100042, 0x00000000,
        0x0010001a, 0x00000000, 0x00004001, 0x00000004, 0x03040003, 0x0010002a, 0x00000000, 0x0f000023,
        0x001000c2, 0x00000000, 0x00100556, 0x00000000, 0x00004002, 0x00000000, 0x00000000, 0x00000002,
        0x00000002, 0x00004002, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x0c0000a8, 0x0621e032,
        0x00000001, 0x00000004, 0x0010000a, 0x00000000, 0x0010001a, 0x00000000, 0x00004001, 0x00000000,
        0x00100ae6, 0x00000000, 0x0700001e, 0x00100022, 0x00000000, 0x0010001a, 0x00000000, 0x00004001,
        0x00000001, 0x01000016, 0x0700001e, 0x00100012, 0x00000000, 0x0010000a, 0x00000000, 0x00004001,
        0x00000001, 0x01000016, 0x05000036, 0x00100012, 0x00000000, 0x00004001, 0x00000000, 0x01000030,
        0x07000021, 0x00100022, 0x00000000, 0x0010000a, 0x00000000, 0x00004001, 0x00000004, 0x03040003,
        0x0010001a, 0x00000000, 0x05000036, 0x00100022, 0x00000000, 0x00004001, 0x00000000, 0x01000030,
        0x07000021, 0x00100042, 0x00000000, 0x0010001a, 0x00000000, 0x00004001, 0x00000004, 0x03040003,
        0x0010002a, 0x00000000, 0x0f000023, 0x00100072, 0x00000001, 0x00004002, 0x00000003, 0x00000003,
        0x00000003, 0x00000000, 0x00100556, 0x00000000, 0x00004002, 0x00000000, 0x00000001, 0x00000002,
        0x00000000, 0x0c0000a8, 0x0621e072, 0x00000002, 0x00000008, 0x0010000a, 0x00000000, 0x0010001a,
        0x00000000, 0x00004001, 0x00000000, 0x00100246, 0x00000001, 0x0700001e, 0x00100022, 0x00000000,
        0x0010001a, 0x00000000, 0x00004001, 0x00000001, 0x01000016, 0x0700001e, 0x00100012, 0x00000000,
        0x0010000a, 0x00000000, 0x00004001, 0x00000001, 0x01000016, 0x05000036, 0x00100012, 0x00000000,
        0x00004001, 0x00000000, 0x01000030, 0x07000021, 0x00100022, 0x00000000, 0x0010000a, 0x00000000,
        0x00004001, 0x00000004, 0x03040003, 0x0010001a, 0x00000000, 0x05000036, 0x00100022, 0x00000000,
        0x00004001, 0x00000000, 0x01000030, 0x07000021, 0x00100042, 0x00000000, 0x0010001a, 0x00000000,
        0x00004001, 0x00000004, 0x03040003, 0x0010002a, 0x00000000, 0x0f000023, 0x001000f2, 0x00000001,
        0x00100556, 0x00000000, 0x00004002, 0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00004002,
        0x00000000, 0x00000001, 0x00000002, 0x00000003, 0x0c0000a8, 0x0621e0f2, 0x00000003, 0x0000000c,
        0x0010000a, 0x00000000, 0x0010001a, 0x00000000, 0x00004001, 0x00000000, 0x00100e46, 0x00000001,
        0x0700001e, 0x00100022, 0x00000000, 0x0010001a, 0x00000000, 0x00004001, 0x00000001, 0x01000016,
        0x0700001e, 0x00100012, 0x00000000, 0x0010000a, 0x00000000, 0x00004001, 0x00000001, 0x01000016,
        0x05000036, 0x00100012, 0x00000000, 0x00004001, 0x00000000, 0x01000030, 0x07000021, 0x00100022,
        0x00000000, 0x0010000a, 0x00000000, 0x00004001, 0x00000004, 0x03040003, 0x0010001a, 0x00000000,
        0x07000029, 0x00100022, 0x00000000, 0x0010000a, 0x00000000, 0x00004001, 0x00000002, 0x05000036,
        0x00100042, 0x00000000, 0x00004001, 0x00000000, 0x01000030, 0x07000021, 0x00100082, 0x00000000,
        0x0010002a, 0x00000000, 0x00004001, 0x00000004, 0x03040003, 0x0010003a, 0x00000000, 0x07000029,
        0x00100082, 0x00000000, 0x0010002a, 0x00000000, 0x00004001, 0x00000002, 0x0700001e, 0x00100082,
        0x00000000, 0x0010001a, 0x00000000, 0x0010003a, 0x00000000, 0x0700001e, 0x00100012, 0x00000001,
        0x0010002a, 0x00000000, 0x0010001a, 0x00000000, 0x0a0000a6, 0x0621e012, 0x00000004, 0x00000010,
        0x0010000a, 0x00000000, 0x0010003a, 0x00000000, 0x0010000a, 0x00000001, 0x0700001e, 0x00100042,
        0x00000000, 0x0010002a, 0x00000000, 0x00004001, 0x00000001, 0x01000016, 0x0700001e, 0x00100012,
        0x00000000, 0x0010000a, 0x00000000, 0x00004001, 0x00000001, 0x01000016, 0x05000036, 0x00100012,
        0x00000000, 0x00004001, 0x00000000, 0x01000030, 0x07000021, 0x00100022, 0x00000000, 0x0010000a,
        0x00000000, 0x00004001, 0x00000004, 0x03040003, 0x0010001a, 0x00000000, 0x0a00001e, 0x00100062,
        0x00000000, 0x00100006, 0x00000000, 0x00004002, 0x00000000, 0x00000004, 0x00000001, 0x00000000,
        0x07000029, 0x00100082, 0x00000000, 0x0010000a, 0x00000000, 0x00004001, 0x00000002, 0x05000036,
        0x00100012, 0x00000001, 0x00004001, 0x00000000, 0x01000030, 0x07000021, 0x00100022, 0x00000001,
        0x0010000a, 0x00000001, 0x00004001, 0x00000004, 0x03040003, 0x0010001a, 0x00000001, 0x07000029,
        0x00100022, 0x00000001, 0x0010000a, 0x00000001, 0x00004001, 0x00000002, 0x0700001e, 0x00100022,
        0x00000001, 0x0010003a, 0x00000000, 0x0010001a, 0x00000001, 0x0700001e, 0x00100042, 0x00000001,
        0x0010003a, 0x00000000, 0x0010000a, 0x00000001, 0x0f000023, 0x001000c2, 0x00000001, 0x00100aa6,
        0x00000001, 0x00004002, 0x00000000, 0x00000000, 0x00000002, 0x00000002, 0x00004002, 0x00000000,
        0x00000000, 0x00000000, 0x00000001, 0x0a0000a6, 0x0621e032, 0x00000004, 0x00000010, 0x0010001a,
        0x00000000, 0x0010001a, 0x00000001, 0x00100ae6, 0x00000001, 0x0700001e, 0x00100012, 0x00000001,
        0x0010000a, 0x00000001, 0x00004001, 0x00000001, 0x01000016, 0x05000036, 0x00100012, 0x00000000,
        0x0010002a, 0x00000000, 0x01000016, 0x05000036, 0x00100012, 0x00000000, 0x00004001, 0x00000000,
        0x01000030, 0x07000021, 0x00100022, 0x00000000, 0x0010000a, 0x00000000, 0x00004001, 0x00000004,
        0x03040003, 0x0010001a, 0x00000000, 0x0700001e, 0x00100022, 0x00000000, 0x0010000a, 0x00000000,
        0x00004001, 0x00000008, 0x07000029, 0x00100042, 0x00000000, 0x0010000a, 0x00000000, 0x00004001,
        0x00000002, 0x05000036, 0x00100082, 0x00000000, 0x00004001, 0x00000000, 0x01000030, 0x07000021,
        0x00100012, 0x00000001, 0x0010003a, 0x00000000, 0x00004001, 0x00000004, 0x03040003, 0x0010000a,
        0x00000001, 0x07000029, 0x00100012, 0x00000001, 0x0010003a, 0x00000000, 0x00004001, 0x00000002,
        0x0700001e, 0x00100012, 0x00000001, 0x0010002a, 0x00000000, 0x0010000a, 0x00000001, 0x0700001e,
        0x00100022, 0x00000001, 0x0010003a, 0x00000000, 0x0010002a, 0x00000000, 0x0f000023, 0x001000e2,
        0x00000001, 0x00004002, 0x00000000, 0x00000003, 0x00000003, 0x00000003, 0x00100556, 0x00000001,
        0x00004002, 0x00000000, 0x00000000, 0x00000001, 0x00000002, 0x0a0000a6, 0x0621e072, 0x00000004,
        0x00000010, 0x0010001a, 0x00000000, 0x0010000a, 0x00000001, 0x00100796, 0x00000001, 0x0700001e,
        0x00100082, 0x00000000, 0x0010003a, 0x00000000, 0x00004001, 0x00000001, 0x01000016, 0x0700001e,
        0x00100012, 0x00000000, 0x0010000a, 0x00000000, 0x00004001, 0x00000001, 0x01000016, 0x05000036,
        0x00100012, 0x00000000, 0x00004001, 0x00000000, 0x01000030, 0x07000021, 0x00100022, 0x00000000,
        0x0010000a, 0x00000000, 0x00004001, 0x00000004, 0x03040003, 0x0010001a, 0x00000000, 0x0a00001e,
        0x00100062, 0x00000000, 0x00100006, 0x00000000, 0x00004002, 0x00000000, 0x0000000c, 0x00000001,
        0x00000000, 0x07000029, 0x00100082, 0x00000000, 0x0010000a, 0x00000000, 0x00004001, 0x00000002,
        0x05000036, 0x00100012, 0x00000001, 0x00004001, 0x00000000, 0x01000030, 0x07000021, 0x00100022,
        0x00000001, 0x0010000a, 0x00000001, 0x00004001, 0x00000004, 0x03040003, 0x0010001a, 0x00000001,
        0x07000029, 0x00100022, 0x00000001, 0x0010000a, 0x00000001, 0x00004001, 0x00000002, 0x0700001e,
        0x00100022, 0x00000001, 0x0010003a, 0x00000000, 0x0010001a, 0x00000001, 0x0700001e, 0x00100042,
        0x00000001, 0x0010003a, 0x00000000, 0x0010000a, 0x00000001, 0x0f000023, 0x001000f2, 0x00000002,
        0x00100aa6, 0x00000001, 0x00004002, 0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00004002,
        0x00000000, 0x00000001, 0x00000002, 0x00000003, 0x0a0000a6, 0x0621e0f2, 0x00000004, 0x00000010,
        0x0010001a, 0x00000000, 0x0010001a, 0x00000001, 0x00100e46, 0x00000002, 0x0700001e, 0x00100012,
        0x00000001, 0x0010000a, 0x00000001, 0x00004001, 0x00000001, 0x01000016, 0x05000036, 0x00100012,
        0x00000000, 0x0010002a, 0x00000000, 0x01000016, 0x01000015, 0x0100003e,
    };
    static const BYTE cs_code_dxil[] =
    {
        0x44, 0x58, 0x42, 0x43, 0x4b, 0x87, 0x60, 0x69, 0xa4, 0x42, 0x09, 0x0f, 0x75, 0x32, 0x54, 0x02, 0x8c, 0x50, 0xaa, 0x29, 0x01, 0x00, 0x00, 0x00, 0x14, 0x0c, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
        0x34, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x53, 0x46, 0x49, 0x30, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x49, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x4f, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x08, 0x00, 0x00, 0x00, 0x50, 0x53, 0x56, 0x30, 0x8c, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0x14, 0x0b, 0x00, 0x00,
        0x60, 0x00, 0x05, 0x00, 0xc5, 0x02, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0x00, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0xfc, 0x0a, 0x00, 0x00, 0x42, 0x43, 0xc0, 0xde, 0x21, 0x0c, 0x00, 0x00,
        0xbc, 0x02, 0x00, 0x00, 0x0b, 0x82, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x07, 0x81, 0x23, 0x91, 0x41, 0xc8, 0x04, 0x49, 0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c,
        0x25, 0x05, 0x08, 0x19, 0x1e, 0x04, 0x8b, 0x62, 0x80, 0x18, 0x45, 0x02, 0x42, 0x92, 0x0b, 0x42, 0xc4, 0x10, 0x32, 0x14, 0x38, 0x08, 0x18, 0x4b, 0x0a, 0x32, 0x62, 0x88, 0x48, 0x90, 0x14, 0x20,
        0x43, 0x46, 0x88, 0xa5, 0x00, 0x19, 0x32, 0x42, 0xe4, 0x48, 0x0e, 0x90, 0x11, 0x23, 0xc4, 0x50, 0x41, 0x51, 0x81, 0x8c, 0xe1, 0x83, 0xe5, 0x8a, 0x04, 0x31, 0x46, 0x06, 0x51, 0x18, 0x00, 0x00,
        0x08, 0x00, 0x00, 0x00, 0x1b, 0x8c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x40, 0x02, 0xa8, 0x0d, 0x86, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x20, 0x01, 0xd5, 0x06, 0x62, 0xf8, 0xff, 0xff, 0xff,
        0xff, 0x01, 0x90, 0x00, 0x49, 0x18, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x13, 0x82, 0x60, 0x42, 0x20, 0x4c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x89, 0x20, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
        0x32, 0x22, 0x88, 0x09, 0x20, 0x64, 0x85, 0x04, 0x13, 0x23, 0xa4, 0x84, 0x04, 0x13, 0x23, 0xe3, 0x84, 0xa1, 0x90, 0x14, 0x12, 0x4c, 0x8c, 0x8c, 0x0b, 0x84, 0xc4, 0x4c, 0x10, 0x8c, 0xc1, 0x08,
        0x40, 0x09, 0x00, 0x0a, 0xe6, 0x08, 0xc0, 0xa0, 0x0c, 0xc3, 0x30, 0x10, 0x31, 0x47, 0x80, 0x90, 0x71, 0xcf, 0x70, 0xf9, 0x13, 0xf6, 0x10, 0x92, 0x1f, 0x02, 0xcd, 0xb0, 0x10, 0x28, 0x38, 0xe6,
        0x08, 0x82, 0x62, 0x20, 0x83, 0x31, 0x0c, 0x09, 0x29, 0x45, 0x01, 0x06, 0x64, 0x18, 0x86, 0x61, 0x18, 0x0c, 0x62, 0x06, 0x02, 0x66, 0x32, 0x83, 0x71, 0x60, 0x87, 0x70, 0x98, 0x87, 0x79, 0x70,
        0x03, 0x59, 0xb8, 0x85, 0x59, 0xa0, 0x07, 0x79, 0xa8, 0x87, 0x71, 0xa0, 0x87, 0x7a, 0x90, 0x87, 0x72, 0x20, 0x07, 0x51, 0xa8, 0x07, 0x73, 0x30, 0x87, 0x72, 0x90, 0x07, 0x3e, 0xa8, 0x07, 0x77,
        0x98, 0x87, 0x74, 0x38, 0x07, 0x77, 0x28, 0x07, 0x72, 0x00, 0x83, 0x74, 0x70, 0x07, 0x7a, 0xf0, 0x03, 0x14, 0x0c, 0x49, 0xf0, 0x10, 0x34, 0x8c, 0x20, 0x0c, 0x33, 0xc9, 0xc1, 0x38, 0xb0, 0x43,
        0x38, 0xcc, 0xc3, 0x3c, 0xb8, 0x81, 0x2c, 0xdc, 0xc2, 0x2c, 0xd0, 0x83, 0x3c, 0xd4, 0xc3, 0x38, 0xd0, 0x43, 0x3d, 0xc8, 0x43, 0x39, 0x90, 0x83, 0x28, 0xd4, 0x83, 0x39, 0x98, 0x43, 0x39, 0xc8,
        0x03, 0x1f, 0xd8, 0x43, 0x39, 0x8c, 0x03, 0x3d, 0xbc, 0x83, 0x3c, 0xf0, 0x41, 0x3d, 0xb8, 0xc3, 0x3c, 0xa4, 0xc3, 0x39, 0xb8, 0x43, 0x39, 0x90, 0x03, 0x18, 0xa4, 0x83, 0x3b, 0xd0, 0x03, 0x1b,
        0x80, 0x81, 0x1c, 0xf8, 0x01, 0x18, 0xf8, 0x01, 0x0a, 0xa4, 0x24, 0x98, 0x88, 0x1a, 0x46, 0x18, 0x86, 0x99, 0xe4, 0x60, 0x1c, 0xd8, 0x21, 0x1c, 0xe6, 0x61, 0x1e, 0xdc, 0x40, 0x16, 0x6e, 0x61,
        0x16, 0xe8, 0x41, 0x1e, 0xea, 0x61, 0x1c, 0xe8, 0xa1, 0x1e, 0xe4, 0xa1, 0x1c, 0xc8, 0x41, 0x14, 0xea, 0xc1, 0x1c, 0xcc, 0xa1, 0x1c, 0xe4, 0x81, 0x0f, 0xec, 0xa1, 0x1c, 0xc6, 0x81, 0x1e, 0xde,
        0x41, 0x1e, 0xf8, 0xa0, 0x1e, 0xdc, 0x61, 0x1e, 0xd2, 0xe1, 0x1c, 0xdc, 0xa1, 0x1c, 0xc8, 0x01, 0x0c, 0xd2, 0xc1, 0x1d, 0xe8, 0x81, 0x0d, 0xc0, 0x60, 0x0e, 0xfc, 0x00, 0x0c, 0xfc, 0x00, 0x05,
        0x56, 0x12, 0x5c, 0x84, 0x0d, 0x23, 0x10, 0xc3, 0x4c, 0x72, 0x30, 0x0e, 0xec, 0x10, 0x0e, 0xf3, 0x30, 0x0f, 0x6e, 0x20, 0x0b, 0xb7, 0x30, 0x0b, 0xf4, 0x20, 0x0f, 0xf5, 0x30, 0x0e, 0xf4, 0x50,
        0x0f, 0xf2, 0x50, 0x0e, 0xe4, 0x20, 0x0a, 0xf5, 0x60, 0x0e, 0xe6, 0x50, 0x0e, 0xf2, 0xc0, 0x07, 0xf6, 0x50, 0x0e, 0xe3, 0x40, 0x0f, 0xef, 0x20, 0x0f, 0x7c, 0x50, 0x0f, 0xee, 0x30, 0x0f, 0xe9,
        0x70, 0x0e, 0xee, 0x50, 0x0e, 0xe4, 0x00, 0x06, 0xe9, 0xe0, 0x0e, 0xf4, 0xc0, 0x06, 0x60, 0x40, 0x07, 0x7e, 0x00, 0x06, 0x7e, 0x80, 0x02, 0x2d, 0x09, 0x36, 0xe2, 0x4e, 0x93, 0xa6, 0x88, 0x12,
        0x26, 0x7f, 0x85, 0x37, 0x6c, 0x22, 0xb4, 0x61, 0x88, 0x08, 0x49, 0xda, 0xa8, 0xa2, 0x20, 0x22, 0x14, 0x0c, 0x09, 0xe1, 0xd1, 0x37, 0x47, 0x00, 0x0a, 0x53, 0x00, 0x00, 0x13, 0x14, 0x72, 0xc0,
        0x87, 0x74, 0x60, 0x87, 0x36, 0x68, 0x87, 0x79, 0x68, 0x03, 0x72, 0xc0, 0x87, 0x0d, 0xaf, 0x50, 0x0e, 0x6d, 0xd0, 0x0e, 0x7a, 0x50, 0x0e, 0x6d, 0x00, 0x0f, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07,
        0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x78, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0,
        0x06, 0xe9, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x76, 0x40, 0x07, 0x7a, 0x60, 0x07, 0x74, 0xd0, 0x06, 0xe6, 0x10, 0x07, 0x76, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d,
        0x60, 0x0e, 0x73, 0x20, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe6, 0x60, 0x07, 0x74, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x6d, 0xe0, 0x0e, 0x78, 0xa0, 0x07, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07,
        0x72, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x43, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x3c, 0x04, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0c, 0x79, 0x14, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xf2, 0x30, 0x40, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x05, 0x02, 0x00, 0x00, 0x00,
        0x0e, 0x00, 0x00, 0x00, 0x32, 0x1e, 0x98, 0x14, 0x19, 0x11, 0x4c, 0x90, 0x8c, 0x09, 0x26, 0x47, 0xc6, 0x04, 0x43, 0x1a, 0x4a, 0x60, 0x04, 0xa0, 0x10, 0x8a, 0xa1, 0x30, 0x0a, 0xa2, 0x08, 0xca,
        0xa0, 0x40, 0xca, 0x82, 0x92, 0x11, 0x00, 0x0a, 0x0b, 0x84, 0xaa, 0x19, 0x00, 0xca, 0x66, 0x00, 0xa8, 0x9b, 0x01, 0x20, 0x70, 0x06, 0x80, 0xa2, 0x19, 0x00, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00,
        0x54, 0x00, 0x00, 0x00, 0x1a, 0x03, 0x4c, 0x90, 0x46, 0x02, 0x13, 0xc4, 0x88, 0x0c, 0x6f, 0xec, 0xed, 0x4d, 0x0c, 0x44, 0x06, 0x26, 0x26, 0xc7, 0x05, 0xa6, 0xc6, 0x05, 0x06, 0x66, 0x43, 0x10,
        0x4c, 0x10, 0x06, 0x62, 0x82, 0x30, 0x14, 0x1b, 0x84, 0x81, 0x98, 0x20, 0x0c, 0xc6, 0x06, 0x61, 0x30, 0x28, 0x8c, 0xcd, 0x4d, 0x10, 0x86, 0x63, 0xc3, 0x80, 0x24, 0xc4, 0x04, 0x21, 0xa2, 0x08,
        0x4c, 0x10, 0x06, 0x64, 0x82, 0x90, 0x38, 0x1b, 0x16, 0x62, 0x61, 0x08, 0xc2, 0x68, 0x1c, 0xc7, 0x39, 0x26, 0x08, 0x15, 0x34, 0x41, 0x18, 0x92, 0x0d, 0xc2, 0x10, 0x6d, 0x58, 0x06, 0x88, 0x21,
        0x0c, 0xa3, 0x71, 0x1c, 0x47, 0x9a, 0x20, 0x0c, 0xca, 0x04, 0x21, 0x8b, 0x36, 0x08, 0x43, 0xb3, 0x61, 0xa1, 0x2a, 0x86, 0x88, 0x8c, 0xc6, 0x71, 0x1c, 0x6b, 0x82, 0x30, 0x2c, 0x13, 0x84, 0x4e,
        0x9a, 0x20, 0x0c, 0xcc, 0x06, 0x61, 0xd0, 0x36, 0x2c, 0x58, 0xc6, 0x10, 0x8d, 0xd1, 0x38, 0x8e, 0xb3, 0x4d, 0x10, 0xc0, 0x60, 0x9a, 0x20, 0x0c, 0xcd, 0x86, 0xc5, 0xe8, 0x18, 0x42, 0xd3, 0x3c,
        0xc7, 0x71, 0x80, 0x0d, 0xc5, 0x33, 0x5d, 0xdc, 0xb7, 0x81, 0x00, 0xc0, 0x00, 0x00, 0x26, 0x08, 0x02, 0xb0, 0x01, 0xd8, 0x30, 0x10, 0x63, 0x30, 0x06, 0x1b, 0x02, 0x32, 0xd8, 0x30, 0x0c, 0x62,
        0x50, 0x06, 0x24, 0xda, 0xc2, 0xd2, 0xdc, 0x26, 0x08, 0x61, 0xf0, 0x6c, 0x18, 0x86, 0x61, 0xd8, 0x40, 0x10, 0x68, 0x60, 0xa4, 0xc1, 0x86, 0x42, 0x0c, 0xce, 0x00, 0x08, 0x03, 0x35, 0xa8, 0xc2,
        0xc6, 0x66, 0xd7, 0xe6, 0x92, 0x46, 0x56, 0xe6, 0x46, 0x37, 0x25, 0x08, 0xaa, 0x90, 0xe1, 0xb9, 0xd8, 0x95, 0xc9, 0xcd, 0xa5, 0xbd, 0xb9, 0x4d, 0x09, 0x88, 0x26, 0x64, 0x78, 0x2e, 0x76, 0x61,
        0x6c, 0x76, 0x65, 0x72, 0x53, 0x02, 0xa3, 0x0e, 0x19, 0x9e, 0xcb, 0x1c, 0x5a, 0x18, 0x59, 0x99, 0x5c, 0xd3, 0x1b, 0x59, 0x19, 0xdb, 0x94, 0x20, 0x29, 0x43, 0x86, 0xe7, 0x22, 0x57, 0x36, 0xf7,
        0x56, 0x27, 0x37, 0x56, 0x36, 0x37, 0x25, 0x00, 0x83, 0x4a, 0x64, 0x78, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x82, 0x32, 0xa8,
        0x43, 0x86, 0xe7, 0x52, 0xe6, 0x46, 0x27, 0x97, 0x07, 0xf5, 0x96, 0xe6, 0x46, 0x37, 0x37, 0x25, 0x50, 0x03, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c,
        0xc4, 0xe1, 0x1c, 0x66, 0x14, 0x01, 0x3d, 0x88, 0x43, 0x38, 0x84, 0xc3, 0x8c, 0x42, 0x80, 0x07, 0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6, 0x00, 0x0f, 0xed, 0x10, 0x0e, 0xf4, 0x80, 0x0e,
        0x33, 0x0c, 0x42, 0x1e, 0xc2, 0xc1, 0x1d, 0xce, 0xa1, 0x1c, 0x66, 0x30, 0x05, 0x3d, 0x88, 0x43, 0x38, 0x84, 0x83, 0x1b, 0xcc, 0x03, 0x3d, 0xc8, 0x43, 0x3d, 0x8c, 0x03, 0x3d, 0xcc, 0x78, 0x8c,
        0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79, 0x48, 0x87, 0x70, 0x70, 0x07, 0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20, 0x87, 0x19, 0xcc, 0x11, 0x0e, 0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e,
        0x30, 0x0f, 0xe3, 0xf0, 0x0e, 0xf0, 0x50, 0x0e, 0x33, 0x10, 0xc4, 0x1d, 0xde, 0x21, 0x1c, 0xd8, 0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89, 0x3b, 0xbc, 0x83, 0x3b, 0xd0, 0x43, 0x39, 0xb4,
        0x03, 0x3c, 0xbc, 0x83, 0x3c, 0x84, 0x03, 0x3b, 0xcc, 0xf0, 0x14, 0x76, 0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x68, 0x87, 0x72, 0x68, 0x07, 0x37, 0x80, 0x87, 0x70, 0x90, 0x87, 0x70, 0x60, 0x07,
        0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76, 0x78, 0x87, 0x77, 0x80, 0x87, 0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98, 0x87, 0x79, 0x98, 0x81, 0x2c, 0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5,
        0xc0, 0x0e, 0xec, 0x30, 0x03, 0x62, 0xc8, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xcc, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c, 0xc4, 0x81, 0x1d, 0xca, 0x61, 0x06, 0xd6, 0x90,
        0x43, 0x39, 0xc8, 0x43, 0x39, 0x98, 0x43, 0x39, 0xc8, 0x43, 0x39, 0xb8, 0xc3, 0x38, 0x94, 0x43, 0x38, 0x88, 0x03, 0x3b, 0x94, 0xc3, 0x2f, 0xbc, 0x83, 0x3c, 0xfc, 0x82, 0x3b, 0xd4, 0x03, 0x3b,
        0xb0, 0xc3, 0x8c, 0xcc, 0x21, 0x07, 0x7c, 0x70, 0x03, 0x74, 0x60, 0x07, 0x37, 0x90, 0x87, 0x72, 0x98, 0x87, 0x77, 0xa8, 0x07, 0x79, 0x18, 0x87, 0x72, 0x70, 0x83, 0x70, 0xa0, 0x07, 0x7a, 0x90,
        0x87, 0x74, 0x10, 0x87, 0x7a, 0xa0, 0x87, 0x72, 0x00, 0x00, 0x00, 0x00, 0x71, 0x20, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x36, 0x50, 0x0d, 0x97, 0xef, 0x3c, 0x7e, 0x40, 0x15, 0x05, 0x11, 0xb1,
        0x93, 0x13, 0x11, 0x3e, 0x72, 0xdb, 0x26, 0x20, 0x0d, 0x97, 0xef, 0x3c, 0xbe, 0x10, 0x11, 0xc0, 0x44, 0x84, 0x40, 0x33, 0x2c, 0x84, 0x05, 0x48, 0xc3, 0xe5, 0x3b, 0x8f, 0x3f, 0x1d, 0x11, 0x01,
        0x0c, 0xe2, 0xe0, 0x23, 0xb7, 0x6d, 0x00, 0x04, 0x03, 0x20, 0x0d, 0x00, 0x61, 0x20, 0x00, 0x00, 0x2f, 0x01, 0x00, 0x00, 0x13, 0x04, 0x53, 0x2c, 0x10, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x34, 0xcc, 0x00, 0x94, 0x62, 0x40, 0xc9, 0x95, 0x42, 0x39, 0x94, 0x44, 0x51, 0x94, 0x46, 0x71, 0x94, 0x47, 0xe9, 0x06, 0x90, 0x51, 0x02, 0x65, 0x50, 0x0e, 0xe5, 0x01, 0x23, 0x06, 0x06, 0x00,
        0x82, 0x60, 0x40, 0x8c, 0x41, 0xf1, 0x0d, 0x37, 0x04, 0x60, 0x00, 0x06, 0xb3, 0x0c, 0x81, 0x14, 0xcc, 0x12, 0x08, 0x03, 0x15, 0xc3, 0x21, 0x88, 0x42, 0x50, 0x81, 0x18, 0xc0, 0x88, 0x41, 0x02,
        0x80, 0x20, 0x18, 0x28, 0x66, 0x10, 0x21, 0x63, 0x10, 0x68, 0x23, 0x06, 0x0d, 0x00, 0x82, 0x60, 0xc0, 0x98, 0xc1, 0x14, 0x90, 0x01, 0x19, 0x90, 0x01, 0x45, 0x51, 0xc9, 0x88, 0x41, 0x03, 0x80,
        0x20, 0x18, 0x30, 0x66, 0x30, 0x05, 0x65, 0x40, 0x06, 0x65, 0x40, 0x51, 0x54, 0x32, 0x62, 0xd0, 0x00, 0x20, 0x08, 0x06, 0x8c, 0x19, 0x4c, 0xc1, 0x47, 0x06, 0x1f, 0x45, 0x51, 0xc9, 0x88, 0x41,
        0x03, 0x80, 0x20, 0x18, 0x30, 0x66, 0x30, 0x05, 0x1e, 0x19, 0x78, 0x14, 0x45, 0x25, 0x36, 0x94, 0x01, 0x0c, 0x86, 0x1b, 0x02, 0x32, 0x00, 0x83, 0x59, 0x86, 0x41, 0x08, 0x66, 0x09, 0x88, 0x81,
        0x8a, 0xe1, 0x20, 0x58, 0x61, 0xa8, 0xc0, 0x0c, 0x60, 0xc4, 0x20, 0x01, 0x40, 0x10, 0x0c, 0x94, 0x35, 0xb0, 0x9a, 0x34, 0x08, 0xbe, 0x11, 0x83, 0x06, 0x00, 0x41, 0x30, 0x60, 0xd6, 0x00, 0x0b,
        0xd2, 0x20, 0x0d, 0xd2, 0x40, 0x0d, 0xb2, 0xac, 0x19, 0x31, 0x68, 0x00, 0x10, 0x04, 0x03, 0x66, 0x0d, 0xb0, 0x40, 0x0d, 0xd2, 0x80, 0x0c, 0xc6, 0x20, 0xcb, 0x9a, 0x11, 0x83, 0x06, 0x00, 0x41,
        0x30, 0x60, 0xd6, 0x00, 0x0b, 0xc8, 0x20, 0x0d, 0xd0, 0xc0, 0xca, 0xb2, 0x66, 0xc4, 0xa0, 0x01, 0x40, 0x10, 0x0c, 0x98, 0x35, 0xc0, 0x82, 0x31, 0x48, 0x83, 0x33, 0xa8, 0xb2, 0xac, 0xb1, 0x41,
        0x0d, 0x60, 0x30, 0xdc, 0x10, 0xa4, 0x01, 0x18, 0xcc, 0x32, 0x14, 0x44, 0x30, 0x4b, 0x60, 0x0c, 0x54, 0x0c, 0x87, 0x61, 0x0b, 0x45, 0x05, 0x68, 0x00, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0xa0,
        0xc0, 0xc1, 0x26, 0xa1, 0x41, 0x40, 0x06, 0x23, 0x06, 0x0d, 0x00, 0x82, 0x60, 0xc0, 0xc0, 0x41, 0x17, 0xb8, 0x81, 0x1b, 0xb8, 0xc1, 0x1b, 0xa4, 0x81, 0x17, 0x8d, 0x18, 0x34, 0x00, 0x08, 0x82,
        0x01, 0x03, 0x07, 0x5d, 0xf0, 0x06, 0x6e, 0x80, 0x06, 0x6d, 0xb0, 0x79, 0xd1, 0x88, 0x41, 0x03, 0x80, 0x20, 0x18, 0x30, 0x70, 0xd0, 0x05, 0x69, 0xe0, 0x06, 0x6c, 0xa0, 0xa9, 0x81, 0x17, 0x8d,
        0x18, 0x34, 0x00, 0x08, 0x82, 0x01, 0x03, 0x07, 0x5d, 0x80, 0x06, 0x6e, 0x90, 0x61, 0x66, 0xe0, 0x45, 0x36, 0xbc, 0x01, 0x0c, 0x86, 0x1b, 0x02, 0x37, 0x00, 0x83, 0x59, 0x86, 0xc3, 0x08, 0x66,
        0x09, 0x90, 0x81, 0x8a, 0xe1, 0x40, 0xc0, 0xe1, 0xa8, 0xc0, 0x0d, 0x60, 0xc4, 0x20, 0x01, 0x40, 0x10, 0x0c, 0x94, 0x3a, 0x00, 0x83, 0x8b, 0x0d, 0x82, 0x34, 0x18, 0x31, 0x68, 0x00, 0x10, 0x04,
        0x03, 0xa6, 0x0e, 0xc4, 0x20, 0x98, 0x83, 0x39, 0x98, 0x03, 0x3a, 0x70, 0x83, 0x36, 0xa8, 0x46, 0x0c, 0x1a, 0x00, 0x04, 0xc1, 0x80, 0xa9, 0x03, 0x31, 0x08, 0xe8, 0x60, 0x0e, 0xe4, 0x00, 0x0c,
        0xe2, 0xe0, 0xab, 0x46, 0x0c, 0x1a, 0x00, 0x04, 0xc1, 0x80, 0xa9, 0x03, 0x31, 0x08, 0xdc, 0x60, 0x0e, 0xde, 0xc0, 0xeb, 0xd6, 0xa0, 0x1a, 0x31, 0x68, 0x00, 0x10, 0x04, 0x03, 0xa6, 0x0e, 0xc4,
        0x20, 0x68, 0x83, 0x39, 0x80, 0x03, 0x6e, 0xd3, 0x2a, 0x1b, 0xe8, 0x00, 0x06, 0xc3, 0x0d, 0xc1, 0x1c, 0x80, 0xc1, 0x2c, 0x43, 0x82, 0x04, 0xb3, 0x04, 0xca, 0x40, 0xc5, 0x50, 0x29, 0xea, 0x90,
        0x54, 0x10, 0x07, 0x57, 0x02, 0x1c, 0xc0, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x28, 0x7b, 0x60, 0x06, 0xdd, 0x1d, 0x04, 0x6f, 0x30, 0x62, 0xd0, 0x00, 0x20, 0x08, 0x06, 0xcc, 0x1e, 0xa0, 0x41,
        0x30, 0xa4, 0xc1, 0x90, 0x06, 0x69, 0x90, 0x06, 0x5e, 0x0d, 0x7a, 0xb0, 0x46, 0xe4, 0x01, 0x0c, 0x46, 0x0c, 0x1a, 0x00, 0x04, 0xc1, 0x80, 0xe9, 0x03, 0x35, 0x18, 0x82, 0x35, 0x10, 0xd6, 0x60,
        0x0d, 0xd6, 0x00, 0x0c, 0xaa, 0xb0, 0x83, 0x35, 0x03, 0x0f, 0x60, 0x30, 0x62, 0xd0, 0x00, 0x20, 0x08, 0x06, 0xcc, 0x1f, 0xb0, 0x41, 0x11, 0xb4, 0x81, 0xd0, 0x06, 0x6d, 0xd0, 0x06, 0x62, 0x50,
        0xc7, 0x1d, 0xac, 0x21, 0x7b, 0x00, 0x83, 0x11, 0x83, 0x06, 0x00, 0x41, 0x30, 0x60, 0x42, 0xc1, 0x0d, 0x8e, 0xe0, 0x0d, 0x84, 0x37, 0x78, 0x83, 0x37, 0x20, 0x03, 0x53, 0x40, 0x01, 0x06, 0xc3,
        0x0d, 0xc1, 0x1f, 0x80, 0xc1, 0x2c, 0xc3, 0xa2, 0x04, 0xb3, 0x04, 0xcc, 0x40, 0xc5, 0x10, 0x06, 0x8c, 0x48, 0x2c, 0x16, 0x84, 0x02, 0x0c, 0x4a, 0xe8, 0x83, 0xab, 0xa0, 0x14, 0xb6, 0x08, 0x50,
        0xb8, 0x22, 0xfe, 0x00, 0x46, 0x0c, 0x12, 0x00, 0x04, 0xc1, 0x40, 0x51, 0x85, 0x3a, 0x60, 0x03, 0x53, 0x08, 0xfc, 0x60, 0xc4, 0xa0, 0x01, 0x40, 0x10, 0x0c, 0x18, 0x55, 0xb8, 0x83, 0x60, 0xc0,
        0x83, 0x82, 0xc0, 0x03, 0x3c, 0x60, 0x83, 0x2a, 0x46, 0x61, 0xcb, 0x18, 0x85, 0xb5, 0x22, 0x15, 0x60, 0x30, 0x62, 0xd0, 0x00, 0x20, 0x08, 0x06, 0x4c, 0x2b, 0xe8, 0x01, 0x11, 0xec, 0xc1, 0x20,
        0xec, 0xc1, 0x1e, 0xbc, 0x41, 0x21, 0xaa, 0xb0, 0x95, 0xe4, 0xc1, 0x1a, 0x92, 0x0a, 0x30, 0x18, 0x31, 0x68, 0x00, 0x10, 0x04, 0x03, 0x06, 0x16, 0xfa, 0xe0, 0x08, 0xfc, 0x60, 0x10, 0xfc, 0xc0,
        0x0f, 0xe4, 0xa0, 0x16, 0x56, 0xd8, 0x62, 0xf6, 0x60, 0x6d, 0x69, 0x05, 0x18, 0x8c, 0x18, 0x34, 0x00, 0x08, 0x82, 0x01, 0x33, 0x0b, 0xa0, 0xa0, 0x04, 0xa1, 0x30, 0x08, 0xa1, 0x10, 0x0a, 0x75,
        0x60, 0x90, 0x2c, 0xc0, 0x60, 0xb8, 0x21, 0x88, 0x05, 0x30, 0x98, 0x65, 0x68, 0x98, 0x60, 0x96, 0xc0, 0x19, 0xa8, 0x18, 0xde, 0xc0, 0x31, 0x8b, 0xc6, 0x02, 0x58, 0x80, 0x81, 0x09, 0xb2, 0x20,
        0x83, 0x0a, 0x6e, 0x61, 0x4b, 0x90, 0x85, 0xad, 0x62, 0x16, 0xae, 0x0a, 0x59, 0x80, 0x11, 0x83, 0x04, 0x00, 0x41, 0x30, 0x50, 0x7a, 0x01, 0x15, 0xfe, 0x20, 0x17, 0x82, 0x58, 0x18, 0x31, 0x68,
        0x00, 0x10, 0x04, 0x03, 0xa6, 0x17, 0x54, 0x21, 0x18, 0x56, 0xc1, 0x28, 0x88, 0x55, 0xf0, 0x83, 0x1a, 0x78, 0x61, 0x2d, 0xb0, 0x05, 0x19, 0x58, 0xe0, 0x0b, 0x30, 0x30, 0x21, 0x17, 0x60, 0x60,
        0x87, 0x2f, 0xc0, 0x60, 0xc4, 0xa0, 0x01, 0x40, 0x10, 0x0c, 0x18, 0x71, 0x78, 0x05, 0x23, 0x80, 0x05, 0x62, 0x10, 0x60, 0x61, 0x14, 0x0a, 0xd9, 0x85, 0xb5, 0x60, 0x17, 0x64, 0x50, 0xc1, 0x38,
        0xac, 0x09, 0xbe, 0x00, 0x03, 0x63, 0xc0, 0x01, 0x06, 0x23, 0x06, 0x0d, 0x00, 0x82, 0x60, 0xc0, 0x9c, 0x03, 0x2d, 0x2c, 0x41, 0x2d, 0x10, 0x83, 0x50, 0x0b, 0xa8, 0x50, 0xcd, 0x2f, 0xac, 0x05,
        0xe0, 0x20, 0x03, 0x0b, 0xd0, 0x01, 0x06, 0x26, 0x8c, 0x03, 0x0c, 0x2c, 0x32, 0x07, 0x18, 0x8c, 0x18, 0x34, 0x00, 0x08, 0x82, 0x01, 0xc3, 0x0e, 0xb9, 0x00, 0x05, 0xba, 0x40, 0x0c, 0x82, 0x2e,
        0xb4, 0x82, 0x5d, 0xeb, 0x00, 0x83, 0xe1, 0x86, 0x40, 0x1d, 0xc0, 0x60, 0x96, 0xe1, 0x71, 0x82, 0x59, 0x02, 0x68, 0xa0, 0x62, 0x88, 0x03, 0x08, 0x37, 0x1e, 0x0b, 0xd4, 0x01, 0x06, 0x25, 0xb4,
        0xc3, 0x55, 0x00, 0x0f, 0x5b, 0xc2, 0x3a, 0x6c, 0x0d, 0xeb, 0xb0, 0x65, 0xb4, 0xc3, 0x95, 0xc1, 0x0e, 0x30, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0xca, 0x3d, 0x88, 0x43, 0x2e, 0xcc, 0x43, 0xb0,
        0x0e, 0x23, 0x06, 0x0d, 0x00, 0x82, 0x60, 0xc0, 0xdc, 0x03, 0x39, 0x04, 0x43, 0x39, 0x1c, 0x46, 0x41, 0xdc, 0x42, 0x1d, 0xf4, 0xb0, 0x85, 0x8c, 0xc3, 0x56, 0x52, 0x0f, 0x5b, 0x0a, 0x39, 0xac,
        0x1d, 0xf8, 0x00, 0x83, 0x11, 0x83, 0x06, 0x00, 0x41, 0x30, 0x60, 0xf8, 0x21, 0x1d, 0x8c, 0x40, 0x1d, 0x0a, 0x62, 0x10, 0x78, 0xa1, 0x18, 0x7b, 0xd8, 0x6a, 0xcc, 0x61, 0xcb, 0x31, 0x87, 0xad,
        0xa7, 0x1e, 0xd6, 0x18, 0x7d, 0x80, 0xc1, 0x88, 0x41, 0x03, 0x80, 0x20, 0x18, 0x30, 0x21, 0xe1, 0x0e, 0x4b, 0xf0, 0x0e, 0x05, 0x31, 0x08, 0xe1, 0x50, 0x11, 0x3f, 0x6c, 0x49, 0xe9, 0xb0, 0x35,
        0xa5, 0xc3, 0x16, 0x95, 0x0e, 0x6b, 0x11, 0x48, 0xc0, 0x60, 0xc4, 0xa0, 0x01, 0x40, 0x10, 0x0c, 0x18, 0x93, 0x98, 0x07, 0x28, 0xa0, 0x87, 0x82, 0x18, 0x04, 0x73, 0x30, 0xac, 0x24, 0x60, 0x30,
        0xdc, 0x10, 0x90, 0x04, 0x18, 0xcc, 0x32, 0x44, 0x50, 0x30, 0x4b, 0x20, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    };

    if (!init_compute_test_context(&context))
        return;

    if (use_dxil && !context_supports_dxil(&context))
    {
        destroy_test_context(&context);
        return;
    }

    command_list = context.list;
    queue = context.queue;

    root_signature_desc.NumParameters = 1;
    root_signature_desc.Flags = 0;
    root_signature_desc.NumStaticSamplers = 0;
    root_signature_desc.pStaticSamplers = NULL;
    root_signature_desc.pParameters = root_parameters;

    root_parameters[0].ParameterType = D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE;
    root_parameters[0].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
    root_parameters[0].DescriptorTable.NumDescriptorRanges = 1;
    root_parameters[0].DescriptorTable.pDescriptorRanges = descriptor_ranges;

    descriptor_ranges[0].RegisterSpace = 0;
    descriptor_ranges[0].BaseShaderRegister = 0;
    descriptor_ranges[0].OffsetInDescriptorsFromTableStart = 0;
    descriptor_ranges[0].NumDescriptors = UINT_MAX;
    descriptor_ranges[0].RangeType = D3D12_DESCRIPTOR_RANGE_TYPE_UAV;

    hr = create_root_signature(context.device, &root_signature_desc, &context.root_signature);
    ok(SUCCEEDED(hr), "Failed to create root signature, hr %#x.\n", hr);

    output_buffer = create_default_buffer(context.device, chunk_size * 32, D3D12_RESOURCE_FLAG_ALLOW_UNORDERED_ACCESS, D3D12_RESOURCE_STATE_UNORDERED_ACCESS);

    context.pipeline_state = create_compute_pipeline_state(context.device,
        context.root_signature,
        shader_bytecode(use_dxil ? (const void*)cs_code_dxil : (const void*)cs_code_dxbc,
                use_dxil ? sizeof(cs_code_dxil) : sizeof(cs_code_dxbc)));

    heap = create_gpu_descriptor_heap(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV, 512);
    aux_cpu_heap = create_cpu_descriptor_heap(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV, 1);
    aux_gpu_heap = create_gpu_descriptor_heap(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV, 1);
    cpu_handle = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(heap);
    gpu_handle = ID3D12DescriptorHeap_GetGPUDescriptorHandleForHeapStart(heap);
    descriptor_size = ID3D12Device_GetDescriptorHandleIncrementSize(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV);

    /* Exhaustively test all combinations of stride and offset within a 16 byte boundary. */
    for (j = 0; j < 4; j++)
    {
        for (i = 0; i < 4; i++)
        {
            D3D12_UNORDERED_ACCESS_VIEW_DESC view;
            D3D12_CPU_DESCRIPTOR_HANDLE h = cpu_handle;
            unsigned int stride = 4 + 4 * j;
            view.Format = DXGI_FORMAT_UNKNOWN;
            view.ViewDimension = D3D12_UAV_DIMENSION_BUFFER;
            view.Buffer.FirstElement = (j * 4 + i) * (chunk_size / stride) + 1; /* Offset by one element always for more test coverage. */
            view.Buffer.NumElements = 1 + i;
            view.Buffer.StructureByteStride = stride;
            view.Buffer.CounterOffsetInBytes = 0;
            view.Buffer.Flags = 0;
            h.ptr += (j * 4 + i) * descriptor_size;
            ID3D12Device_CreateUnorderedAccessView(context.device, output_buffer, NULL, &view, h);
        }
    }

    for (i = 0; i < 16; i++)
    {
        D3D12_UNORDERED_ACCESS_VIEW_DESC view;
        D3D12_CPU_DESCRIPTOR_HANDLE h = cpu_handle;
        view.Format = DXGI_FORMAT_R32_TYPELESS;
        view.ViewDimension = D3D12_UAV_DIMENSION_BUFFER;
        view.Buffer.FirstElement = (16 + i) * chunk_size_words;
        view.Buffer.NumElements = 4;
        view.Buffer.StructureByteStride = 0;
        view.Buffer.CounterOffsetInBytes = 0;
        view.Buffer.Flags = D3D12_BUFFER_UAV_FLAG_RAW;
        h.ptr += (i + 16) * descriptor_size;
        ID3D12Device_CreateUnorderedAccessView(context.device, output_buffer, NULL, &view, h);
    }

    ID3D12GraphicsCommandList_SetDescriptorHeaps(command_list, 1, &aux_gpu_heap);
    {
        const UINT clear_value[4] = { 0xaaaaaaaau, 0xaaaaaaaau, 0xaaaaaaaau, 0xaaaaaaaau };
        D3D12_CPU_DESCRIPTOR_HANDLE cpu_desc, gpu_desc;
        D3D12_UNORDERED_ACCESS_VIEW_DESC view;
        D3D12_RESOURCE_BARRIER barrier;

        cpu_desc = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(aux_cpu_heap);
        gpu_desc = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(aux_gpu_heap);
        view.Format = DXGI_FORMAT_R32_TYPELESS;
        view.ViewDimension = D3D12_UAV_DIMENSION_BUFFER;
        view.Buffer.FirstElement = 0;
        view.Buffer.NumElements = chunk_size_words * 32;
        view.Buffer.StructureByteStride = 0;
        view.Buffer.CounterOffsetInBytes = 0;
        view.Buffer.Flags = D3D12_BUFFER_UAV_FLAG_RAW;
        ID3D12Device_CreateUnorderedAccessView(context.device, output_buffer, NULL, &view, cpu_desc);
        ID3D12Device_CreateUnorderedAccessView(context.device, output_buffer, NULL, &view, gpu_desc);
        ID3D12GraphicsCommandList_ClearUnorderedAccessViewUint(command_list,
                ID3D12DescriptorHeap_GetGPUDescriptorHandleForHeapStart(aux_gpu_heap),
                cpu_desc, output_buffer, clear_value, 0, NULL);

        barrier.Type = D3D12_RESOURCE_BARRIER_TYPE_UAV;
        barrier.Flags = D3D12_RESOURCE_BARRIER_FLAG_NONE;
        barrier.UAV.pResource = output_buffer;
        ID3D12GraphicsCommandList_ResourceBarrier(command_list, 1, &barrier);
    }

    ID3D12GraphicsCommandList_SetDescriptorHeaps(command_list, 1, &heap);
    ID3D12GraphicsCommandList_SetComputeRootSignature(command_list, context.root_signature);
    ID3D12GraphicsCommandList_SetPipelineState(command_list, context.pipeline_state);
    ID3D12GraphicsCommandList_SetComputeRootDescriptorTable(command_list, 0, gpu_handle);
    ID3D12GraphicsCommandList_Dispatch(command_list, 1, 1, 1);

    transition_resource_state(command_list, output_buffer, D3D12_RESOURCE_STATE_UNORDERED_ACCESS, D3D12_RESOURCE_STATE_COPY_SOURCE);
    get_buffer_readback_with_command_list(output_buffer, DXGI_FORMAT_UNKNOWN, &rb, queue, command_list);

    for (j = 0; j < 4; j++)
    {
        unsigned int stride_words = 1 + j;

        for (i = 0; i < 4; i++)
        {
            unsigned int base_offset_words = chunk_size_words * (j * 4 + i) + stride_words;
            unsigned int num_elements = 1 + i;
            unsigned int num_words = num_elements * stride_words;

            for (word_index = 0; word_index < num_words; word_index++)
            {
                UINT value = get_readback_uint(&rb, base_offset_words + word_index, 0, 0);
                UINT reference = word_index;
                ok(value == reference, "Readback value for structured buffer iteration (%u, %u, %u) is: %u\n", j, i, word_index, value);
            }

            /* Read beyond and verify we got robustness behavior. */
            for (word_index = 0; word_index < 16; word_index++)
            {
                UINT value = get_readback_uint(&rb, base_offset_words + word_index + num_words, 0, 0);
                UINT reference = 0xaaaaaaaau;
                ok(value == reference, "Readback value for boundary check iteration (%u, %u, %u) is: %u\n", j, i, word_index, value);
            }
        }
    }

    {
        UINT expected_block[16][8];
        memset(expected_block, 0xaa, sizeof(expected_block));
#define STORE1(desc, word, value) do { if ((word) < 4) expected_block[desc][word] = value; } while(0)
#define STORE2(desc, word, value0, value1) STORE1(desc, word, value0); STORE1(desc, (word) + 1, value1)
#define STORE3(desc, word, value0, value1, value2) STORE2(desc, word, value0, value1); STORE1(desc, (word) + 2, value2)
#define STORE4(desc, word, value0, value1, value2, value3) STORE3(desc, word, value0, value1, value2); STORE1(desc, (word) + 3, value3)
#define STAMP(i, j) (4 * (j) + (i))

        /* Do whatever the shader is doing, apply 16 byte robustness per 32-bit access. */
        for (j = 0; j < 4; j++)
            for (i = 0; i < 4; i++)
                STORE1(4 * 0 + j, i + j, STAMP(i, j));

        for (j = 0; j < 4; j++)
            for (i = 0; i < 4; i++)
                STORE2(4 * 1 + j, i + j, 2 * STAMP(i, j) + 0, 2 * STAMP(i, j) + 1);

        for (j = 0; j < 4; j++)
            for (i = 0; i < 4; i++)
                STORE3(4 * 2 + j, i + j, 3 * STAMP(i, j) + 0, 3 * STAMP(i, j) + 1, 3 * STAMP(i, j) + 2);

        for (j = 0; j < 4; j++)
            for (i = 0; i < 4; i++)
                STORE4(4 * 3 + j, i + j, 4 * STAMP(i, j) + 0, 4 * STAMP(i, j) + 1, 4 * STAMP(i, j) + 2, 4 * STAMP(i, j) + 3);

#undef STORE1
#undef STORE2
#undef STORE3
#undef STORE4
#undef STAMP

        for (j = 0; j < 4; j++)
        {
            for (i = 0; i < 4; i++)
            {
                unsigned int base_offset_words = chunk_size_words * (16 + 4 * j + i);

                for (word_index = 0; word_index < 8; word_index++)
                {
                    UINT value = get_readback_uint(&rb, base_offset_words + word_index, 0, 0);
                    UINT reference = expected_block[4 * j + i][word_index];
                    ok(value == reference, "Readback value for raw buffer iteration (%u, %u) is: %u\n", i, word_index, value);
                }
            }
        }
    }

    release_resource_readback(&rb);
    reset_command_list(command_list, context.allocator);

    ID3D12Resource_Release(output_buffer);
    ID3D12DescriptorHeap_Release(heap);
    ID3D12DescriptorHeap_Release(aux_cpu_heap);
    ID3D12DescriptorHeap_Release(aux_gpu_heap);
    destroy_test_context(&context);
}

void test_buffers_oob_behavior_dxbc(void)
{
    test_buffers_oob_behavior(false);
}

void test_buffers_oob_behavior_dxil(void)
{
    test_buffers_oob_behavior(true);
}

static void test_undefined_read_typed_buffer_as_untyped(bool use_dxil)
{
    D3D12_ROOT_SIGNATURE_DESC root_signature_desc;
    D3D12_ROOT_PARAMETER root_parameters[1];
    D3D12_DESCRIPTOR_RANGE descriptor_ranges[1];
    ID3D12DescriptorHeap *cpu_heap;
    ID3D12DescriptorHeap *heap;

    ID3D12Resource *output_buffer;
    struct resource_readback rb;

    ID3D12GraphicsCommandList *command_list;
    D3D12_CPU_DESCRIPTOR_HANDLE cpu_handle;
    D3D12_GPU_DESCRIPTOR_HANDLE gpu_handle;
    unsigned int i, descriptor_size;
    struct test_context context;
    ID3D12CommandQueue *queue;
    HRESULT hr;

#if 0
    RWStructuredBuffer<uint> Bufs[32] : register(u0, space0);
    RWByteAddressBuffer RawBufs[32] : register(u32, space0);

    [numthreads(64, 1, 1)]
    void main(uint thr : SV_DispatchThreadID)
    {
        if (thr < 32)
        {
            Bufs[NonUniformResourceIndex(thr)][0] = 4 * thr;
            Bufs[NonUniformResourceIndex(thr)][1] = 4 * thr + 1;
            Bufs[NonUniformResourceIndex(thr)][2] = 4 * thr + 2;
            Bufs[NonUniformResourceIndex(thr)][3] = 4 * thr + 3;
        }
        else
        {
            RawBufs[NonUniformResourceIndex(thr - 32)].Store4(0, 4 * thr + uint4(0, 1, 2, 3));
        }
    }
#endif
    static const DWORD cs_code_dxbc[] =
    {
        0x43425844, 0x796e68df, 0x8eea7bec, 0x05c401ff, 0x2a2c5db6, 0x00000001, 0x00000280, 0x00000003,
        0x0000002c, 0x0000003c, 0x0000004c, 0x4e475349, 0x00000008, 0x00000000, 0x00000008, 0x4e47534f,
        0x00000008, 0x00000000, 0x00000008, 0x58454853, 0x0000022c, 0x00050051, 0x0000008b, 0x0100086a,
        0x0700009e, 0x0031ee46, 0x00000000, 0x00000000, 0x0000001f, 0x00000004, 0x00000000, 0x0600009d,
        0x0031ee46, 0x00000001, 0x00000020, 0x0000003f, 0x00000000, 0x0200005f, 0x00020012, 0x02000068,
        0x00000002, 0x0400009b, 0x00000040, 0x00000001, 0x00000001, 0x0600004f, 0x00100012, 0x00000000,
        0x0002000a, 0x00004001, 0x00000020, 0x0304001f, 0x0010000a, 0x00000000, 0x06000029, 0x00100012,
        0x00000000, 0x0002000a, 0x00004001, 0x00000002, 0x04000036, 0x00100022, 0x00000000, 0x0002000a,
        0x0c0000a8, 0x8421e012, 0x00020001, 0x00000000, 0x0010001a, 0x00000000, 0x00004001, 0x00000000,
        0x00004001, 0x00000000, 0x0010000a, 0x00000000, 0x0e000023, 0x001000d2, 0x00000000, 0x00020006,
        0x00004002, 0x00000004, 0x00000000, 0x00000004, 0x00000004, 0x00004002, 0x00000001, 0x00000000,
        0x00000002, 0x00000003, 0x0c0000a8, 0x8421e012, 0x00020001, 0x00000000, 0x0010001a, 0x00000000,
        0x00004001, 0x00000001, 0x00004001, 0x00000000, 0x0010000a, 0x00000000, 0x0c0000a8, 0x8421e012,
        0x00020001, 0x00000000, 0x0010001a, 0x00000000, 0x00004001, 0x00000002, 0x00004001, 0x00000000,
        0x0010002a, 0x00000000, 0x0c0000a8, 0x8421e012, 0x00020001, 0x00000000, 0x0010001a, 0x00000000,
        0x00004001, 0x00000003, 0x00004001, 0x00000000, 0x0010003a, 0x00000000, 0x01000012, 0x0600001e,
        0x00100012, 0x00000000, 0x0002000a, 0x00004001, 0xffffffe0, 0x0e000023, 0x001000f2, 0x00000001,
        0x00020006, 0x00004002, 0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00004002, 0x00000000,
        0x00000001, 0x00000002, 0x00000003, 0x0b0000a6, 0x8621e0f2, 0x00020001, 0x00000001, 0x00000020,
        0x0010000a, 0x00000000, 0x00004001, 0x00000000, 0x00100e46, 0x00000001, 0x01000015, 0x0100003e,
    };
    static const BYTE cs_code_dxil[] =
    {
        0x44, 0x58, 0x42, 0x43, 0x54, 0x47, 0x19, 0x47, 0x31, 0x41, 0xbd, 0x02, 0x54, 0xec, 0x1c, 0x7d, 0x8e, 0x10, 0x57, 0x86, 0x01, 0x00, 0x00, 0x00, 0x94, 0x06, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
        0x34, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0xc8, 0x00, 0x00, 0x00, 0x53, 0x46, 0x49, 0x30, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x49, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x4f, 0x53, 0x47, 0x31, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x08, 0x00, 0x00, 0x00, 0x50, 0x53, 0x56, 0x30, 0x5c, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0xc4, 0x05, 0x00, 0x00, 0x60, 0x00, 0x05, 0x00, 0x71, 0x01, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0x00, 0x01, 0x00, 0x00,
        0x10, 0x00, 0x00, 0x00, 0xac, 0x05, 0x00, 0x00, 0x42, 0x43, 0xc0, 0xde, 0x21, 0x0c, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00, 0x0b, 0x82, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
        0x07, 0x81, 0x23, 0x91, 0x41, 0xc8, 0x04, 0x49, 0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c, 0x25, 0x05, 0x08, 0x19, 0x1e, 0x04, 0x8b, 0x62, 0x80, 0x14, 0x45, 0x02, 0x42, 0x92, 0x0b, 0x42,
        0xa4, 0x10, 0x32, 0x14, 0x38, 0x08, 0x18, 0x4b, 0x0a, 0x32, 0x52, 0x88, 0x48, 0x90, 0x14, 0x20, 0x43, 0x46, 0x88, 0xa5, 0x00, 0x19, 0x32, 0x42, 0xe4, 0x48, 0x0e, 0x90, 0x91, 0x22, 0xc4, 0x50,
        0x41, 0x51, 0x81, 0x8c, 0xe1, 0x83, 0xe5, 0x8a, 0x04, 0x29, 0x46, 0x06, 0x51, 0x18, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1b, 0x8c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x40, 0x02, 0xa8, 0x0d,
        0x86, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x20, 0x01, 0xd5, 0x06, 0x62, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x01, 0x90, 0x00, 0x49, 0x18, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x13, 0x82, 0x60, 0x42,
        0x20, 0x4c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x89, 0x20, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x32, 0x22, 0x48, 0x09, 0x20, 0x64, 0x85, 0x04, 0x93, 0x22, 0xa4, 0x84, 0x04, 0x93, 0x22, 0xe3,
        0x84, 0xa1, 0x90, 0x14, 0x12, 0x4c, 0x8a, 0x8c, 0x0b, 0x84, 0xa4, 0x4c, 0x10, 0x5c, 0x23, 0x00, 0x25, 0x00, 0x14, 0xe6, 0x08, 0xc0, 0xa0, 0x0c, 0x63, 0x0c, 0x22, 0x73, 0x04, 0x08, 0x99, 0x7b,
        0x86, 0xcb, 0x9f, 0xb0, 0x87, 0x90, 0xfc, 0x10, 0x68, 0x86, 0x85, 0x40, 0xc1, 0x99, 0x23, 0x08, 0x8a, 0x81, 0x86, 0x19, 0x23, 0x91, 0x2a, 0x0a, 0x18, 0x68, 0x8c, 0x31, 0xc6, 0x30, 0xc4, 0x06,
        0x02, 0x66, 0x32, 0x83, 0x71, 0x60, 0x87, 0x70, 0x98, 0x87, 0x79, 0x70, 0x03, 0x59, 0xb8, 0x85, 0x59, 0xa0, 0x07, 0x79, 0xa8, 0x87, 0x71, 0xa0, 0x87, 0x7a, 0x90, 0x87, 0x72, 0x20, 0x07, 0x51,
        0xa8, 0x07, 0x73, 0x30, 0x87, 0x72, 0x90, 0x07, 0x3e, 0xa8, 0x07, 0x77, 0x98, 0x87, 0x74, 0x38, 0x07, 0x77, 0x28, 0x07, 0x72, 0x00, 0x83, 0x74, 0x70, 0x07, 0x7a, 0xf0, 0x03, 0x14, 0x8c, 0x04,
        0x79, 0x04, 0x4f, 0x93, 0xa6, 0x88, 0x12, 0x26, 0x7f, 0x85, 0x37, 0x6c, 0x22, 0xb4, 0x61, 0x88, 0x08, 0x49, 0xda, 0xa8, 0xa2, 0x20, 0x22, 0x14, 0x8c, 0x04, 0x91, 0x34, 0xe7, 0x08, 0x40, 0x61,
        0x0a, 0x00, 0x00, 0x00, 0x13, 0x14, 0x72, 0xc0, 0x87, 0x74, 0x60, 0x87, 0x36, 0x68, 0x87, 0x79, 0x68, 0x03, 0x72, 0xc0, 0x87, 0x0d, 0xaf, 0x50, 0x0e, 0x6d, 0xd0, 0x0e, 0x7a, 0x50, 0x0e, 0x6d,
        0x00, 0x0f, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x78, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e,
        0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe9, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x76, 0x40, 0x07, 0x7a, 0x60, 0x07, 0x74, 0xd0, 0x06, 0xe6, 0x10,
        0x07, 0x76, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x60, 0x0e, 0x73, 0x20, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe6, 0x60, 0x07, 0x74, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x6d, 0xe0, 0x0e, 0x78,
        0xa0, 0x07, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x43, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x3c, 0x04, 0x10, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x79, 0x14, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xf2, 0x30, 0x40, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x90, 0x05, 0x02, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x32, 0x1e, 0x98, 0x14, 0x19, 0x11, 0x4c, 0x90, 0x8c, 0x09, 0x26, 0x47, 0xc6, 0x04, 0x43, 0x1a, 0x25, 0x30, 0x02, 0x50,
        0x08, 0xc5, 0x50, 0x40, 0x85, 0x51, 0x16, 0x05, 0x18, 0x40, 0x69, 0x04, 0x80, 0x6a, 0x81, 0x10, 0x9d, 0x01, 0xa0, 0x38, 0x03, 0x00, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00,
        0x1a, 0x03, 0x4c, 0x90, 0x46, 0x02, 0x13, 0xc4, 0x88, 0x0c, 0x6f, 0xec, 0xed, 0x4d, 0x0c, 0x44, 0x06, 0x26, 0x26, 0xc7, 0x05, 0xa6, 0xc6, 0x05, 0x06, 0x66, 0x43, 0x10, 0x4c, 0x10, 0x06, 0x62,
        0x82, 0x30, 0x14, 0x1b, 0x84, 0x81, 0x98, 0x20, 0x0c, 0xc6, 0x06, 0x61, 0x30, 0x28, 0x8c, 0xcd, 0x4d, 0x10, 0x86, 0x63, 0xc3, 0x80, 0x24, 0xc4, 0x04, 0x21, 0x7a, 0x08, 0x4c, 0x10, 0x06, 0x64,
        0x82, 0x30, 0x24, 0x13, 0x84, 0x84, 0xd9, 0xb0, 0x10, 0x0b, 0x43, 0x10, 0x8d, 0xf3, 0x3c, 0xcf, 0x31, 0x41, 0xa0, 0x9c, 0x09, 0xc2, 0xa0, 0x6c, 0x58, 0x86, 0x88, 0x21, 0x9a, 0x46, 0x7a, 0x9e,
        0x07, 0xd8, 0x20, 0x40, 0xd3, 0x06, 0x02, 0xa0, 0x00, 0x60, 0x82, 0x20, 0x00, 0x1b, 0x80, 0x0d, 0x03, 0x71, 0x5d, 0x1b, 0x02, 0x6c, 0xc3, 0x30, 0x58, 0x19, 0x89, 0xb6, 0xb0, 0x34, 0xb7, 0x09,
        0x42, 0xd5, 0x4c, 0x10, 0x86, 0x65, 0xc3, 0xd0, 0x0d, 0xc3, 0x06, 0x82, 0xe0, 0x0c, 0x6f, 0x43, 0x61, 0x6d, 0x40, 0xf5, 0x55, 0x61, 0x63, 0xb3, 0x6b, 0x73, 0x49, 0x23, 0x2b, 0x73, 0xa3, 0x9b,
        0x12, 0x04, 0x55, 0xc8, 0xf0, 0x5c, 0xec, 0xca, 0xe4, 0xe6, 0xd2, 0xde, 0xdc, 0xa6, 0x04, 0x44, 0x13, 0x32, 0x3c, 0x17, 0xbb, 0x30, 0x36, 0xbb, 0x32, 0xb9, 0x29, 0x81, 0x51, 0x87, 0x0c, 0xcf,
        0x65, 0x0e, 0x2d, 0x8c, 0xac, 0x4c, 0xae, 0xe9, 0x8d, 0xac, 0x8c, 0x6d, 0x4a, 0x90, 0x94, 0x21, 0xc3, 0x73, 0x91, 0x2b, 0x9b, 0x7b, 0xab, 0x93, 0x1b, 0x2b, 0x9b, 0x9b, 0x12, 0x50, 0x95, 0xc8,
        0xf0, 0x5c, 0xe8, 0xf2, 0xe0, 0xca, 0x82, 0xdc, 0xdc, 0xde, 0xe8, 0xc2, 0xe8, 0xd2, 0xde, 0xdc, 0xe6, 0xa6, 0x04, 0x59, 0x1d, 0x32, 0x3c, 0x97, 0x32, 0x37, 0x3a, 0xb9, 0x3c, 0xa8, 0xb7, 0x34,
        0x37, 0xba, 0xb9, 0x29, 0xc1, 0x07, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c, 0xc4, 0xe1, 0x1c, 0x66, 0x14, 0x01, 0x3d, 0x88, 0x43, 0x38, 0x84, 0xc3,
        0x8c, 0x42, 0x80, 0x07, 0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6, 0x00, 0x0f, 0xed, 0x10, 0x0e, 0xf4, 0x80, 0x0e, 0x33, 0x0c, 0x42, 0x1e, 0xc2, 0xc1, 0x1d, 0xce, 0xa1, 0x1c, 0x66, 0x30,
        0x05, 0x3d, 0x88, 0x43, 0x38, 0x84, 0x83, 0x1b, 0xcc, 0x03, 0x3d, 0xc8, 0x43, 0x3d, 0x8c, 0x03, 0x3d, 0xcc, 0x78, 0x8c, 0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79, 0x48, 0x87, 0x70, 0x70, 0x07,
        0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20, 0x87, 0x19, 0xcc, 0x11, 0x0e, 0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e, 0x30, 0x0f, 0xe3, 0xf0, 0x0e, 0xf0, 0x50, 0x0e, 0x33, 0x10, 0xc4, 0x1d,
        0xde, 0x21, 0x1c, 0xd8, 0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89, 0x3b, 0xbc, 0x83, 0x3b, 0xd0, 0x43, 0x39, 0xb4, 0x03, 0x3c, 0xbc, 0x83, 0x3c, 0x84, 0x03, 0x3b, 0xcc, 0xf0, 0x14, 0x76,
        0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x68, 0x87, 0x72, 0x68, 0x07, 0x37, 0x80, 0x87, 0x70, 0x90, 0x87, 0x70, 0x60, 0x07, 0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76, 0x78, 0x87, 0x77, 0x80, 0x87,
        0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98, 0x87, 0x79, 0x98, 0x81, 0x2c, 0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5, 0xc0, 0x0e, 0xec, 0x30, 0x03, 0x62, 0xc8, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c,
        0xcc, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c, 0xc4, 0x81, 0x1d, 0xca, 0x61, 0x06, 0xd6, 0x90, 0x43, 0x39, 0xc8, 0x43, 0x39, 0x98, 0x43, 0x39, 0xc8, 0x43, 0x39, 0xb8,
        0xc3, 0x38, 0x94, 0x43, 0x38, 0x88, 0x03, 0x3b, 0x94, 0xc3, 0x2f, 0xbc, 0x83, 0x3c, 0xfc, 0x82, 0x3b, 0xd4, 0x03, 0x3b, 0xb0, 0xc3, 0x8c, 0xcc, 0x21, 0x07, 0x7c, 0x70, 0x03, 0x74, 0x60, 0x07,
        0x37, 0x90, 0x87, 0x72, 0x98, 0x87, 0x77, 0xa8, 0x07, 0x79, 0x18, 0x87, 0x72, 0x70, 0x83, 0x70, 0xa0, 0x07, 0x7a, 0x90, 0x87, 0x74, 0x10, 0x87, 0x7a, 0xa0, 0x87, 0x72, 0x98, 0xe1, 0x3c, 0xe4,
        0x80, 0x0f, 0x6e, 0xe0, 0x0e, 0xef, 0xe0, 0x0e, 0xf5, 0xe0, 0x0e, 0xe9, 0x60, 0x0e, 0xef, 0x20, 0x0f, 0xed, 0x00, 0x00, 0x71, 0x20, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x36, 0x50, 0x0d, 0x97,
        0xef, 0x3c, 0x7e, 0x40, 0x15, 0x05, 0x11, 0xb1, 0x93, 0x13, 0x11, 0x3e, 0x72, 0xdb, 0x26, 0x20, 0x0d, 0x97, 0xef, 0x3c, 0xbe, 0x10, 0x11, 0xc0, 0x44, 0x84, 0x40, 0x33, 0x2c, 0x84, 0x05, 0x48,
        0xc3, 0xe5, 0x3b, 0x8f, 0x3f, 0x1d, 0x11, 0x01, 0x0c, 0xe2, 0xe0, 0x23, 0xb7, 0x6d, 0x00, 0x04, 0x03, 0x20, 0x0d, 0x00, 0x61, 0x20, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x13, 0x04, 0x44, 0x2c,
        0x10, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x34, 0x66, 0x00, 0x4a, 0x31, 0xa0, 0x08, 0xca, 0xa0, 0xe4, 0x4a, 0x37, 0xa0, 0x82, 0xc8, 0x94, 0x40, 0x79, 0x50, 0xaa, 0x01, 0x00, 0x00, 0x00,
        0x23, 0x06, 0x06, 0x00, 0x82, 0x60, 0x40, 0x64, 0x45, 0x35, 0xdc, 0x10, 0x4c, 0x64, 0x50, 0x82, 0x72, 0x15, 0x64, 0x5b, 0x02, 0xb3, 0x35, 0x30, 0x3b, 0xcb, 0x10, 0x08, 0x45, 0x19, 0x1b, 0x8c,
        0x18, 0x24, 0x00, 0x08, 0x82, 0x81, 0xf2, 0x35, 0x0a, 0x17, 0x20, 0x23, 0x06, 0x0d, 0x00, 0x82, 0x60, 0xc0, 0x7c, 0x51, 0xd0, 0x75, 0x86, 0x24, 0x49, 0xcb, 0x88, 0x41, 0x03, 0x80, 0x20, 0x18,
        0x30, 0x5f, 0x14, 0x78, 0x5d, 0x21, 0x49, 0xd2, 0x32, 0x62, 0xd0, 0x00, 0x20, 0x08, 0x06, 0xcc, 0x17, 0x05, 0x50, 0x47, 0x48, 0x92, 0xb4, 0x8c, 0x18, 0x34, 0x00, 0x08, 0x82, 0x01, 0xf3, 0x45,
        0xc1, 0xd3, 0x0d, 0x92, 0x24, 0x2d, 0xb3, 0x04, 0x43, 0x21, 0x0c, 0x54, 0xb0, 0xc1, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x28, 0x62, 0x00, 0x35, 0x60, 0x10, 0x2c, 0x23, 0x06, 0x0d, 0x00, 0x82,
        0x60, 0xc0, 0x88, 0x01, 0x15, 0x80, 0x41, 0x95, 0x20, 0x87, 0xd1, 0xcc, 0x12, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
    };

    if (!init_compute_test_context(&context))
        return;

    if (use_dxil && !context_supports_dxil(&context))
    {
        destroy_test_context(&context);
        return;
    }

    command_list = context.list;
    queue = context.queue;

    root_signature_desc.NumParameters = 1;
    root_signature_desc.Flags = 0;
    root_signature_desc.NumStaticSamplers = 0;
    root_signature_desc.pStaticSamplers = NULL;
    root_signature_desc.pParameters = root_parameters;

    root_parameters[0].ParameterType = D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE;
    root_parameters[0].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
    root_parameters[0].DescriptorTable.NumDescriptorRanges = 1;
    root_parameters[0].DescriptorTable.pDescriptorRanges = descriptor_ranges;

    descriptor_ranges[0].RegisterSpace = 0;
    descriptor_ranges[0].BaseShaderRegister = 0;
    descriptor_ranges[0].OffsetInDescriptorsFromTableStart = 0;
    descriptor_ranges[0].NumDescriptors = UINT_MAX;
    descriptor_ranges[0].RangeType = D3D12_DESCRIPTOR_RANGE_TYPE_UAV;

    hr = create_root_signature(context.device, &root_signature_desc, &context.root_signature);
    ok(SUCCEEDED(hr), "Failed to create root signature, hr %#x.\n", hr);

    output_buffer = create_default_buffer(context.device, 64 * 1024, D3D12_RESOURCE_FLAG_ALLOW_UNORDERED_ACCESS, D3D12_RESOURCE_STATE_UNORDERED_ACCESS);

    context.pipeline_state = create_compute_pipeline_state(context.device,
        context.root_signature,
        shader_bytecode(use_dxil ? (const void *)cs_code_dxil : (const void *)cs_code_dxbc,
            use_dxil ? sizeof(cs_code_dxil) : sizeof(cs_code_dxbc)));

    cpu_heap = create_cpu_descriptor_heap(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV, 64);
    heap = create_gpu_descriptor_heap(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV, 64);
    cpu_handle = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(cpu_heap);
    gpu_handle = ID3D12DescriptorHeap_GetGPUDescriptorHandleForHeapStart(heap);
    descriptor_size = ID3D12Device_GetDescriptorHandleIncrementSize(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV);

    for (i = 0; i < 64; i++)
    {
        D3D12_UNORDERED_ACCESS_VIEW_DESC view;
        D3D12_CPU_DESCRIPTOR_HANDLE h = cpu_handle;

        /* This is not legal, but it just works on native D3D12 drivers :( */
        view.Format = DXGI_FORMAT_R32_UINT;
        view.ViewDimension = D3D12_UAV_DIMENSION_BUFFER;
        view.Buffer.FirstElement = 4 * i;
        view.Buffer.NumElements = 4;
        view.Buffer.StructureByteStride = 0;
        view.Buffer.CounterOffsetInBytes = 0;
        view.Buffer.Flags = 0;
        h.ptr += i * descriptor_size;
        ID3D12Device_CreateUnorderedAccessView(context.device, output_buffer, NULL, &view, h);
    }

    ID3D12Device_CopyDescriptorsSimple(context.device, 64,
            ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(heap), cpu_handle,
            D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV);

    ID3D12GraphicsCommandList_SetComputeRootSignature(command_list, context.root_signature);
    ID3D12GraphicsCommandList_SetPipelineState(command_list, context.pipeline_state);
    ID3D12GraphicsCommandList_SetDescriptorHeaps(command_list, 1, &heap);
    ID3D12GraphicsCommandList_SetComputeRootDescriptorTable(command_list, 0, gpu_handle);
    ID3D12GraphicsCommandList_Dispatch(command_list, 1, 1, 1);

    transition_resource_state(command_list, output_buffer, D3D12_RESOURCE_STATE_UNORDERED_ACCESS, D3D12_RESOURCE_STATE_COPY_SOURCE);
    get_buffer_readback_with_command_list(output_buffer, DXGI_FORMAT_UNKNOWN, &rb, queue, command_list);

    for (i = 0; i < 256; i++)
    {
        UINT value = get_readback_uint(&rb, i, 0, 0);
        UINT reference = i;
        ok(value == reference, "Readback value for buffer iteration %u is: %u\n", i, value);
    }

    release_resource_readback(&rb);
    reset_command_list(command_list, context.allocator);

    ID3D12Resource_Release(output_buffer);
    ID3D12DescriptorHeap_Release(cpu_heap);
    ID3D12DescriptorHeap_Release(heap);
    destroy_test_context(&context);
}

void test_undefined_read_typed_buffer_as_untyped_dxbc(void)
{
    test_undefined_read_typed_buffer_as_untyped(false);
}

void test_undefined_read_typed_buffer_as_untyped_dxil(void)
{
    test_undefined_read_typed_buffer_as_untyped(true);
}

void test_null_descriptor_mismatch_type(void)
{
    /* A very cursed test. This is invalid in D3D12, but some games rely on this (or at least a subset) working ._. */
    D3D12_ROOT_SIGNATURE_DESC root_signature_desc;
    D3D12_DESCRIPTOR_RANGE descriptor_ranges[9];
    ID3D12DescriptorHeap *gpu_heap, *cpu_heap;
    D3D12_ROOT_PARAMETER root_parameters[2];

    ID3D12Resource *texture;
    ID3D12Resource *buffer;

    ID3D12Resource *output_buffer;
    struct resource_readback rb;

    ID3D12GraphicsCommandList *command_list;
    unsigned int i, descriptor_size;
    struct test_context context;
    ID3D12CommandQueue *queue;
    HRESULT hr;

#if 0
    struct C { uint v; };
    ConstantBuffer<C> CBuf[]: register(b0, space0);

    Texture2D<uint> ROTex2D[] : register(t0, space0);
    Buffer<uint> ROTyped[] : register(t0, space1);
    StructuredBuffer<uint> RORaw[] : register(t0, space2);

    RWTexture2D<uint> RWTex2D[] : register(u0, space0);
    RWBuffer<uint> RWTyped[] : register(u0, space1);
    RWStructuredBuffer<uint> RWRaw[] : register(u0, space2);

    RWStructuredBuffer<uint> RWOut : register(u0, space3);

    [numthreads(1, 1, 1)]
    void main(uint thr : SV_DispatchThreadID)
    {
        uint res = thr;
        res += RORaw[thr][0] != 0 ? 1000 : 0;
        res += RWRaw[thr][0] != 0 ? 10000 : 0;
        res += ROTyped[thr][0] != 0 ? 100000 : 0;
        res += RWTyped[thr][0] != 0 ? 1000000 : 0;
        res += ROTex2D[thr].Load(int3(thr, 0, 0)) != 0 ? 10000000 : 0;
        res += RWTex2D[thr].Load(int2(thr, 0)) != 0 ? 100000000 : 0;
        res += CBuf[thr].v != 0 ? 1000000000 : 0;
        RWOut[thr] = res;
    }
#endif
    static const DWORD cs_code[] =
    {
        0x43425844, 0xb4b5af4f, 0xf2d1b7d9, 0xbd7f2ac5, 0x1ea4ad33, 0x00000001, 0x00000490, 0x00000003,
        0x0000002c, 0x0000003c, 0x0000004c, 0x4e475349, 0x00000008, 0x00000000, 0x00000008, 0x4e47534f,
        0x00000008, 0x00000000, 0x00000008, 0x58454853, 0x0000043c, 0x00050051, 0x0000010f, 0x0100086a,
        0x07000859, 0x00308e46, 0x00000000, 0x00000000, 0xffffffff, 0x00000001, 0x00000000, 0x07001858,
        0x00307e46, 0x00000000, 0x00000000, 0xffffffff, 0x00004444, 0x00000000, 0x07000858, 0x00307e46,
        0x00000001, 0x00000000, 0xffffffff, 0x00004444, 0x00000001, 0x070000a2, 0x00307e46, 0x00000002,
        0x00000000, 0xffffffff, 0x00000004, 0x00000002, 0x0700189c, 0x0031ee46, 0x00000000, 0x00000000,
        0xffffffff, 0x00004444, 0x00000000, 0x0700089c, 0x0031ee46, 0x00000001, 0x00000000, 0xffffffff,
        0x00004444, 0x00000001, 0x0700009e, 0x0031ee46, 0x00000002, 0x00000000, 0xffffffff, 0x00000004,
        0x00000002, 0x0700009e, 0x0031ee46, 0x00000003, 0x00000000, 0x00000000, 0x00000004, 0x00000003,
        0x0200005f, 0x00020012, 0x02000068, 0x00000002, 0x0400009b, 0x00000001, 0x00000001, 0x00000001,
        0x04000036, 0x00100012, 0x00000000, 0x0002000a, 0x0b0000a7, 0x00100022, 0x00000000, 0x00004001,
        0x00000000, 0x00004001, 0x00000000, 0x04207006, 0x00000002, 0x0010000a, 0x00000000, 0x09000037,
        0x00100022, 0x00000000, 0x0010001a, 0x00000000, 0x00004001, 0x000003e8, 0x00004001, 0x00000000,
        0x0600001e, 0x00100022, 0x00000000, 0x0010001a, 0x00000000, 0x0002000a, 0x0b0000a7, 0x00100042,
        0x00000000, 0x00004001, 0x00000000, 0x00004001, 0x00000000, 0x0421e006, 0x00000002, 0x0010000a,
        0x00000000, 0x09000037, 0x00100042, 0x00000000, 0x0010002a, 0x00000000, 0x00004001, 0x00002710,
        0x00004001, 0x00000000, 0x0700001e, 0x00100022, 0x00000000, 0x0010002a, 0x00000000, 0x0010001a,
        0x00000000, 0x0c00002d, 0x00100042, 0x00000000, 0x00004002, 0x00000000, 0x00000000, 0x00000000,
        0x00000000, 0x04207c96, 0x00000001, 0x0010000a, 0x00000000, 0x09000037, 0x00100042, 0x00000000,
        0x0010002a, 0x00000000, 0x00004001, 0x000186a0, 0x00004001, 0x00000000, 0x0700001e, 0x00100022,
        0x00000000, 0x0010002a, 0x00000000, 0x0010001a, 0x00000000, 0x0c0000a3, 0x00100042, 0x00000000,
        0x00004002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0421ec96, 0x00000001, 0x0010000a,
        0x00000000, 0x09000037, 0x00100042, 0x00000000, 0x0010002a, 0x00000000, 0x00004001, 0x000f4240,
        0x00004001, 0x00000000, 0x0700001e, 0x00100022, 0x00000000, 0x0010002a, 0x00000000, 0x0010001a,
        0x00000000, 0x04000036, 0x00100012, 0x00000001, 0x0002000a, 0x08000036, 0x001000e2, 0x00000001,
        0x00004002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0900002d, 0x00100042, 0x00000000,
        0x00100fc6, 0x00000001, 0x04207c96, 0x00000000, 0x0010000a, 0x00000000, 0x09000037, 0x00100042,
        0x00000000, 0x0010002a, 0x00000000, 0x00004001, 0x00989680, 0x00004001, 0x00000000, 0x0700001e,
        0x00100022, 0x00000000, 0x0010002a, 0x00000000, 0x0010001a, 0x00000000, 0x090000a3, 0x00100042,
        0x00000000, 0x00100e46, 0x00000001, 0x0421ec96, 0x00000000, 0x0010000a, 0x00000000, 0x09000037,
        0x00100042, 0x00000000, 0x0010002a, 0x00000000, 0x00004001, 0x05f5e100, 0x00004001, 0x00000000,
        0x0700001e, 0x00100022, 0x00000000, 0x0010002a, 0x00000000, 0x0010001a, 0x00000000, 0x0c000037,
        0x00100012, 0x00000000, 0x0430800a, 0x00000000, 0x0010000a, 0x00000000, 0x00000000, 0x00004001,
        0x3b9aca00, 0x00004001, 0x00000000, 0x0700001e, 0x00100012, 0x00000000, 0x0010000a, 0x00000000,
        0x0010001a, 0x00000000, 0x090000a8, 0x0021e012, 0x00000003, 0x00000000, 0x0002000a, 0x00004001,
        0x00000000, 0x0010000a, 0x00000000, 0x0100003e,
    };

    if (!init_compute_test_context(&context))
        return;

    command_list = context.list;
    queue = context.queue;

    root_signature_desc.NumParameters = ARRAY_SIZE(root_parameters);
    root_signature_desc.Flags = 0;
    root_signature_desc.NumStaticSamplers = 0;
    root_signature_desc.pStaticSamplers = NULL;
    root_signature_desc.pParameters = root_parameters;

    root_parameters[0].ParameterType = D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE;
    root_parameters[0].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
    root_parameters[0].DescriptorTable.NumDescriptorRanges = ARRAY_SIZE(descriptor_ranges);
    root_parameters[0].DescriptorTable.pDescriptorRanges = &descriptor_ranges[0];

    root_parameters[1].ParameterType = D3D12_ROOT_PARAMETER_TYPE_UAV;
    root_parameters[1].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
    root_parameters[1].Descriptor.RegisterSpace = 3;
    root_parameters[1].Descriptor.ShaderRegister = 0;

    /* Need two idential ranges so we can alias two different resource dimensions over same table. */
    for (i = 0; i < ARRAY_SIZE(descriptor_ranges); i++)
    {
        descriptor_ranges[i].RegisterSpace = i % 3;
        descriptor_ranges[i].BaseShaderRegister = 0;
        descriptor_ranges[i].OffsetInDescriptorsFromTableStart = 512 * (i / 3);
        descriptor_ranges[i].NumDescriptors = 512;
    }

    for (i = 0; i < 3; i++)
    {
        descriptor_ranges[i + 0].RangeType = D3D12_DESCRIPTOR_RANGE_TYPE_SRV;
        descriptor_ranges[i + 3].RangeType = D3D12_DESCRIPTOR_RANGE_TYPE_UAV;
        descriptor_ranges[i + 6].RangeType = D3D12_DESCRIPTOR_RANGE_TYPE_CBV;
    }

    hr = create_root_signature(context.device, &root_signature_desc, &context.root_signature);
    ok(SUCCEEDED(hr), "Failed to create root signature, hr %#x.\n", hr);

    {
        const UINT buffer_data[] = { 1, 1, 1, 1 };
        buffer = create_default_buffer(context.device, 256, D3D12_RESOURCE_FLAG_ALLOW_UNORDERED_ACCESS, D3D12_RESOURCE_STATE_COPY_DEST);
        upload_buffer_data(buffer, 0, sizeof(buffer_data), buffer_data, queue, command_list);
        reset_command_list(command_list, context.allocator);
        transition_resource_state(command_list, buffer, D3D12_RESOURCE_STATE_COPY_DEST, D3D12_RESOURCE_STATE_NON_PIXEL_SHADER_RESOURCE);
    }

    {
        const UINT tex_data = 1;
        D3D12_SUBRESOURCE_DATA sub;
        sub.pData = &tex_data;
        sub.RowPitch = 1;
        sub.SlicePitch = 1;
        texture = create_default_texture2d(context.device, 1, 1, 1, 1, DXGI_FORMAT_R32_UINT, D3D12_RESOURCE_FLAG_ALLOW_UNORDERED_ACCESS, D3D12_RESOURCE_STATE_COPY_DEST);
        upload_texture_data(texture, &sub, 1, queue, command_list);
        reset_command_list(command_list, context.allocator);
        transition_resource_state(command_list, texture, D3D12_RESOURCE_STATE_COPY_DEST, D3D12_RESOURCE_STATE_NON_PIXEL_SHADER_RESOURCE);
    }
    output_buffer = create_default_buffer(context.device, 4 * 512, D3D12_RESOURCE_FLAG_ALLOW_UNORDERED_ACCESS, D3D12_RESOURCE_STATE_UNORDERED_ACCESS);

    context.pipeline_state = create_compute_pipeline_state(context.device, context.root_signature, shader_bytecode(cs_code, sizeof(cs_code)));

    gpu_heap = create_gpu_descriptor_heap(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV, 512 * 3);
    cpu_heap = create_cpu_descriptor_heap(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV, 7);
    descriptor_size = ID3D12Device_GetDescriptorHandleIncrementSize(context.device, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV);

    /* Stamp out valid descriptors across the heap. */
    for (i = 0; i < 512; i++)
    {
        D3D12_SHADER_RESOURCE_VIEW_DESC view;
        D3D12_CPU_DESCRIPTOR_HANDLE h;

        h = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(gpu_heap);
        h.ptr += (0 + i) * descriptor_size;
        view.Shader4ComponentMapping = D3D12_DEFAULT_SHADER_4_COMPONENT_MAPPING;
        view.Format = DXGI_FORMAT_R32_UINT;
        view.ViewDimension = D3D12_SRV_DIMENSION_TEXTURE2D;
        view.Texture2D.MipLevels = 1;
        view.Texture2D.MostDetailedMip = 0;
        view.Texture2D.PlaneSlice = 0;
        view.Texture2D.ResourceMinLODClamp = 0;
        ID3D12Device_CreateShaderResourceView(context.device, texture, &view, h);
    }

    for (i = 0; i < 512; i++)
    {
        D3D12_UNORDERED_ACCESS_VIEW_DESC view;
        D3D12_CPU_DESCRIPTOR_HANDLE h;

        h = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(gpu_heap);
        h.ptr += (512 + i) * descriptor_size;
        view.Format = DXGI_FORMAT_R32_UINT;
        view.ViewDimension = D3D12_UAV_DIMENSION_TEXTURE2D;
        view.Texture2D.PlaneSlice = 0;
        view.Texture2D.MipSlice = 0;
        ID3D12Device_CreateUnorderedAccessView(context.device, texture, NULL, &view, h);
    }

    for (i = 0; i < 512; i++)
    {
        D3D12_CONSTANT_BUFFER_VIEW_DESC view;
        D3D12_CPU_DESCRIPTOR_HANDLE h;

        h = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(gpu_heap);
        h.ptr += (1024 + i) * descriptor_size;
        view.BufferLocation = ID3D12Resource_GetGPUVirtualAddress(buffer);
        view.SizeInBytes = 256;
        ID3D12Device_CreateConstantBufferView(context.device, &view, h);
    }

    /* Create 7 template NULL descriptors which cover every possible descriptor type.
     * Allows us to test splat NULL descriptor copy. */
    {
        D3D12_UNORDERED_ACCESS_VIEW_DESC uav_tex, uav_typed, uav_raw;
        D3D12_SHADER_RESOURCE_VIEW_DESC srv_tex, srv_typed, srv_raw;
        D3D12_CPU_DESCRIPTOR_HANDLE gpu_h, cpu_h;
        D3D12_CONSTANT_BUFFER_VIEW_DESC cbv;

        cpu_h = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(cpu_heap);
        gpu_h = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(gpu_heap);

        cbv.BufferLocation = 0;
        cbv.SizeInBytes = 0;
        ID3D12Device_CreateConstantBufferView(context.device, &cbv, cpu_h);
        ID3D12Device_CreateConstantBufferView(context.device, &cbv, gpu_h);
        cpu_h.ptr += descriptor_size;
        gpu_h.ptr += descriptor_size;

        memset(&srv_tex, 0, sizeof(srv_tex));
        srv_tex.Shader4ComponentMapping = D3D12_DEFAULT_SHADER_4_COMPONENT_MAPPING;
        srv_tex.ViewDimension = D3D12_SRV_DIMENSION_TEXTURE2D;
        srv_tex.Format = DXGI_FORMAT_R32_UINT;
        srv_typed = srv_tex;
        srv_typed.ViewDimension = D3D12_SRV_DIMENSION_BUFFER;
        srv_raw = srv_typed;
        srv_raw.Format = DXGI_FORMAT_R32_TYPELESS;
        srv_raw.Buffer.Flags = D3D12_BUFFER_SRV_FLAG_RAW;

        /* SRV tex null descriptor is misinterpreted on AMD Windows native when read as a buffer. */
        ID3D12Device_CreateShaderResourceView(context.device, NULL, &srv_typed /*&srv_tex*/, cpu_h);
        ID3D12Device_CreateShaderResourceView(context.device, NULL, &srv_typed /*&srv_tex*/, gpu_h);
        cpu_h.ptr += descriptor_size;
        gpu_h.ptr += descriptor_size;
        ID3D12Device_CreateShaderResourceView(context.device, NULL, &srv_typed, cpu_h);
        ID3D12Device_CreateShaderResourceView(context.device, NULL, &srv_typed, gpu_h);
        cpu_h.ptr += descriptor_size;
        gpu_h.ptr += descriptor_size;
        ID3D12Device_CreateShaderResourceView(context.device, NULL, &srv_raw, cpu_h);
        ID3D12Device_CreateShaderResourceView(context.device, NULL, &srv_raw, gpu_h);
        cpu_h.ptr += descriptor_size;
        gpu_h.ptr += descriptor_size;

        memset(&uav_tex, 0, sizeof(uav_tex));
        uav_tex.ViewDimension = D3D12_UAV_DIMENSION_TEXTURE2D;
        uav_tex.Format = DXGI_FORMAT_R32_UINT;
        uav_typed = uav_tex;
        uav_typed.ViewDimension = D3D12_UAV_DIMENSION_BUFFER;
        uav_raw = uav_typed;
        uav_raw.Format = DXGI_FORMAT_R32_TYPELESS;
        uav_raw.Buffer.Flags = D3D12_BUFFER_UAV_FLAG_RAW;

        /* UAV tex null descriptor is misinterpreted on AMD Windows native when read as a buffer. */
        ID3D12Device_CreateUnorderedAccessView(context.device, NULL, NULL, &uav_typed /*&uav_tex*/, cpu_h);
        ID3D12Device_CreateUnorderedAccessView(context.device, NULL, NULL, &uav_typed /*&uav_tex*/, gpu_h);
        cpu_h.ptr += descriptor_size;
        gpu_h.ptr += descriptor_size;
        ID3D12Device_CreateUnorderedAccessView(context.device, NULL, NULL, &uav_typed, cpu_h);
        ID3D12Device_CreateUnorderedAccessView(context.device, NULL, NULL, &uav_typed, gpu_h);
        cpu_h.ptr += descriptor_size;
        gpu_h.ptr += descriptor_size;
        ID3D12Device_CreateUnorderedAccessView(context.device, NULL, NULL, &uav_raw, cpu_h);
        ID3D12Device_CreateUnorderedAccessView(context.device, NULL, NULL, &uav_raw, gpu_h);
        cpu_h.ptr += descriptor_size;
        gpu_h.ptr += descriptor_size;
    }

    /* Copy random NULL descriptors. The types won't match, but this "happens to work" on native drivers :(.
     * The first batch of NULL descriptors were written directly, which lets us test that path as well. */
    for (i = 7; i < 512 * 3; i++)
    {
        D3D12_CPU_DESCRIPTOR_HANDLE dst, src;
        dst = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(gpu_heap);
        src = ID3D12DescriptorHeap_GetCPUDescriptorHandleForHeapStart(cpu_heap);
        dst.ptr += descriptor_size * i;
        src.ptr += descriptor_size * (i % 7);
        ID3D12Device_CopyDescriptorsSimple(context.device, 1, dst, src, D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV);
    }

    ID3D12GraphicsCommandList_SetComputeRootSignature(command_list, context.root_signature);
    ID3D12GraphicsCommandList_SetPipelineState(command_list, context.pipeline_state);
    ID3D12GraphicsCommandList_SetDescriptorHeaps(command_list, 1, &gpu_heap);
    ID3D12GraphicsCommandList_SetComputeRootDescriptorTable(command_list, 0, ID3D12DescriptorHeap_GetGPUDescriptorHandleForHeapStart(gpu_heap));
    ID3D12GraphicsCommandList_SetComputeRootUnorderedAccessView(command_list, 1, ID3D12Resource_GetGPUVirtualAddress(output_buffer));
    ID3D12GraphicsCommandList_Dispatch(command_list, 512, 1, 1);

    transition_resource_state(command_list, output_buffer, D3D12_RESOURCE_STATE_UNORDERED_ACCESS, D3D12_RESOURCE_STATE_COPY_SOURCE);
    get_buffer_readback_with_command_list(output_buffer, DXGI_FORMAT_UNKNOWN, &rb, queue, command_list);

    for (i = 0; i < 512; i++)
    {
        UINT value = get_readback_uint(&rb, i, 0, 0);
        UINT reference = i;
        ok(value == reference, "Readback value [%u] is: %u\n", i, value);
    }

    release_resource_readback(&rb);
    reset_command_list(command_list, context.allocator);

    ID3D12Resource_Release(buffer);
    ID3D12Resource_Release(texture);
    ID3D12Resource_Release(output_buffer);
    ID3D12DescriptorHeap_Release(gpu_heap);
    ID3D12DescriptorHeap_Release(cpu_heap);
    destroy_test_context(&context);
}

