'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var cx = require('clsx');
var hljs = require('highlight.js');
var core = require('@mantine/core');
var CodeHighlight_module = require('./CodeHighlight.module.css.cjs');
var CodeHighlight_theme_module = require('./CodeHighlight.theme.module.css.cjs');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var cx__default = /*#__PURE__*/_interopDefault(cx);
var hljs__default = /*#__PURE__*/_interopDefault(hljs);

const classes = { ...CodeHighlight_module, code: cx__default.default(CodeHighlight_module.code, CodeHighlight_theme_module.theme) };
const defaultProps = {
  language: "tsx"
};
const InlineCodeHighlight = core.factory((_props, ref) => {
  const props = core.useProps("InlineCodeHighlight", defaultProps, _props);
  const { classNames, className, style, styles, unstyled, vars, code, language, ...others } = props;
  const getStyles = core.useStyles({
    name: "InlineCodeHighlight",
    props,
    classes,
    className,
    style,
    classNames,
    styles,
    unstyled,
    rootSelector: "code"
  });
  const highlighted = hljs__default.default.highlight(code.trim(), { language }).value;
  return /* @__PURE__ */ jsxRuntime.jsx(
    core.Box,
    {
      ...getStyles("code"),
      component: "code",
      ref,
      ...others,
      dangerouslySetInnerHTML: { __html: highlighted }
    }
  );
});
InlineCodeHighlight.displayName = "@mantine/core/InlineCodeHighlight";

exports.InlineCodeHighlight = InlineCodeHighlight;
//# sourceMappingURL=InlineCodeHighlight.cjs.map
