"use strict";

var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _server = _interopRequireDefault(require("react-dom/server"));
var _shallow = _interopRequireDefault(require("react-test-renderer/shallow"));
var _testUtils = _interopRequireDefault(require("react-dom/test-utils"));
var _checkPropTypes2 = _interopRequireDefault(require("prop-types/checkPropTypes"));
var _has = _interopRequireDefault(require("has"));
var _reactIs = require("react-is");
var _enzyme = require("enzyme");
var _Utils = require("enzyme/build/Utils");
var _enzymeShallowEqual = _interopRequireDefault(require("enzyme-shallow-equal"));
var _enzymeAdapterUtils = require("@wojtekmaj/enzyme-adapter-utils");
var _findCurrentFiberUsingSlowPath = _interopRequireDefault(require("./findCurrentFiberUsingSlowPath"));
var _detectFiberTags = _interopRequireDefault(require("./detectFiberTags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
// Lazily populated if DOM is available.
var FiberTags = null;
function nodeAndSiblingsArray(nodeWithSibling) {
  var array = [];
  var node = nodeWithSibling;
  while (node != null) {
    array.push(node);
    node = node.sibling;
  }
  return array;
}
function flatten(arr) {
  var result = [];
  var stack = [{
    i: 0,
    array: arr
  }];
  while (stack.length) {
    var n = stack.pop();
    while (n.i < n.array.length) {
      var el = n.array[n.i];
      n.i += 1;
      if (Array.isArray(el)) {
        stack.push(n);
        stack.push({
          i: 0,
          array: el
        });
        break;
      }
      result.push(el);
    }
  }
  return result;
}
function nodeTypeFromType(type) {
  if (type === _reactIs.Portal) {
    return 'portal';
  }
  return (0, _enzymeAdapterUtils.nodeTypeFromType)(type);
}
function isMemo(type) {
  return (0, _enzymeAdapterUtils.compareNodeTypeOf)(type, _reactIs.Memo);
}
function isLazy(type) {
  return (0, _enzymeAdapterUtils.compareNodeTypeOf)(type, _reactIs.Lazy);
}
function unmemoType(type) {
  return isMemo(type) ? type.type : type;
}
function checkIsSuspenseAndCloneElement(el, _ref) {
  var suspenseFallback = _ref.suspenseFallback;
  if (!(0, _reactIs.isSuspense)(el)) {
    return el;
  }
  var children = el.props.children;
  if (suspenseFallback) {
    var fallback = el.props.fallback;
    children = replaceLazyWithFallback(children, fallback);
  }
  var FakeSuspenseWrapper = function FakeSuspenseWrapper(props) {
    return /*#__PURE__*/_react["default"].createElement(el.type, _objectSpread(_objectSpread({}, el.props), props), children);
  };
  return /*#__PURE__*/_react["default"].createElement(FakeSuspenseWrapper, null, children);
}
function elementToTree(el) {
  if (!(0, _reactIs.isPortal)(el)) {
    return (0, _enzymeAdapterUtils.elementToTree)(el, elementToTree);
  }
  var children = el.children,
    containerInfo = el.containerInfo;
  var props = {
    children: children,
    containerInfo: containerInfo
  };
  return {
    nodeType: 'portal',
    type: _reactIs.Portal,
    props: props,
    key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(el.key),
    ref: el.ref || null,
    instance: null,
    rendered: elementToTree(el.children)
  };
}
function _toTree(vnode) {
  if (vnode == null) {
    return null;
  }
  // TODO(lmr): I'm not really sure I understand whether or not this is what
  // i should be doing, or if this is a hack for something i'm doing wrong
  // somewhere else. Should talk to sebastian about this perhaps
  var node = (0, _findCurrentFiberUsingSlowPath["default"])(vnode);
  switch (node.tag) {
    case FiberTags.HostRoot:
      return childrenToTree(node.child);
    case FiberTags.HostPortal:
      {
        var containerInfo = node.stateNode.containerInfo,
          children = node.memoizedProps;
        var props = {
          containerInfo: containerInfo,
          children: children
        };
        return {
          nodeType: 'portal',
          type: _reactIs.Portal,
          props: props,
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.ClassComponent:
      return {
        nodeType: 'class',
        type: node.type,
        props: _objectSpread({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: node.stateNode,
        rendered: childrenToTree(node.child)
      };
    case FiberTags.FunctionalComponent:
      return {
        nodeType: 'function',
        type: node.type,
        props: _objectSpread({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: null,
        rendered: childrenToTree(node.child)
      };
    case FiberTags.MemoClass:
      return {
        nodeType: 'class',
        type: node.elementType.type,
        props: _objectSpread({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: node.stateNode,
        rendered: childrenToTree(node.child.child)
      };
    case FiberTags.MemoSFC:
      {
        var renderedNodes = flatten(nodeAndSiblingsArray(node.child).map(_toTree));
        if (renderedNodes.length === 0) {
          renderedNodes = childrenToTree(node.memoizedProps.children);
        }
        return {
          nodeType: 'function',
          type: node.elementType,
          props: _objectSpread({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: renderedNodes
        };
      }
    case FiberTags.HostComponent:
      {
        var _renderedNodes = flatten(nodeAndSiblingsArray(node.child).map(_toTree));
        if (_renderedNodes.length === 0) {
          _renderedNodes = [node.memoizedProps.children];
        }
        return {
          nodeType: 'host',
          type: node.type,
          props: _objectSpread({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: node.stateNode,
          rendered: _renderedNodes
        };
      }
    case FiberTags.HostText:
      return node.memoizedProps;
    case FiberTags.Fragment:
    case FiberTags.Mode:
    case FiberTags.ContextProvider:
    case FiberTags.ContextConsumer:
      return childrenToTree(node.child);
    case FiberTags.Profiler:
    case FiberTags.ForwardRef:
      {
        return {
          nodeType: 'function',
          type: node.type,
          props: _objectSpread({}, node.pendingProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.Suspense:
      {
        return {
          nodeType: 'function',
          type: _reactIs.Suspense,
          props: _objectSpread({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.Lazy:
      return childrenToTree(node.child);
    case FiberTags.OffscreenComponent:
      return childrenToTree(node.child);
    default:
      throw new Error("Enzyme Internal Error: unknown node with tag ".concat(node.tag));
  }
}
function childrenToTree(node) {
  if (!node) {
    return null;
  }
  var children = nodeAndSiblingsArray(node);
  if (children.length === 0) {
    return null;
  }
  if (children.length === 1) {
    return _toTree(children[0]);
  }
  return flatten(children.map(_toTree));
}
function _nodeToHostNode(_node) {
  // NOTE(lmr): node could be a function component
  // which wont have an instance prop, but we can get the
  // host node associated with its return value at that point.
  // Although this breaks down if the return value is an array,
  // as is possible with React 16.
  var node = _node;
  while (node && !Array.isArray(node) && node.instance === null) {
    node = node.rendered;
  }
  // if the SFC returned null effectively, there is no host node.
  if (!node) {
    return null;
  }
  var mapper = function mapper(item) {
    if (item && item.instance) return _reactDom["default"].findDOMNode(item.instance);
    return null;
  };
  if (Array.isArray(node)) {
    return node.map(mapper);
  }
  if (Array.isArray(node.rendered) && node.nodeType === 'class') {
    return node.rendered.map(mapper);
  }
  return mapper(node);
}
function replaceLazyWithFallback(node, fallback) {
  if (!node) {
    return null;
  }
  if (Array.isArray(node)) {
    return node.map(function (el) {
      return replaceLazyWithFallback(el, fallback);
    });
  }
  if (isLazy(node.type)) {
    return fallback;
  }
  return _objectSpread(_objectSpread({}, node), {}, {
    props: _objectSpread(_objectSpread({}, node.props), {}, {
      children: replaceLazyWithFallback(node.props.children, fallback)
    })
  });
}
function wrapAct(fn) {
  var returnVal;
  _testUtils["default"].act(function () {
    returnVal = fn();
  });
  return returnVal;
}
function getProviderDefaultValue(Provider) {
  // React stores references to the Provider's defaultValue differently across versions.
  if ('_defaultValue' in Provider._context) {
    return Provider._context._defaultValue;
  }
  if ('_currentValue' in Provider._context) {
    return Provider._context._currentValue;
  }
  throw new Error('Enzyme Internal Error: can’t figure out how to get Provider’s default value');
}
function makeFakeElement(type) {
  return {
    $$typeof: _reactIs.Element,
    type: type
  };
}
function isStateful(Component) {
  return Component.prototype && (Component.prototype.isReactComponent || Array.isArray(Component.__reactAutoBindPairs)) // fallback for createClass components
  ;
}
var ReactSeventeenAdapter = /*#__PURE__*/function (_EnzymeAdapter) {
  _inherits(ReactSeventeenAdapter, _EnzymeAdapter);
  var _super = _createSuper(ReactSeventeenAdapter);
  function ReactSeventeenAdapter() {
    var _this;
    _classCallCheck(this, ReactSeventeenAdapter);
    _this = _super.call(this);
    var lifecycles = _this.options.lifecycles;
    _this.options = _objectSpread(_objectSpread({}, _this.options), {}, {
      enableComponentDidUpdateOnSetState: true,
      // TODO: remove, semver-major
      legacyContextMode: 'parent',
      lifecycles: _objectSpread(_objectSpread({}, lifecycles), {}, {
        componentDidUpdate: {
          onSetState: true
        },
        getDerivedStateFromProps: {
          hasShouldComponentUpdateBug: false
        },
        getSnapshotBeforeUpdate: true,
        setState: {
          skipsComponentDidUpdateOnNullish: true
        },
        getChildContext: {
          calledByRenderer: false
        },
        getDerivedStateFromError: true
      })
    });
    return _this;
  }
  _createClass(ReactSeventeenAdapter, [{
    key: "createMountRenderer",
    value: function createMountRenderer(options) {
      (0, _enzymeAdapterUtils.assertDomAvailable)('mount');
      if ((0, _has["default"])(options, 'suspenseFallback')) {
        throw new TypeError('`suspenseFallback` is not supported by the `mount` renderer');
      }
      if (FiberTags === null) {
        // Requires DOM.
        FiberTags = (0, _detectFiberTags["default"])();
      }
      var attachTo = options.attachTo,
        hydrateIn = options.hydrateIn,
        wrappingComponentProps = options.wrappingComponentProps;
      var domNode = hydrateIn || attachTo || global.document.createElement('div');
      var instance = null;
      var adapter = this;
      return {
        render: function render(el, context, callback) {
          return wrapAct(function () {
            if (instance === null) {
              var type = el.type,
                props = el.props,
                ref = el.ref;
              var wrapperProps = _objectSpread({
                Component: type,
                props: props,
                wrappingComponentProps: wrappingComponentProps,
                context: context
              }, ref && {
                refProp: ref
              });
              var ReactWrapperComponent = (0, _enzymeAdapterUtils.createMountWrapper)(el, _objectSpread(_objectSpread({}, options), {}, {
                adapter: adapter
              }));
              var wrappedEl = /*#__PURE__*/_react["default"].createElement(ReactWrapperComponent, wrapperProps);
              instance = hydrateIn ? _reactDom["default"].hydrate(wrappedEl, domNode) : _reactDom["default"].render(wrappedEl, domNode);
              if (typeof callback === 'function') {
                callback();
              }
            } else {
              instance.setChildProps(el.props, context, callback);
            }
          });
        },
        unmount: function unmount() {
          wrapAct(function () {
            _reactDom["default"].unmountComponentAtNode(domNode);
          });
          instance = null;
        },
        getNode: function getNode() {
          if (!instance) {
            return null;
          }
          return (0, _enzymeAdapterUtils.getNodeFromRootFinder)(adapter.isCustomComponent, _toTree(instance._reactInternals), options);
        },
        simulateError: function simulateError(nodeHierarchy, rootNode, error) {
          var isErrorBoundary = function isErrorBoundary(_ref2) {
            var elInstance = _ref2.instance,
              type = _ref2.type;
            if (type && type.getDerivedStateFromError) {
              return true;
            }
            return elInstance && elInstance.componentDidCatch;
          };
          var _ref3 = nodeHierarchy.find(isErrorBoundary) || {},
            catchingInstance = _ref3.instance,
            catchingType = _ref3.type;
          (0, _enzymeAdapterUtils.simulateError)(error, catchingInstance, nodeHierarchy, nodeTypeFromType, adapter.displayNameOfNode.bind(adapter), catchingType);
        },
        simulateEvent: function simulateEvent(node, event, mock) {
          var mappedEvent = (0, _enzymeAdapterUtils.mapNativeEventNames)(event);
          var eventFn = _testUtils["default"].Simulate[mappedEvent];
          if (!eventFn) {
            throw new TypeError("ReactWrapper::simulate() event '".concat(event, "' does not exist"));
          }
          wrapAct(function () {
            eventFn(adapter.nodeToHostNode(node), mock);
          });
        },
        batchedUpdates: function batchedUpdates(fn) {
          return fn();
          // return ReactDOM.unstable_batchedUpdates(fn);
        },
        getWrappingComponentRenderer: function getWrappingComponentRenderer() {
          return _objectSpread(_objectSpread({}, this), (0, _enzymeAdapterUtils.getWrappingComponentMountRenderer)({
            toTree: function toTree(inst) {
              return _toTree(inst._reactInternals);
            },
            getMountWrapperInstance: function getMountWrapperInstance() {
              return instance;
            }
          }));
        },
        wrapInvoke: wrapAct
      };
    }
  }, {
    key: "createShallowRenderer",
    value: function createShallowRenderer() {
      var _this2 = this;
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var adapter = this;
      var renderer = new _shallow["default"]();
      var suspenseFallback = options.suspenseFallback;
      if (typeof suspenseFallback !== 'undefined' && typeof suspenseFallback !== 'boolean') {
        throw TypeError('`options.suspenseFallback` should be boolean or undefined');
      }
      var isDOM = false;
      var cachedNode = null;
      var lastComponent = null;
      var wrappedComponent = null;
      var sentinel = {};

      // wrap memo components with a PureComponent, or a class component with sCU
      var wrapPureComponent = function wrapPureComponent(Component, compare) {
        if (lastComponent !== Component) {
          if (isStateful(Component)) {
            wrappedComponent = /*#__PURE__*/function (_Component) {
              _inherits(wrappedComponent, _Component);
              var _super2 = _createSuper(wrappedComponent);
              function wrappedComponent() {
                _classCallCheck(this, wrappedComponent);
                return _super2.apply(this, arguments);
              }
              return _createClass(wrappedComponent);
            }(Component);
            if (compare) {
              wrappedComponent.prototype.shouldComponentUpdate = function (nextProps) {
                return !compare(_this2.props, nextProps);
              };
            } else {
              wrappedComponent.prototype.isPureReactComponent = true;
            }
          } else {
            var memoized = sentinel;
            var prevProps;
            wrappedComponent = function wrappedComponentFn(props) {
              var shouldUpdate = memoized === sentinel || (compare ? !compare(prevProps, props) : !(0, _enzymeShallowEqual["default"])(prevProps, props));
              if (shouldUpdate) {
                for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                  args[_key - 1] = arguments[_key];
                }
                memoized = Component.apply(void 0, [_objectSpread(_objectSpread({}, Component.defaultProps), props)].concat(args));
                prevProps = props;
              }
              return memoized;
            };
          }
          Object.assign(wrappedComponent, Component, {
            displayName: adapter.displayNameOfNode({
              type: Component
            })
          });
          lastComponent = Component;
        }
        return wrappedComponent;
      };

      // Wrap functional components on versions prior to 16.5,
      // to avoid inadvertently pass a `this` instance to it.
      var wrapFunctionalComponent = function wrapFunctionalComponent(Component) {
        if ((0, _has["default"])(Component, 'defaultProps')) {
          if (lastComponent !== Component) {
            wrappedComponent = Object.assign(function (props) {
              for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
                args[_key2 - 1] = arguments[_key2];
              }
              return Component.apply(void 0, [_objectSpread(_objectSpread({}, Component.defaultProps), props)].concat(args));
            }, Component, {
              displayName: adapter.displayNameOfNode({
                type: Component
              })
            });
            lastComponent = Component;
          }
          return wrappedComponent;
        }
        return Component;
      };
      var renderElement = function renderElement(elConfig) {
        for (var _len3 = arguments.length, rest = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
          rest[_key3 - 1] = arguments[_key3];
        }
        var renderedEl = renderer.render.apply(renderer, [elConfig].concat(rest));
        var typeIsExisted = !!(renderedEl && renderedEl.type);
        if (typeIsExisted) {
          var clonedEl = checkIsSuspenseAndCloneElement(renderedEl, {
            suspenseFallback: suspenseFallback
          });
          var elementIsChanged = clonedEl.type !== renderedEl.type;
          if (elementIsChanged) {
            return renderer.render.apply(renderer, [_objectSpread(_objectSpread({}, elConfig), {}, {
              type: clonedEl.type
            })].concat(rest));
          }
        }
        return renderedEl;
      };
      return {
        render: function render(el, unmaskedContext) {
          var _ref4 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
            _ref4$providerValues = _ref4.providerValues,
            providerValues = _ref4$providerValues === void 0 ? new Map() : _ref4$providerValues;
          cachedNode = el;
          if (typeof el.type === 'string') {
            isDOM = true;
          } else if ((0, _reactIs.isContextProvider)(el)) {
            providerValues.set(el.type, el.props.value);
            var MockProvider = Object.assign(function (props) {
              return props.children;
            }, el.type);
            return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
              return renderElement(_objectSpread(_objectSpread({}, el), {}, {
                type: MockProvider
              }));
            });
          } else if ((0, _reactIs.isContextConsumer)(el)) {
            var Provider = adapter.getProviderFromConsumer(el.type);
            var value = providerValues.has(Provider) ? providerValues.get(Provider) : getProviderDefaultValue(Provider);
            var MockConsumer = Object.assign(function (props) {
              return props.children(value);
            }, el.type);
            return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
              return renderElement(_objectSpread(_objectSpread({}, el), {}, {
                type: MockConsumer
              }));
            });
          } else {
            isDOM = false;
            var renderedEl = el;
            if (isLazy(renderedEl)) {
              throw TypeError('`React.lazy` is not supported by shallow rendering.');
            }
            renderedEl = checkIsSuspenseAndCloneElement(renderedEl, {
              suspenseFallback: suspenseFallback
            });
            var _renderedEl = renderedEl,
              Component = _renderedEl.type;
            var context = (0, _enzymeAdapterUtils.getMaskedContext)(Component.contextTypes, unmaskedContext);
            if (isMemo(el.type)) {
              var _el$type = el.type,
                InnerComp = _el$type.type,
                compare = _el$type.compare;
              return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                return renderElement(_objectSpread(_objectSpread({}, el), {}, {
                  type: wrapPureComponent(InnerComp, compare)
                }), context);
              });
            }
            var isComponentStateful = isStateful(Component);
            if (!isComponentStateful && typeof Component === 'function') {
              return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                return renderElement(_objectSpread(_objectSpread({}, renderedEl), {}, {
                  type: wrapFunctionalComponent(Component)
                }), context);
              });
            }
            if (isComponentStateful && renderer._instance && el.props === renderer._instance.props && !(0, _enzymeShallowEqual["default"])(context, renderer._instance.context)) {
              var _spyMethod = (0, _enzymeAdapterUtils.spyMethod)(renderer, '_updateClassComponent', function (originalMethod) {
                  return function _updateClassComponent() {
                    var props = renderer._instance.props;
                    var clonedProps = _objectSpread({}, props);
                    renderer._instance.props = clonedProps;
                    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
                      args[_key4] = arguments[_key4];
                    }
                    var result = originalMethod.apply(renderer, args);
                    renderer._instance.props = props;
                    restore();
                    return result;
                  };
                }),
                restore = _spyMethod.restore;
            }
            return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
              return renderElement(renderedEl, context);
            });
          }
        },
        unmount: function unmount() {
          renderer.unmount();
        },
        getNode: function getNode() {
          if (isDOM) {
            return elementToTree(cachedNode);
          }
          var output = renderer.getRenderOutput();
          return {
            nodeType: nodeTypeFromType(cachedNode.type),
            type: cachedNode.type,
            props: cachedNode.props,
            key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(cachedNode.key),
            ref: cachedNode.ref,
            instance: renderer._instance,
            rendered: Array.isArray(output) ? flatten(output).map(function (el) {
              return elementToTree(el);
            }) : elementToTree(output)
          };
        },
        simulateError: function simulateError(nodeHierarchy, rootNode, error) {
          (0, _enzymeAdapterUtils.simulateError)(error, renderer._instance, nodeHierarchy.concat(cachedNode), nodeTypeFromType, adapter.displayNameOfNode.bind(adapter), cachedNode.type);
        },
        simulateEvent: function simulateEvent(node, event) {
          for (var _len5 = arguments.length, args = new Array(_len5 > 2 ? _len5 - 2 : 0), _key5 = 2; _key5 < _len5; _key5++) {
            args[_key5 - 2] = arguments[_key5];
          }
          var handler = node.props[(0, _enzymeAdapterUtils.propFromEvent)(event)];
          if (handler) {
            (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
              // TODO(lmr): create/use synthetic events
              // TODO(lmr): emulate React's event propagation
              // ReactDOM.unstable_batchedUpdates(() => {
              handler.apply(void 0, args);
              // });
            });
          }
        },
        batchedUpdates: function batchedUpdates(fn) {
          return fn();
          // return ReactDOM.unstable_batchedUpdates(fn);
        },
        checkPropTypes: function checkPropTypes(typeSpecs, values, location, hierarchy) {
          return (0, _checkPropTypes2["default"])(typeSpecs, values, location, (0, _enzymeAdapterUtils.displayNameOfNode)(cachedNode), function () {
            return (0, _enzymeAdapterUtils.getComponentStack)(hierarchy.concat([cachedNode]));
          });
        }
      };
    }
  }, {
    key: "createStringRenderer",
    value: function createStringRenderer(options) {
      if ((0, _has["default"])(options, 'suspenseFallback')) {
        throw new TypeError('`suspenseFallback` should not be specified in options of string renderer');
      }
      return {
        render: function render(el, context) {
          if (options.context && (el.type.contextTypes || options.childContextTypes)) {
            var childContextTypes = _objectSpread(_objectSpread({}, el.type.contextTypes || {}), options.childContextTypes);
            var ContextWrapper = (0, _enzymeAdapterUtils.createRenderWrapper)(el, context, childContextTypes);
            return _server["default"].renderToStaticMarkup( /*#__PURE__*/_react["default"].createElement(ContextWrapper));
          }
          return _server["default"].renderToStaticMarkup(el);
        }
      };
    }

    // Provided a bag of options, return an `EnzymeRenderer`. Some options can be implementation
    // specific, like `attach` etc. for React, but not part of this interface explicitly.
  }, {
    key: "createRenderer",
    value: function createRenderer(options) {
      switch (options.mode) {
        case _enzyme.EnzymeAdapter.MODES.MOUNT:
          return this.createMountRenderer(options);
        case _enzyme.EnzymeAdapter.MODES.SHALLOW:
          return this.createShallowRenderer(options);
        case _enzyme.EnzymeAdapter.MODES.STRING:
          return this.createStringRenderer(options);
        default:
          throw new Error("Enzyme Internal Error: Unrecognized mode: ".concat(options.mode));
      }
    }
  }, {
    key: "wrap",
    value: function wrap(element) {
      return (0, _enzymeAdapterUtils.wrap)(element);
    }

    // converts an RSTNode to the corresponding JSX Pragma Element. This will be needed
    // in order to implement the `Wrapper.mount()` and `Wrapper.shallow()` methods, but should
    // be pretty straightforward for people to implement.
  }, {
    key: "nodeToElement",
    value: function nodeToElement(node) {
      if (!node || _typeof(node) !== 'object') return null;
      var type = node.type;
      return /*#__PURE__*/_react["default"].createElement(unmemoType(type), (0, _enzymeAdapterUtils.propsWithKeysAndRef)(node));
    }
  }, {
    key: "matchesElementType",
    value: function matchesElementType(node, matchingType) {
      if (!node) {
        return node;
      }
      var type = node.type;
      return unmemoType(type) === unmemoType(matchingType);
    }
  }, {
    key: "elementToNode",
    value: function elementToNode(element) {
      return elementToTree(element);
    }
  }, {
    key: "nodeToHostNode",
    value: function nodeToHostNode(node) {
      var supportsArray = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var nodes = _nodeToHostNode(node);
      if (Array.isArray(nodes) && !supportsArray) {
        // get the first non-null node
        return nodes.filter(Boolean)[0];
      }
      return nodes;
    }
  }, {
    key: "displayNameOfNode",
    value: function displayNameOfNode(node) {
      if (!node) return null;
      var type = node.type,
        $$typeof = node.$$typeof;
      var adapter = this;
      var nodeType = type || $$typeof;

      // newer node types may be undefined, so only test if the nodeType exists
      if (nodeType) {
        switch (nodeType) {
          case _reactIs.ConcurrentMode || NaN:
            return 'ConcurrentMode';
          case _reactIs.Fragment || NaN:
            return 'Fragment';
          case _reactIs.StrictMode || NaN:
            return 'StrictMode';
          case _reactIs.Profiler || NaN:
            return 'Profiler';
          case _reactIs.Portal || NaN:
            return 'Portal';
          case _reactIs.Suspense || NaN:
            return 'Suspense';
          default:
        }
      }
      var $$typeofType = type && type.$$typeof;
      switch ($$typeofType) {
        case _reactIs.ContextConsumer || NaN:
          return 'ContextConsumer';
        case _reactIs.ContextProvider || NaN:
          return 'ContextProvider';
        case _reactIs.Memo || NaN:
          {
            var nodeName = (0, _enzymeAdapterUtils.displayNameOfNode)(node);
            return typeof nodeName === 'string' ? nodeName : "Memo(".concat(adapter.displayNameOfNode(type), ")");
          }
        case _reactIs.ForwardRef || NaN:
          {
            if (type.displayName) {
              return type.displayName;
            }
            var name = adapter.displayNameOfNode({
              type: type.render
            });
            return name ? "ForwardRef(".concat(name, ")") : 'ForwardRef';
          }
        case _reactIs.Lazy || NaN:
          {
            return 'lazy';
          }
        default:
          return (0, _enzymeAdapterUtils.displayNameOfNode)(node);
      }
    }
  }, {
    key: "isValidElement",
    value: function isValidElement(element) {
      return (0, _reactIs.isElement)(element);
    }
  }, {
    key: "isValidElementType",
    value: function isValidElementType(object) {
      return !!object && (0, _reactIs.isValidElementType)(object);
    }
  }, {
    key: "isFragment",
    value: function isFragment(fragment) {
      return (0, _Utils.typeOfNode)(fragment) === _reactIs.Fragment;
    }
  }, {
    key: "isCustomComponent",
    value: function isCustomComponent(type) {
      var fakeElement = makeFakeElement(type);
      return !!type && (typeof type === 'function' || (0, _reactIs.isForwardRef)(fakeElement) || (0, _reactIs.isContextProvider)(fakeElement) || (0, _reactIs.isContextConsumer)(fakeElement) || (0, _reactIs.isSuspense)(fakeElement));
    }
  }, {
    key: "isContextConsumer",
    value: function isContextConsumer(type) {
      return !!type && (0, _reactIs.isContextConsumer)(makeFakeElement(type));
    }
  }, {
    key: "isCustomComponentElement",
    value: function isCustomComponentElement(inst) {
      if (!inst || !this.isValidElement(inst)) {
        return false;
      }
      return this.isCustomComponent(inst.type);
    }
  }, {
    key: "getProviderFromConsumer",
    value: function getProviderFromConsumer(Consumer) {
      // React stores references to the Provider on a Consumer differently across versions.
      if (Consumer) {
        var Provider;
        if (Consumer._context) {
          // check this first, to avoid a deprecation warning
          Provider = Consumer._context.Provider;
        } else if (Consumer.Provider) {
          Provider = Consumer.Provider;
        }
        if (Provider) {
          return Provider;
        }
      }
      throw new Error('Enzyme Internal Error: can’t figure out how to get Provider from Consumer');
    }
  }, {
    key: "createElement",
    value: function createElement() {
      return /*#__PURE__*/_react["default"].createElement.apply(_react["default"], arguments);
    }
  }, {
    key: "wrapWithWrappingComponent",
    value: function wrapWithWrappingComponent(node, options) {
      return {
        RootFinder: _enzymeAdapterUtils.RootFinder,
        node: (0, _enzymeAdapterUtils.wrapWithWrappingComponent)(_react["default"].createElement, node, options)
      };
    }
  }]);
  return ReactSeventeenAdapter;
}(_enzyme.EnzymeAdapter);
module.exports = ReactSeventeenAdapter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=ReactSeventeenAdapter.js.map