# $Id: Terminal.pm,v 1.2 2005/03/05 18:15:22 kissg Exp $

package Pista::Object::Terminal;

use strict;
use warnings;
use vars qw(@ISA);
@ISA = qw(Pista::Object);
use Pista::Util qw(min swap_history);
use Pista::Section;
use Term::ReadLine;

use Dumpvalue;
my $dumper = new Dumpvalue('arrayDepth' => 10, 'quoteHighBit'=>1);

my @saved_history;

sub new {
	my $pkg = shift;
	my $self = { term => shift, device => shift, };
	if (!$self->{device}) {
		print "440 No device selected\n";
		return undef;
	}
	bless $self, $pkg;
}

sub write {
	my ($self, $src) = @_;

#$dumper->dumpValue($self);
	print "131 Buffer dump follows\n";
	foreach (qw(prog cal userid devid conf)) {
		next unless exists $src->{$_};
		$self->_write($src->{$_}, $self->{device}->{$_}->{width});
	}
	foreach (qw(eeprom)) {
		next unless exists $src->{$_};
		$self->_write($src->{$_}, 1);
	}
	print ".\n";
	return $src;
}

sub _write {
#print "->_write(@_)\n";
	my ($self, $section, $width) = @_;
	my $start = my $base = $section->{start};
	my $end = $section->{end};
	my $buffer = $section->{content};
#print "$self,start=$start,end=$end,buffer=$buffer\n";
	my $i;
#$dumper->dumpValue([$section, $buffer]);
	while ($#$buffer >= 0 and $start <= $end) {
		print _bufline($buffer, $width, $base, $start,
					min((($start+8)&~0x7)-1,$end));
		$start += 8;
		$start &= ~0x7;
	}
}

# Assemble an output line
sub _bufline {
	my ($bufref, $width, $base, $start, $end) = @_;
	my $something_to_print = 0;
	my $i;
	$width = 2 unless defined $width;
#$dumper->dumpValue(["bufline",$bufref, $width, $base, $start, $end]);
	for ($i=$start; $i<=$end; $i++) {
		next unless defined $$bufref[$i-$base];
		$something_to_print++;
		last;
	}
	return '' unless $something_to_print;
#printf "start=0x%x end=0x%x base=0x%x width=$width\n", $start, $end, $base;
	my $line = sprintf("%6.4x:", $start);
	for ($i=$start&~0x7; $i<$start; $i++) {
		$line .= ' 'x(2*$width+1);
	}
	for ($i=$start; $i<=$end; $i++) {
		if (defined $$bufref[$i-$base]) {
			$line .= sprintf " %.*x", 2*$width, $$bufref[$i-$base];
		} else {
			$line .= ' ' . '-' x (2*$width);
		}
	}
	$line .= "\n";
	return $line;
}

sub read {
#print "Pista::Object::Terminal::read(@_)\n";
	my $self = shift;
	my %arg = (@_);
	my $range = $arg{range};
	undef %arg;
	my ($start, @buffer);

	@saved_history = swap_history($self->{term}, @saved_history);

	print "330 Enter data. End with a single '.'.\n";
	while ( defined ($_ = $self->{term}->readline()) ) {
		last if $_ eq '.';
		$self->{term}->AddHistory($_)
			if $self->{term}->Features->{addHistory};
		if (!/^\s*([\da-f]+):\s*([\da-f-][\da-f\s-]*)?$/) {
			print "400 Invalid input\n";
			next;
		}
		my $address = hex($1);
		for my $val (split(/\s+/,$2)) {
			next if $val =~ /-+/;
			$start = $address unless defined $start;
			my $sect = $self->{device}->qualify($address);
			next unless $sect;
			my $section = Pista::Section->new($address,
							$address, [hex($val)]);
			if (exists $self->{$sect}) {
				$self->{$sect} = $self->{$sect}->merge($section);
			}
			else {
				$self->{$sect} = $section;
			}
		}
		continue {
			$address++;
		}
	}

	@saved_history = swap_history($self->{term}, @saved_history);

	for (qw(prog cal userid devid conf eeprom)) {
		next unless exists $self->{$_};
		if (exists $range->{$_}) {
			$self->{$_}->intersect($range->{$_}->{start},
						$range->{$_}->{end});
		}
		else {
			delete $self->{$_};
		}
	}
	return $self;
}

1;
