# $Id: Programmer.pm,v 1.2 2005/03/05 18:14:20 kissg Exp $

package Pista::Programmer;

use strict;
use warnings;
use Getopt::Long;
use vars qw(@ISA);

sub new {
	my $pkg = shift;
	my $self;
	my ($o_help, $o_debug, $o_noprogress);
	{
		local @ARGV = @_;
		local $SIG{__WARN__} = sub { print "500 $_[0]"; };
		GetOptions(
			'help'		=> \$o_help,
			'debug'		=> \$o_debug,
			'noprogress'	=> \$o_noprogress,
		) or return;
		@_ = @ARGV;
	}
	if ($o_help) {
		print <<"EOT";
210-'programmer [options] type [line]' - select your programmer and serial port
210-Known types		Default port
210-picstart		/dev/picstart
210-
210-Options:
210-  --debug		Dump I/O
210   --noprogress	Don't display progress report
EOT
		return 'help';
	}
	my $programmer_type = shift;
	if (!$programmer_type) {
		print "500 Syntax error. Try 'help programmer'\n";
		return;
	}
	my $port = shift;

	for my $class (qw(PicStart ProMate PicWriter)) {
		my $lcclass = lc($class);
		next unless $programmer_type =~ /$lcclass/i;
		my $fqclass = "Pista::Programmer::$class";
		eval "require $fqclass";
		if ($@) {
			die "$@\n" unless $@ =~ m|^Can't locate Pista/Programmer/$class.pm in \@INC|;
			print "521 Unsupported programmer type: $programmer_type\n";
			return;
		}
		else {
			return "$fqclass"->new($port || "/dev/$lcclass",
						debug => $o_debug,
						progress => !$o_noprogress,
					);
		}
	}

	print "521 Unknown programmer type: $programmer_type\n";
	return;
}

sub grupid {
	my $self = shift;
	print "$self: fallback grupid()\n";
}
#sub grupid {
#	my ($device, $attrib, $content) = @_;
#	warn "Unknown programmer attributes ignored\n" if (ref $attrib);
#	for my $element (@$content) {
#		if ($element->{name} eq 'picstart_plus') {
#			$device = process_element_picstart_plus($device,
#						$element->{attrib},
#						$element->{content});
#			next;
#		}
#		warn "Unknown programmer '$element->{name}' ignored\n";
#	}
#	return $device;
#}

1;
