/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import net.pms.dlna.DLNAResource;
import net.pms.dlna.Range;
import net.pms.dlna.virtual.VirtualFolder;

public class ChapterFileTranscodeVirtualFolder
extends VirtualFolder {
    private final int interval;

    public ChapterFileTranscodeVirtualFolder(String name, String thumbnailIcon, int interval) {
        super(name, thumbnailIcon);
        this.interval = interval;
    }

    @Override
    protected void resolveOnce() {
        if (this.getChildren().size() == 1) {
            DLNAResource child = this.getChildren().get(0);
            child.resolve();
            int nbMinutes = (int)(child.getMedia().getDurationInSeconds() / 60.0);
            int nbIntervals = nbMinutes / this.interval;
            for (int i = 1; i <= nbIntervals; ++i) {
                DLNAResource newChildNoSub = child.clone();
                newChildNoSub.setPlayer(child.getPlayer());
                newChildNoSub.setMedia(child.getMedia());
                newChildNoSub.setNoName(true);
                newChildNoSub.setMediaAudio(child.getMediaAudio());
                newChildNoSub.setMediaSubtitle(child.getMediaSubtitle());
                newChildNoSub.setSplitRange(new Range.Time(60.0 * (double)i * (double)this.interval, newChildNoSub.getMedia().getDurationInSeconds()));
                this.addChildInternal(newChildNoSub);
            }
        }
    }
}

