/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.IPushOutput;
import net.pms.dlna.InputFile;
import net.pms.util.FileUtil;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RarredEntry
extends DLNAResource
implements IPushOutput {
    private static final Logger logger = LoggerFactory.getLogger(RarredEntry.class);
    private String name;
    private File file;
    private String fileHeaderName;
    private long length;

    @Override
    protected String getThumbnailURL() {
        if (this.getType() == 2 || this.getType() == 1) {
            return null;
        }
        return super.getThumbnailURL();
    }

    public RarredEntry(String name, File file, String fileHeaderName, long length) {
        this.fileHeaderName = fileHeaderName;
        this.name = name;
        this.file = file;
        this.length = length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long length() {
        if (this.getPlayer() != null && this.getPlayer().type() != 2) {
            return 0x7FFFFFFF7FFFFFFFL;
        }
        return this.length;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Deprecated
    public long lastModified() {
        return 0L;
    }

    @Override
    public String getSystemName() {
        return FilenameUtils.getBaseName(this.file.getAbsolutePath()) + "." + FilenameUtils.getExtension(this.name);
    }

    @Override
    public boolean isValid() {
        this.resolveFormat();
        this.setSrtFile(FileUtil.isSubtitlesExists(this.file, null));
        return this.getFormat() != null;
    }

    @Override
    public boolean isUnderlyingSeekSupported() {
        return this.length() < 800000000L;
    }

    @Override
    public void push(final OutputStream out) throws IOException {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Archive rarFile = null;
                try {
                    rarFile = new Archive(RarredEntry.this.file);
                    FileHeader header = null;
                    for (FileHeader fh : rarFile.getFileHeaders()) {
                        if (!fh.getFileNameString().equals(RarredEntry.this.fileHeaderName)) continue;
                        header = fh;
                        break;
                    }
                    if (header != null) {
                        logger.trace("Starting the extraction of " + header.getFileNameString());
                        rarFile.extractFile(header, out);
                    }
                }
                catch (Exception e) {
                    logger.debug("Unpack error, maybe it's normal, as backend can be terminated: " + e.getMessage());
                }
                finally {
                    try {
                        rarFile.close();
                        out.close();
                    }
                    catch (IOException e) {
                        logger.debug("Caught exception", e);
                    }
                }
            }
        };
        new Thread(r, "Rar Extractor").start();
    }

    @Override
    protected void resolveOnce() {
        if (this.getFormat() == null || !this.getFormat().isVideo()) {
            return;
        }
        boolean found = false;
        if (!found) {
            if (this.getMedia() == null) {
                this.setMedia(new DLNAMediaInfo());
            }
            boolean bl = found = !this.getMedia().isMediaparsed() && !this.getMedia().isParsing();
            if (this.getFormat() != null) {
                InputFile input = new InputFile();
                input.setPush(this);
                input.setSize(this.length());
                this.getFormat().parse(this.getMedia(), input, this.getType());
            }
        }
    }

    @Override
    public InputStream getThumbnailInputStream() throws IOException {
        if (this.getMedia() != null && this.getMedia().getThumb() != null) {
            return this.getMedia().getThumbnailInputStream();
        }
        return super.getThumbnailInputStream();
    }
}

