/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.IOException;
import javax.swing.JComponent;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.Player;
import net.pms.encoders.PlayerPurpose;
import net.pms.io.OutputParams;
import net.pms.io.PipeProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.util.PlayerUtil;

public class MEncoderWebVideo
extends Player {
    public static final String ID = "mencoderwebvideo";
    private final PmsConfiguration configuration;

    @Override
    public JComponent config() {
        return null;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.VIDEO_WEB_STREAM_PLAYER;
    }

    @Override
    public boolean isTimeSeekable() {
        return false;
    }

    @Override
    public String mimeType() {
        return "video/mpeg";
    }

    protected String[] getDefaultArgs() {
        int nThreads = this.configuration.getMencoderMaxThreads();
        String acodec = this.configuration.isMencoderAc3Fixed() ? "ac3_fixed" : "ac3";
        return new String[]{"-msglevel", "all=2", "-quiet", "-prefer-ipv4", "-cache", "16384", "-oac", "lavc", "-of", "lavf", "-lavfopts", "format=dvd", "-ovc", "lavc", "-lavcopts", "vcodec=mpeg2video:vbitrate=4096:threads=" + nThreads + ":acodec=" + acodec + ":abitrate=128", "-vf", "harddup", "-ofps", "25"};
    }

    public MEncoderWebVideo(PmsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ProcessWrapper launchTranscode(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        String filename;
        PipeProcess pipe;
        params.minBufferSize = params.minFileSize;
        params.secondread_minsize = 100000;
        params.input_pipes[0] = pipe = new PipeProcess("mencoder" + System.currentTimeMillis(), new String[0]);
        String[] cmdArray = new String[this.args().length + 4];
        cmdArray[0] = this.executable();
        cmdArray[1] = filename = dlna.getSystemName();
        for (int i = 0; i < this.args().length; ++i) {
            cmdArray[i + 2] = this.args()[i];
        }
        cmdArray[cmdArray.length - 2] = "-o";
        cmdArray[cmdArray.length - 1] = pipe.getInputPipe();
        ProcessWrapper mkfifo_process = pipe.getPipeProcess();
        cmdArray = this.finalizeTranscoderArgs(filename, dlna, media, params, cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.attachProcess(mkfifo_process);
        mkfifo_process.runInNewThread();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        pipe.deleteLater();
        pw.runInNewThread();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return pw;
    }

    @Override
    public String name() {
        return "MEncoder Web Video";
    }

    @Override
    public String[] args() {
        return this.getDefaultArgs();
    }

    @Override
    public String executable() {
        return this.configuration.getMencoderPath();
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public boolean isCompatible(DLNAResource resource) {
        return PlayerUtil.isWebVideo(resource);
    }
}

