/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.io.BufferedOutputFile;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.WaitBufferedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedOutputFileImpl
extends OutputStream
implements BufferedOutputFile {
    private static final Logger logger = LoggerFactory.getLogger(BufferedOutputFileImpl.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private static final int INITIAL_BUFFER_SIZE = 50000000;
    private static final int MARGIN_LARGE = 20000000;
    private static final int MARGIN_MEDIUM = 2000000;
    private static final int MARGIN_SMALL = 600000;
    private static final int CHECK_INTERVAL = 500;
    private static final int CHECK_END_OF_PROCESS = 2500;
    private int minMemorySize;
    private int maxMemorySize;
    private int bufferOverflowWarning;
    private boolean eof;
    private long writeCount;
    private byte[] buffer;
    private boolean forcefirst = configuration.getTrancodeBlocksMultipleConnections() && configuration.getTrancodeKeepFirstConnections();
    private ArrayList<WaitBufferedInputStream> inputStreams;
    private ProcessWrapper attachedThread;
    private int secondread_minsize;
    private Timer timer;
    private boolean shiftScr;
    private FileOutputStream debugOutput = null;
    private boolean buffered = false;
    private DecimalFormat formatter = new DecimalFormat("#,###");
    private double timeseek;
    private double timeend;
    private long packetpos = 0L;

    private byte[] growBuffer(byte[] buffer, int newSize) {
        byte[] copy;
        if (buffer == null) {
            buffer = new byte[]{};
        }
        if (newSize <= buffer.length) {
            return buffer;
        }
        try {
            copy = new byte[newSize];
        }
        catch (OutOfMemoryError e) {
            if (buffer.length == 0) {
                logger.error("Cannot initialize buffer to " + this.formatter.format(newSize) + " bytes.", e);
            } else {
                logger.warn("Cannot grow buffer size from " + this.formatter.format(buffer.length) + " bytes to " + this.formatter.format(newSize) + " bytes.", e);
            }
            long realisticSize = Runtime.getRuntime().maxMemory() * 3L / 10L;
            if (realisticSize < (long)buffer.length) {
                return buffer;
            }
            try {
                copy = new byte[(int)realisticSize];
            }
            catch (OutOfMemoryError e2) {
                logger.error("Cannot grow buffer size from " + this.formatter.format(buffer.length) + " bytes to " + this.formatter.format(realisticSize) + " bytes either.", e2);
                logger.error("freeMemory: " + this.formatter.format(Runtime.getRuntime().freeMemory()));
                logger.error("totalMemory: " + this.formatter.format(Runtime.getRuntime().totalMemory()));
                logger.error("maxMemory: " + this.formatter.format(Runtime.getRuntime().maxMemory()));
                return buffer;
            }
        }
        if (buffer.length == 0) {
            logger.info("Successfully initialized buffer to " + this.formatter.format(copy.length) + " bytes.");
        } else {
            try {
                System.arraycopy(buffer, 0, copy, 0, buffer.length);
                logger.info("Successfully grown buffer from " + this.formatter.format(buffer.length) + " bytes to " + this.formatter.format(copy.length) + " bytes.");
            }
            catch (Exception ex) {
                logger.error("Cannot grow buffer size, error copying buffer contents.", ex);
            }
        }
        return copy;
    }

    public BufferedOutputFileImpl(OutputParams params) {
        this.minMemorySize = (int)(1048576.0 * params.minBufferSize);
        this.maxMemorySize = (int)(1048576.0 * params.maxBufferSize);
        int margin = 20000000;
        if (this.maxMemorySize < margin && this.maxMemorySize < (margin = 2000000)) {
            margin = 600000;
        }
        this.bufferOverflowWarning = this.maxMemorySize - margin;
        this.secondread_minsize = params.secondread_minsize;
        this.timeseek = params.timeseek;
        this.timeend = params.timeend;
        this.shiftScr = params.shift_scr;
        this.buffer = this.maxMemorySize > 50000000 && !configuration.initBufferMax() ? this.growBuffer(null, 50000000) : this.growBuffer(null, this.maxMemorySize);
        if (this.buffer.length == 0) {
            logger.info("FATAL ERROR: OutOfMemory / dumping stats");
            logger.trace("freeMemory: " + Runtime.getRuntime().freeMemory());
            logger.trace("totalMemory: " + Runtime.getRuntime().totalMemory());
            logger.trace("maxMemory: " + Runtime.getRuntime().maxMemory());
            System.exit(1);
        }
        this.inputStreams = new ArrayList();
        this.timer = new Timer();
        if (params.maxBufferSize > 15.0 && !params.hidebuffer) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    long rc = 0L;
                    if (BufferedOutputFileImpl.this.getCurrentInputStream() != null) {
                        rc = BufferedOutputFileImpl.this.getCurrentInputStream().getReadCount();
                        PMS.get().getFrame().setReadValue(rc, "");
                    }
                    long space = BufferedOutputFileImpl.this.writeCount - rc;
                    logger.trace("buffered: " + BufferedOutputFileImpl.this.formatter.format(space) + " bytes / inputs: " + BufferedOutputFileImpl.this.inputStreams.size());
                    long bufferInMBs = space / 0x100000L;
                    PMS.get().getFrame().setValue((int)(100L * space / (long)BufferedOutputFileImpl.this.maxMemorySize), BufferedOutputFileImpl.this.formatter.format(bufferInMBs) + " " + Messages.getString("StatusTab.12"));
                }
            }, 0L, 2000L);
        }
    }

    @Override
    public void close() throws IOException {
        logger.trace("EOF");
        this.eof = true;
    }

    @Override
    public WaitBufferedInputStream getCurrentInputStream() {
        WaitBufferedInputStream wai = null;
        if (this.inputStreams.size() > 0) {
            try {
                wai = this.forcefirst ? this.inputStreams.get(0) : this.inputStreams.get(this.inputStreams.size() - 1);
            }
            catch (IndexOutOfBoundsException e) {
                logger.error("Unexpected input stream removal", e);
            }
        }
        return wai;
    }

    @Override
    public InputStream getInputStream(long newReadPosition) {
        if (this.attachedThread != null) {
            this.attachedThread.setReadyToStop(false);
        }
        if (configuration.getTrancodeBlocksMultipleConnections() && this.getCurrentInputStream() != null) {
            if (configuration.getTrancodeKeepFirstConnections()) {
                logger.debug("BufferedOutputFile is already attached to an InputStream: " + this.getCurrentInputStream());
            } else {
                while (this.inputStreams.size() > 0) {
                    try {
                        this.inputStreams.get(0).close();
                    }
                    catch (IOException e) {
                        logger.error("Error: ", e);
                    }
                }
                this.inputStreams.clear();
                WaitBufferedInputStream atominputStream = new WaitBufferedInputStream(this);
                this.inputStreams.add(atominputStream);
                logger.debug("Reassign inputstream: " + this.getCurrentInputStream());
            }
            return null;
        }
        WaitBufferedInputStream atominputStream = new WaitBufferedInputStream(this);
        this.inputStreams.add(atominputStream);
        if (newReadPosition > 0L) {
            logger.debug("Setting InputStream new position to: " + this.formatter.format(newReadPosition));
            atominputStream.setReadCount(newReadPosition);
        }
        return atominputStream;
    }

    @Override
    public long getWriteCount() {
        return this.writeCount;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.debugOutput != null) {
            this.debugOutput.write(b, off, len);
            this.debugOutput.flush();
        }
        WaitBufferedInputStream input = this.getCurrentInputStream();
        while (input != null && this.writeCount - input.getReadCount() > (long)this.bufferOverflowWarning || input == null && this.writeCount > (long)this.bufferOverflowWarning) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            input = this.getCurrentInputStream();
        }
        if (this.buffer != null) {
            int mb = (int)(this.writeCount % (long)this.maxMemorySize);
            if (mb >= this.buffer.length - (len - off)) {
                if (this.buffer.length == 50000000) {
                    this.buffer = this.growBuffer(this.buffer, this.maxMemorySize);
                }
                int s = len - off;
                for (int i = 0; i < s; ++i) {
                    this.buffer[this.modulo((int)(mb + i), (int)this.buffer.length)] = b[off + i];
                }
            } else {
                System.arraycopy(b, off, this.buffer, mb, len - off);
                if (len - off > 0) {
                    this.buffered = true;
                }
            }
            if (this.timeseek > 0.0 && this.writeCount > 10L) {
                for (int i = 0; i < len; ++i) {
                    if (this.buffer == null || !this.shiftScr) continue;
                    this.shiftSCRByTimeSeek(mb + i, (int)this.timeseek);
                }
            }
            this.writeCount += (long)(len - off);
            if (this.timeseek > 0.0 && this.timeend == 0.0) {
                int packetLength = 6;
                while (this.packetpos + (long)packetLength < this.writeCount && this.buffer != null) {
                    int packetposMB = (int)(this.packetpos % (long)this.maxMemorySize);
                    int streamPos = 0;
                    if (this.buffer[this.modulo(packetposMB, this.buffer.length)] == 71) {
                        packetLength = 188;
                        streamPos = 4;
                        if ((this.buffer[this.modulo(packetposMB + 3, this.buffer.length)] & 0x20) == 32) {
                            streamPos += 1 + (this.buffer[this.modulo(packetposMB + 4, this.buffer.length)] + 256) % 256;
                        }
                        if (streamPos == 188) {
                            streamPos = -1;
                        }
                    } else if (this.buffer[this.modulo(packetposMB + 3, this.buffer.length)] == -70) {
                        packetLength = 14;
                        streamPos = -1;
                    } else {
                        packetLength = 6 + (this.buffer[this.modulo(packetposMB + 4, this.buffer.length)] + 256) % 256 * 256 + (this.buffer[this.modulo(packetposMB + 5, this.buffer.length)] + 256) % 256;
                    }
                    if (streamPos != -1 && !this.shiftVideo(mb = packetposMB + streamPos + 18, true)) {
                        this.shiftAudio(mb -= 5, true);
                    }
                    this.packetpos += (long)packetLength;
                }
            }
        }
    }

    private int modulo(int number, int divisor) {
        if (number >= 0) {
            return number % divisor;
        }
        return (number % divisor + divisor) % divisor;
    }

    @Override
    public void write(int b) throws IOException {
        boolean bb = b % 100000 == 0;
        WaitBufferedInputStream input = this.getCurrentInputStream();
        while (bb && (input != null && this.writeCount - input.getReadCount() > (long)this.bufferOverflowWarning || input == null && this.writeCount == (long)this.bufferOverflowWarning)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            input = this.getCurrentInputStream();
        }
        int mb = (int)(this.writeCount++ % (long)this.maxMemorySize);
        if (this.buffer != null) {
            this.buffer[mb] = (byte)b;
            this.buffered = true;
            if (this.writeCount == 50000000L) {
                this.buffer = this.growBuffer(this.buffer, this.maxMemorySize);
            }
            if (this.timeseek > 0.0 && this.writeCount > 19L) {
                this.shiftByTimeSeek(mb, mb <= 20);
            }
            if (this.timeseek > 0.0 && this.writeCount > 10L) {
                this.shiftSCRByTimeSeek(mb, (int)this.timeseek);
            }
        }
    }

    private void shiftSCRByTimeSeek(int buffer_index, int offset_sec) {
        int m9 = this.modulo(buffer_index - 9, this.buffer.length);
        int m8 = this.modulo(buffer_index - 8, this.buffer.length);
        int m7 = this.modulo(buffer_index - 7, this.buffer.length);
        int m6 = this.modulo(buffer_index - 6, this.buffer.length);
        int m5 = this.modulo(buffer_index - 5, this.buffer.length);
        int m4 = this.modulo(buffer_index - 4, this.buffer.length);
        int m3 = this.modulo(buffer_index - 3, this.buffer.length);
        int m2 = this.modulo(buffer_index - 2, this.buffer.length);
        int m1 = this.modulo(buffer_index - 1, this.buffer.length);
        int m0 = this.modulo(buffer_index, this.buffer.length);
        if (this.buffer[m9] == 0 && this.buffer[m8] == 0 && this.buffer[m7] == 1 && this.buffer[m6] == -70 && (this.buffer[m5] & 0x80) != 128 && (this.buffer[m5] & 0x40) == 64 && (this.buffer[m5] & 4) == 4 && (this.buffer[m3] & 4) == 4 && (this.buffer[m1] & 4) == 4 && (this.buffer[m0] & 1) == 1) {
            long scr_32_30 = (this.buffer[m5] & 0x38) >> 3;
            long scr_29_15 = ((this.buffer[m5] & 3) << 13) + (this.buffer[m4] << 5) + ((this.buffer[m3] & 0xF8) >> 3);
            long scr_14_00 = ((this.buffer[m3] & 3) << 13) + (this.buffer[m2] << 5) + ((this.buffer[m1] & 0xF8) >> 3);
            long scr = (scr_32_30 << 30) + (scr_29_15 << 15) + scr_14_00;
            long scr_new = scr + 90000L * (long)offset_sec;
            long scr_32_30_new = (scr_new & 0x1C0000000L) >> 30;
            long scr_29_15_new = (scr_new & 0x3FFF8000L) >> 15;
            long scr_14_00_new = scr_new & 0x7FFFL;
            this.buffer[m5] = (byte)((long)(this.buffer[m5] & 0xC7) + (scr_32_30_new << 3 & 0x38L));
            this.buffer[m5] = (byte)((long)(this.buffer[m5] & 0xFC) + (scr_29_15_new >> 13 & 3L));
            this.buffer[m4] = (byte)(scr_29_15_new >> 5);
            this.buffer[m3] = (byte)((long)(this.buffer[m3] & 7) + (scr_29_15_new << 3 & 0xF8L));
            this.buffer[m3] = (byte)((long)(this.buffer[m3] & 0xFC) + (scr_14_00_new >> 13 & 3L));
            this.buffer[m2] = (byte)(scr_14_00_new >> 5);
            this.buffer[m1] = (byte)((long)(this.buffer[m1] & 7) + (scr_14_00_new << 3 & 0xF8L));
        }
    }

    private void shiftGOPByTimeSeek(int buffer_index, int offset_sec) {
        int m7 = this.modulo(buffer_index - 7, this.buffer.length);
        int m6 = this.modulo(buffer_index - 6, this.buffer.length);
        int m5 = this.modulo(buffer_index - 5, this.buffer.length);
        int m4 = this.modulo(buffer_index - 4, this.buffer.length);
        int m3 = this.modulo(buffer_index - 3, this.buffer.length);
        int m2 = this.modulo(buffer_index - 2, this.buffer.length);
        int m1 = this.modulo(buffer_index - 1, this.buffer.length);
        int m0 = this.modulo(buffer_index, this.buffer.length);
        if (this.buffer[m7] == 0 && this.buffer[m6] == 0 && this.buffer[m5] == 1 && this.buffer[m4] == -72 && (this.buffer[m2] & 8) == 8 && (this.buffer[m0] & 0x1F) == 0 && (this.buffer[m3] & 0x80) != 128 && (this.buffer[m0] & 0x10) != 16) {
            byte h = (byte)((this.buffer[m3] & 0x7C) >> 2);
            byte m = (byte)(((this.buffer[m3] & 3) << 4) + ((this.buffer[m2] & 0xF0) >> 4));
            byte s = (byte)(((this.buffer[m2] & 7) << 3) + ((this.buffer[m1] & 0xE0) >> 5));
            int _offset = s + m * 60 + h * 60 + offset_sec;
            byte _h = (byte)(_offset / 3600 % 24);
            byte _m = (byte)(_offset / 60 % 60);
            byte _s = (byte)(_offset % 60);
            this.buffer[m3] = (byte)((this.buffer[m3] & 0x83) + (_h << 2));
            this.buffer[m3] = (byte)((this.buffer[m3] & 0xFC) + (_m >> 4));
            this.buffer[m2] = (byte)((this.buffer[m2] & 0xF) + (_m << 4));
            this.buffer[m2] = (byte)((this.buffer[m2] & 0xF8) + (_s >> 3));
            this.buffer[m1] = (byte)((this.buffer[m1] & 0x1F) + (_s << 5));
        }
    }

    private void shiftByTimeSeek(int mb, boolean mod) {
        this.shiftVideo(mb, mod);
        this.shiftAudio(mb, mod);
    }

    private boolean shiftAudio(int mb, boolean mod) {
        boolean bb;
        boolean bl = bb = !mod && (this.buffer[mb - 10] == -67 || this.buffer[mb - 10] == -64) && this.buffer[mb - 11] == 1 && this.buffer[mb - 12] == 0 && this.buffer[mb - 13] == 0 && (this.buffer[mb - 6] & 0x80) == 128 || mod && (this.buffer[this.modulo(mb - 10, this.buffer.length)] == -67 || this.buffer[this.modulo(mb - 10, this.buffer.length)] == -64) && this.buffer[this.modulo(mb - 11, this.buffer.length)] == 1 && this.buffer[this.modulo(mb - 12, this.buffer.length)] == 0 && this.buffer[this.modulo(mb - 13, this.buffer.length)] == 0 && (this.buffer[this.modulo(mb - 6, this.buffer.length)] & 0x80) == 128;
        if (bb) {
            int pts = (((this.buffer[this.modulo(mb - 3, this.buffer.length)] & 0xFF) << 8) + (this.buffer[this.modulo(mb - 2, this.buffer.length)] & 0xFF) >> 1 << 15) + (((this.buffer[this.modulo(mb - 1, this.buffer.length)] & 0xFF) << 8) + (this.buffer[this.modulo(mb, this.buffer.length)] & 0xFF) >> 1);
            this.setTS(pts += (int)(this.timeseek * 90000.0), mb, mod);
            return true;
        }
        return false;
    }

    private boolean shiftVideo(int mb, boolean mod) {
        boolean bb;
        boolean bl = bb = !mod && (this.buffer[mb - 15] == -32 || this.buffer[mb - 15] == -3) && this.buffer[mb - 16] == 1 && this.buffer[mb - 17] == 0 && this.buffer[mb - 18] == 0 && (this.buffer[mb - 11] & 0x80) == 128 && (this.buffer[mb - 9] & 0x20) == 32 || mod && (this.buffer[this.modulo(mb - 15, this.buffer.length)] == -32 || this.buffer[this.modulo(mb - 15, this.buffer.length)] == -3) && this.buffer[this.modulo(mb - 16, this.buffer.length)] == 1 && this.buffer[this.modulo(mb - 17, this.buffer.length)] == 0 && this.buffer[this.modulo(mb - 18, this.buffer.length)] == 0 && (this.buffer[this.modulo(mb - 11, this.buffer.length)] & 0x80) == 128 && (this.buffer[this.modulo(mb - 9, this.buffer.length)] & 0x20) == 32;
        if (bb) {
            boolean dts_present;
            int pts = this.getTS(mb - 5, mod);
            int dts = 0;
            boolean bl2 = dts_present = (this.buffer[this.modulo(mb - 11, this.buffer.length)] & 0x40) == 64;
            if (dts_present) {
                if ((this.buffer[this.modulo(mb - 4, this.buffer.length)] & 0xF) == 15) {
                    dts = ((255 - (this.buffer[this.modulo(mb - 3, this.buffer.length)] & 0xFF) << 8) + (255 - (this.buffer[this.modulo(mb - 2, this.buffer.length)] & 0xFF)) >> 1 << 15) + ((255 - (this.buffer[this.modulo(mb - 1, this.buffer.length)] & 0xFF) << 8) + (255 - (this.buffer[this.modulo(mb, this.buffer.length)] & 0xFF)) >> 1);
                    dts = -dts;
                } else {
                    dts = this.getTS(mb, mod);
                }
            }
            int ts = (int)(this.timeseek * 90000.0);
            if (mb == 50 && this.writeCount < (long)this.maxMemorySize) {
                --dts;
            }
            this.setTS(pts += ts, mb - 5, mod);
            if (dts_present) {
                if (dts < 0) {
                    this.buffer[this.modulo((int)(mb - 4), (int)this.buffer.length)] = 17;
                }
                this.setTS(dts += ts, mb, mod);
            }
            return true;
        }
        return false;
    }

    private int getTS(int mb, boolean modulo) {
        int m3 = mb - 3;
        int m2 = mb - 2;
        int m1 = mb - 1;
        int m0 = mb;
        if (modulo) {
            m3 = this.modulo(m3, this.buffer.length);
            m2 = this.modulo(m2, this.buffer.length);
            m1 = this.modulo(m1, this.buffer.length);
            m0 = this.modulo(m0, this.buffer.length);
        }
        return (((this.buffer[m3] & 0xFF) << 8) + (this.buffer[m2] & 0xFF) >> 1 << 15) + (((this.buffer[m1] & 0xFF) << 8) + (this.buffer[m0] & 0xFF) >> 1);
    }

    private void setTS(int ts, int mb, boolean modulo) {
        int m3 = mb - 3;
        int m2 = mb - 2;
        int m1 = mb - 1;
        int m0 = mb;
        if (modulo) {
            m3 = this.modulo(m3, this.buffer.length);
            m2 = this.modulo(m2, this.buffer.length);
            m1 = this.modulo(m1, this.buffer.length);
            m0 = this.modulo(m0, this.buffer.length);
        }
        int pts_low = ts & Short.MAX_VALUE;
        int pts_high = ts >> 15 & Short.MAX_VALUE;
        int pts_left_low = 1 + (pts_low << 1);
        int pts_left_high = 1 + (pts_high << 1);
        this.buffer[m3] = (byte)((pts_left_high & 0xFF00) >> 8);
        this.buffer[m2] = (byte)(pts_left_high & 0xFF);
        this.buffer[m1] = (byte)((pts_left_low & 0xFF00) >> 8);
        this.buffer[m0] = (byte)(pts_left_low & 0xFF);
    }

    @Override
    public int read(boolean firstRead, long readCount, byte[] buf, int off, int len) {
        int minBufferS;
        if (readCount > 50000000L && readCount < (long)this.maxMemorySize) {
            int newMargin = this.maxMemorySize - 2000000;
            if (this.bufferOverflowWarning != newMargin) {
                logger.debug("Setting margin to 2Mb");
            }
            this.bufferOverflowWarning = newMargin;
        }
        if (this.eof && readCount >= this.writeCount) {
            return -1;
        }
        int c = 0;
        int n = minBufferS = firstRead ? this.minMemorySize : this.secondread_minsize;
        while (this.writeCount - readCount <= (long)minBufferS && !this.eof && c < 15) {
            if (c == 0) {
                logger.trace("Suspend Read: readCount=" + readCount + " / writeCount=" + this.writeCount);
            }
            ++c;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        if (this.attachedThread != null) {
            this.attachedThread.setReadyToStop(false);
        }
        if (c > 0) {
            logger.trace("Resume Read: readCount=" + readCount + " / writeCount=" + this.writeCount);
        }
        if (this.buffer == null || !this.buffered) {
            return -1;
        }
        int mb = (int)(readCount % (long)this.maxMemorySize);
        int endOF = this.buffer.length;
        int cut = 0;
        if (this.eof && this.writeCount - readCount < (long)len) {
            cut = (int)((long)len - (this.writeCount - readCount));
        }
        if (mb >= endOF - len) {
            try {
                System.arraycopy(this.buffer, mb, buf, off, endOF - mb - cut);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                logger.error("Something went wrong with the buffer.", ex);
                logger.error("buffer.length: " + this.formatter.format(this.buffer.length) + " bytes.");
                logger.error("mb: " + mb);
                logger.error("buf.length: " + this.formatter.format(buf.length) + " bytes.");
                logger.error("off: " + off);
                logger.error("endOF - mb - cut: " + (endOF - mb - cut));
            }
            return endOF - mb;
        }
        System.arraycopy(this.buffer, mb, buf, off, len - cut);
        return len;
    }

    @Override
    public int read(boolean firstRead, long readCount) {
        int minBufferS;
        if (readCount > 50000000L && readCount < (long)this.maxMemorySize) {
            int newMargin = this.maxMemorySize - 2000000;
            if (this.bufferOverflowWarning != newMargin) {
                logger.debug("Setting margin to 2Mb");
            }
            this.bufferOverflowWarning = newMargin;
        }
        if (this.eof && readCount >= this.writeCount) {
            return -1;
        }
        int c = 0;
        int n = minBufferS = firstRead ? this.minMemorySize : this.secondread_minsize;
        while (this.writeCount - readCount <= (long)minBufferS && !this.eof && c < 15) {
            if (c == 0) {
                logger.trace("Suspend Read: readCount=" + readCount + " / writeCount=" + this.writeCount);
            }
            ++c;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        if (this.attachedThread != null) {
            this.attachedThread.setReadyToStop(false);
        }
        if (c > 0) {
            logger.trace("Resume Read: readCount=" + readCount + " / writeCount=" + this.writeCount);
        }
        if (this.buffer == null || !this.buffered) {
            return -1;
        }
        try {
            return 0xFF & this.buffer[(int)(readCount % (long)this.maxMemorySize)];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            logger.error("Buffer read ArrayIndexOutOfBoundsException error.", ex);
            logger.error("buffer.length: " + this.formatter.format(this.buffer.length) + " bytes.");
            logger.error("readCount: \"" + readCount + "\"");
            logger.error("maxMemorySize: \"" + this.maxMemorySize + "\"");
            return -1;
        }
    }

    @Override
    public void attachThread(ProcessWrapper thread) {
        if (this.attachedThread != null) {
            throw new RuntimeException("BufferedOutputFile is already attached to a Thread: " + this.attachedThread);
        }
        logger.debug("Attaching thread: " + thread);
        this.attachedThread = thread;
    }

    @Override
    public void removeInputStream(WaitBufferedInputStream inputStream) {
        this.inputStreams.remove(inputStream);
    }

    @Override
    public void detachInputStream() {
        PMS.get().getFrame().setReadValue(0L, "");
        if (this.attachedThread != null) {
            this.attachedThread.setReadyToStop(true);
        }
        Runnable checkEnd = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException e) {
                    logger.error(null, e);
                }
                if (BufferedOutputFileImpl.this.attachedThread != null && BufferedOutputFileImpl.this.attachedThread.isReadyToStop()) {
                    if (!BufferedOutputFileImpl.this.attachedThread.isDestroyed()) {
                        BufferedOutputFileImpl.this.attachedThread.stopProcess();
                    }
                    BufferedOutputFileImpl.this.reset();
                }
            }
        };
        new Thread(checkEnd, "Buffered IO End Checker").start();
    }

    @Override
    public synchronized void reset() {
        if (this.debugOutput != null) {
            try {
                this.debugOutput.close();
            }
            catch (IOException ex) {
                logger.warn("Caught exception", ex);
            }
        }
        this.timer.cancel();
        if (this.buffer != null) {
            logger.info("Destroying buffer");
            this.buffer = null;
        }
        this.buffered = false;
        if (this.maxMemorySize != 0x100000) {
            PMS.get().getFrame().setValue(0, Messages.getString("StatusTab.5"));
        }
    }
}

