/*
 * Decompiled with CFR 0.152.
 */
package net.pms.logging;

import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.status.ErrorStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.pms.newgui.IFrame;

public class FrameAppender<E>
extends UnsynchronizedAppenderBase<E> {
    private static IFrame frame;
    private Encoder<E> encoder;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);
    private final Object lock = new Object();
    private final List<String> buffer = new ArrayList<String>();

    @Override
    public void start() {
        boolean error = true;
        if (this.encoder == null) {
            this.addStatus(new ErrorStatus("No encoder set for the appender named [" + this.name + "].", this));
        } else {
            try {
                this.encoder.init(this.outputStream);
                error = false;
            }
            catch (IOException ioe) {
                this.addStatus(new ErrorStatus("Failed to initialize encoder for appender named [" + this.name + "].", this, ioe));
            }
        }
        if (!error) {
            super.start();
        }
    }

    public static void setFrame(IFrame iframe) {
        frame = iframe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void append(E eventObject) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.encoder.doEncode(eventObject);
                String msg = this.outputStream.toString("UTF-8");
                this.outputStream.reset();
                if (frame == null) {
                    this.buffer.add(msg);
                } else {
                    if (!this.buffer.isEmpty()) {
                        for (String buffered : this.buffer) {
                            frame.append(buffered);
                        }
                        this.buffer.clear();
                    }
                    frame.append(msg);
                }
            }
        }
        catch (IOException ioe) {
            this.addStatus(new ErrorStatus("IO failure in appender", this, ioe));
        }
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }
}

