/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.pms.PMS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iso639 {
    private static final Logger logger = LoggerFactory.getLogger(Iso639.class);
    private static final String LOCAL_ALIAS = "loc";
    private static HashMap<String, String[]> links = new HashMap();
    private static ArrayList<String> languages = new ArrayList();
    private static ArrayList<String> codes = new ArrayList();

    public static String getLanguage(String code) {
        if (code == null) {
            return null;
        }
        String lang = null;
        for (Map.Entry<String, String[]> entry : links.entrySet()) {
            for (String c : entry.getValue()) {
                if (!code.equalsIgnoreCase(c)) continue;
                return entry.getKey();
            }
        }
        return lang;
    }

    public static String getISO639_2Code(String code) {
        if (code == null) {
            return null;
        }
        String lang = null;
        for (Map.Entry<String, String[]> entry : links.entrySet()) {
            for (String c : entry.getValue()) {
                if (!code.equalsIgnoreCase(c)) continue;
                return entry.getValue()[entry.getValue().length - 1].toLowerCase();
            }
        }
        return lang;
    }

    private static String normalize(String isoCode) {
        if (LOCAL_ALIAS.equals(isoCode)) {
            return PMS.getConfiguration().getLanguage();
        }
        return isoCode;
    }

    public static boolean isCodeMatching(String language, String code) {
        String[] codes;
        if (language == null || code == null) {
            return false;
        }
        String isoCode = Iso639.normalize(code);
        for (String c : codes = links.get(language)) {
            if (!c.equalsIgnoreCase(isoCode)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCodesMatching(String code1, String code2) {
        if (code1 == null || code2 == null) {
            return false;
        }
        String isoCode1 = Iso639.normalize(code1);
        String isoCode2 = Iso639.normalize(code2);
        for (Map.Entry<String, String[]> entry : links.entrySet()) {
            for (String c : entry.getValue()) {
                if (!isoCode1.equalsIgnoreCase(c)) continue;
                for (String c2 : entry.getValue()) {
                    if (!isoCode2.equalsIgnoreCase(c2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static ArrayList<String> getLanguageList() {
        return languages;
    }

    public static ArrayList<String> getCodeList() {
        return codes;
    }

    private static void putCode(String language, String iso6391, String iso6392, String iso6392bis) {
        ArrayList<String> codeArray = new ArrayList<String>();
        if (iso6391 != null) {
            codeArray.add(iso6391);
        }
        if (iso6392 != null) {
            codeArray.add(iso6392);
        }
        if (iso6392bis != null) {
            codeArray.add(iso6392bis);
        }
        String[] newCodes = new String[codeArray.size()];
        codeArray.toArray(newCodes);
        links.put(language, newCodes);
    }

    private static void initLanguages() {
        Iterator<String> iterator = links.keySet().iterator();
        while (iterator.hasNext()) {
            languages.add(iterator.next());
        }
    }

    private static void initCodes() {
        codes = new ArrayList();
        Iterator<String[]> iterator = links.values().iterator();
        while (iterator.hasNext()) {
            for (String s : iterator.next()) {
                codes.add(s);
            }
        }
    }

    private static void initLinks() {
        Iso639.putCode("Abkhazian", "ab", "abk", "abk");
        Iso639.putCode("Achinese", null, "ace", "ace");
        Iso639.putCode("Acoli", null, "ach", "ach");
        Iso639.putCode("Adangme", null, "ada", "ada");
        Iso639.putCode("Afar", "aa", "aar", "aar");
        Iso639.putCode("Afrihili", null, "afh", "afh");
        Iso639.putCode("Afrikaans", "af", "afr", "afr");
        Iso639.putCode("Afro-Asiatic (Other)", null, "afa", "afa");
        Iso639.putCode("Akan", null, "aka", "aka");
        Iso639.putCode("Akkadian", null, "akk", "akk");
        Iso639.putCode("Albanian", "sq", "sqi", "alb");
        Iso639.putCode("Aleut", null, "ale", "ale");
        Iso639.putCode("Algonquian languages", null, "alg", "alg");
        Iso639.putCode("Altaic (Other)", null, "tut", "tut");
        Iso639.putCode("Amharic", "am", "amh", "amh");
        Iso639.putCode("Apache languages", null, "apa", "apa");
        Iso639.putCode("Arabic", "ar", "ara", "ara");
        Iso639.putCode("Aramaic", null, "arc", "arc");
        Iso639.putCode("Arapaho", null, "arp", "arp");
        Iso639.putCode("Araucanian", null, "arn", "arn");
        Iso639.putCode("Arawak", null, "arw", "arw");
        Iso639.putCode("Armenian", "hy", "hye", "arm");
        Iso639.putCode("Artificial (Other)", null, "art", "art");
        Iso639.putCode("Assamese", "as", "asm", "asm");
        Iso639.putCode("Athapascan languages", null, "ath", "ath");
        Iso639.putCode("Australian languages", null, "aus", "aus");
        Iso639.putCode("Austronesian (Other)", null, "map", "map");
        Iso639.putCode("Avaric", null, "ava", "ava");
        Iso639.putCode("Avestan", "ae", "ave", "ave");
        Iso639.putCode("Awadhi", null, "awa", "awa");
        Iso639.putCode("Aymara", "ay", "aym", "aym");
        Iso639.putCode("Azerbaijani", "az", "aze", "aze");
        Iso639.putCode("Balinese", null, "ban", "ban");
        Iso639.putCode("Baltic (Other)", null, "bat", "bat");
        Iso639.putCode("Baluchi", null, "bal", "bal");
        Iso639.putCode("Bambara", null, "bam", "bam");
        Iso639.putCode("Bamileke languages", null, "bai", "bai");
        Iso639.putCode("Banda", null, "bad", "bad");
        Iso639.putCode("Bantu (Other)", null, "bnt", "bnt");
        Iso639.putCode("Basa", null, "bas", "bas");
        Iso639.putCode("Bashkir", "ba", "bak", "bak");
        Iso639.putCode("Basque", "eu", "eus", "baq");
        Iso639.putCode("Batak (Indonesia)", null, "btk", "btk");
        Iso639.putCode("Beja", null, "bej", "bej");
        Iso639.putCode("Belarusian", "be", "bel", "bel");
        Iso639.putCode("Bemba", null, "bem", "bem");
        Iso639.putCode("Bengali", "bn", "ben", "ben");
        Iso639.putCode("Berber (Other)", null, "ber", "ber");
        Iso639.putCode("Bhojpuri", null, "bho", "bho");
        Iso639.putCode("Bihari", "bh", "bih", "bih");
        Iso639.putCode("Bikol", null, "bik", "bik");
        Iso639.putCode("Bini", null, "bin", "bin");
        Iso639.putCode("Bislama", "bi", "bis", "bis");
        Iso639.putCode("Bosnian", "bs", "bos", "bos");
        Iso639.putCode("Braj", null, "bra", "bra");
        Iso639.putCode("Breton", "br", "bre", "bre");
        Iso639.putCode("Buginese", null, "bug", "bug");
        Iso639.putCode("Bulgarian", "bg", "bul", "bul");
        Iso639.putCode("Buriat", null, "bua", "bua");
        Iso639.putCode("Burmese", "my", "mya", "bur");
        Iso639.putCode("Caddo", null, "cad", "cad");
        Iso639.putCode("Carib", null, "car", "car");
        Iso639.putCode("Catalan", "ca", "cat", "cat");
        Iso639.putCode("Caucasian (Other)", null, "cau", "cau");
        Iso639.putCode("Cebuano", null, "ceb", "ceb");
        Iso639.putCode("Celtic (Other)", null, "cel", "cel");
        Iso639.putCode("Central American Indian (Other)", null, "cai", "cai");
        Iso639.putCode("Chagatai", null, "chg", "chg");
        Iso639.putCode("Chamic languages", null, "cmc", "cmc");
        Iso639.putCode("Chamorro", "ch", "cha", "cha");
        Iso639.putCode("Chechen", "ce", "che", "che");
        Iso639.putCode("Cherokee", null, "chr", "chr");
        Iso639.putCode("Cheyenne", null, "chy", "chy");
        Iso639.putCode("Chibcha", null, "chb", "chb");
        Iso639.putCode("Chichewa; Nyanja", "ny", "nya", "nya");
        Iso639.putCode("Chinese", "zh", "zho", "chi");
        Iso639.putCode("Chinook jargon", null, "chn", "chn");
        Iso639.putCode("Chipewyan", null, "chp", "chp");
        Iso639.putCode("Choctaw", null, "cho", "cho");
        Iso639.putCode("Church Slavic", "cu", "chu", "chu");
        Iso639.putCode("Chuukese", null, "chk", "chk");
        Iso639.putCode("Chuvash", "cv", "chv", "chv");
        Iso639.putCode("Coptic", null, "cop", "cop");
        Iso639.putCode("Cornish", "kw", "cor", "cor");
        Iso639.putCode("Corsican", "co", "cos", "cos");
        Iso639.putCode("Cree", null, "cre", "cre");
        Iso639.putCode("Creek", null, "mus", "mus");
        Iso639.putCode("Creoles and pidgins (Other)", null, "crp", "crp");
        Iso639.putCode("Creoles and pidgins, English-based (Other)", null, "cpe", "cpe");
        Iso639.putCode("Creoles and pidgins, French-based (Other)", null, "cpf", "cpf");
        Iso639.putCode("Creoles and pidgins, Portuguese-based (Other)", null, "cpp", "cpp");
        Iso639.putCode("Croatian", "hr", "hrv", "scr");
        Iso639.putCode("Cushitic (Other)", null, "cus", "cus");
        Iso639.putCode("Czech", "cs", "ces", "cze");
        Iso639.putCode("Dakota", null, "dak", "dak");
        Iso639.putCode("Danish", "da", "dan", "dan");
        Iso639.putCode("Dayak", null, "day", "day");
        Iso639.putCode("Delaware", null, "del", "del");
        Iso639.putCode("Dinka", null, "din", "din");
        Iso639.putCode("Divehi", null, "div", "div");
        Iso639.putCode("Dogri", null, "doi", "doi");
        Iso639.putCode("Dogrib", null, "dgr", "dgr");
        Iso639.putCode("Dravidian (Other)", null, "dra", "dra");
        Iso639.putCode("Duala", null, "dua", "dua");
        Iso639.putCode("Dutch", "nl", "nld", "dut");
        Iso639.putCode("Dutch, Middle (ca. 1050-1350)", null, "dum", "dum");
        Iso639.putCode("Dyula", null, "dyu", "dyu");
        Iso639.putCode("Dzongkha", "dz", "dzo", "dzo");
        Iso639.putCode("Efik", null, "efi", "efi");
        Iso639.putCode("Egyptian (Ancient)", null, "egy", "egy");
        Iso639.putCode("Ekajuk", null, "eka", "eka");
        Iso639.putCode("Elamite", null, "elx", "elx");
        Iso639.putCode("English", "en", "eng", "eng");
        Iso639.putCode("English, Middle (1100-1500)", null, "enm", "enm");
        Iso639.putCode("English, Old (ca.450-1100)", null, "ang", "ang");
        Iso639.putCode("Esperanto", "eo", "epo", "epo");
        Iso639.putCode("Estonian", "et", "est", "est");
        Iso639.putCode("Ewe", null, "ewe", "ewe");
        Iso639.putCode("Ewondo", null, "ewo", "ewo");
        Iso639.putCode("Fang", null, "fan", "fan");
        Iso639.putCode("Fanti", null, "fat", "fat");
        Iso639.putCode("Faroese", "fo", "fao", "fao");
        Iso639.putCode("Fijian", "fj", "fij", "fij");
        Iso639.putCode("Finnish", "fi", "fin", "fin");
        Iso639.putCode("Finno-Ugrian (Other)", null, "fiu", "fiu");
        Iso639.putCode("Fon", null, "fon", "fon");
        Iso639.putCode("French", "fr", "fra", "fre");
        Iso639.putCode("French, Middle (ca.1400-1600)", null, "frm", "frm");
        Iso639.putCode("French, Old (842-ca.1400)", null, "fro", "fro");
        Iso639.putCode("Frisian", "fy", "fry", "fry");
        Iso639.putCode("Friulian", null, "fur", "fur");
        Iso639.putCode("Fulah", null, "ful", "ful");
        Iso639.putCode("Ga", null, "gaa", "gaa");
        Iso639.putCode("Gaelic (Scots)", "gd", "gla", "gla");
        Iso639.putCode("Gallegan", "gl", "glg", "glg");
        Iso639.putCode("Ganda", null, "lug", "lug");
        Iso639.putCode("Gayo", null, "gay", "gay");
        Iso639.putCode("Gbaya", null, "gba", "gba");
        Iso639.putCode("Geez", null, "gez", "gez");
        Iso639.putCode("Georgian", "ka", "kat", "geo");
        Iso639.putCode("German", "de", "deu", "ger");
        Iso639.putCode("German, Low; Saxon, Low; Low German; Low Saxon", null, "nds", "nds");
        Iso639.putCode("German, Middle High (ca.1050-1500)", null, "gmh", "gmh");
        Iso639.putCode("German, Old High (ca.750-1050)", null, "goh", "goh");
        Iso639.putCode("Germanic (Other)", null, "gem", "gem");
        Iso639.putCode("Gilbertese", null, "gil", "gil");
        Iso639.putCode("Gondi", null, "gon", "gon");
        Iso639.putCode("Gorontalo", null, "gor", "gor");
        Iso639.putCode("Gothic", null, "got", "got");
        Iso639.putCode("Grebo", null, "grb", "grb");
        Iso639.putCode("Greek, Ancient (to 1453)", null, "grc", "grc");
        Iso639.putCode("Greek, Modern (1453-)", "el", "ell", "gre");
        Iso639.putCode("Guarani", "gn", "grn", "grn");
        Iso639.putCode("Gujarati", "gu", "guj", "guj");
        Iso639.putCode("Gwich-in", null, "gwi", "gwi");
        Iso639.putCode("Haida", null, "hai", "hai");
        Iso639.putCode("Hausa", "ha", "hau", "hau");
        Iso639.putCode("Hawaiian", null, "haw", "haw");
        Iso639.putCode("Hebrew", "he", "heb", "heb");
        Iso639.putCode("Herero", "hz", "her", "her");
        Iso639.putCode("Hiligaynon", null, "hil", "hil");
        Iso639.putCode("Himachali", null, "him", "him");
        Iso639.putCode("Hindi", "hi", "hin", "hin");
        Iso639.putCode("Hiri Motu", "ho", "hmo", "hmo");
        Iso639.putCode("Hittite", null, "hit", "hit");
        Iso639.putCode("Hmong", null, "hmn", "hmn");
        Iso639.putCode("Hungarian", "hu", "hun", "hun");
        Iso639.putCode("Hupa", null, "hup", "hup");
        Iso639.putCode("Iban", null, "iba", "iba");
        Iso639.putCode("Icelandic", "is", "isl", "ice");
        Iso639.putCode("Igbo", null, "ibo", "ibo");
        Iso639.putCode("Ijo", null, "ijo", "ijo");
        Iso639.putCode("Iloko", null, "ilo", "ilo");
        Iso639.putCode("Indic (Other)", null, "inc", "inc");
        Iso639.putCode("Indo-European (Other)", null, "ine", "ine");
        Iso639.putCode("Indonesian", "id", "ind", "ind");
        Iso639.putCode("Interlingua (International Auxiliary Language Association)", "ia", "ina", "ina");
        Iso639.putCode("Interlingue", "ie", "ile", "ile");
        Iso639.putCode("Inuktitut", "iu", "iku", "iku");
        Iso639.putCode("Inupiaq", "ik", "ipk", "ipk");
        Iso639.putCode("Iranian (Other)", null, "ira", "ira");
        Iso639.putCode("Irish", "ga", "gle", "gle");
        Iso639.putCode("Irish, Middle (900-1200)", null, "mga", "mga");
        Iso639.putCode("Irish, Old (to 900)", null, "sga", "sga");
        Iso639.putCode("Iroquoian languages", null, "iro", "iro");
        Iso639.putCode("Italian", "it", "ita", "ita");
        Iso639.putCode("Japanese", "ja", "jpn", "jpn");
        Iso639.putCode("Javanese", "jw", "jaw", "jav");
        Iso639.putCode("Judeo-Arabic", null, "jrb", "jrb");
        Iso639.putCode("Judeo-Persian", null, "jpr", "jpr");
        Iso639.putCode("Kabyle", null, "kab", "kab");
        Iso639.putCode("Kachin", null, "kac", "kac");
        Iso639.putCode("Kalaallisut", "kl", "kal", "kal");
        Iso639.putCode("Kamba", null, "kam", "kam");
        Iso639.putCode("Kannada", "kn", "kan", "kan");
        Iso639.putCode("Kanuri", null, "kau", "kau");
        Iso639.putCode("Kara-Kalpak", null, "kaa", "kaa");
        Iso639.putCode("Karen", null, "kar", "kar");
        Iso639.putCode("Kashmiri", "ks", "kas", "kas");
        Iso639.putCode("Kawi", null, "kaw", "kaw");
        Iso639.putCode("Kazakh", "kk", "kaz", "kaz");
        Iso639.putCode("Khasi", null, "kha", "kha");
        Iso639.putCode("Khmer", "km", "khm", "khm");
        Iso639.putCode("Khoisan (Other)", null, "khi", "khi");
        Iso639.putCode("Khotanese", null, "kho", "kho");
        Iso639.putCode("Kikuyu", "ki", "kik", "kik");
        Iso639.putCode("Kimbundu", null, "kmb", "kmb");
        Iso639.putCode("Kinyarwanda", "rw", "kin", "kin");
        Iso639.putCode("Kirghiz", "ky", "kir", "kir");
        Iso639.putCode("Komi", "kv", "kom", "kom");
        Iso639.putCode("Kongo", null, "kon", "kon");
        Iso639.putCode("Konkani", null, "kok", "kok");
        Iso639.putCode("Korean", "ko", "kor", "kor");
        Iso639.putCode("Kosraean", null, "kos", "kos");
        Iso639.putCode("Kpelle", null, "kpe", "kpe");
        Iso639.putCode("Kru", null, "kro", "kro");
        Iso639.putCode("Kuanyama", "kj", "kua", "kua");
        Iso639.putCode("Kumyk", null, "kum", "kum");
        Iso639.putCode("Kurdish", "ku", "kur", "kur");
        Iso639.putCode("Kurukh", null, "kru", "kru");
        Iso639.putCode("Kutenai", null, "kut", "kut");
        Iso639.putCode("Ladino", null, "lad", "lad");
        Iso639.putCode("Lahnda", null, "lah", "lah");
        Iso639.putCode("Lamba", null, "lam", "lam");
        Iso639.putCode("Lao", "lo", "lao", "lao");
        Iso639.putCode("Latin", "la", "lat", "lat");
        Iso639.putCode("Latvian", "lv", "lav", "lav");
        Iso639.putCode("Letzeburgesch", "lb", "ltz", "ltz");
        Iso639.putCode("Lezghian", null, "lez", "lez");
        Iso639.putCode("Lingala", "ln", "lin", "lin");
        Iso639.putCode("Lithuanian", "lt", "lit", "lit");
        Iso639.putCode("Low German; Low Saxon; German, Low; Saxon, Low", null, "nds", "nds");
        Iso639.putCode("Low Saxon; Low German; Saxon, Low; German, Low", null, "nds", "nds");
        Iso639.putCode("Lozi", null, "loz", "loz");
        Iso639.putCode("Luba-Katanga", null, "lub", "lub");
        Iso639.putCode("Luba-Lulua", null, "lua", "lua");
        Iso639.putCode("Luiseno", null, "lui", "lui");
        Iso639.putCode("Lunda", null, "lun", "lun");
        Iso639.putCode("Luo (Kenya and Tanzania)", null, "luo", "luo");
        Iso639.putCode("Lushai", null, "lus", "lus");
        Iso639.putCode("Macedonian", "mk", "mkd", "mac");
        Iso639.putCode("Madurese", null, "mad", "mad");
        Iso639.putCode("Magahi", null, "mag", "mag");
        Iso639.putCode("Maithili", null, "mai", "mai");
        Iso639.putCode("Makasar", null, "mak", "mak");
        Iso639.putCode("Malagasy", "mg", "mlg", "mlg");
        Iso639.putCode("Malay", "ms", "msa", "may");
        Iso639.putCode("Malayalam", "ml", "mal", "mal");
        Iso639.putCode("Maltese", "mt", "mlt", "mlt");
        Iso639.putCode("Manchu", null, "mnc", "mnc");
        Iso639.putCode("Mandar", null, "mdr", "mdr");
        Iso639.putCode("Mandingo", null, "man", "man");
        Iso639.putCode("Manipuri", null, "mni", "mni");
        Iso639.putCode("Manobo languages", null, "mno", "mno");
        Iso639.putCode("Manx", "gv", "glv", "glv");
        Iso639.putCode("Maori", "mi", "mri", "mao");
        Iso639.putCode("Marathi", "mr", "mar", "mar");
        Iso639.putCode("Mari", null, "chm", "chm");
        Iso639.putCode("Marshall", "mh", "mah", "mah");
        Iso639.putCode("Marwari", null, "mwr", "mwr");
        Iso639.putCode("Masai", null, "mas", "mas");
        Iso639.putCode("Mayan languages", null, "myn", "myn");
        Iso639.putCode("Mende", null, "men", "men");
        Iso639.putCode("Micmac", null, "mic", "mic");
        Iso639.putCode("Minangkabau", null, "min", "min");
        Iso639.putCode("Miscellaneous languages", null, "mis", "mis");
        Iso639.putCode("Mohawk", null, "moh", "moh");
        Iso639.putCode("Moldavian", "mo", "mol", "mol");
        Iso639.putCode("Mon-Khmer (Other)", null, "mkh", "mkh");
        Iso639.putCode("Mongo", null, "lol", "lol");
        Iso639.putCode("Mongolian", "mn", "mon", "mon");
        Iso639.putCode("Mossi", null, "mos", "mos");
        Iso639.putCode("Munda languages", null, "mun", "mun");
        Iso639.putCode("Nahuatl", null, "nah", "nah");
        Iso639.putCode("Nauru", "na", "nau", "nau");
        Iso639.putCode("Navajo", "nv", "nav", "nav");
        Iso639.putCode("Ndebele, North", "nd", "nde", "nde");
        Iso639.putCode("Ndebele, South", "nr", "nbl", "nbl");
        Iso639.putCode("Ndonga", "ng", "ndo", "ndo");
        Iso639.putCode("Nepali", "ne", "nep", "nep");
        Iso639.putCode("Newari", null, "new", "new");
        Iso639.putCode("Nias", null, "nia", "nia");
        Iso639.putCode("Niger-Kordofanian (Other)", null, "nic", "nic");
        Iso639.putCode("Nilo-Saharan (Other)", null, "ssa", "ssa");
        Iso639.putCode("Niuean", null, "niu", "niu");
        Iso639.putCode("Norse, Old", null, "non", "non");
        Iso639.putCode("North American Indian(Other)", null, "nai", "nai");
        Iso639.putCode("Northern Sami", "se", "sme", "sme");
        Iso639.putCode("Norwegian", "no", "nor", "nor");
        Iso639.putCode("Norwegian Bokmal", "nb", "nob", "nob");
        Iso639.putCode("Norwegian Nynorsk", "nn", "nno", "nno");
        Iso639.putCode("Nubian languages", null, "nub", "nub");
        Iso639.putCode("Nyamwezi", null, "nym", "nym");
        Iso639.putCode("Nyanja; Chichewa", "ny", "nya", "nya");
        Iso639.putCode("Nyankole", null, "nyn", "nyn");
        Iso639.putCode("Nyoro", null, "nyo", "nyo");
        Iso639.putCode("Nzima", null, "nzi", "nzi");
        Iso639.putCode("Occitan (post 1500); Provencal", "oc", "oci", "oci");
        Iso639.putCode("Ojibwa", null, "oji", "oji");
        Iso639.putCode("Oriya", "or", "ori", "ori");
        Iso639.putCode("Oromo", "om", "orm", "orm");
        Iso639.putCode("Osage", null, "osa", "osa");
        Iso639.putCode("Ossetian; Ossetic", "os", "oss", "oss");
        Iso639.putCode("Otomian languages", null, "oto", "oto");
        Iso639.putCode("Pahlavi", null, "pal", "pal");
        Iso639.putCode("Palauan", null, "pau", "pau");
        Iso639.putCode("Pali", "pi", "pli", "pli");
        Iso639.putCode("Pampanga", null, "pam", "pam");
        Iso639.putCode("Pangasinan", null, "pag", "pag");
        Iso639.putCode("Panjabi", "pa", "pan", "pan");
        Iso639.putCode("Papiamento", null, "pap", "pap");
        Iso639.putCode("Papuan (Other)", null, "paa", "paa");
        Iso639.putCode("Persian", "fa", "fas", "per");
        Iso639.putCode("Persian, Old (ca.600-400 B.C.)", null, "peo", "peo");
        Iso639.putCode("Philippine (Other)", null, "phi", "phi");
        Iso639.putCode("Phoenician", null, "phn", "phn");
        Iso639.putCode("Pohnpeian", null, "pon", "pon");
        Iso639.putCode("Polish", "pl", "pol", "pol");
        Iso639.putCode("Portuguese", "pt", "por", "por");
        Iso639.putCode("Prakrit languages", null, "pra", "pra");
        Iso639.putCode("Provencal; Occitan (post 1500)", "oc", "oci", "oci");
        Iso639.putCode("Provencal, Old (to 1500)", null, "pro", "pro");
        Iso639.putCode("Pushto", "ps", "pus", "pus");
        Iso639.putCode("Quechua", "qu", "que", "que");
        Iso639.putCode("Raeto-Romance", "rm", "roh", "roh");
        Iso639.putCode("Rajasthani", null, "raj", "raj");
        Iso639.putCode("Rapanui", null, "rap", "rap");
        Iso639.putCode("Rarotongan", null, "rar", "rar");
        Iso639.putCode("Romance (Other)", null, "roa", "roa");
        Iso639.putCode("Romanian", "ro", "ron", "rum");
        Iso639.putCode("Romany", null, "rom", "rom");
        Iso639.putCode("Rundi", "rn", "run", "run");
        Iso639.putCode("Russian", "ru", "rus", "rus");
        Iso639.putCode("Salishan languages", null, "sal", "sal");
        Iso639.putCode("Samaritan Aramaic", null, "sam", "sam");
        Iso639.putCode("Sami languages (Other)", null, "smi", "smi");
        Iso639.putCode("Samoan", "sm", "smo", "smo");
        Iso639.putCode("Sandawe", null, "sad", "sad");
        Iso639.putCode("Sango", "sg", "sag", "sag");
        Iso639.putCode("Sanskrit", "sa", "san", "san");
        Iso639.putCode("Santali", null, "sat", "sat");
        Iso639.putCode("Sardinian", "sc", "srd", "srd");
        Iso639.putCode("Sasak", null, "sas", "sas");
        Iso639.putCode("Saxon, Low; German, Low; Low Saxon; Low German", null, "nds", "nds");
        Iso639.putCode("Scots", null, "sco", "sco");
        Iso639.putCode("Selkup", null, "sel", "sel");
        Iso639.putCode("Semitic (Other)", null, "sem", "sem");
        Iso639.putCode("Serbian", "sr", "srp", "scc");
        Iso639.putCode("Serer", null, "srr", "srr");
        Iso639.putCode("Shan", null, "shn", "shn");
        Iso639.putCode("Shona", "sn", "sna", "sna");
        Iso639.putCode("Sidamo", null, "sid", "sid");
        Iso639.putCode("Sign languages", null, "sgn", "sgn");
        Iso639.putCode("Siksika", null, "bla", "bla");
        Iso639.putCode("Sindhi", "sd", "snd", "snd");
        Iso639.putCode("Sinhalese", "si", "sin", "sin");
        Iso639.putCode("Sino-Tibetan (Other)", null, "sit", "sit");
        Iso639.putCode("Siouan languages", null, "sio", "sio");
        Iso639.putCode("Slave (Athapascan)", null, "den", "den");
        Iso639.putCode("Slavic (Other)", null, "sla", "sla");
        Iso639.putCode("Slovak", "sk", "slk", "slo");
        Iso639.putCode("Slovenian", "sl", "slv", "slv");
        Iso639.putCode("Sogdian", null, "sog", "sog");
        Iso639.putCode("Somali", "so", "som", "som");
        Iso639.putCode("Songhai", null, "son", "son");
        Iso639.putCode("Soninke", null, "snk", "snk");
        Iso639.putCode("Sorbian languages", null, "wen", "wen");
        Iso639.putCode("Sotho, Northern", null, "nso", "nso");
        Iso639.putCode("Sotho, Southern", "st", "sot", "sot");
        Iso639.putCode("South American Indian (Other)", null, "sai", "sai");
        Iso639.putCode("Spanish", "es", "spa", "spa");
        Iso639.putCode("Sukuma", null, "suk", "suk");
        Iso639.putCode("Sumerian", null, "sux", "sux");
        Iso639.putCode("Sundanese", "su", "sun", "sun");
        Iso639.putCode("Susu", null, "sus", "sus");
        Iso639.putCode("Swahili", "sw", "swa", "swa");
        Iso639.putCode("Swati", "ss", "ssw", "ssw");
        Iso639.putCode("Swedish", "sv", "swe", "swe");
        Iso639.putCode("Syriac", null, "syr", "syr");
        Iso639.putCode("Tagalog", "tl", "tgl", "tgl");
        Iso639.putCode("Tahitian", "ty", "tah", "tah");
        Iso639.putCode("Tai (Other)", null, "tai", "tai");
        Iso639.putCode("Tajik", "tg", "tgk", "tgk");
        Iso639.putCode("Tamashek", null, "tmh", "tmh");
        Iso639.putCode("Tamil", "ta", "tam", "tam");
        Iso639.putCode("Tatar", "tt", "tat", "tat");
        Iso639.putCode("Telugu", "te", "tel", "tel");
        Iso639.putCode("Tereno", null, "ter", "ter");
        Iso639.putCode("Tetum", null, "tet", "tet");
        Iso639.putCode("Thai", "th", "tha", "tha");
        Iso639.putCode("Tibetan", "bo", "bod", "tib");
        Iso639.putCode("Tigre", null, "tig", "tig");
        Iso639.putCode("Tigrinya", "ti", "tir", "tir");
        Iso639.putCode("Timne", null, "tem", "tem");
        Iso639.putCode("Tiv", null, "tiv", "tiv");
        Iso639.putCode("Tlingit", null, "tli", "tli");
        Iso639.putCode("Tok Pisin", null, "tpi", "tpi");
        Iso639.putCode("Tokelau", null, "tkl", "tkl");
        Iso639.putCode("Tonga (Nyasa)", null, "tog", "tog");
        Iso639.putCode("Tonga (Tonga Islands)", "to", "ton", "ton");
        Iso639.putCode("Tsimshian", null, "tsi", "tsi");
        Iso639.putCode("Tsonga", "ts", "tso", "tso");
        Iso639.putCode("Tswana", "tn", "tsn", "tsn");
        Iso639.putCode("Tumbuka", null, "tum", "tum");
        Iso639.putCode("Turkish", "tr", "tur", "tur");
        Iso639.putCode("Turkish, Ottoman (1500-1928)", null, "ota", "ota");
        Iso639.putCode("Turkmen", "tk", "tuk", "tuk");
        Iso639.putCode("Tuvalu", null, "tvl", "tvl");
        Iso639.putCode("Tuvinian", null, "tyv", "tyv");
        Iso639.putCode("Twi", "tw", "twi", "twi");
        Iso639.putCode("Ugaritic", null, "uga", "uga");
        Iso639.putCode("Uighur", "ug", "uig", "uig");
        Iso639.putCode("Ukrainian", "uk", "ukr", "ukr");
        Iso639.putCode("Umbundu", null, "umb", "umb");
        Iso639.putCode("Undetermined", null, "und", "und");
        Iso639.putCode("Urdu", "ur", "urd", "urd");
        Iso639.putCode("Uzbek", "uz", "uzb", "uzb");
        Iso639.putCode("Vai", null, "vai", "vai");
        Iso639.putCode("Venda", null, "ven", "ven");
        Iso639.putCode("Vietnamese", "vi", "vie", "vie");
        Iso639.putCode("Volapuk", "vo", "vol", "vol");
        Iso639.putCode("Votic", null, "vot", "vot");
        Iso639.putCode("Wakashan languages", null, "wak", "wak");
        Iso639.putCode("Walamo", null, "wal", "wal");
        Iso639.putCode("Waray", null, "war", "war");
        Iso639.putCode("Washo", null, "was", "was");
        Iso639.putCode("Welsh", "cy", "cym", "wel");
        Iso639.putCode("Wolof", "wo", "wol", "wol");
        Iso639.putCode("Xhosa", "xh", "xho", "xho");
        Iso639.putCode("Yakut", null, "sah", "sah");
        Iso639.putCode("Yao", null, "yao", "yao");
        Iso639.putCode("Yapese", null, "yap", "yap");
        Iso639.putCode("Yiddish", "yi", "yid", "yid");
        Iso639.putCode("Yoruba", "yo", "yor", "yor");
        Iso639.putCode("Yupik languages", null, "ypk", "ypk");
        Iso639.putCode("Zande", null, "znd", "znd");
        Iso639.putCode("Zapotec", null, "zap", "zap");
        Iso639.putCode("Zenaga", null, "zen", "zen");
        Iso639.putCode("Zhuang", "za", "zha", "zha");
        Iso639.putCode("Zulu", "zu", "zul", "zul");
        Iso639.putCode("Zuni", null, "zun", "zun");
    }

    static {
        Iso639.initLinks();
        Iso639.initLanguages();
        Iso639.initCodes();
    }
}

