/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.IOException;
import java.io.OutputStream;
import net.pms.util.FlowParserOutputStream;

public class PCMAudioOutputStream
extends FlowParserOutputStream {
    protected int nbchannels;
    protected int sampleFrequency;
    protected int bitsperSample;
    protected int blocksize;
    protected byte[] payload;

    public PCMAudioOutputStream(OutputStream source, int nbchannels, int sampleFrequency, int bitsperSample) {
        super(source, 600000);
        this.nbchannels = nbchannels;
        this.sampleFrequency = sampleFrequency;
        this.bitsperSample = bitsperSample;
        this.swapOrderBits = 2;
        this.init();
    }

    protected void init() {
        this.blocksize = 2 * ((this.nbchannels + 1) / 2) * this.sampleFrequency * this.bitsperSample / 1600;
        this.payload = new byte[4];
        switch (this.nbchannels) {
            case 1: {
                this.payload[2] = 17;
                break;
            }
            case 2: {
                this.payload[2] = 49;
                break;
            }
            case 3: {
                this.payload[2] = 65;
                break;
            }
            case 4: {
                this.payload[2] = 113;
                break;
            }
            case 5: {
                this.payload[2] = -127;
                break;
            }
            case 6: {
                this.payload[2] = -111;
                break;
            }
            case 7: {
                this.payload[2] = -95;
                break;
            }
            case 8: {
                this.payload[2] = -79;
            }
        }
        this.payload[0] = (byte)(this.blocksize >> 8 & 0xFF);
        this.payload[1] = (byte)((this.blocksize + 256) % 256);
        if (this.sampleFrequency == 96000) {
            this.payload[2] = (byte)(this.payload[2] + 3);
        }
        if (this.sampleFrequency == 192000) {
            this.payload[2] = (byte)(this.payload[2] + 4);
        }
        this.payload[3] = (byte)(16 * (this.bitsperSample - 12));
    }

    @Override
    protected void afterChunkSend() throws IOException {
    }

    @Override
    protected void analyzeBuffer(byte[] data, int off, int len) {
        this.streamableByteNumber = this.blocksize;
    }

    @Override
    protected void beforeChunkSend() throws IOException {
        this.writePayload(this.payload);
    }
}

