# The Rsyslog Documentation Strategy

**Version: 1.1 (2025-08-12)**
**Related Document:** `IMPLEMENTATION_PLAN.md`
**Status:** Active

This document outlines the official strategy for the rsyslog project's documentation. It is a living document, subject to revision as our tools and processes evolve. Its purpose is to ensure our documentation is **authoritative**, **sustainable**, and **intelligent**, serving both human system administrators and AI agents as a primary source of truth.

---

## What changed since 1.0 (summary)

- Added a **Transitional Reference Workflow** for per-parameter pages until the code-driven pipeline (Doxygen -> Breathe) is ready.
- Defined a **Parameter Page Standard** (paths, labels, metadata, summary include slices).
- Clarified **light CI gates** for the PoC phase and the path to stricter enforcement.
- Documented **case policy** (display CamelCase; case-insensitive), **stable labels/paths**, and **type semantics** linking.

---

## Core Principles

1. **Docs-as-Code:** Documentation is version-controlled, lives in the repo, and is integrated into CI/CD.
2. **Single Source of Truth:** Minimize duplication; prefer one canonical location with references elsewhere.
3. **Automation First:** Prefer generated/validated artifacts; add checks for drift, links, and structure.
4. **Hybrid Model:** Code-driven reference + human-authored narrative.

---

## Pillar 1: The Automated Foundation (Code-Driven Reference)

**Goal:** Reference docs reflect source code truth.

- **Authoritative Source:** C source defines modules, parameters, directives.
- **Generation Toolchain:** Doxygen -> XML -> Breathe -> Sphinx.
- **Handling Undocumented Changes:**
  1) CI analyzes source and compares to docs.
  2) On mismatch, **do not fail** (while in transition).
  3) Open a GitHub issue tagged `documentation` + `autogenerated`.

### 1.1 Transitional Reference Workflow (Active)

Until the code-driven pipeline is complete, we maintain **manual per-parameter pages** with stable IDs and paths that future generators must **preserve**.

- **Paths (flat, RAG-friendly):** `doc/source/reference/parameters/<module>-<param-slug>.rst`
  Example: `imdocker-dockerapiunixsockaddr.rst`
- **Slugs:** lowercase; trim; remove spaces/punct; filenames and labels use the slug.
  Displayed names remain historical **CamelCase**.
- **Stability Requirement:** When auto-generation lands, emit into **the same paths and labels** (no breaking changes; add redirects only if absolutely necessary).

---

## Pillar 2: The Narrative Layer (Human-Authored Guides)

- **Validated Example Library (target state):**
  - Place complete examples in `doc/examples/`.
  - Guides use `.. literalinclude::` to avoid drift.
- **Transitional exception (PoC):**
  - Inline examples are allowed temporarily in parameter pages and modules.
  - Prefer moving high-value examples to `doc/examples/` as soon as feasible.

- **Diagrams as Code:** Prefer Mermaid via `sphinx-mermaid`.
- **Content Migration:** Curate and integrate high-value external content into `doc/source/tutorials/`.

---

## Pillar 3: Quality & Contribution Framework

- **Docs CI (target state):**
  1) `sphinx-build -nW` (warnings as errors).
  2) Linkcheck passes.
  3) Drift detector verifies rsyslog terms/IDs against authoritative lists.

- **Docs CI (PoC, current):**
  - Run `sphinx-build -b html doc/source doc/_build/html` (non-blocking).
  - Optional `linkcheck` (non-blocking; collect report).
  - Defer drift detector & strict warnings until post-transition.

- **AI-Powered Review:** Optional PR comment bot for clarity/style.
- **User Feedback:** “Edit on GitHub” links via `html_context`.

---

## Pillar 4: Distribution & Format Integration

- **Man Pages:** Generated from RST via Sphinx man builder; included in release tarballs.
- **Versioning Policy:**
  > Online docs reflect `main` (latest). For stable versions, authoritative docs are bundled with release tarballs. If using distro packages, prefer the documentation shipped with that package.

---

## Pillar 5: Ecosystem Integration

- **External Projects:** Use `git submodule` + `intersphinx` for cross-references.
- **Deployments:** Top-level `08_deployment_guides/` with platform subfolders.

---

## Pillar 6: Content Amplification & Authority

- **Technical SEO:** `sphinx-sitemap`, and Schema.org metadata in templates.
- **Strategic Syndication:** Publish key tutorials with `rel="canonical"` back to docs.
- **Answer Hubs:** Summarize and link back to official docs.

---

## Parameter Page Standard (Transitional & Future-Proof)

This contract applies now (manual) and must remain valid when pages are auto-generated.

### A. Location & Naming

- **Location:** `doc/source/reference/parameters/`
- **Filename:** `<module>-<param-slug>.rst` (flat namespace).
- **Slug rules:** lowercase; no spaces/punct; keep display name CamelCase.

### B. Required Labels (top of file, exactly)

```rst
.. _param-<module>-<param-slug>:
.. _<module>.parameter.module.<param-slug>:
```

- Add an **alias label** only for high-confidence, common typos:
  `.. _<module>.parameter.module.<typo-alias>:` (optional).

### C. Header & Summary

- **Heading (H1):** Original CamelCase parameter name.
- **One-sentence summary:** Encapsulated for reuse:

```rst
.. summary-start
<single concise sentence; <=160 chars>
.. summary-end
```

- **Backlink line (separate):**
  This parameter applies to :doc:`../../configuration/modules/<module>`. 

### D. Lightweight Metadata (Field List, fixed order)

Fill unknowns with `(tbd)`; keep keys present.

```
:Name: <CamelCase>
:Type: string (see :doc:`../../rainerscript/constant_strings`) | integer | boolean
:Default: <value or (none)>
:Required?: yes | no
:Introduced: (tbd)
:Aliases: <comma-separated> | (none)
:Constraints: <brief rule> | (tbd)
```

> **Case policy:** rsyslog parameters are case-insensitive; CamelCase is recommended for readability (documented once per module page as a note).

### E. Sections (order)

1. **Description** — migrated/cleaned from the module page.
2. **Notes** — optional clarifications (e.g., “Do not prepend `?`”).
3. **Usage / Examples** — config snippets (`.. code-block:: rsyslog`).
4. **See also** — link back to the module page.

### F. Module Overview Page Adjustments

In `doc/source/configuration/modules/<module>.rst`:

- Replace inline parameter docs with a **two-column list-table** (Parameter | Summary).
  **Do not** define any labels inside the table.
- Pull the summary via **include slice** to avoid duplication:

```rst
.. list-table::
   :widths: 30 70
   :header-rows: 1

   * - Parameter
     - Summary
   * - :doc:`../../reference/parameters/<module>-<param-slug>`
     - .. include:: ../../reference/parameters/<module>-<param-slug>.rst
        :start-after: .. summary-start
        :end-before: .. summary-end
```

- Add a hidden toctree listing all parameter pages to avoid orphan warnings.

---

## Backward Compatibility Policy (Docs)

- rsyslog maintains strong backward compatibility; parameters rarely change.
- Document **Introduced** version when known; avoid “Deprecated/Removed” unless it actually happened.
- The stable **paths and labels** above are part of this policy; generators must preserve them.

---

## Acceptance Checklist (PoC Phase)

- [ ] Parameter pages exist at `reference/parameters/<module>-<param-slug>.rst`.
- [ ] Labels follow the **two required labels**; optional typo alias only if justified.
- [ ] Module overview links to each parameter and includes summaries via include slices.
- [ ] Field list present with fixed keys; `(tbd)` allowed.
- [ ] Build succeeds with `sphinx-build -b html`.
- [ ] Optional linkcheck report collected (non-blocking).

---

## Maintaining This Strategy

- **Location:** `doc/STRATEGY.md`
- **Discoverability:** Repo root `CONTRIBUTING.md` links here; PR template includes a checklist item.
- **Enforcement:** During PoC, soft checks; post-transition, CI enforces strict gates (`-nW`, linkcheck, drift detector).

