// Code generated by gnark-crypto/generator. DO NOT EDIT.
#include "textflag.h"
#include "funcdata.h"
#include "go_asm.h"

#define REDUCE(ra0, ra1, ra2, ra3, ra4, rb0, rb1, rb2, rb3, rb4) \
	MOVQ    ra0, rb0;              \
	SUBQ    ·qElement(SB), ra0;    \
	MOVQ    ra1, rb1;              \
	SBBQ    ·qElement+8(SB), ra1;  \
	MOVQ    ra2, rb2;              \
	SBBQ    ·qElement+16(SB), ra2; \
	MOVQ    ra3, rb3;              \
	SBBQ    ·qElement+24(SB), ra3; \
	MOVQ    ra4, rb4;              \
	SBBQ    ·qElement+32(SB), ra4; \
	CMOVQCS rb0, ra0;              \
	CMOVQCS rb1, ra1;              \
	CMOVQCS rb2, ra2;              \
	CMOVQCS rb3, ra3;              \
	CMOVQCS rb4, ra4;              \

TEXT ·reduce(SB), NOSPLIT, $0-8
	MOVQ res+0(FP), AX
	MOVQ 0(AX), DX
	MOVQ 8(AX), CX
	MOVQ 16(AX), BX
	MOVQ 24(AX), SI
	MOVQ 32(AX), DI

	// reduce element(DX,CX,BX,SI,DI) using temp registers (R8,R9,R10,R11,R12)
	REDUCE(DX,CX,BX,SI,DI,R8,R9,R10,R11,R12)

	MOVQ DX, 0(AX)
	MOVQ CX, 8(AX)
	MOVQ BX, 16(AX)
	MOVQ SI, 24(AX)
	MOVQ DI, 32(AX)
	RET

// MulBy3(x *Element)
TEXT ·MulBy3(SB), NOSPLIT, $0-8
	MOVQ x+0(FP), AX
	MOVQ 0(AX), DX
	MOVQ 8(AX), CX
	MOVQ 16(AX), BX
	MOVQ 24(AX), SI
	MOVQ 32(AX), DI
	ADDQ DX, DX
	ADCQ CX, CX
	ADCQ BX, BX
	ADCQ SI, SI
	ADCQ DI, DI

	// reduce element(DX,CX,BX,SI,DI) using temp registers (R8,R9,R10,R11,R12)
	REDUCE(DX,CX,BX,SI,DI,R8,R9,R10,R11,R12)

	ADDQ 0(AX), DX
	ADCQ 8(AX), CX
	ADCQ 16(AX), BX
	ADCQ 24(AX), SI
	ADCQ 32(AX), DI

	// reduce element(DX,CX,BX,SI,DI) using temp registers (R13,R14,R15,R8,R9)
	REDUCE(DX,CX,BX,SI,DI,R13,R14,R15,R8,R9)

	MOVQ DX, 0(AX)
	MOVQ CX, 8(AX)
	MOVQ BX, 16(AX)
	MOVQ SI, 24(AX)
	MOVQ DI, 32(AX)
	RET

// MulBy5(x *Element)
TEXT ·MulBy5(SB), NOSPLIT, $0-8
	MOVQ x+0(FP), AX
	MOVQ 0(AX), DX
	MOVQ 8(AX), CX
	MOVQ 16(AX), BX
	MOVQ 24(AX), SI
	MOVQ 32(AX), DI
	ADDQ DX, DX
	ADCQ CX, CX
	ADCQ BX, BX
	ADCQ SI, SI
	ADCQ DI, DI

	// reduce element(DX,CX,BX,SI,DI) using temp registers (R8,R9,R10,R11,R12)
	REDUCE(DX,CX,BX,SI,DI,R8,R9,R10,R11,R12)

	ADDQ DX, DX
	ADCQ CX, CX
	ADCQ BX, BX
	ADCQ SI, SI
	ADCQ DI, DI

	// reduce element(DX,CX,BX,SI,DI) using temp registers (R13,R14,R15,R8,R9)
	REDUCE(DX,CX,BX,SI,DI,R13,R14,R15,R8,R9)

	ADDQ 0(AX), DX
	ADCQ 8(AX), CX
	ADCQ 16(AX), BX
	ADCQ 24(AX), SI
	ADCQ 32(AX), DI

	// reduce element(DX,CX,BX,SI,DI) using temp registers (R10,R11,R12,R13,R14)
	REDUCE(DX,CX,BX,SI,DI,R10,R11,R12,R13,R14)

	MOVQ DX, 0(AX)
	MOVQ CX, 8(AX)
	MOVQ BX, 16(AX)
	MOVQ SI, 24(AX)
	MOVQ DI, 32(AX)
	RET

// MulBy13(x *Element)
TEXT ·MulBy13(SB), $16-8
	MOVQ x+0(FP), AX
	MOVQ 0(AX), DX
	MOVQ 8(AX), CX
	MOVQ 16(AX), BX
	MOVQ 24(AX), SI
	MOVQ 32(AX), DI
	ADDQ DX, DX
	ADCQ CX, CX
	ADCQ BX, BX
	ADCQ SI, SI
	ADCQ DI, DI

	// reduce element(DX,CX,BX,SI,DI) using temp registers (R8,R9,R10,R11,R12)
	REDUCE(DX,CX,BX,SI,DI,R8,R9,R10,R11,R12)

	ADDQ DX, DX
	ADCQ CX, CX
	ADCQ BX, BX
	ADCQ SI, SI
	ADCQ DI, DI

	// reduce element(DX,CX,BX,SI,DI) using temp registers (R13,R14,R15,s0-8(SP),s1-16(SP))
	REDUCE(DX,CX,BX,SI,DI,R13,R14,R15,s0-8(SP),s1-16(SP))

	MOVQ DX, R13
	MOVQ CX, R14
	MOVQ BX, R15
	MOVQ SI, s0-8(SP)
	MOVQ DI, s1-16(SP)
	ADDQ DX, DX
	ADCQ CX, CX
	ADCQ BX, BX
	ADCQ SI, SI
	ADCQ DI, DI

	// reduce element(DX,CX,BX,SI,DI) using temp registers (R8,R9,R10,R11,R12)
	REDUCE(DX,CX,BX,SI,DI,R8,R9,R10,R11,R12)

	ADDQ R13, DX
	ADCQ R14, CX
	ADCQ R15, BX
	ADCQ s0-8(SP), SI
	ADCQ s1-16(SP), DI

	// reduce element(DX,CX,BX,SI,DI) using temp registers (R8,R9,R10,R11,R12)
	REDUCE(DX,CX,BX,SI,DI,R8,R9,R10,R11,R12)

	ADDQ 0(AX), DX
	ADCQ 8(AX), CX
	ADCQ 16(AX), BX
	ADCQ 24(AX), SI
	ADCQ 32(AX), DI

	// reduce element(DX,CX,BX,SI,DI) using temp registers (R8,R9,R10,R11,R12)
	REDUCE(DX,CX,BX,SI,DI,R8,R9,R10,R11,R12)

	MOVQ DX, 0(AX)
	MOVQ CX, 8(AX)
	MOVQ BX, 16(AX)
	MOVQ SI, 24(AX)
	MOVQ DI, 32(AX)
	RET

// Butterfly(a, b *Element) sets a = a + b; b = a - b
TEXT ·Butterfly(SB), $24-16
	MOVQ    a+0(FP), AX
	MOVQ    0(AX), CX
	MOVQ    8(AX), BX
	MOVQ    16(AX), SI
	MOVQ    24(AX), DI
	MOVQ    32(AX), R8
	MOVQ    CX, R9
	MOVQ    BX, R10
	MOVQ    SI, R11
	MOVQ    DI, R12
	MOVQ    R8, R13
	XORQ    AX, AX
	MOVQ    b+8(FP), DX
	ADDQ    0(DX), CX
	ADCQ    8(DX), BX
	ADCQ    16(DX), SI
	ADCQ    24(DX), DI
	ADCQ    32(DX), R8
	SUBQ    0(DX), R9
	SBBQ    8(DX), R10
	SBBQ    16(DX), R11
	SBBQ    24(DX), R12
	SBBQ    32(DX), R13
	MOVQ    CX, R14
	MOVQ    BX, R15
	MOVQ    SI, s0-8(SP)
	MOVQ    DI, s1-16(SP)
	MOVQ    R8, s2-24(SP)
	MOVQ    $const_q0, CX
	MOVQ    $const_q1, BX
	MOVQ    $const_q2, SI
	MOVQ    $const_q3, DI
	MOVQ    $const_q4, R8
	CMOVQCC AX, CX
	CMOVQCC AX, BX
	CMOVQCC AX, SI
	CMOVQCC AX, DI
	CMOVQCC AX, R8
	ADDQ    CX, R9
	ADCQ    BX, R10
	ADCQ    SI, R11
	ADCQ    DI, R12
	ADCQ    R8, R13
	MOVQ    R14, CX
	MOVQ    R15, BX
	MOVQ    s0-8(SP), SI
	MOVQ    s1-16(SP), DI
	MOVQ    s2-24(SP), R8
	MOVQ    R9, 0(DX)
	MOVQ    R10, 8(DX)
	MOVQ    R11, 16(DX)
	MOVQ    R12, 24(DX)
	MOVQ    R13, 32(DX)

	// reduce element(CX,BX,SI,DI,R8) using temp registers (R9,R10,R11,R12,R13)
	REDUCE(CX,BX,SI,DI,R8,R9,R10,R11,R12,R13)

	MOVQ a+0(FP), AX
	MOVQ CX, 0(AX)
	MOVQ BX, 8(AX)
	MOVQ SI, 16(AX)
	MOVQ DI, 24(AX)
	MOVQ R8, 32(AX)
	RET

// mul(res, x, y *Element)
TEXT ·mul(SB), $24-24

	// Algorithm 2 of "Faster Montgomery Multiplication and Multi-Scalar-Multiplication for SNARKS"
	// by Y. El Housni and G. Botrel https://doi.org/10.46586/tches.v2023.i3.504-521
	// See github.com/Consensys/gnark-crypto/field/generator for more comments.

	NO_LOCAL_POINTERS
	CMPB ·supportAdx(SB), $1
	JNE  noAdx_1
	MOVQ x+8(FP), DI

	// x[0] -> R9
	// x[1] -> R10
	// x[2] -> R11
	MOVQ 0(DI), R9
	MOVQ 8(DI), R10
	MOVQ 16(DI), R11
	MOVQ y+16(FP), R12

	// A -> BP
	// t[0] -> R14
	// t[1] -> R13
	// t[2] -> CX
	// t[3] -> BX
	// t[4] -> SI
#define MACC(in0, in1, in2) \
	ADCXQ in0, in1     \
	MULXQ in2, AX, in0 \
	ADOXQ AX, in1      \

#define DIV_SHIFT() \
	MOVQ  $const_qInvNeg, DX        \
	IMULQ R14, DX                   \
	XORQ  AX, AX                    \
	MULXQ ·qElement+0(SB), AX, R8   \
	ADCXQ R14, AX                   \
	MOVQ  R8, R14                   \
	MACC(R13, R14, ·qElement+8(SB)) \
	MACC(CX, R13, ·qElement+16(SB)) \
	MACC(BX, CX, ·qElement+24(SB))  \
	MACC(SI, BX, ·qElement+32(SB))  \
	MOVQ  $0, AX                    \
	ADCXQ AX, SI                    \
	ADOXQ BP, SI                    \

#define MUL_WORD_0() \
	XORQ  AX, AX         \
	MULXQ R9, R14, R13   \
	MULXQ R10, AX, CX    \
	ADOXQ AX, R13        \
	MULXQ R11, AX, BX    \
	ADOXQ AX, CX         \
	MULXQ 24(DI), AX, SI \
	ADOXQ AX, BX         \
	MULXQ 32(DI), AX, BP \
	ADOXQ AX, SI         \
	MOVQ  $0, AX         \
	ADOXQ AX, BP         \
	DIV_SHIFT()          \

#define MUL_WORD_N() \
	XORQ  AX, AX         \
	MULXQ R9, AX, BP     \
	ADOXQ AX, R14        \
	MACC(BP, R13, R10)   \
	MACC(BP, CX, R11)    \
	MACC(BP, BX, 24(DI)) \
	MACC(BP, SI, 32(DI)) \
	MOVQ  $0, AX         \
	ADCXQ AX, BP         \
	ADOXQ AX, BP         \
	DIV_SHIFT()          \

	// mul body
	MOVQ 0(R12), DX
	MUL_WORD_0()
	MOVQ 8(R12), DX
	MUL_WORD_N()
	MOVQ 16(R12), DX
	MUL_WORD_N()
	MOVQ 24(R12), DX
	MUL_WORD_N()
	MOVQ 32(R12), DX
	MUL_WORD_N()

	// reduce element(R14,R13,CX,BX,SI) using temp registers (R8,DI,R12,R9,R10)
	REDUCE(R14,R13,CX,BX,SI,R8,DI,R12,R9,R10)

	MOVQ res+0(FP), AX
	MOVQ R14, 0(AX)
	MOVQ R13, 8(AX)
	MOVQ CX, 16(AX)
	MOVQ BX, 24(AX)
	MOVQ SI, 32(AX)
	RET

noAdx_1:
	MOVQ res+0(FP), AX
	MOVQ AX, (SP)
	MOVQ x+8(FP), AX
	MOVQ AX, 8(SP)
	MOVQ y+16(FP), AX
	MOVQ AX, 16(SP)
	CALL ·_mulGeneric(SB)
	RET

TEXT ·fromMont(SB), $8-8
	NO_LOCAL_POINTERS

	// Algorithm 2 of "Faster Montgomery Multiplication and Multi-Scalar-Multiplication for SNARKS"
	// by Y. El Housni and G. Botrel https://doi.org/10.46586/tches.v2023.i3.504-521
	// when y = 1 we have:
	// for i=0 to N-1
	// 		t[i] = x[i]
	// for i=0 to N-1
	// 		m := t[0]*q'[0] mod W
	// 		C,_ := t[0] + m*q[0]
	// 		for j=1 to N-1
	// 		    (C,t[j-1]) := t[j] + m*q[j] + C
	// 		t[N-1] = C
	CMPB ·supportAdx(SB), $1
	JNE  noAdx_2
	MOVQ res+0(FP), DX
	MOVQ 0(DX), R14
	MOVQ 8(DX), R13
	MOVQ 16(DX), CX
	MOVQ 24(DX), BX
	MOVQ 32(DX), SI
	XORQ DX, DX

	// m := t[0]*q'[0] mod W
	MOVQ  $const_qInvNeg, DX
	IMULQ R14, DX
	XORQ  AX, AX

	// C,_ := t[0] + m*q[0]
	MULXQ ·qElement+0(SB), AX, BP
	ADCXQ R14, AX
	MOVQ  BP, R14

	// (C,t[0]) := t[1] + m*q[1] + C
	ADCXQ R13, R14
	MULXQ ·qElement+8(SB), AX, R13
	ADOXQ AX, R14

	// (C,t[1]) := t[2] + m*q[2] + C
	ADCXQ CX, R13
	MULXQ ·qElement+16(SB), AX, CX
	ADOXQ AX, R13

	// (C,t[2]) := t[3] + m*q[3] + C
	ADCXQ BX, CX
	MULXQ ·qElement+24(SB), AX, BX
	ADOXQ AX, CX

	// (C,t[3]) := t[4] + m*q[4] + C
	ADCXQ SI, BX
	MULXQ ·qElement+32(SB), AX, SI
	ADOXQ AX, BX
	MOVQ  $0, AX
	ADCXQ AX, SI
	ADOXQ AX, SI
	XORQ  DX, DX

	// m := t[0]*q'[0] mod W
	MOVQ  $const_qInvNeg, DX
	IMULQ R14, DX
	XORQ  AX, AX

	// C,_ := t[0] + m*q[0]
	MULXQ ·qElement+0(SB), AX, BP
	ADCXQ R14, AX
	MOVQ  BP, R14

	// (C,t[0]) := t[1] + m*q[1] + C
	ADCXQ R13, R14
	MULXQ ·qElement+8(SB), AX, R13
	ADOXQ AX, R14

	// (C,t[1]) := t[2] + m*q[2] + C
	ADCXQ CX, R13
	MULXQ ·qElement+16(SB), AX, CX
	ADOXQ AX, R13

	// (C,t[2]) := t[3] + m*q[3] + C
	ADCXQ BX, CX
	MULXQ ·qElement+24(SB), AX, BX
	ADOXQ AX, CX

	// (C,t[3]) := t[4] + m*q[4] + C
	ADCXQ SI, BX
	MULXQ ·qElement+32(SB), AX, SI
	ADOXQ AX, BX
	MOVQ  $0, AX
	ADCXQ AX, SI
	ADOXQ AX, SI
	XORQ  DX, DX

	// m := t[0]*q'[0] mod W
	MOVQ  $const_qInvNeg, DX
	IMULQ R14, DX
	XORQ  AX, AX

	// C,_ := t[0] + m*q[0]
	MULXQ ·qElement+0(SB), AX, BP
	ADCXQ R14, AX
	MOVQ  BP, R14

	// (C,t[0]) := t[1] + m*q[1] + C
	ADCXQ R13, R14
	MULXQ ·qElement+8(SB), AX, R13
	ADOXQ AX, R14

	// (C,t[1]) := t[2] + m*q[2] + C
	ADCXQ CX, R13
	MULXQ ·qElement+16(SB), AX, CX
	ADOXQ AX, R13

	// (C,t[2]) := t[3] + m*q[3] + C
	ADCXQ BX, CX
	MULXQ ·qElement+24(SB), AX, BX
	ADOXQ AX, CX

	// (C,t[3]) := t[4] + m*q[4] + C
	ADCXQ SI, BX
	MULXQ ·qElement+32(SB), AX, SI
	ADOXQ AX, BX
	MOVQ  $0, AX
	ADCXQ AX, SI
	ADOXQ AX, SI
	XORQ  DX, DX

	// m := t[0]*q'[0] mod W
	MOVQ  $const_qInvNeg, DX
	IMULQ R14, DX
	XORQ  AX, AX

	// C,_ := t[0] + m*q[0]
	MULXQ ·qElement+0(SB), AX, BP
	ADCXQ R14, AX
	MOVQ  BP, R14

	// (C,t[0]) := t[1] + m*q[1] + C
	ADCXQ R13, R14
	MULXQ ·qElement+8(SB), AX, R13
	ADOXQ AX, R14

	// (C,t[1]) := t[2] + m*q[2] + C
	ADCXQ CX, R13
	MULXQ ·qElement+16(SB), AX, CX
	ADOXQ AX, R13

	// (C,t[2]) := t[3] + m*q[3] + C
	ADCXQ BX, CX
	MULXQ ·qElement+24(SB), AX, BX
	ADOXQ AX, CX

	// (C,t[3]) := t[4] + m*q[4] + C
	ADCXQ SI, BX
	MULXQ ·qElement+32(SB), AX, SI
	ADOXQ AX, BX
	MOVQ  $0, AX
	ADCXQ AX, SI
	ADOXQ AX, SI
	XORQ  DX, DX

	// m := t[0]*q'[0] mod W
	MOVQ  $const_qInvNeg, DX
	IMULQ R14, DX
	XORQ  AX, AX

	// C,_ := t[0] + m*q[0]
	MULXQ ·qElement+0(SB), AX, BP
	ADCXQ R14, AX
	MOVQ  BP, R14

	// (C,t[0]) := t[1] + m*q[1] + C
	ADCXQ R13, R14
	MULXQ ·qElement+8(SB), AX, R13
	ADOXQ AX, R14

	// (C,t[1]) := t[2] + m*q[2] + C
	ADCXQ CX, R13
	MULXQ ·qElement+16(SB), AX, CX
	ADOXQ AX, R13

	// (C,t[2]) := t[3] + m*q[3] + C
	ADCXQ BX, CX
	MULXQ ·qElement+24(SB), AX, BX
	ADOXQ AX, CX

	// (C,t[3]) := t[4] + m*q[4] + C
	ADCXQ SI, BX
	MULXQ ·qElement+32(SB), AX, SI
	ADOXQ AX, BX
	MOVQ  $0, AX
	ADCXQ AX, SI
	ADOXQ AX, SI

	// reduce element(R14,R13,CX,BX,SI) using temp registers (DI,R8,R9,R10,R11)
	REDUCE(R14,R13,CX,BX,SI,DI,R8,R9,R10,R11)

	MOVQ res+0(FP), AX
	MOVQ R14, 0(AX)
	MOVQ R13, 8(AX)
	MOVQ CX, 16(AX)
	MOVQ BX, 24(AX)
	MOVQ SI, 32(AX)
	RET

noAdx_2:
	MOVQ res+0(FP), AX
	MOVQ AX, (SP)
	CALL ·_fromMontGeneric(SB)
	RET
