/*
*  qm_libraryview.h
*  QUIMUP library treeview
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_LIBRARY_H
#define QM_LIBRARY_H

#include <QtWidgets>
#include <QTreeWidget>
#include <QHeaderView>
#include <QTreeWidgetItem>
#include <QKeyEvent>
#include <QMenu>
#include <QFile>
#include <QMessageBox>
#include <QProcess>
#include "qm_mpdcom.h"
#include "qm_itemlist.h"
#include "qm_commandlist.h"
#include "qm_config.h"

#define setdummy(dm)  setData(0, Qt::UserRole +  1, dm)
#define settype(tp)  setData(0, Qt::UserRole +  2, tp)
#define settime(tm)  setData(0, Qt::UserRole +  3, tm)
#define setartist(at)  setData(0, Qt::UserRole +  4, at)
#define setalbum(ab) setData(0, Qt::UserRole +  5, ab)
#define settitle(tt) setData(0, Qt::UserRole +  6, tt)
#define seturi(ur)  setData(0, Qt::UserRole +  8, ur)
#define settrack(tr)  setData(0, Qt::UserRole +  9, tr)
#define setname(nm)  setData(0, Qt::UserRole + 10, nm)
#define setgenre(gr)  setData(0, Qt::UserRole + 12, gr)

#define getdummy  data(0, Qt::UserRole +  1).toInt()
#define gettype   data(0, Qt::UserRole +  2).toInt()
#define gettime   data(0, Qt::UserRole +  3).toInt()
#define getartist   data(0, Qt::UserRole +  4).toString()
#define getalbum  data(0, Qt::UserRole +  5).toString()
#define gettitle  data(0, Qt::UserRole +  6).toString()
#define geturi   data(0, Qt::UserRole +  8).toString()
#define gettrack   data(0, Qt::UserRole +  9).toString()
#define getname   data(0, Qt::UserRole + 10).toString()
#define getgenre   data(0, Qt::UserRole + 12).toString()

class qm_libraryView : public QTreeWidget
{
    Q_OBJECT

public:
    qm_libraryView(QWidget *, qm_Config *);
    virtual ~qm_libraryView();

public slots:
    void set_connected(qm_mpdCommand*, bool);
    void reload_root();
    void on_playlist_dropreceived(int);
    void resize_columns();
    void set_last_column_width();
    void set_auto_columns();
    void set_actions();

private slots:
    void on_item_expanded(QTreeWidgetItem *);
    void on_selection_changed();
    void on_append();
    void on_createnew();
    void on_delete();
    void on_opendir();
    void on_tagedit();
    void on_update();
    void on_mpd_plistsaved();

private:
    bool
        b_mpd_connected,
        b_opendir_tagedit_set;
    int
        playlist_droppos,
        column_count,
        resize_countdown,
        last_column_width;
    qm_mpdCommand *mpd_cmd;
    qm_Config *config;
    QMenu *context_menu;
    QAction
        *a_delete,
        *a_opendir,
        *a_loadtags,
        *a_tagedit,
        *a_newplaylist,
        *a_append,
        *a_collapse;
    QHeaderView *hvw_library;
    QIcon
        ic_dot,
        ic_check,
        ic_track,
        ic_album,
        ic_artist,
        ic_genre,
        ic_playlist,
        ic_delete,
        ic_dir,
        ic_stream,
        ic_a_newplaylist,
        ic_a_append,
        ic_a_loadtags,
        ic_a_opendir,
        ic_a_tagedit,
        ic_a_delete,
        ic_a_collapse;
    QString string_last_column;
    QPixmap pxb_dragdrop;

    qm_commandList playlist_modification_list;
    void get_albums(QString, bool);
    void get_albums_year();
    void get_artists(QString);
    void get_genres(QString);
    void get_songs(QString);
    void get_playlists();
    void get_directories(QString);
    void expand_album(QTreeWidgetItem *);
    void expand_artist(QTreeWidgetItem *);
    void expand_playlist(QTreeWidgetItem *);
    void expand_directory(QTreeWidgetItem *);
    void expand_genre(QTreeWidgetItem *);
    void add_dummy_to(QTreeWidgetItem *);
    void take_dummy_from(QTreeWidgetItem *);
    void add_songdata_toItem(QTreeWidgetItem *, qm_listItemInfo);
    void modify_playlist(bool, bool);
    void append_to_modlist(QString, QString, QString, bool);
    void append_to_modlist_dir(QString, bool);
    void append_to_modlist_plist(QString, bool);
    void set_column_count(int);
    void setup_widgets();
    void set_themed_icons(bool);
    int  get_string_width(QString);

protected:
    void startDrag(Qt::DropActions);
    void resizeEvent (QResizeEvent *);
    void contextMenuEvent(QContextMenuEvent *);
};

#endif //  QM_LIBRARY_H
